<?php
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR . "HttpRequest.class.php" );
/**
 * モジュールの実行をコントロールするクラスです。
 * 各モジュールの実行は、本クラスによって行われます。
 * 
 * @package spider spiderのコアパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class Controller {
	
	/** 実行モジュールのモジュール名配列（実行した順） */
	var $executed_module_name_array		= array();
	/** 実行モジュールのオブジェクトハッシュ	*/
	var $executed_module_object_array	= array();
	
	/** ライブラリフォルダのルートパス	*/
	var $dir_path_lib					= '';
	
	/** リクエストコンテナオブジェクト	*/
	var $request_object				= null;
	/** 出力オブジェクト				*/
	var $http_output_object				= null;

	/**
	 * コンストラクタ
	 * @param $dir_path_lib モジュールを配備するルートパス
	 */
	function Controller( $dir_path_lib = null ) {
		$this->executed_module_name_array		= array();
		$this->executed_module_object_array		= array();
		if ( is_null( $dir_path_lib ) || strlen( $dir_path_lib ) ) {
			$this->dir_path_lib					= dirname(dirname( __FILE__ ));
		} else {
			$this->dir_path_lib					= $dir_path_lib;
		}
	}

	/**
	 * 全体実行
	 * @param $request_object 
	 * @param $http_output_obj 
	 */
	function execute( & $request_object, & $http_output_obj ) {
		
		$this->request_object		= & $request_object;
		$this->http_output_object	= & $http_output_obj;
		// グローバルエラーが存在したらエラーに追加
		$global_errors				= unserialize( $_SESSION['spider.global_errors'] );
		if( is_array( $global_errors ) ) {
			$this->request_object->errors	= $global_errors;
		}
		unset( $_SESSION['spider.global_errors'] );
		// リクエスト出力
		$this->http_output_object->output( $this, $this->request_object );
		// グローバルエラーが登録されていたらセッションに登録
		if( is_array($request_object->global_errors) && count($request_object->global_errors) > 0 ) {
			$_SESSION['spider.global_errors']	= serialize($_SESSION['spider.global_errors']);
		}
	}
	/**
	 * モジュール実行
	 * @param $module_name 実行するモジュール名
	 */
	function loadModule( $module_name, $force=false ) {
		if( $force || !$this->request_object->isError() ) {
			$path = str_replace( ".", DIRECTORY_SEPARATOR, $module_name );
			$path = $this->dir_path_lib . DIRECTORY_SEPARATOR . $path;
			if ( file_exists( $path . ".class.php" ) ) {
				include_once( $path . ".class.php" );
			} else if ( file_exists( $path . ".inc.php" ) ) {
				include_once( $path . ".inc.php" );
			} else if ( file_exists( $path . ".php" ) ) {
				include_once( $path . ".php" );
			} else if ( file_exists( $path . ".php.inc" ) ) {
				include_once( $path . ".php.inc" );
			} else if( file_exists( $path . ".inc" ) ){
				include_once( $path . ".inc" );
			} else {
				header('Content-Type: text/plain;charset=UTF-8');
				die('Core Error: 存在しないモジュール呼び出しです。[' . $module_name . ']');
			}
			$module_real_name = str_replace( ".", "_", $module_name );
			$module_obj	= $this->executed_module_object_array[$module_name];
			if( is_null( $module_obj ) ) {
				$module_obj = new $module_real_name;
				$module_obj->controller_object	= & $this;
				$module_obj->http_output_object	= & $this->http_output_object;
				// 要求モジュールが存在するなら先に実行する
				if( is_array( $module_obj->require_module_array ) ) {
					foreach( $module_obj->require_module_array as $require_module_name ) {
						$this->loadModule( $require_module_name, $force );
					}
				}
				// 指定モジュールを実行する
				$module_obj->execute( $this->request_object );
				$module_obj	= $this->executed_module_object_array[$module_name]	= $module_obj;
				array_unshift( $this->executed_module_name_array, $module_name );
				// 指定後処理モジュールがあるなら実行する
				if( is_array( $module_obj->post_module_array ) ) {
					foreach( $module_obj->post_module_array as $post_module_name ) {
						$this->loadModule( $post_module_name, $force );
					}
				}
			} else {
				return;
			}
		}
	}
	/**
	 * 現在までに実行したモジュールの後処理メソッドを降順で呼び出します。
	 */
	function post_process_all() {
		foreach ( $this->executed_module_name_array as $module_name ) {
			$module_obj	= $this->executed_module_object_array[$module_name];
			if ( method_exists ( $module_obj, 'post_process' ) ) {
				$module_obj->post_process( $this->request_object );
			}
		}
	}
	/**
	 * メインテンプレートを設定します。
	 * @param $template_name テンプレート名
	 * @param $ext 
	 */
	function setTemplate( $template_name, $ext=null ) {
		$this->http_output_object->setTemplate( $template_name, $ext );
	}
	/**
	 * 出力文字セットを設定します。（デフォルトUTF-8)
	 * @param $charset 文字セット
	 */
	function setOutputCharset( $charset ) {
		$this->http_output_object->setOutputCharset( $charset );
	}
	/**
	 * 出力言語を設定します（デフォルトJapanese）
	 * @param $language 出力言語
	 */
	function setLanguage( $language ) {
		$this->http_output_object->setLanguage( $language );
	}
}
?>
