<?php
/**
 * HTML用変換タグの基礎クラス
 * 
 * @package spider spiderのコアパッケージ
 * @subpackage tags spiderのテンプレートタグ変換クラスパッケージ
 * @version 1.1.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR."TagBase.class.php");
class spider_tags_If extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_If() {
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$creator ){
		$vars_tags_aray			= array();
		preg_match_all( '/\\{if\\:[^\\}]*?}/'
			, $result_strings
			, $vars_tags_aray
			, PREG_PATTERN_ORDER );
		$valiable_counter	= 0;
		foreach ( $vars_tags_aray as $vars_tags ) {
			foreach ( $vars_tags as $vars_tag ) {
				$var_name	= preg_replace( '/\\{if\\:/','', $vars_tag );
				$var_name	= preg_replace( '/\\}$/','', $var_name );
				$var_name	= trim( $var_name );
				$repstr		= $this->parseCondition( $var_name, $valiable_counter );
				$result_strings	= str_replace( $vars_tag, $repstr, $result_strings );
				$valiable_counter++;
			}
		}
		$result_strings = str_replace( '{else}', '<?php } else { ?>', $result_strings );
		$result_strings = str_replace( '{end-if}', '<?php } ?>', $result_strings );
		$result_strings = str_replace( '{/if}', '<?php } ?>', $result_strings );
	}
	/**
	 * if条件文の式を解析する
	 * 定義済み文字列： and / or / = / != / > / < / + / - / * // is null /is not null/in
	 */
	function parseCondition( $strings, $prefix=1 ) {

		// 内部で利用されている変数を全て取り出す
		$var_name_array		= array();
		$and_array			= explode( ' and ', $strings );
		foreach( $and_array as $condition_and ) {
			$or_array		= explode( ' or ', $condition_and );
			foreach( $or_array as $condition_or ) {
				$divider	= '';
				if( preg_match('/\\<=/', $condition_or ) > 0 ) {
					$divider	= '<=';
				} else if( preg_match('/\\</', $condition_or ) > 0 ) {
					$divider	= '<';
				} else if( preg_match('/\\>=/', $condition_or ) > 0 ) {
					$divider	= '>=';
				} else if( preg_match('/\\>/', $condition_or ) > 0 ) {
					$divider	= '>';
				} else if( preg_match('/\\!=/', $condition_or ) > 0 ) {
					$divider	= '!=';
				} else if( preg_match('/\\=/', $condition_or ) > 0 ) {
					$divider	= '=';
				} else if( preg_match('/ is not null/', $condition_or ) > 0 ) {
					$divider	= ' is not null';
				} else if( preg_match('/ is null/', $condition_or ) > 0 ) {
					$divider	= ' is null';
				} else if( preg_match('/ in /', $condition_or ) > 0 ) {
					$divider	= ' in ';
				} else {
					$divider	= '';
				}
				if( $divider == ' in ' ) {
					list( $pre, $post ) = explode( $divider, $condition_or );
					$str	= 'in_array('.$pre.','.$post.')';
					$strings	= str_replace( $condition_or, $str, $strings );
				}
				if( $divider == ' is null' ) {
					list( $pre ) = explode( $divider, $condition_or );
					$str	= 'is_null('.$pre.') || ( is_string('.$pre.') && strlen('.$pre.') == 0 ) ';
					$strings	= str_replace( $condition_or, $str, $strings );
				}
				if( $divider == ' is not null' ) {
					list( $pre ) = explode( $divider, $condition_or );
					$str	= '!is_null('.$pre.')';
					$strings	= str_replace( $condition_or, $str, $strings );
				}
				// =/ !=で前または後が空文字列だった場合の対策
				if( $divider == '=' ) {
					list( $pre, $post ) = explode( $divider, $condition_or );
					if( strlen(trim($pre)) == 0 ) {
						$pre	= "''";
					}
					if( strlen(trim($post)) == 0 ) {
						$post	= "''";
					}
					$str	= trim($pre)." == ".trim($post);
					$strings	= str_replace( $condition_or, $str, $strings );
				}
				if( $divider == '!=' ) {
					list( $pre, $post ) = explode( $divider, $condition_or );
					if( strlen(trim($pre)) == 0 ) {
						$pre	= "''";
					}
					if( strlen(trim($post)) == 0 ) {
						$post	= "''";
					}
					$str	= trim($pre)." != ".trim($post);
					$strings	= str_replace( $condition_or, $str, $strings );
				}
				
				if( strlen($divider) > 0 ) {
					// 比較演算子で区切れるなら計算式の項を前から順に取り出す
					$element_array	= explode($divider,$condition_or);
					foreach( $element_array as $element ) {
						$pos=0;
						for( $i=0; $i<strlen($element); $i++ ) {
							$char	= substr($element,$i,1);
							if( '+' == $char || '-' == $char
								|| '*' == $char || '/' == $char
								|| '(' == $char || ')' == $char || ',' == $char || '!' == $char ) {
								// 演算子が登場したらひとつ前までを文字列切り出し
								$str	= substr( $element, $pos, $i-$pos );
								$pos	= $i+1;
								if( '(' != $char && strlen( trim($str) ) > 0 ) {
									// 関数名でなければ追加
									$var_name_array[trim($str)]	= '';
								}
							}
						}
						// ループ最後のポジションから最後の要素を切り出し
						$str	= substr( $element, $pos, $i-$pos );
						if( strlen( trim($str) ) > 0 ) {
							$var_name_array[trim($str)]	= '';
						}
					}
				} else {
					// 比較演算子で区切れないなら単一要素
					$pos=0;
					for( $i=0; $i<strlen($condition_or); $i++ ) {
						$char	= substr($condition_or,$i,1);
						if( '+' == $char || '-' == $char
							|| '*' == $char || '/' == $char
							|| '(' == $char || ')' == $char || ',' == $char || '!' == $char ) {
							// 演算子が登場したらひとつ前までを文字列切り出し
							$str	= substr( $condition_or, $pos, $i-$pos );
							$pos	= $i+1;
							if( '(' != $char && strlen( trim($str) ) > 0 ) {
								// 関数名でなければ追加
								$var_name_array[trim($str)]	= '';
							}
						}
					}
					// ループ最後のポジションから最後の要素を切り出し
					$str	= substr( $condition_or, $pos, $i-$pos );
					if( strlen( trim($str) ) > 0 ) {
						$var_name_array[trim($str)]	= '';
					}
				}
			}
		}
		// 変数一時格納配列
		$temporary_valiable_getter_array	= array();
		
		// 変数の変換を確認
		$vcounter	= 0;
		foreach( $var_name_array as $key => $value ) {
			if( strlen($key) > 0 ) {
				if( is_numeric( $key ) ) {
					// 変数が数字なら変換対象としない
					$var_name_array[$key]	= $key;
				} else if( 'true' == $key || 'false' == $key ) {
					// trueとfalseはそのまま利用する
					$var_name_array[$key]	= $key;
				} else {
					// 変数が文字列の場合
					$tmp_name	= '$____' . sprintf('%03d',$prefix) . sprintf('%03d',$vcounter);
					$var_name_array[$key]	= $tmp_name;
					if( preg_match('/^\\\'(.)*\\\'$/',$key) > 0 ) {
						$str	= $tmp_name. '='.$key.';'."\n";
						array_push( $temporary_valiable_getter_array, $str );
					} else {
						list( $vname, $vparam )		= explode('::',$key);
						// 一時編集取得文字列作成
						$str	= $tmp_name. '=$request_object->getAttribute(\''.$vname.'\');'."\n";
						$str	.= 'if( !$request_object->existAttribute("'.$vname.'") ){'."\n";
						$str	.= "\t".$tmp_name. '=\''.$vname.'\';'."\n";
						$str	.= '} else if(\'array\'==gettype('.$tmp_name.')) {'."\n";
						if( is_numeric($vparam) ) {
							$str	.= "\t".$tmp_name. '='.$tmp_name.'['.$vparam.'];'."\n";
						} else if( strlen(trim($vparam)) > 0 ){
							$str	.= "\t".$tmp_name. '='.$tmp_name.'[\''.$vparam.'\'];'."\n";
						}
						$str	.= '} else if(\'object\'==gettype('.$tmp_name.')) {'."\n";
						if( is_numeric($vparam) ) {
							// オブジェクトの場合、数値は許可できません。(変数名、メソッド名は数値から始められない)
							$str	.= "\t".'$request_object->addError(\'オブジェクトの添え字には数字を指定できません。\');'."\n";
						} else if( strlen(trim($vparam)) > 0 ){
							$str	.= "\t".$tmp_name. '='.$tmp_name.'->'.$vparam.';'."\n";
						}
						$str	.= '}'."\n";
						array_push( $temporary_valiable_getter_array, $str );
					}
					$vcounter++;
				}
			}
		}
		// 変数配列を文字列の長い順にソート
		$order_array	= array();
		foreach( $var_name_array as $key => $value ) {
			if( !is_array( $order_array[strlen($key)] ) ) {
				$order_array[strlen($key)]	= array();
			}
			array_push($order_array[strlen($key)],$key);
		}
		krsort($order_array);
		$new_var_name_array		= array();
		foreach( $order_array as $item_array ) {
			foreach( $item_array as $name ) {
				$new_var_name_array[$name]	= $var_name_array[$name];
			}
		}
		
		// 渡された文字列の置換
		foreach( $new_var_name_array as $key => $value ) {
			$strings	= str_replace( $key, $value, $strings );
		}
		// and or の置換
		$strings	= str_replace( 'and', '&&', $strings );
		$strings	= str_replace( 'or', '||', $strings );
		$strings	= 'if( ' . $strings .' ) {';
		// 変数取り出し文字列を冒頭に追加
		$strings	= implode("\n",$temporary_valiable_getter_array).$strings;
		$strings	= '<?php ' . $strings .' ?>';
		
		return $strings;
	}
}
?>