<?php
/**
 * HTML用変換タグの基礎クラス
 * 
 * @package spider spiderのコアパッケージ
 * @subpackage tags spiderのテンプレートタグ変換クラスパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR."TagBase.class.php");
class spider_tags_Module extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_Module() {
		$this->priority	= 10;
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$creator ){
		// モジュール読み込み行を取得
		if( preg_match_all( '/\\$this->loadModule\\([^\\)]*?\\)\\;/'
			, $result_strings
			, $output_array
			, PREG_PATTERN_ORDER ) > 0 ) {
			foreach ( $output_array as $output ) {
				foreach ( $output as $target ) {
					$module_name	= preg_replace( '/\\$this->loadModule\\(/','', $target );
					$module_name	= preg_replace( '/\\)\\;/','', $module_name );
					$module_name	= str_replace("'","",$module_name);
					$module_name	= str_replace('"','',$module_name);
					$result_strings = str_replace( $target, "", $result_strings );
					array_push($creator->module_name_array,trim($module_name));
				}
			}
		}
		// モジュール読み込みタグ
		$vars_tags_aray			= array();
		if( preg_match_all( '/\\{module\\:[^\\}]*?}/'
			, $result_strings
			, $vars_tags_aray
			, PREG_PATTERN_ORDER ) > 0 ) {
			foreach ( $vars_tags_aray as $vars_tags ) {
				foreach ( $vars_tags as $vars_tag ) {
					$module_name	= preg_replace( '/\\{module\\:/','', $vars_tag );
					$module_name	= preg_replace( '/\\}$/','', $module_name );
					$module_name	= str_replace("'","",$module_name);
					$module_name	= str_replace('"','',$module_name);
					array_push($creator->module_name_array,trim($module_name));
					$result_strings = str_replace( $vars_tag
						, ''
						, $result_strings );
				}
			}
		}
	}
}
?>