<?php
/**
 * HTML用変換タグの基礎クラス
 * 
 * @package spider spiderのコアパッケージ
* @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR."TagBase.class.php");
class spider_tags_Template extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_Template() {
		$this->priority	= 0;
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$creator ){
		// 外側テンプレートを確認(旧バージョン互換)
		preg_match_all( '/\\$this->setTemplate\\([^\\)]*?\\)\\;/'
			, $creator->out_body_strings
			, $output_array
			, PREG_PATTERN_ORDER );
		foreach ( $output_array as $output ) {
			foreach ( $output as $target ) {
				$template_name	= preg_replace( '/\\$this->setTemplate\\(/','', $target );
				$template_name	= preg_replace( '/\\)\\;/','', $template_name );
				list( $template_name,$template_type )	= explode(",",$template_name);
				$template_name	= str_replace("'","",$template_name);
				$template_name	= str_replace('"','',$template_name);
				$template_name	= trim($template_name);
				$template_type	= str_replace("'","",$template_type);
				$template_type	= str_replace('"','',$template_type);
				$template_type	= trim($template_type);
				$creator->out_body_strings = str_replace( $target, "", $creator->out_body_strings );
				$creator->template_outer	= $template_name;
				$creator->template_type	= $template_type;
			}
		}
		// 外側テンプレートを確認
		preg_match_all( '/\\{tpl\\-outer\\:[^\\}]*?\\}/'
			, $creator->out_body_strings
			, $output_array
			, PREG_PATTERN_ORDER );
		foreach ( $output_array as $output ) {
			foreach ( $output as $target ) {
				$template_name	= preg_replace( '/\\{tpl\\-outer\\:/','', $target );
				$template_name	= preg_replace( '/\\}/','', $template_name );
				$creator->out_body_strings = str_replace( $target, "", $creator->out_body_strings );
				$template_name	= trim($template_name);
				$creator->template_outer	= $template_name;
			}
		}
		preg_match_all( '/\\{tpl\\-type\\:[^\\}]*?\\}/'
			, $creator->out_body_strings
			, $output_array
			, PREG_PATTERN_ORDER );
		foreach ( $output_array as $output ) {
			foreach ( $output as $target ) {
				$template_type	= preg_replace( '/\\{tpl\\-type\\:/','', $target );
				$template_type	= preg_replace( '/\\}/','', $template_type );
				$creator->out_body_strings = str_replace( $target, "", $creator->out_body_strings );
				$template_type	= trim($template_type);
				$creator->template_type	= $template_type;
			}
		}
		
		// 外側テンプレート適用
		$template_file_path	= $creator->getRealTemplateFilePath( $creator->template_outer );
		if ( !is_null( $creator->template_outer ) && file_exists( $template_file_path ) ) {
			// テンプレートファイルの内容を取得
			$template_lines		= file( $template_file_path );
			$template_outer_strings	= implode( "", $template_lines );
			// テンプレートの改行コードを統一
			$template_outer_strings = str_replace( "\r\n", "\n" , $template_outer_strings );
			$template_outer_strings = str_replace( "\r", "\n" , $template_outer_strings );
			
			// action resultは先にテンプレートに適用する
			$template_outer_strings	= str_replace( '{write:action_result}'
				, $creator->out_body_strings
				, $template_outer_strings );

		} else {
			$template_outer_strings	= $creator->out_body_strings;
		}
		// 子テンプレート呼び出し箇所の確認
		$child_template_tag_aray		= array();
		while( preg_match_all( '/\\{tpl\\:[^\\}]*?}/'
			, $template_outer_strings
			, $child_template_tag_aray
			, PREG_PATTERN_ORDER ) > 0 ) {
			foreach ( $child_template_tag_aray as $child_template_tags ) {
				foreach ( $child_template_tags as $child_template_tag ) {
					$child_template_file	= preg_replace( '/\\{tpl\\:/','', $child_template_tag );
					$child_template_file	= preg_replace( '/\\}$/','', $child_template_file );
					array_push( $creator->template_array, $child_template_file );
					$child_template_file_path = $creator->getRealTemplateFilePath( $child_template_file );
					if ( file_exists( $child_template_file_path ) ) {
						// 子テンプレート出力文字列取得
						$child_template_lines		= file( $child_template_file_path );
						$child_template_strings		= implode( "", $child_template_lines );
						// 子テンプレートの改行コードを統一
						$child_template_strings = str_replace( "\r\n", "\n" , $child_template_strings );
						$child_template_strings = str_replace( "\r", "\n" , $child_template_strings );
						// テンプレート文字列に子テンプレートの出力
						$template_outer_strings = str_replace( $child_template_tag, $child_template_strings, $template_outer_strings );
					}
				}
			}
		}
		$creator->out_body_strings		= $template_outer_strings;
	}
	
}
?>