<?php
/**
 * HTML用変換タグの基礎クラス
 * 
 * @package spider spiderのコアパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR."TagBase.class.php");
class spider_tags_UseSession extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_UseSession() {
		$this->priority	= 0;
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$creator ){
		
		if( preg_match('/\\{use-session\\:[fF][aA][lL][sS][eE]\\}/', $creator->out_body_strings ) > 0
			|| preg_match('/\\{use-session\\:[nN][oO]\\}/', $creator->out_body_strings ) > 0 ) {
			// falseかnoが指定されているならセッションは開始しない
			$creator->out_body_strings = preg_replace( '/\\{use-session\\:[fF][aA][lL][sS][eE]\\}/'
				, "", $creator->out_body_strings );
		} else {
			// 明示的にセッション開始を否定していないなら暗黙的にセッションを開始する
			$creator->out_body_strings = preg_replace( '/\\{use-session\\:[^\\}]*?\\}/'
				, "", $creator->out_body_strings );
			$process_code	= "if( defined('SPIDER_USE_SPIDER_SESSION_ID') && SPIDER_USE_SPIDER_SESSION_ID ) {\n"
				. "if( !spider_session_start() ) {\n"
				. "header( 'Content-type: text/plain;charset=UTF-8' );\n"
				. "die( 'Core Error : アプリケーションセッションを開始できませんでした。' );\n}\n"
				. "}else{\n"
				. "session_start();\n}"
			;
			if( !is_array($creator->preview_process_hash) ){
				$creator->preview_process_hash	= array();
			}
			if( !is_array($creator->preview_process_hash[$this->priority]) ){
				$creator->preview_process_hash[$this->priority]	= array();
			}
			array_push( $creator->preview_process_hash[$this->priority], $process_code );
		}
		
	}
}
?>