<?php
/**
 * メール送信基底クラス
 * @package util ユーティリティパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class util_Mail {
	
	/** 送信設定オプション	*/
	var $options	= array();
	/** 初期化済みフラグ	*/
	var $is_init	= false;
	
	// 送信項目
	/** subject	*/
	var $subject;
	/** text body	*/
	var $text_body;
	/** attachement	*/
	var $attachements	= array();
	
	/** To	*/
	var $to;
	/** From	*/
	var $from;
	/** Cc	*/
	var $cc		= array();
	/** Bcc	*/
	var $bcc	= array();
	/** reply to	*/
	var $reply_to;
	/** return path	*/
	var $return_path;
	
	// option
	var $boundary;
	var $x_mailer			= 'MDS.Co.,Ltd./Web Mailer v1.0.0/www.md-systems.net';
	var $charset_header		= 'ISO-2022-JP';
	var $charset_body		= 'ISO-2022-JP';
	var $charset_file_name	= 'Shift_JIS';
	var $replace_words	= array();
		
	/**
	 * コンストラクタ
	 */
	function util_Mail() {
	}
	/**
	 * 送信メソッドクラス定義に合わせたインスタンスを生成します。
	 * $class_name: SendMail / SMTP /PHP
	 * $options:    送信オプション
	 */
	function get_instance( $class_name='SendMail', $options=array() ) {
		$send_class_path	= dirname(__FILE__)
			.DIRECTORY_SEPARATOR.'mail'
			.DIRECTORY_SEPARATOR.$class_name.'.class.php';
		if( !file_exists( $send_class_path ) ) {
			return false;
		} else {
			require_once($send_class_path);
			$send_class_name	= 'util_mail_' . $class_name;
			$send_object		= new $send_class_name;
			if( count($send_object->validate_options( $options )) == 0 ) {
				$send_object->init( $options );
				return $send_object;
			} else {
				return false;
			}
		}
	}
	/**
	 * 送信設定オプションの妥当性検査を行いエラーメッセージの配列を返します。
	 * エラーがない場合は要素0の配列を返します。
	 */
	function validate_options( $options = array() ) {
		return array();
	}
	/**
	 * 指定された送信設定オプションで送信オブジェクトを初期化します。
	 */
	function init( $options = array() ) {
		$this->options	= $options;
		$this->is_init	= true;
	}
	/**
	 * 件名を設定します。
	 * @param $subject string
	 */
	function setSubject( $subject ) {
		$this->subject	= $subject;
	}
	/**
	 * テキスト本文を設定します。
	 * @param $body string
	 */
	function setTextBody( $body ) {
		$this->text_body	= $body;
	}
	/**
	 * テンプレートから件名と本文を設定します。
	 * @param $file_path テンプレートファイルパス
	 */
	function setTemplateFile( $file_path ) {
		if( file_exists( $file_path ) ) {
			if( $lines = @file( $file_path ) ) {
				$this->subject		= array_shift( $lines );
				$this->subject		= str_replace("\r\n","",$this->subject);
				$this->subject		= str_replace("\r","",$this->subject);
				$this->subject		= str_replace("\n","",$this->subject);
				$this->text_body	= implode("",$lines);
				$this->text_body	= str_replace("\r\n","\n",$this->text_body);
				$this->text_body	= str_replace("\r","\n",$this->text_body);
			} else {
				return false;
			}
		} else {
			return false;
		}
		return true;
	}
	/**
	 * Fromアドレスを設定します。
	 * メールアドレス RFC 2822を満たしていればアドレスに名前を付加することもできます。
	 * 例) MDS <info@md-systems.net>
	 * @param $address string
	 */
	function setFrom( $address ) {
		$this->from	= $address;
	}
	function setReplyTo( $address ) {
		$this->reply_to	= $address;
	}
	function setReturnPath( $address ) {
		$this->return_path	= $address;
	}
	/**
	 * Ccアドレスを配列で設定します。
	 * メールアドレス RFC 2822を満たしていればアドレスに名前を付加することもできます。
	 * 例) MDS <info@md-systems.net>
	 * @param $address_array string
	 */
	function setCc( $address_array ) {
		if( is_array( $address_array ) ) {
			$this->cc	= $address_array;
		} else if( strlen(trim($address_array)) > 0 ) {
			$this->cc	= array();
			array_push( $this->cc, $address_array );
		}
	}
	/**
	 * Ccアドレスを追加します。
	 * メールアドレス RFC 2822を満たしていればアドレスに名前を付加することもできます。
	 * 例) MDS <info@md-systems.net>
	 * @param $address string
	 */
	function addCc( $address ) {
		if( !is_array( $this->cc) ) {
			$this->cc	= array();
		}
		array_push( $this->cc, $address );
	}
	/**
	 * Bccアドレスを配列で設定します。
	 * メールアドレス RFC 2822を満たしていればアドレスに名前を付加することもできます。
	 * 例) MDS <info@md-systems.net>
	 * @param $address_array string
	 */
	function setBcc( $address_array ) {
		if( is_array( $address_array ) ) {
			$this->bcc	= $address_array;
		} else if( strlen(trim($address_array)) > 0 ) {
			$this->bcc	= array();
			array_push( $this->bcc, $address_array );
		}
	}
	/**
	 * Bccアドレスを追加します。
	 * メールアドレス RFC 2822を満たしていればアドレスに名前を付加することもできます。
	 * 例) MDS <info@md-systems.net>
	 * @param $address string
	 */
	function addBcc( $address ) {
		if( !is_array( $this->bcc) ) {
			$this->bcc	= array();
		}
		array_push( $this->bcc, $address );
	}
	/**
	 * 添付ファイルを追加します。
	 * @param $address string
	 */
	function addAttachement( $file_path, $name=null, $type="application/octet-stream" ) {
		if( !is_array( $this->attachements ) ) {
			$this->attachements	= array();
		}
		if( is_null( $name ) || strlen(trim($name)) == 0 ) {
			$name	= basename( $file_path );
		}
		$file_info	= array(
			'name'	=> $name,
			'path'	=> $file_path,
			'type'	=> $type
		);
		array_push( $this->attachements, $file_info );
	}

	/**
	 * メールを送信します
	 */
	function send( $to, $subject=null, $body=null, $from=null, $reply_to=null, $return_path=null, $cc=null, $bcc=null ) {
		$this->to	= $to;
		if( !is_null($subject) && strlen(trim($subject)) > 0 ) {
			$this->subject	= $subject;
		}
		if( !is_null($body) && strlen(trim($body)) > 0 ) {
			$this->text_body	= $body;
		}
		if( !is_null($from) && strlen(trim($from)) > 0 ) {
			$this->from	= $from;
		}
		if( !is_null($reply_to) && strlen(trim($reply_to)) > 0 ) {
			$this->reply_to	= $reply_to;
		}
		if( !is_null($return_path) && strlen(trim($return_path)) > 0 ) {
			$this->return_path	= $return_path;
		}
		if( is_array( $cc ) ) {
			$this->setCc( $cc );
		} else if( strlen(trim($cc)) > 0 ) {
			$this->addCc( $cc );
		}
		if( is_array( $bcc ) ) {
			$this->setBcc( $bcc );
		} else if( strlen(trim($bcc)) > 0 ) {
			$this->addBcc( $bcc );
		}
		return $this->send_execute();
	}
	/**
	 * 送信処理を行う抽象メソッド
	 */
	function send_execute() {
		return false;
	}
	/**
	 * メールヘッダ用にエンコードした件名を取得します
	 */
	function get_encoded_subject() {
		// 置換文字列の処理を行う
		$subject	= $this->subject;
		foreach( $this->replace_words as $key => $val ) {
			$subject			= str_replace( "{".$key."}", $val, $subject );
		}
		// 文字コード変換
		if( mb_detect_encoding($subject) != 'ascii' ) {
			$subject	= mb_convert_encoding($subject,$this->getHeaderEncoding(),'auto');
		}
		$subject					= base64_encode( $subject );
		return '=?'.$this->getHeaderCharset().'?B?'.$subject.'?=';
	}
	/**
	 * 設定されたメールヘッダーをヘッダー文字列として取得します。
	 */
	function _get_header_part_strings( $include_to=false, $include_subject=false, $include_bcc=false ) {
		$header_hash	= $this->_get_header_hash( $include_to, $include_subject, $include_bcc );
		$header_strings	= '';
		foreach( $header_hash as $key => $value ) {
			$header_strings	.= $key . ': ' . $value . "\r\n";
		}
		return $header_strings;
	}
	/**
	 * 設定されたメールヘッダーをエンコード済みのハッシュで取得します。
	 */
	function _get_header_hash( $include_to=false, $include_subject=false, $include_bcc=false ) {
		$return_hash	= array();
		$return_hash['MIME-Version']					= '1.0';
		$return_hash['Content-Transfer-Encoding']	= '7bit';
		$return_hash['X-Mailer']						= $this->x_mailer;
		
		if( strlen(trim($this->reply_to)) == 0 ) {
			$this->reply_to	= $this->from;
		}
		if( strlen(trim($this->return_path)) == 0 ) {
			$this->return_path	= $this->from;
		}
		
		// メールアドレス RFC 2822を満たすことを前提としてユーザ名をエンコードする
		if( $include_to ) {
			$return_hash['To']				= $this->convertHeaderAddress( $this->to );
		}
		$return_hash['From']			= $this->convertHeaderAddress( $this->from );
		$return_hash['Reply-To']		= $this->convertHeaderAddress( $this->reply_to );
		$return_hash['Return-Path']	= $this->convertHeaderAddress( $this->return_path );
		$new_cc_array	= array();
		foreach( $this->cc as $address ) {
			if( strlen(trim($address)) > 0 ) {
				// RFC 2822を満たすことを前提としてユーザ名をエンコードする
				array_push( $new_cc_array, $this->convertHeaderAddress( $address ) );
			}
		}
		if( count($new_cc_array) > 0 ) {
			$return_hash['Cc']				= implode(", ", $new_cc_array );
		}
		if( $include_bcc ) {
			$new_bcc_array	= array();
			foreach( $this->bcc as $address ) {
				if( strlen(trim($address)) > 0 ) {
					// RFC 2822を満たすことを前提としてユーザ名をエンコードする
					array_push( $new_bcc_array, $this->convertHeaderAddress( $address ) );
				}
			}
			if( count($new_bcc_array) > 0 ) {
				$return_hash['Bcc']				= implode(", ", $new_bcc_array );
			}
		}
		// 件名の処理
		if( $include_subject ) {
			// 置換文字列の処理を行う
			$subject	= $this->subject;
			foreach( $this->replace_words as $key => $val ) {
				$subject			= str_replace( "{".$key."}", $val, $subject );
			}
			// 文字コード変換
			if( mb_detect_encoding($subject) != 'ascii' ) {
				$subject	= mb_convert_encoding($subject,$this->getHeaderEncoding(),'auto');
			}
			$subject					= base64_encode( $subject );
			$return_hash['Subject']	= '=?'.$this->getHeaderCharset().'?B?'.$subject.'?=';
		}
		// 現在の日時を追加
		$return_hash['Date']	= date('r');

		// 添付ファイルの確認
		if( is_array($this->attachements) && count( $this->attachements ) > 0 ) {
			$this->boundary = "-*-*-*-*-*-*-*-*-Boundary_" . uniqid("b");
			$return_hash['Content-Type']	= 'Multipart/Mixed; boundary="'.$this->boundary.'"'."\r\n";
		} else {
			$return_hash['Content-Type']	= 'text/plain; charset='.$this->getBodyCharset()."\r\n";
		}

		return $return_hash;
	}
	/**
	 * Toのアドレス部分のみを抜き出したメールアドレスのみを取得します。
	 */
	function getToAddress() {
		$to	= $this->to;
		if( preg_match('/\\s/',$to) > 0 ) {
			$params = explode(' ', $to );
			$to		= array_pop($params);
		}
		$to	= trim($to);
		$to	= preg_replace('/^</','',$to);
		$to	= preg_replace('/>$/','',$to);
		return $to;
	}
	/**
	 * Fromのアドレス部分のみを抜き出したメールアドレスのみを取得します。
	 */
	function getFromAddress() {
		$from	= $this->from;
		if( preg_match('/\\s/',$from) > 0 ) {
			$params 	= explode(' ', $from );
			$from		= array_pop($params);
		}
		$from	= trim($from);
		$from	= preg_replace('/^</','',$from);
		$from	= preg_replace('/>$/','',$from);
		return $from;
	}
	/**
	 * Ccのアドレス部分のみを抜き出したメールアドレスのみの配列を取得します。
	 */
	function getCcAddresses() {
		$addresses	= array();
		if( is_array($this->cc) ) {
			foreach( $this->cc as $address ) {
				if( strlen(trim($address)) > 0 ) {
					if( preg_match('/\\s/',$address) > 0 ) {
						$params 	= explode(' ', $address );
						$address	= array_pop($params);
					}
					$address	= trim($address);
					$address	= preg_replace('/^</','',$address);
					$address	= preg_replace('/>$/','',$address);
					if( strlen(trim($address)) > 0 ) {
						array_push( $addresses, $address );
					}
				}
			}
		}
		return $addresses;
	}
	/**
	 * Bccのアドレス部分のみを抜き出したメールアドレスのみの配列を取得します。
	 */
	function getBccAddresses() {
		$addresses	= array();
		if( is_array($this->bcc) ) {
			foreach( $this->bcc as $address ) {
				if( strlen(trim($address)) > 0 ) {
					if( preg_match('/\\s/',$address) > 0 ) {
						$params 	= explode(' ', $address );
						$address	= array_pop($params);
					}
					$address	= trim($address);
					$address	= preg_replace('/^</','',$address);
					$address	= preg_replace('/>$/','',$address);
					if( strlen(trim($address)) > 0 ) {
						array_push( $addresses, $address );
					}
				}
			}
		}
		return $addresses;
	}
	/**
	 * 
	 */
	function convertHeaderAddress( $address ) {
		// to RFC 2822を満たすことを前提としてユーザ名をエンコードする
		$name	= '';
		if( preg_match('/\\s/',$address) > 0 ) {
			$params		= explode(' ', $address );
			$address	= array_pop( $params );
			$name		= implode( ' ', $params );
			if( mb_detect_encoding($address) != 'ascii' ) {
				$name	= mb_convert_encoding($name,$this->getHeaderEncoding(),'auto');
			}
			$name	= base64_encode( $name );
			$name	= '=?'.$this->getHeaderCharset().'?B?'.$name.'?=';
			$address	= $name.' '.$address;
		}
		return $address;
	}
	/**
	 * メールのボディパート文字列を取得します。
	 */
	function _get_body_part_strings() {
		// text_bodyのみ置換文字列の処理を行う
		$text_body	= $this->text_body;
		foreach( $this->replace_words as $key => $val ) {
			$text_body			= str_replace( "{".$key."}", $val, $text_body );
		}
		// リターンするbody文字列を作成する
		$return_body	= '';
		if( is_array($this->attachements) && count( $this->attachements ) > 0 ) {
			// 添付ファイルが指定されているならテキストパートとファイルパートに分けて作成
			// textパート
			$return_body	= '--' . $this->boundary . "\r\n";
			$return_body	.= 'Content-Type: text/plain; charset="'.$this->getBodyCharset().'"' ."\r\n";
			$return_body	.= mb_convert_encoding(str_replace("\r","\n",str_replace("\r\n","\n",$text_body)),$this->getBodyEncoding(),'auto');
			$return_body	.= "\r\n";
			// ファイルパート
			foreach( $this->attachements as $file_info ) {
				$file_path	= $file_info['path'];
				$file_type	= $file_info['type'];
				$file_name	= $file_info['name'];
				$contents	= file_get_contents( $file_path );
				$attach		= chunk_split(base64_encode($contents));
				$file_name	= mb_convert_encoding( $file_name, $this->getFileNameEncoding(), 'auto');
				$file_name	= base64_encode($file_name);
				$file_name	= '=?'.$this->getFileNameCharset().'?B?'.$file_name.'?=';

				$return_body	.= '--' . $this->boundary . "\r\n";
				$return_body	.= 'Content-Type: '.$file_type.'; name="'.$file_name.'"'."\r\n";
				$return_body	.= 'Content-Transfer-Encoding: base64'."\r\n";
				$return_body	.= 'Content-Disposition: attachment; filename="'.$file_name.'"'."\r\n";
				$return_body	.= "\r\n";
				$return_body	.= $attach . "\r\n";
				$return_body	.= "\r\n";
			}
			// マルチパート終了
			$return_body	.= '--' . $this->boundary . '--'."\r\n";

		} else {
			// 添付ファイルがないならプレーンテキストbodyの改行コードはLFに統一する
			$return_body	= str_replace("\r\n","\n",$text_body);
			$return_body	= str_replace("\r","\n",$return_body);
			// 本文の文字コード
			if( mb_detect_encoding($return_body) != 'ascii' ) {
				$return_body		= mb_convert_encoding($return_body,$this->getBodyEncoding(),'auto');
			}
		}
		return $return_body;
	}
	/**
	 * 本文と件名の特定置き換えワードを設定します。
	 */
	function addReplaceWord( $name, $value ) {
		$this->replace_words[$name]	= $value;
	}
	/**
	 * 本文と件名の特定置き換えワードをオブジェクトで設定します。
	 */
	function addReplaceWordByObject( $prefix_name, $object ) {
		$vars	= get_object_vars( $object );
		foreach( $vars as $key=>$val ) {
			if( gettype( $val ) != 'object'
				&& gettype( $val ) != 'array'
				&& gettype( $val ) != 'resource'
			) {
				$this->addReplaceWord( $prefix_name."::".$key, $val );
			}
		}
	}
	/**
	 * メールヘッダの文字コードを指定します。
	 */
	function setHeaderCharset( $charset ) {
		$this->charset_header	= $charset;
	}
	/**
	 * 設定されているメールヘッダ文字コードを取得します
	 */
	function getHeaderCharset() {
		return $this->charset_header;
	}
	/**
	 * 設定されているメールヘッダ文字コードで利用するPHPコード変換ルールを取得します
	 */
	function getHeaderEncoding() {
		$key	= strtoupper($this->charset_header);
		if( isset( $GLOBALS['UTIL_MAIL_CHARSET_CODE_MAP'][$key]) ) {
			return $GLOBALS['UTIL_MAIL_CHARSET_CODE_MAP'][$key];
		} else {
			return $this->charset_header;
		}
	}
	/**
	 * テキストボディの文字コードを指定します。
	 */
	function setBodyCharset( $charset ) {
		$this->charset_body	= $charset;
	}
	/**
	 * 設定されているテキストボディ文字コードを取得します
	 */
	function getBodyCharset() {
		return $this->charset_body;
	}
	/**
	 * 設定されているテキストボディ文字コードで利用するPHPコード変換ルールを取得します
	 */
	function getBodyEncoding() {
		$key	= strtoupper($this->charset_body);
		if( isset( $GLOBALS['UTIL_MAIL_CHARSET_CODE_MAP'][$key]) ) {
			return $GLOBALS['UTIL_MAIL_CHARSET_CODE_MAP'][$key];
		} else {
			return $this->charset_body;
		}
	}
	/**
	 * 添付ファイル名の文字コードを指定します。
	 */
	function setFileNameCharset( $charset ) {
		$this->charset_filename	= $charset;
	}
	/**
	 * 設定されている添付ファイル名文字コードを取得します
	 */
	function getFileNameCharset() {
		return $this->charset_filename;
	}
	/**
	 * 設定されている添付ファイル名文字コードで利用するPHPコード変換ルールを取得します
	 */
	function getFileNameEncoding() {
		$key	= strtoupper($this->charset_filename);
		if( isset( $GLOBALS['UTIL_MAIL_CHARSET_CODE_MAP'][$key]) ) {
			return $GLOBALS['UTIL_MAIL_CHARSET_CODE_MAP'][$key];
		} else {
			return $this->charset_filename;
		}
	}
}
// 本クラスで利用するグローバル変数定義
/** 文字コード変換ルール	*/
$GLOBALS['UTIL_MAIL_CHARSET_CODE_MAP']	= array(
	'JIS'			=> 'ISO-2022-JP',
	'SHIFT_JIS'	=> 'SJIS-win',
	'SHIFT-JIS'	=> 'SJIS-win',
);
?>