<?php
/*
 * Created on 2008/05/18
 */
// Framework Version
define( 'SPIDER_VERSION', '1.0.01' );

/* 設定ファイルの読み込み	*/
if( file_exists( dirname(__FILE__).DIRECTORY_SEPARATOR."service" ) ) {
	require_once( dirname(__FILE__).DIRECTORY_SEPARATOR.'define.service.inc.php' );
} else if( file_exists( dirname(__FILE__).DIRECTORY_SEPARATOR."development" ) ) {
	require_once( dirname(__FILE__).DIRECTORY_SEPARATOR.'define.dev.inc.php' );
} else {
	require_once( dirname(__FILE__).DIRECTORY_SEPARATOR.'define.inc.php' );
}
if ( file_exists( dirname( __FILE__ ).DIRECTORY_SEPARATOR.'unique_setting.inc.php' ) ) {
	include_once( dirname( __FILE__ ).DIRECTORY_SEPARATOR.'unique_setting.inc.php' );
}
// システムメール定義ファイルの読み込み
if( defined('FILE_PATH_SYSTEM_DEFINITION') && file_exists( FILE_PATH_SYSTEM_DEFINITION ) ){
	require_once( FILE_PATH_SYSTEM_DEFINITION );
}

// アクションファイルパスの取得
$action_file_path = $_SERVER["SCRIPT_FILENAME"];
if ( str_replace( "\\", "/", __FILE__ )
	== str_replace( "\\", "/", $action_file_path ) ) {
	// 本ファイル直接呼出しなら実行中止
	header( 'Content-type: text/plain;charset=UTF-8' );
	die( "Core Error : コントロールファイルです。" );
} else {
	// チェック実行
	if( !file_exists(DIR_PATH_TEMPLATE) ) {
		header( 'Content-type: text/plain;charset=UTF-8' );
		die( "Core Error : テンプレートディレクトリがありません。" );
	}
	if( !file_exists(DIR_PATH_LIB) ) {
		header( 'Content-type: text/plain;charset=UTF-8' );
		die( "Core Error : ライブラリディレクトリがありません。" );
	}
	if( !file_exists(DIR_PATH_LOCK) ) {
		header( 'Content-type: text/plain;charset=UTF-8' );
		die( "Core Error : プロセスロックディレクトリがありません。" );
	} else if( !is_writable(DIR_PATH_LOCK) ){
		header( 'Content-type: text/plain;charset=UTF-8' );
		die( "Core Error : プロセスロックディレクトリが書き込み不能になっています。" );
	}
	if( !file_exists(DIR_PATH_TMP) ) {
		header( 'Content-type: text/plain;charset=UTF-8' );
		die( "Core Error : 一時ディレクトリがありません。" );
	} else if( !is_writable(DIR_PATH_TMP) ){
		header( 'Content-type: text/plain;charset=UTF-8' );
		die( "Core Error : 一時ディレクトリが書き込み不能になっています。" );
	}
	if( !file_exists(DIR_PATH_CACHE) ) {
		header( 'Content-type: text/plain;charset=UTF-8' );
		die( "Core Error : キャッシュディレクトリがありません。" );
	} else if( !is_writable(DIR_PATH_CACHE) ){
		header( 'Content-type: text/plain;charset=UTF-8' );
		die( "Core Error : キャッシュディレクトリが書き込み不能になっています。" );
	}
	if( !file_exists(DIR_PATH_DATA) ) {
		header( 'Content-type: text/plain;charset=UTF-8' );
		die( "Core Error : データディレクトリがありません。" );
	} else if( !is_writable(DIR_PATH_DATA) ){
		header( 'Content-type: text/plain;charset=UTF-8' );
		die( "Core Error : データディレクトリが書き込み不能になっています。" );
	}
	if( !file_exists(DIR_PATH_BIN) ) {
		header( 'Content-type: text/plain;charset=UTF-8' );
		die( "Core Error : バイナリ保存ディレクトリがありません。" );
	} else if( !is_writable(DIR_PATH_BIN) ){
		header( 'Content-type: text/plain;charset=UTF-8' );
		die( "Core Error : バイナリ保存ディレクトリが書き込み不能になっています。" );
	}
	if( !file_exists(DIR_PATH_LOG) ) {
		header( 'Content-type: text/plain;charset=UTF-8' );
		die( "Core Error : ログ保存ディレクトリがありません。" );
	} else if( !is_writable(DIR_PATH_LOG) ){
		header( 'Content-type: text/plain;charset=UTF-8' );
		die( "Core Error : ログ保存ディレクトリが書き込み不能になっています。" );
	}
}

/* リクエストコンテナオブジェクト	*/
require_once( DIR_PATH_LIB
	. DIRECTORY_SEPARATOR . "spider"
	. DIRECTORY_SEPARATOR . "HttpRequest.class.php" );
$GLOBALS['request_object']	= new HttpRequest();

/* 出力クラス	*/
require_once( DIR_PATH_LIB
	. DIRECTORY_SEPARATOR . "spider" 
	. DIRECTORY_SEPARATOR . "HttpOutput.class.php" );
$GLOBALS['output_object']		= new HttpOutput( DIR_PATH_TEMPLATE );

/* コントローラークラス	*/
require_once( DIR_PATH_LIB
	. DIRECTORY_SEPARATOR . "spider" 
	. DIRECTORY_SEPARATOR . "Controller.class.php" );

/* グローバル関数ファイル	*/
require_once( DIR_PATH_LIB
	. DIRECTORY_SEPARATOR . "spider" 
	. DIRECTORY_SEPARATOR . "functions.inc.php" );

// POSTとGETとCOOKIEの値をオブジェクトに設定する
foreach( $_POST as $key => $value ) {
	$GLOBALS['request_object']->setAttribute( 'post.'.$key, $value );
}
foreach( $_GET as $key => $value ) {
	$GLOBALS['request_object']->setAttribute( 'get.'.$key, $value );
}
foreach( $_COOKIE as $key => $value ) {
	$GLOBALS['request_object']->setAttribute( 'cookie.'.$key, $value );
}
// sessionのnameとidをリクエストに登録する
$GLOBALS['request_object']->setAttribute( 'spider.session_name', session_name() );
$GLOBALS['request_object']->setAttribute( 'spider.session_id', session_id() );

// spiderの固定値をリクエスト属性に設定する
$value = APPLICATION_BASE_URL;
$GLOBALS['request_object']->setAttribute( 'spider.base_url', $value );
$value = APPLICATION_NML_URL;
$GLOBALS['request_object']->setAttribute( 'spider.nomal_url', $value );
$value = APPLICATION_SSL_URL;
$GLOBALS['request_object']->setAttribute( 'spider.ssl_url', $value );
$value = APPLICATION_BASE_URI;
$GLOBALS['request_object']->setAttribute( 'spider.base_uri', $value );
$value = APPLICATION_BASE_PATH;
$GLOBALS['request_object']->setAttribute( 'spider.base_path', $value );

// メイン処理
$GLOBALS['controller']	= new Controller( DIR_PATH_LIB );
$GLOBALS['controller']->execute( $GLOBALS['request_object'], $GLOBALS['output_object'] );

die;

?>
