<?php
/**
 * 文字列用ユーティリティクラス
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class CharUtility {
	function CharUtility() {
	}
	/**
	 * 渡された文字列を指定されたキーでMD5暗号化して返します。
	 */
	function md5_encrypt($plain_text, $password, $iv_len = 16) {
	   $plain_text .= "\x13";
	   $n = strlen($plain_text);
	   if ($n % 16) $plain_text .= str_repeat("\0", 16 - ($n % 16));
	   $i = 0;
	   $enc_text = CharUtility::get_rnd_iv($iv_len);
	   $iv = substr($password ^ $enc_text, 0, 512);
	   while ($i < $n) {
		   $block = substr($plain_text, $i, 16) ^ pack('H*', md5($iv));
		   $enc_text .= $block;
		   $iv = substr($block . $iv, 0, 512) ^ $password;
		   $i += 16;
	   }
	   return base64_encode($enc_text);
	}
	/**
	 * 渡された文字列を渡されたキーで複合化して返します。
	 */
	function md5_decrypt($enc_text, $password, $iv_len = 16) {
	   $enc_text = base64_decode($enc_text);
	   $n = strlen($enc_text);
	   $i = $iv_len;
	   $plain_text = '';
	   $iv = substr($password ^ substr($enc_text, 0, $iv_len), 0, 512);
	   while ($i < $n) {
		   $block = substr($enc_text, $i, 16);
		   $plain_text .= $block ^ pack('H*', md5($iv));
		   $iv = substr($block . $iv, 0, 512) ^ $password;
		   $i += 16;
	   }
	   return preg_replace('/\\x13\\x00*$/', '', $plain_text);
	}
	/**
	 * 
	 */
	function get_rnd_iv($iv_len) {
	   $iv = '';
	   while ($iv_len-- > 0) {
		   $iv .= chr(mt_rand() & 0xff);
	   }
	   return $iv;
	}
	/**
	 * 指定桁数のランダム文字列を生成して返します。
	 */
	function get_rundom_key( $length=16 ) {
		$char_array	= array(
			'0','1','2','3','4','5','6','7','8','9'
			,'a','b','c','d','e','f','g','h','i','j'
			,'k','l','m','n','o','p','q','r','s','t'
			,'u','v','w','x','y','z'
			,'A','B','C','D','E','F','G','H','I','J'
			,'K','L','M','N','O','P','Q','R','S','T'
			,'U','V','W','X','Y','Z'
			,'-'
		);
		$rand_keys	= array_rand($char_array, $length);
		$ret_str	= '';
		foreach ( $rand_keys as $key ) {
			$ret_str .= $char_array[$key];
		}
		return $ret_str;
	}
	/**
	 * 指定桁数のランダム文字列を生成して返します。
	 * 見た目が紛らわしい0,o,O,lなどの文字列は利用しません。
	 */
	function get_rundom_password( $length=8 ) {
		$char_array	= array(
			'1','2','3','4','5','6','7','8','9'
			,'a','b','c','d','e','f','g','h','i','j'
			,'k','m','n','p','q','r','s','t'
			,'u','v','w','x','y','z'
			,'A','B','C','D','E','F','G','H','J'
			,'K','M','N','P','Q','R','S','T'
			,'U','V','W','X','Y','Z'
			,'-'
		);
		$rand_keys	= array_rand($char_array, $length);
		$ret_str	= '';
		foreach ( $rand_keys as $key ) {
			$ret_str .= $char_array[$key];
		}
		return $ret_str;
	}
	/**
	 * 指定桁数のランダム文字列を生成して返します。
	 * 見た目が紛らわしい0,o,O,lなどの文字列は利用しません。
	 */
	function get_rundom_large_char( $length=8 ) {
		$char_array	= array(
			'1','2','3','4','5','6','7','8','9'
			,'A','B','C','D','E','F','G','H','J'
			,'K','M','N','P','Q','R','S','T'
			,'U','V','W','X','Y','Z'
		);
		$rand_keys	= array_rand($char_array, $length);
		$ret_str	= '';
		foreach ( $rand_keys as $key ) {
			$ret_str .= $char_array[$key];
		}
		return $ret_str;
	}
	/**
	 * 正規表現で利用する為の文字パターン用にエスケープします。
	 */
	function escape_regx_str($str){
		$str = str_replace('\\', '\\\\', $str);
		$str = str_replace('*', '\\*', $str);
		$str = str_replace('+', '\\+', $str);
		$str = str_replace('.', '\\.', $str);
		$str = str_replace('?', '\\?', $str);
		$str = str_replace('(', '\\(', $str);
		$str = str_replace(')', '\\)', $str);
		$str = str_replace('{', '\\{', $str);
		$str = str_replace('}', '\\}', $str);
		$str = str_replace('[', '\\[', $str);
		$str = str_replace(']', '\\]', $str);
		$str = str_replace('^', '\\^', $str);
		$str = str_replace('$', '\\$', $str);
		$str = str_replace('|', '\\|', $str);
		$str = str_replace('/', '\\/', $str);
		return $str;
	}
}
?>