<?php
/**
 * HTML用変換タグ:ウィジェットタグ変換クラス
 * 
 * {widget:[ウィジェットファイル名] [オプション文字列]}
 * ブラウザに応じて準備されたDATA/widgetフォルダ内のファイルに記述された文字列を適用します。
 * 
 * ブラウザごとの振り分けフォルダの定義はDATA/define.inc.phpの記述に準じます。
 * ターゲットブラウザのフォルダが見つからない場合は、defaultフォルダ内を検索します。
 * 
 * 指定できるオプション）
 * dynamic
 *    dynamicをオプション文字列内に記述することで動的ウィジェットとして動作します。
 * 
 * 動的ウィジェットタグは、呼び出すウィジェットの内容を以下の順序で動的に制御します。
 * この機能の追加により、ページレイアウトの一部分だけ変更したい時にテンプレートを増やす必要がなくなります。
 * 
 * 【動的ウィジェット取り込み優先順位】
 * １） 表示しようとしているページのURIと同じ階層で同じファイル名のファイルがwidgetsフォルダ内にあれば
 *       そのファイルをページ特有のウィジェットとして取り込む
 * ２） 上記が存在しなかった場合、widgetsフォルダ内の同一階層フォルダにある、[ウィジェットファイル名]を
 *       探し、あればそのファイルをウィジェットとして取り込む。
 * ３） 同一フォルダ内になければ、widgetsフォルダ内をさかのぼり、[ウィジェットファイル名]のファイルを見つけた
 *       たらそのファイルをウィジェットとして取り込む。
 * 
 * @package spider spiderのコアパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2009, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR."TagBase.class.php");
class spider_tags_Widget extends spider_tags_TagBase {
	/**
	 * コンストラクタ
	 */
	function spider_tags_Widget() {
		$this->priority		= 3;
		$this->tag_name		= 'widget';
	}
	/**
	 * 個々のタグ文字列の変換後文字列を取得します
	 */
	function getConvertedStrings( &$result_strings, &$build_information, $option_array=array(), $valiable_counter=0 ) {
		$widget_file		= $option_array[0];
		$widget_file_path	= false;
		if( in_array('dynamic',$option_array) ) {
			$widget_file_path	= $this->getDynamicWidgetFilePath( $widget_file, $build_information );
		} else {
			$widget_file_path	= $this->getAvailableWidgetFilePath( $widget_file, $build_information );
		}
		if ( false !== $widget_file_path && file_exists( $widget_file_path ) ) {
			// ウィジェット出力文字列取得
			$widget_strings		= trim(file_get_contents( $widget_file_path ));
			if( preg_match('/^\\{widget\\-link\\:[^\\}]*?\\}$/',$widget_strings) > 0 ) {
				// ウィジェットファイルの中身がウィジェットリンクを指定しているならウィジェットファイルを再取得する
				$widget_file	= preg_replace('/^\\{widget\\-link\\:/','',$widget_strings);
				$widget_file	= trim(preg_replace('/\\}$/','',$widget_file));
				// リンクは必ず静的呼び出し
				$widget_file_path	= $this->getAvailableWidgetFilePath( $widget_file, $build_information );
				if ( false !== $widget_file_path && file_exists( $widget_file_path ) ) {
					$widget_strings		= trim(file_get_contents( $widget_file_path ));
				} else {
					return '[widget file for '.$build_information->agent_class.' is not found!]';
				}
			}
			// ウィジェットの改行コードを統一
			$widget_strings = str_replace( "\r\n", "\n" , $widget_strings );
			$widget_strings = str_replace( "\r", "\n" , $widget_strings );
			return $widget_strings;
		} else {
			// ウィジェットファイルが見つからない場合に無限ループにならないよう文字列を出力
			return '[widget file for '.$build_information->agent_class.' is not found!]';
		}
	}
	/**
	 * ユーザーエージェント分類にあったウィジェットファイルのパスを取得する
	 * @param $file_name 使用するウィジェットファイル名
	 */
	function getAvailableWidgetFilePath( $file_name, & $build_information ) {
		$agent_class		= trim($build_information->agent_class);
		// 指定エージェントのファイル
		$widget_file_path	= $this->getAgentWidgetFilePath( $file_name, $agent_class );
		if( false === $widget_file_path ) {
			return false;
		} else if( file_exists($widget_file_path) ) {
			$build_information->addCompareFile( $widget_file_path );
			return $widget_file_path;
		} else {
			$build_information->addConfirmFile( $widget_file_path );
		}
		// 代替エージェントのファイル
		$alt_agent	= $GLOBALS['SPIDER_USER_AGENT_CLASS_ALT_HASH'][$agent_class];
		if( !is_null($alt_agent) && strlen($alt_agent) > 0 ) {
			$widget_file_path	= $this->getAgentWidgetFilePath( $file_name, $alt_agent );
			if( false === $widget_file_path ) {
				return false;
			} else if( file_exists($widget_file_path) ) {
				$build_information->addCompareFile( $widget_file_path );
				return $widget_file_path;
			} else {
				$build_information->addConfirmFile( $widget_file_path );
			}
		}
		// デフォルトのファイル
		$widget_file_path	= $this->getAgentWidgetFilePath( $file_name, 'default' );
		if( false === $widget_file_path ) {
			return false;
		} else if( file_exists($widget_file_path) ) {
			$build_information->addCompareFile( $widget_file_path );
			return $widget_file_path;
		} else {
			$build_information->addConfirmFile( $widget_file_path );
		}
		return false;
	}
	/**
	 * ユーザーエージェント分類にあったウィジェットファイルのパスを取得する
	 * @param $file_name 使用するウィジェットファイル名
	 */
	function getDynamicWidgetFilePath( $file_name, & $build_information ) {
		$agent_class		= trim($build_information->agent_class);
		$alt_agent			= null;
		if( isset($GLOBALS['SPIDER_USER_AGENT_CLASS_ALT_HASH'])
			&& isset($GLOBALS['SPIDER_USER_AGENT_CLASS_ALT_HASH'][$agent_class]) ) {
			$alt_agent			= $GLOBALS['SPIDER_USER_AGENT_CLASS_ALT_HASH'][$agent_class];
		}
		$page_uri			= $build_information->getPageUri();
		$dir_path_widget	= DIR_PATH_SPIDER_DATA.DIRECTORY_SEPARATOR.'widgets';
		if( !is_dir( $dir_path_widget ) ) {
			return false;
		}
		// 最初にウィジェットフォルダの同じURIにファイルがあるか確認しあれば返す
		$widget_file_path = $dir_path_widget.DIRECTORY_SEPARATOR.$build_information->getAgentPageUri();
		if( file_exists($widget_file_path) ) {
			$build_information->addCompareFile( $widget_file_path );
			return $widget_file_path;
		} else {
			$build_information->addConfirmFile( $widget_file_path );
		}
		// 代替エージェントのURIファイルを探す
		if( !is_null($alt_agent) && strlen($alt_agent) > 0 ) {
			$widget_file_path = $dir_path_widget
				.DIRECTORY_SEPARATOR.$alt_agent
				.$page_uri;
			if( file_exists($widget_file_path) ) {
				$build_information->addCompareFile( $widget_file_path );
				return $widget_file_path;
			} else {
				$build_information->addConfirmFile( $widget_file_path );
			}
		}
		// デフォルトのユーザーエージェントURLファイルを探す
		$widget_file_path = $dir_path_widget
			.DIRECTORY_SEPARATOR.'default'
			.$page_uri;
		if( file_exists($widget_file_path) ) {
			$build_information->addCompareFile( $widget_file_path );
			return $widget_file_path;
		} else {
			$build_information->addConfirmFile( $widget_file_path );
		}
		
		// URIファイルが存在しない場合、ディレクトリをさかのぼりながら指定名のウィジェットファイルを探す
		$target_dir_uri	= dirname($page_uri);
		$target_dir_uri	= preg_replace('/^'.CharUtility::escape_regx_str(DIRECTORY_SEPARATOR).'/','',$target_dir_uri);
		do {
			$target_file_name	= $target_dir_uri.DIRECTORY_SEPARATOR.$file_name;
			// 指定ユーザエージェントのウィジェット
			$widget_file_path	= $this->getAgentWidgetFilePath( $target_file_name, $agent_class );
			if( false === $widget_file_path ) {
				return false;
			} else if( file_exists($widget_file_path) ) {
				$build_information->addCompareFile( $widget_file_path );
				return $widget_file_path;
			} else {
				$build_information->addConfirmFile( $widget_file_path );
			}
			// 代替エージェントのファイル
			$alt_agent	= $GLOBALS['SPIDER_USER_AGENT_CLASS_ALT_HASH'][$agent_class];
			if( !is_null($alt_agent) && strlen($alt_agent) > 0 ) {
				$widget_file_path	= $this->getAgentWidgetFilePath( $target_file_name, $alt_agent );
				if( false === $widget_file_path ) {
					return false;
				} else if( file_exists($widget_file_path) ) {
					$build_information->addCompareFile( $widget_file_path );
					return $widget_file_path;
				} else {
					$build_information->addConfirmFile( $widget_file_path );
				}
			}
			// デフォルトのファイル
			$widget_file_path	= $this->getAgentWidgetFilePath( $target_file_name, 'default' );
			if( false === $widget_file_path ) {
				return false;
			} else if( file_exists($widget_file_path) ) {
				$build_information->addCompareFile( $widget_file_path );
				return $widget_file_path;
			} else {
				$build_information->addConfirmFile( $widget_file_path );
			}
			// 一つ上のフォルダに移動
			$target_dir_uri	= dirname( $target_dir_uri );
		} while  ( strlen($target_dir_uri) > 0 );
		return false;
	}
	/**
	 * ユーザーエージェント分類に応じたウィジェットファイルパスを取得します
	 * （ファイル存在確認なし）
	 */
	function getAgentWidgetFilePath( $file_name, $agent_class ) {
		$agent_class	= trim($agent_class);
		$file_name		= trim($file_name);
		if( strlen( $agent_class ) == 0 ) {
			return false;
		}
		if( strlen( $file_name ) == 0 ) {
			return false;
		}
		$dir_path_widget = DIR_PATH_SPIDER_DATA.DIRECTORY_SEPARATOR.'widgets';
		if( !is_dir( $dir_path_widget ) ) {
			return false;
		}
		$widget_file_path = $dir_path_widget
			.DIRECTORY_SEPARATOR.$agent_class
			.DIRECTORY_SEPARATOR.$file_name;
		return $widget_file_path;
	}
}
?>