<?php
require_once( dirname(dirname(__FILE__)).DIRECTORY_SEPARATOR.'Mail.class.php');
/**
 * メール送信ユーティリティ拡張クラス：sendmailコマンドによる送信の実装クラス
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class util_mail_SendMail extends util_Mail {
	var $sendmail_path		= '/usr/sbin/sendmail -f';
	function util_mail_SendMail() {
	}
	/**
	 * 設定された内容で実際にメールを送信処理します
	 */
	function send_execute( $add_header_crlf=false, $convert_encoding=true ) {
		
		// 本文文字列を取得する
		$header_strings		= $this->_get_header_part_strings(true,true,false,$add_header_crlf,$convert_encoding);
		$body_strings		= $this->_get_body_part_strings($convert_encoding);
		$sendwrite_strings	= $header_strings . $body_strings;

		// メールアドレス部分のみ抜き出す
		$to				= $this->getToAddress();
		$from			= $this->getFromAddress();
		$return_path	= $this->return_path;
		if( strlen(trim($return_path)) == 0 ) {
			$return_path	= $from;
		}

		if( $this->sendmailTo( $from, $to, $sendwrite_strings, $return_path ) ) {
			// 送信成功したら
			// Ccにメール送信する
			$cc_array	= $this->getCcAddresses();
			foreach( $cc_array as $address ) {
				$this->sendmailTo( $from, $address, $sendwrite_strings, $return_path );
			}
			// Bccにメール送信する
			$bcc_array	= $this->getBccAddresses();
			foreach( $bcc_array as $address ) {
				$this->sendmailTo( $from, $address, $sendwrite_strings, $return_path );
			}
			return true;
		} else {
			return false;
		}
	}
	/**
	 * sendmail コマンドへ書き出します
	 */
	function sendmailTo( $from, $to, $strings, $envelope_from=null ) {
		if( is_null( $envelope_from ) ) {
			$envelope_from	= $from;
		}
		$sendmail_path	= trim($this->options['sendmail_path']);
		// コマンド文字列
		$command	= $sendmail_path.' -t -f'.$envelope_from.' '. $to;
		// sendmailへパイプオープン
		$mp = popen($command, "w");
		if( $mp ) {
			fputs($mp, $strings);
			pclose($mp);
			return true;
		} else {
			return false;
		}
	}
	/**
	 * 送信設定オプションの妥当性検査を行いエラーメッセージの配列を返します。
	 * エラーがない場合は要素0の配列を返します。
	 */
	function validate_options( $options = array() ) {
		$error_messages	= array();
		// sendmail_pathが必須
		$sendmail_path	= trim($options['sendmail_path']);
		if( strlen(trim($sendmail_path)) == 0 ) {
			array_push($error_messages, 'sendmailのパスを設定してください。' );
		} else {
			$command_elements	= explode(' ',$sendmail_path);
			$command_file_path	= array_shift( $command_elements );
			if( !file_exists( $command_file_path ) ) {
				array_push($error_messages, '指定されたパスにsendmailコマンドが存在しません。' );
			}
		}
		return $error_messages;
	}
}
?>