<?php
require_once( dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR."ModuleBase.class.php");
/**
 * spider：POSTおよびGETで入力されたパラメータの文字列を以下のとおり書式変換する
 * 　1）「半角カタカナ」を「全角カタカナ」に変換します。
 * 　2）濁点付きの文字を一文字に変換します。
 * 　3）「全角」英数字を「半角」に変換します。 
 * 　4）「全角」スペースを「半角」に変換します。
 * アクションモジュールクラス
 * 
 * @package spider spider/moduleパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 5.2
 */
class spider_module_AutoFormat extends spider_ModuleBase {
	function spider_module_AutoFormat() {
	}
	function execute( & $request ) {
		// POSTパラメータ
		$this->convertKana( $_POST,'KVas','UTF-8' );
		// GETパラメータ
		$this->convertKana( $_GET,'KVas','UTF-8' );
		$request->setAttribute( 'postparams', $_POST );
		$request->setAttribute( 'getparams', $_GET );
	}
	/**
	 * 多次元配列の値をフォーマットにエンコードします
	 */
	function convertKana( & $hash, $format='KVas', $toChar='UTF-8') {
		if( is_array($hash) ) {
			foreach( $hash as $key => $val ) {
				if( is_array($val) ) {
					$this->convertKana( $hash[$key] );
				} else {
					$hash[$key]	= mb_convert_kana($val,$format,$toChar);
				}
			}
		}
	}
}
?>