<?php
/**
 * ユーティリティ：HTTPリクエストを送信してレスポンスを取得するユーティリティオブジェクト
 * 
 * @package util ユーティリティパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class util_GetHTTPResponse {
	var $protocol			= "";
	var $status_code		= "";
	var $status_string		= "";
	var $response_headers	= array();
	var $response_body		= null;
	function util_GetHTTPResponse(){
	}
	function get($url,$header_params=array()){
		list( $pr, $blank, $domain )	= explode('/',$url );
		$uri	= substr($url,strpos($url,$domain));
		$uri	= str_replace($domain,"",$uri);
		if( strlen($uri) == 0 ) {
			$uri	= '/';
		}
		if( preg_match('/^[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}/',gethostbyname($domain)) == 0 ) {
			return false;
		}
		return $this->get_response($domain,$uri,$header_params);
	}
	function get_response($host,$uri,$header_params=array()){
		$request = "GET {$uri} HTTP/1.1\r\n"
			."Accept: */*\r\n"
			."Host: {$host}\r\n"
		;
		foreach( $header_params as $key => $value ) {
			if( strlen(trim($key)) > 0 && strlen(trim($value)) > 0 ) {
				$request	.= $key . ": " . $value . "\r\n";
			}
		}
		$request	.= "Connection: close\r\n\r\n";
		if( $fp = @fsockopen( gethostbyname($host), 80, $rv->en, $rv->es, 20 ) ){
			if( socket_set_timeout( $fp, 30 ) ) {
				fwrite( $fp, $request );
				$response	= '';
				while (!feof($fp)) {
					$response .= fgets($fp, 128);
				}
				// responseの解析
				$header_string	= '';
				$response_body	= null;

				// レスポンスヘッダ文字列を取得
				$header_string		= substr( $response, 0, strpos($response,"\r\n\r\n"));
				$headerpear_array	= explode("\r\n",$header_string);
				// レスポンスステータスを確認
				$status_str			= array_shift($headerpear_array);
				list($this->protocol,$this->status_code,$this->status_string)
					= explode(" ",$status_str);
				// その他のヘッダを取得
				foreach($headerpear_array as $line){
					if( strlen($line) > 0 ) {
						$headers	= explode(":",$line);
						if( count($headers) > 0 ) {
							$key	= array_shift($headers);
							$val	= implode(':',$headers);
							$this->response_headers[trim($key)] = trim($val);
						}
					}
				}
				// レスポンスボディの取得
				if( $this->response_headers['Transfer-Encoding'] == 'chunked' ) {
					$header_hex_string		= bin2hex($header_string."\r\n\r\n");
					$separator_hex_string	= bin2hex("\r\n");
					$body_start_pos			= strlen($header_hex_string);
					$body_hex_string		= bin2hex($response);
					$body_hex_string		= substr($body_hex_string,$body_start_pos);
					$body_chunk_array		= explode($separator_hex_string,$body_hex_string);
					// 0,2,4,..偶数はチャンクサイズなので削除してつなげ直す
					$i	= 0;
					$body_hex_string		= '';
					foreach( $body_chunk_array as $val ) {
						if( $i%2 != 0 ) { $body_hex_string	.= $val; }
						$i++;
					}
					$this->response_body	= pack("H*",$body_hex_string);
				} else {
					$lines					= explode("\r\n\r\n",$response);
					$header_string			= array_shift($lines);
					$response_body			= implode("\r\n\r\n",$lines);
					$this->response_body	= $response_body;
					$headerpear_array		= explode("\r\n",$header_string);
					$status_str				= array_shift($headerpear_array);
					list($this->protocol,$this->status_code,$this->status_string)
						= explode(" ",$status_str);
				}
				return true;
			}
			return false;
		} else {
			return false;
		}
	}
	function post($url,$header_params=array(),$requestBody){
		list( $pr, $blank, $domain )	= explode('/',$url );
		$uri	= substr($url,strpos($url,$domain));
		$uri	= str_replace($domain,"",$uri);
		if( strlen($uri) == 0 ) {
			$uri	= '/';
		}
		if( preg_match('/^[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}/',gethostbyname($domain)) == 0 ) {
			return false;
		}
		return $this->post_response($domain,$uri,$header_params,$requestBody);
	}
	function post_response($host,$uri,$header_params=array(),$requestBody){
		$request = "POST {$uri} HTTP/1.1\r\n"
			."Accept: */*\r\n"
			."Host: {$host}\r\n"
		;
		foreach( $header_params as $key => $value ) {
			if( strlen(trim($key)) > 0 && strlen(trim($value)) > 0 ) {
				$request	.= $key . ": " . $value . "\r\n";
			}
		}
		$request	.= "Connection: close\r\n\r\n";
		$request	.= "Content-Type: application/x-www-form-urlencoded;charset=UTF-8\r\n";
		$request	.= "Content-Length: ".strlen($requestBody)."\r\n\r\n";
		$request	.= $requestBody;
		if( $fp = @fsockopen( $host, 80, $rv->en, $rv->es, 20 ) ){
			if( socket_set_timeout( $fp, 30 ) ) {
				fwrite( $fp, $request );
				$response	= '';
				while (!feof($fp)) {
					$response .= fgets($fp, 128);
				}
				// responseの解析
				$header_string	= '';
				$response_body	= null;

				// レスポンスヘッダ文字列を取得
				$header_string		= substr( $response, 0, strpos($response,"\r\n\r\n"));
				$headerpear_array	= explode("\r\n",$header_string);
				// レスポンスステータスを確認
				$status_str			= array_shift($headerpear_array);
				list($this->protocol,$this->status_code,$this->status_string)
					= explode(" ",$status_str);
				// その他のヘッダを取得
				foreach($headerpear_array as $line){
					if( strlen($line) > 0 ) {
						$headers	= explode(":",$line);
						if( count($headers) > 0 ) {
							$key	= array_shift($headers);
							$val	= implode(':',$headers);
							$this->response_headers[trim($key)] = trim($val);
						}
					}
				}
				// レスポンスボディの取得
				if( $this->response_headers['Transfer-Encoding'] == 'chunked' ) {
					$header_hex_string		= bin2hex($header_string."\r\n\r\n");
					$separator_hex_string	= bin2hex("\r\n");
					$body_start_pos			= strlen($header_hex_string);
					$body_hex_string		= bin2hex($response);
					$body_hex_string		= substr($body_hex_string,$body_start_pos);
					$body_chunk_array		= explode($separator_hex_string,$body_hex_string);
					// 0,2,4,..偶数はチャンクサイズなので削除してつなげ直す
					$i	= 0;
					$body_hex_string		= '';
					foreach( $body_chunk_array as $val ) {
						if( $i%2 != 0 ) { $body_hex_string	.= $val; }
						$i++;
					}
					$this->response_body	= pack("H*",$body_hex_string);
				} else {
					$lines					= explode("\r\n\r\n",$response);
					$header_string			= array_shift($lines);
					$response_body			= implode("\r\n\r\n",$lines);
					$this->response_body	= $response_body;
					$headerpear_array		= explode("\r\n",$header_string);
					$status_str				= array_shift($headerpear_array);
					list($this->protocol,$this->status_code,$this->status_string)
						= explode(" ",$status_str);
				}
				return true;
			}
			return false;
		} else {
			return false;
		}
	}
}
//$obj = new util_GetHTTPResponse();
//if( $obj->get('http://www.md-systems.net/') ){
////	foreach( $obj->response_headers as $key => $value ) {
////		header($key.': '.$value);
////	}
////	print $obj->response_body;
////
//	header('Content-type: text/plain;charset=UTF-8');
//print_r($obj);
//} else {
//	header('Content-type: text/plain;charset=UTF-8');
//	echo "通信に失敗";
//}
//
?>