<?php
/*
 * framework-spider
 * spider/functions.inc.php
 * 
 * グローバル関数定義ファイル
 * spiderで利用するグローバル関数を定義するファイルです
 * 
 * CopyRight(C)Framework-Spider Developer Team. 2010. All Right Reserved. 
 * URL         : http://sourceforge.jp/projects/frameworkspider/
 * Mail        : frameworkspider-dev@lists.sourceforge.jp
 * Auther      : Masanori Nakashima
 * Modifier    : Masanori Nakashima
 * Last Updated: 2010.07.07
 * 
 */
/**
 * spiderに必要なディレクトリとファイルのパーミッションを確認します
 * @return エラーメッセージ配列
 */
function spider_is_avairable_permittion() {
	$errors	= array();
	if( !file_exists(DIR_PATH_LIB) ) {
		array_push( $errors, $GLOBALS['spider.messages']['spider.finctions.libdirisnotfound'] );
	}
	if( !file_exists(DIR_PATH_TEMPLATES) ) {
		array_push( $errors, $GLOBALS['spider.messages']['spider.finctions.templatedirisnotfound'] );
	}
	
	if( !file_exists(DIR_PATH_WORK) ) {
		array_push( $errors, $GLOBALS['spider.messages']['spider.finctions.workdirisnotfound'] );
	} else if( !is_writable(DIR_PATH_WORK) ){
		array_push( $errors, $GLOBALS['spider.messages']['spider.finctions.workdirisnotwritable'] );
	} else {
		if( !file_exists(DIR_PATH_BIN) ) {
			if( @mkdir(DIR_PATH_BIN,SPIDER_PERMITTION_DATA_FOLDER) ) {
				@chmod(DIR_PATH_BIN,SPIDER_PERMITTION_DATA_FOLDER);
			} else {
				array_push( $errors, $GLOBALS['spider.messages']['spider.finctions.cantcreatebindir'] );
			}
		} else if( !is_writable(DIR_PATH_BIN) ){
			array_push( $errors, $GLOBALS['spider.messages']['spider.finctions.bindirisnotwritable'] );
		}
		if( !file_exists(DIR_PATH_LOCK) ) {
			if( @mkdir( DIR_PATH_LOCK, SPIDER_PERMITTION_DATA_FOLDER ) ) {
				@chmod( DIR_PATH_LOCK, SPIDER_PERMITTION_DATA_FOLDER );
			} else {
				array_push( $errors, $GLOBALS['spider.messages']['spider.finctions.cantcreatelockdir'] );
			}
		} else if( !is_writable(DIR_PATH_LOCK) ){
			array_push( $errors, $GLOBALS['spider.messages']['spider.finctions.lockdirisnotwritable'] );
		}
		if( !file_exists(DIR_PATH_TMP) ) {
			if( @mkdir( DIR_PATH_TMP, SPIDER_PERMITTION_DATA_FOLDER ) ) {
				@chmod( DIR_PATH_TMP, SPIDER_PERMITTION_DATA_FOLDER );
			} else {
				array_push( $errors, $GLOBALS['spider.messages']['spider.finctions.cantcreatetmpdir'] );
			}
		} else if( !is_writable(DIR_PATH_TMP) ){
			array_push( $errors, $GLOBALS['spider.messages']['spider.finctions.tmpdirisnotwritable'] );
		}
		if( !file_exists(DIR_PATH_CACHE) ) {
			if( @mkdir( DIR_PATH_CACHE, SPIDER_PERMITTION_DATA_FOLDER ) ) {
				@chmod( DIR_PATH_CACHE, SPIDER_PERMITTION_DATA_FOLDER );
			} else {
				array_push( $errors, $GLOBALS['spider.messages']['spider.finctions.cantcreatecachedir'] );
			}
		} else if( !is_writable(DIR_PATH_CACHE) ){
			array_push( $errors, $GLOBALS['spider.messages']['spider.finctions.cachedirisnotwritable'] );
		}
	}

	if( !file_exists(DIR_PATH_DATA) ) {
		array_push( $errors, $GLOBALS['spider.messages']['spider.finctions.datadirisnotfound'] );
	} else if( !is_writable(DIR_PATH_DATA) ){
		array_push( $errors, $GLOBALS['spider.messages']['spider.finctions.datadirisnotwritable'] );
	} else {
		if( !file_exists(DIR_PATH_LOG) ) {
			if( @mkdir( DIR_PATH_LOG, SPIDER_PERMITTION_DATA_FOLDER ) ) {
				@chmod( DIR_PATH_LOG, SPIDER_PERMITTION_DATA_FOLDER );
			} else {
				array_push( $errors, $GLOBALS['spider.messages']['spider.finctions.cantcreatelogdir'] );
			}
		} else if( !is_writable(DIR_PATH_LOG) ){
			array_push( $errors, $GLOBALS['spider.messages']['spider.finctions.logdirisnotwritable'] );
		}
	}
	return $errors;
}
/**
 * コアエラーが発生した場合に出力して処理を終了します。
 */
function spider_exitWithCoreError($message) {
	header('Content-type: text/plain;charset=UTF-8');
	die('Core Error: '.$message);
}
/**
 * spiderにおけるセッションを開始します
 * セッションIDの重複を避けるため、生成したIDのセッションが存在するかどうか
 * 確認してからセッションIDを発行します
 * 新規セッション発行時にロックをかけるため通常のPHPセッションスタートする場合よりも
 * 多少のオーバーヘッドがあります。
 */
function spider_session_start( & $request ) {
	if( !defined('SPIDER_USE_SPIDER_SESSION_ID')
		|| SPIDER_USE_SPIDER_SESSION_ID === false
		|| strlen(SPIDER_USE_SPIDER_SESSION_ID) == 0 ) {
		// spiderセッション機構を利用しない場合はシステム任せにセッション開始
		session_set_cookie_params(60*60,SPIDER_URI_BASE);
		if( @session_start() ) {
			$sessionId			= session_id();
			$sessionName		= session_name();
			$getSessionParam	= strip_tags($sessionName.'='.$sessionId);
			$request->setAttribute('spider.session.id',$sessionId);
			$request->setAttribute('spider.session.name',$sessionName);
			$request->setAttribute('spider.session.getparam',$getSessionParam);
			return true;
		} else {
			return false;
		}
	}
	// セッション名を確認
	session_name(SPIDER_USE_SPIDER_SESSION_ID);
	// セッション情報保存フォルダのコントロール
	$getSettingSavePath	= true;
	if( defined('SPIDER_SESSION_SAVE_PATH') ) {
		if( SPIDER_SESSION_SAVE_PATH === true ) {
			$savePath	= DIR_PATH_TMP.'/session';
			if( !file_exists($savePath) ) {
				if( @mkdir($savePath, SPIDER_PERMITTION_DATA_FOLDER) ) {
					@chmod($savePath, SPIDER_PERMITTION_DATA_FOLDER);
				}
			}
			session_save_path($savePath);
			$getSettingSavePath	= false;
		} else if(strlen(SPIDER_SESSION_SAVE_PATH)
			&& file_exists(SPIDER_SESSION_SAVE_PATH)
			&& is_dir(SPIDER_SESSION_SAVE_PATH)){
			// 定義されたフォルダを優先
			session_save_path(SPIDER_SESSION_SAVE_PATH);
			$getSettingSavePath	= false;
		}
	}
	if( $getSettingSavePath ) {
		$savePath	= session_save_path();
		if( is_null($savePath)
			|| strlen(trim($savePath)) == 0
			|| !file_exists($savePath) ) {
			$savePath	= ini_get('session.save_path');
		}
		if( is_null($savePath)
			|| strlen(trim($savePath)) == 0
			|| !file_exists($savePath) ) {
			if( isset($_ENV['TEMP']) ) {
				$savePath	= $_ENV['TEMP'];
			}
		}
		if( !is_null($savePath)
			&& strlen(trim($savePath)) > 0
			&& file_exists($savePath)
			&& is_dir($savePath) ) {
			session_save_path($savePath);
		}
	}
	session_cache_expire(60);
	session_set_cookie_params(60*60,SPIDER_URI_BASE);
	
	$sessionId		= null;
	$userAgent		= null;
	$remoteHost		= spider_getRemotHostString();
	$cookieString	= null;
	if( isset($_SERVER['HTTP_USER_AGENT']) ) {
		$userAgent		= $_SERVER['HTTP_USER_AGENT'];
	}
	
	// クッキーからセッション復元を試みる
	if( isset($_SERVER['HTTP_COOKIE']) ) {
		$cookieString	= $_SERVER['HTTP_COOKIE'];
	}
	$cookieParams	= explode('; ',$cookieString);
	foreach( $cookieParams as $param ) {
		$param	= trim($param);
		if( strlen($param) > 0 ) {
			list( $ckey, $cval )	= explode('=',$param);
			if( SPIDER_USE_SPIDER_SESSION_ID == $ckey ) {
				// セッション名のキーが見つかったら開始を試みる
				if( preg_match('/^[0-9a-zA-Z]{16,32}$/',$cval) > 0 ) {
					if( spider_session_start_validate( $request, $cval ) ) {
						// 正しいセッションIDなら
						$sessionId	= $cval;
						break;
					}
				}
			}
		}
	}
	if( !is_null($sessionId) ) {
		// クッキーでセッションを開始できたら
		// GETパラメータで利用するセッションパラメータはセットしないで終了
		$sessionId			= session_id();
		$sessionName		= session_name();
		$getSessionParam	= '';
		$request->setAttribute('spider.session.id',$sessionId);
		$request->setAttribute('spider.session.name',$sessionName);
		$request->setAttribute('spider.session.getparam',$getSessionParam);
		return true;
	}
	// GET/POSTパラメータから復元を試みる
	if( is_null($sessionId) || strlen($sessionId) == 0 ) {
		// cookieからセッションIDを取得できなかった場合GET/POSTから取得
		if( isset($_GET[SPIDER_USE_SPIDER_SESSION_ID]) && strlen(trim($_GET[SPIDER_USE_SPIDER_SESSION_ID])) > 0 ) {
			$sessionId	= trim($_GET[SPIDER_USE_SPIDER_SESSION_ID]);
		} else if( isset($_POST[SPIDER_USE_SPIDER_SESSION_ID]) && strlen(trim($_POST[SPIDER_USE_SPIDER_SESSION_ID])) > 0 ) {
			$sessionId	= trim($_POST[SPIDER_USE_SPIDER_SESSION_ID]);
		}
	}
	
	if( is_null($sessionId) || strlen($sessionId) == 0 ) {
		// セッションIDが送信されていないなら独自にセッションIDを発行してセッション開始
		return spider_session_create( $request );
	} else if( preg_match('/^[0-9a-zA-Z]{16,32}$/',$sessionId) > 0 ) {
		// 書式が正しいなら開始を試みる
		if( spider_session_start_validate( $request, $sessionId ) ) {
			// 正しいセッションIDならそのまま利用する
			return true;
		} else {
			// 開始に失敗したら新しいセッションを開始
			return spider_session_create( $request );
		}
	} else {
		// 書式が正しくないセッションIDを指定されているなら新しいセッションを開始
		return spider_session_create( $request );
	}
}
/**
 * spiderにおけるセッションを開始します
 * セッションIDの重複を避けるため、生成したIDのセッションが存在するかどうか
 * 確認してからセッションIDを発行します
 * 新規セッション発行時にロックをかけるため通常のPHPセッションスタートする場合よりも
 * 多少のオーバーヘッドがあります。
 */
function spider_session_regenerate_id( & $request ) {
	if( !defined('SPIDER_USE_SPIDER_SESSION_ID')
		|| SPIDER_USE_SPIDER_SESSION_ID === false
		|| strlen(SPIDER_USE_SPIDER_SESSION_ID) == 0 ) {
		// spiderセッション機構を利用しない場合はシステム任せにセッション開始
		session_set_cookie_params(60*60,SPIDER_URI_BASE);
		if( @session_regenerate_id() ) {
			$sessionId			= session_id();
			$sessionName		= session_name();
			$getSessionParam	= strip_tags($sessionName.'='.$sessionId);
			$request->setAttribute('spider.session.id',$sessionId);
			$request->setAttribute('spider.session.name',$sessionName);
			$request->setAttribute('spider.session.getparam',$getSessionParam);
			return true;
		} else {
			return false;
		}
	}
	$oldSessionHash	= array();
	foreach( $_SESSION as $key => $val ) {
		$oldSessionHash[$key]	= unserialize($val);
	}
	$userAgent		= null;
	$remoteHost		= spider_getRemotHostString();
	$cookieString	= null;
	if( isset($_SERVER['HTTP_USER_AGENT']) ) {
		$userAgent		= $_SERVER['HTTP_USER_AGENT'];
	}
	// 一度セッションを全て破棄する
	$sessionId	= session_id();
	session_destroy();
	// 違うセッションIDを発行して新規にセッションを作成する
	session_write_close();
	// セッションクッキーを削除する
	setcookie( SPIDER_USE_SPIDER_SESSION_ID, '', time()-42000, SPIDER_URI_BASE );
	// ファイルを削除する
	$savePath	= session_save_path().'/sess_'.$sessionId;
	@unlink($savePath);
	if( spider_session_create( $request ) ) {
		// 新しいセッションに古いセッション情報を登録
		foreach( $oldSessionHash as $key => $val ) {
			$_SESSION[$key]	= serialize($val);
		}
		return true;
	} else {
		return false;
	}
}
/**
 * spiderにおけるセッションを独自IDで生成します
 * セッションIDの重複を避けるため、生成したIDのセッションが存在するかどうか
 * 確認してからセッションIDを発行します
 * 新規セッション発行時にロックをかけるため通常のPHPセッションスタートする場合よりも
 * 多少のオーバーヘッドがあります。
 */
function spider_session_create( & $request ) {
	session_name(SPIDER_USE_SPIDER_SESSION_ID);
	$userAgent		= null;
	$remoteHost		= spider_getRemotHostString();
	$cookieString	= null;
	if( isset($_SERVER['HTTP_USER_AGENT']) ) {
		$userAgent		= $_SERVER['HTTP_USER_AGENT'];
	}
	if( isset($_SERVER['HTTP_COOKIE']) ) {
		$cookieString	= $_SERVER['HTTP_COOKIE'];
	}
	if( spider_plock() ) {
		$sessionId	= spider_create_session_id();
		$savePath	= session_save_path();
		if( !is_null($savePath) && strlen($savePath) > 0
			&& file_exists($savePath) && is_dir($savePath ) ) {
			// セッション保存フォルダを取得できた場合は重複チェック
			$saveFilePath	= $savePath.'/sess_'.$sessionId;
			while( file_exists($saveFilePath) ) {
				$sessionId	= spider_create_session_id();
				$saveFilePath	= session_save_path().'/sess_'.$sessionId;
			}
		}
		session_id($sessionId);
		session_start();
		$_SESSION['spider.session.initialized']	= serialize(true);
		$_SESSION['spider.session.userAgent']	= serialize($userAgent);
		$_SESSION['spider.session.remoteHost']	= serialize($remoteHost);
		spider_prelease();
		// リモートホスト維持確認
		$validHostname	= true;
		$getSessionParam	= '';
		if( !is_null($remoteHost) && strlen($remoteHost) > 0 ) {
			// HostnameLookupが有効な環境の場合
			$agentClass	= $request->agentClass;
			$permitHostArray	= array();
			if( isset($GLOBALS['SPIDER_USER_AGENT_REMOTE_SESSION_PERMIT_HOSTS'][$agentClass]) ) {
				$permitHostArray	= $GLOBALS['SPIDER_USER_AGENT_REMOTE_SESSION_PERMIT_HOSTS'][$agentClass];
			}
			if( is_array($permitHostArray) && count($permitHostArray) > 0 ) {
				// セッション維持リモートホスト名の正規表現が指定されている場合
				// 前回アクセスのリモートホストに関係なく配列要素にマッチがあればOK
				$validHostname	= false;
				foreach( $permitHostArray as $hostRegx ) {
					if( preg_match($hostRegx,$remoteHost) > 0 ) {
						$validHostname	= true;
						$getSessionParam	= SPIDER_USE_SPIDER_SESSION_ID.'='.$sessionId;
						break;
					}
				}
			}
		}
		// GETパラメータで利用可能なセッションIDを保存
		$request->setAttribute('spider.session.getparam',$getSessionParam);
		$request->setAttribute('spider.session.id',$sessionId);
		$sessionName	= SPIDER_USE_SPIDER_SESSION_ID;
		$request->setAttribute('spider.session.name',$sessionName);
		// GETパラメータにセッションIDが指定されたアクセスされていた場合は
		// 新しいセッションIDを付加してリダイレクトする
		if( $validHostname && isset($_GET[SPIDER_USE_SPIDER_SESSION_ID]) ) {
			$request->redirectTo(SPIDER_URL_REQUEST);
		} else {
			// 許可ホスト名でない場合はセッションが切れてもよいのでリダイレクトしない
		}
		return true;
	} else {
		return false;
	}
}
/**
 * 指定されたセッションIDの妥当性を検査します
 */
function spider_session_start_validate( & $request, $sessionId ) {
	$userAgent		= null;
	$remoteHost		= spider_getRemotHostString();
	if( isset($_SERVER['HTTP_USER_AGENT']) ) {
		$userAgent		= $_SERVER['HTTP_USER_AGENT'];
	}
	// セッションファイルが実際にあるか確認する
	$savePath	= session_save_path().'/sess_'.$sessionId;
	if( !file_exists($savePath) ) {
		// 指定セッションは存在しない
		return false;
	}
	
	// 指定セッションIDでセッションを開始してみる
	session_id($sessionId);
	session_start();
	$spiderSessionInitialized	= false;
	$spiderSessionUserAgent		= null;
	if( isset($_SESSION['spider.session.initialized']) ) {
		$spiderSessionInitialized	= unserialize($_SESSION['spider.session.initialized']);
	}
	if( isset($_SESSION['spider.session.userAgent']) ) {
		$spiderSessionUserAgent	= unserialize($_SESSION['spider.session.userAgent']);
	}
	if( isset($_SESSION['spider.session.remoteHost']) ) {
		$spiderSessionRemoteHost= unserialize($_SESSION['spider.session.remoteHost']);
	}
	// 必要に応じてアクセス元ホストの照合
	$validHostname	= true;
	$getSessionParam	= '';
	if( !is_null($remoteHost) && strlen($remoteHost) > 0 ) {
		// HostnameLookupが有効な環境の場合
		$agentClass	= $request->agentClass;
		$permitHostArray	= array();
		if( isset($GLOBALS['SPIDER_USER_AGENT_REMOTE_SESSION_PERMIT_HOSTS'][$agentClass]) ) {
			$permitHostArray	= $GLOBALS['SPIDER_USER_AGENT_REMOTE_SESSION_PERMIT_HOSTS'][$agentClass];
		}
		if( is_array($permitHostArray) && count($permitHostArray) > 0 ) {
			// セッション維持リモートホスト名の正規表現が指定されている場合
			// 前回アクセスのリモートホストに関係なく配列要素にマッチがあればOK
			$validHostname	= false;
			foreach( $permitHostArray as $hostRegx ) {
				if( preg_match($hostRegx,$remoteHost) > 0 ) {
					$validHostname		= true;
					$getSessionParam	= SPIDER_USE_SPIDER_SESSION_ID.'='.$sessionId;
					break;
				}
			}
		} else {
			// セッション維持リモートホストが指定されていないケースの場合
			// 前回のアクセスと一致を要求
			if( $remoteHost != $spiderSessionRemoteHost ) {
				$validHostname	= false;
			}
		}
	} else {
		// HostnameLookupが有効でないなら確認できないのでしない
		$validHostname	= true;
	}
	
	if( $spiderSessionInitialized && $validHostname && $spiderSessionUserAgent == $userAgent ) {
		// 初期化されていてかつユーザーエージェントが同じならセッション開始に問題なし
		// 最終アクセスのリモートホストを記録
		$_SESSION['spider.session.userAgent']	= serialize($userAgent);
		$_SESSION['spider.session.remoteHost']	= serialize($remoteHost);
		$sessionName	= SPIDER_USE_SPIDER_SESSION_ID;
		$request->setAttribute('spider.session.id',$sessionId);
		$request->setAttribute('spider.session.name',$sessionName);
		$request->setAttribute('spider.session.getparam',$getSessionParam);
		return true;
	} else {
		// 初期化されていないかユーザーエージェントが違うならセッションIDが古いか不正
		// 一度セッションを閉じる
		session_write_close();
		// 正しくないセッションクッキーを削除する
		setcookie( SPIDER_USE_SPIDER_SESSION_ID, '', time()-42000, SPIDER_URI_BASE );
		// 正しくないパラメータは一度削除する
		$nullStr	= '';
		$request->setAttribute('spider.session.id',$nullStr);
		$request->setAttribute('spider.session.name',$nullStr);
		$request->setAttribute('spider.session.getparam',$nullStr);
		return false;
	}
}
/**
 * spiderセッション保存時の検証に利用するリモートホスト名を取得します
 */
function spider_getRemotHostString() {
	if( isset($_SERVER['HTTP_X_FORWARDED_FOR']) && strlen($_SERVER['HTTP_X_FORWARDED_FOR']) > 0 ) {
		if( function_exists('gethostbyaddr') ) {
			return gethostbyaddr($_SERVER['HTTP_X_FORWARDED_FOR']);
		} else {
			return $_SERVER['HTTP_X_FORWARDED_FOR'];
		}
	} else if( isset($_SERVER['REMOTE_HOST']) && strlen($_SERVER['REMOTE_HOST']) > 0 ) {
		return $_SERVER['REMOTE_HOST'];
	} else if( isset($_SERVER['REMOTE_ADDR']) && strlen($_SERVER['REMOTE_ADDR']) > 0 ) {
		if( function_exists('gethostbyaddr') ) {
			return gethostbyaddr($_SERVER['REMOTE_ADDR']);
		} else {
			return $_SERVER['REMOTE_ADDR'];
		}
	}
	return null;
}
/**
 * マイクロタイムスタンプを元にランダム文字列のセッションＩＤを生成します。
 */
function spider_create_session_id() {
	$mictime				= microtime();
	list( $msec, $sec )		= explode(' ', $mictime );
	$microtimestamp			= $sec . str_replace('0.','',$msec );
	$unique_num				=
		spider_get_random_string(2)
		.substr($microtimestamp,0,2)
		.spider_get_random_string(2)
		.substr($microtimestamp,2,2)
		.spider_get_random_string(2)
		.substr($microtimestamp,4,2)
		.spider_get_random_string(2)
		.substr($microtimestamp,6,2)
		.spider_get_random_string(2)
		.substr($microtimestamp,8,2)
		.spider_get_random_string(2)
		.substr($microtimestamp,10,2)
		.spider_get_random_string(2)
		.substr($microtimestamp,12,2)
		.spider_get_random_string(2)
		.substr($microtimestamp,14,2)
	;
	return $unique_num;
}
/**
 * ランダム文字列を作成します
 */
function spider_get_random_string( $length = 32 ) {
	$str_array	= array(
		'A','B','C','D','E','F','G','H','I','J',
		'K','L','M','N','O','P','Q','R','S','T',
		'U','V','W','X','Y','Z',
		'a','b','c','d','e','f','g','h','i','j',
		'k','l','m','n','o','p','q','r','s','t',
		'u','v','w','x','y','z',
		'0','1','2','3','4','5','6','7','8','9',
		'A','B','C','D','E','F','G','H','I','J',
		'K','L','M','N','O','P','Q','R','S','T',
		'U','V','W','X','Y','Z',
		'a','b','c','d','e','f','g','h','i','j',
		'k','l','m','n','o','p','q','r','s','t',
		'u','v','w','x','y','z',
		'0','1','2','3','4','5','6','7','8','9',
		'A','B','C','D','E','F','G','H','I','J',
		'K','L','M','N','O','P','Q','R','S','T',
		'U','V','W','X','Y','Z',
		'a','b','c','d','e','f','g','h','i','j',
		'k','l','m','n','o','p','q','r','s','t',
		'u','v','w','x','y','z',
		'0','1','2','3','4','5','6','7','8','9',
		'A','B','C','D','E','F','G','H','I','J',
		'K','L','M','N','O','P','Q','R','S','T',
		'U','V','W','X','Y','Z',
		'a','b','c','d','e','f','g','h','i','j',
		'k','l','m','n','o','p','q','r','s','t',
		'u','v','w','x','y','z',
		'0','1','2','3','4','5','6','7','8','9',
		'A','B','C','D','E','F','G','H','I','J',
		'K','L','M','N','O','P','Q','R','S','T',
		'U','V','W','X','Y','Z',
		'a','b','c','d','e','f','g','h','i','j',
		'k','l','m','n','o','p','q','r','s','t',
		'u','v','w','x','y','z',
		'0','1','2','3','4','5','6','7','8','9',
		'A','B','C','D','E','F','G','H','I','J',
		'K','L','M','N','O','P','Q','R','S','T',
		'U','V','W','X','Y','Z',
		'a','b','c','d','e','f','g','h','i','j',
		'k','l','m','n','o','p','q','r','s','t',
		'u','v','w','x','y','z',
		'0','1','2','3','4','5','6','7','8','9',
		'A','B','C','D','E','F','G','H','I','J',
		'K','L','M','N','O','P','Q','R','S','T',
		'U','V','W','X','Y','Z',
		'a','b','c','d','e','f','g','h','i','j',
		'k','l','m','n','o','p','q','r','s','t',
		'u','v','w','x','y','z',
		'0','1','2','3','4','5','6','7','8','9',
	);
	$keys	= array_rand( $str_array, $length );
	$string	= '';
	foreach( $keys as $key ) {
		$string	.= $str_array[$key];
	}
	return $string;
}
/**
 * フォルダ作成ベースの処理ロック
 */
function spider_plock(){
	// 現在ロックがかかっているか確認する
	$lock_path	= DIR_PATH_LOCK.'/spider.orgsession.mainlock';
	if( spider_pwait() ) {
		// ロックがかかっていないならロックディレクトリ作成
		@mkdir( $lock_path, SPIDER_PERMITTION_DATA_FOLDER );
		@chmod( $lock_path, SPIDER_PERMITTION_DATA_FOLDER );
		return true;
	} else {
		return false;
	}
}

/**
 * 指定名のロックを解除します。
 */
function spider_prelease(){
	$lock_path	= DIR_PATH_LOCK.'/spider.orgsession.mainlock';
	if( is_dir( $lock_path ) ){
		rmdir( $lock_path );
	}
	return true;
}
/**
 * ロックが解除されるまで待機します
 */
function spider_pwait() {
	$lock_path	= DIR_PATH_LOCK.'/spider.orgsession.mainlock';
	$loop_count	= 0;
	while( true ) {
		$loop_count++;
		if( $loop_count > 300 ){
			return false;
		} else if ( !is_dir( $lock_path ) ) {
			return true;
		} else if ( filemtime($lock_path) + 30 < time() ){
			spider_prelease();
			return true;
		} else {
			usleep(500);
			continue;
		}
	}
}
/**
 * 文字列長を比較して$aと$bが同じ場合は0を、$aが$bより長い場合は1を、$aが$bより短い場合は-1を返します。
 */
function spiderCmp( $a, $b ) {
	$alen	= strlen($a);
	$blen	= strlen($b);
	if( $alen == $blen ) {
		return 0;
	} else if( $alen > $blen ) {
		return 1;
	} else {
		return -1;
	}
}
/**
 * 文字列長を比較して$aと$bが同じ場合は0を、$aが$bより長い場合は-1を、$aが$bより短い場合は1を返します。
 */
function spiderCmpR( $a, $b ) {
	$alen	= strlen($a);
	$blen	= strlen($b);
	if( $alen == $blen ) {
		return 0;
	} else if( $alen > $blen ) {
		return -1;
	} else {
		return 1;
	}
}
/**
 * CSVデータラインを配列にして返します
 */
function convert_csv_columns( $strings ) {
	$strings		= str_replace("\r\n","\n",$strings);
	$strings		= str_replace("\r","\n",$strings);
	$columns		= explode(',',$strings);
	$regist_columns	= array();
	$column_value	= '';
	// カラム値を""と,の関係維持して正確に分割する
	foreach( $columns as $val ) {
		if( strlen($column_value) > 0 ) {
			$column_value	.= ','.$val;
		} else {
			$column_value	.= $val;
		}
		$quote_count	= substr_count( $column_value, '"' );
		if( $quote_count % 2 != 0 ) {
			// クォータ数が偶数でない場合はカラムデータが完結していないので次の行へ
		} else {
			// 完結している場合はカラムとして処理
			if( preg_match('/^"/',$column_value) > 0 && preg_match( '/"$/', $column_value ) > 0 ) {
				$column_value	= preg_replace('/^"/','',$column_value );
				$column_value	= preg_replace('/"$/','',$column_value );
				$column_value	= preg_replace('/""/','"',$column_value );
			}
			$column_value			= mb_convert_kana($column_value,'KVas');
			array_push( $regist_columns, $column_value );
			$column_value	= '';
		}
	}
	return $regist_columns;
}
?>