<?php
/*
 * framework-spider
 * spider/tags/UseSession.class.php
 * 
 * CopyRight(C)Framework-Spider Developer Team. 2010. All Right Reserved. 
 * URL         : http://sourceforge.jp/projects/frameworkspider/
 * Mail        : frameworkspider-dev@lists.sourceforge.jp
 * Auther      : Masanori Nakashima
 * Modifier    : Masanori Nakashima
 * Last Updated: 2010.06.23
 * 
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'TagBase.class.php');
/**
 * HTML用変換タグ：use-sessionタグクラス
 * 
 * {use-session:[true/false]}
 * 対象ページでPHPのセッション機能を利用するか否かを設定するタグです。
 * falseの場合sessionがスタートされません。
 * デフォルトはtrueです。
 * 
 * @package spider spiderのコアパッケージ
 * @version 1.1.00
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class spider_tags_UseSession extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_UseSession() {
		$this->priority	= 0;
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$build_information ){
		if( preg_match('/\\{use\\-session\\:[fF][aA][lL][sS][eE]\\}/', $result_strings ) > 0
			|| preg_match('/\\{use\\-session\\:[nN][oO]\\}/', $result_strings ) > 0 ) {
			// falseかnoが指定されているならセッションは開始しない
			$result_strings = preg_replace( '/\\{use\\-session\\:[fF][aA][lL][sS][eE]\\}/'
				, "", $result_strings );
		} else {
			// 明示的にセッション開始を否定していないなら暗黙的にセッションを開始する
			$result_strings = preg_replace( '/\\{use\\-session\\:[^\\}]*?\\}/'
				, "", $result_strings );
			$process_code	= 'if( !spider_session_start($request_object) ) { header(\'Content-Type: text-plain;charset=UTF-8\');'
				.' die(\''.$GLOBALS['spider.messages']['spider.tags.usesession.cantstart'].'\'); }'
				. "\n"
				. '$GLOBALS[\'request_object\']->setAttribute( \'spider.session_name\', session_name(), SPIDER_SESSION_SCOPE_GLOBAL );'. "\n"
				. '$GLOBALS[\'request_object\']->setAttribute( \'spider.session_id\', session_id(), SPIDER_SESSION_SCOPE_GLOBAL );'. "\n"
				. 'if( isset($_SESSION) ) {'."\n"
				. 'if( isset($_SESSION[\'spider.global_errors\']) ) {'."\n"
				. '$globalErrors = unserialize( $_SESSION[\'spider.global_errors\'] );'."\n"
				. 'if( is_array( $globalErrors ) ) {'
				. '$GLOBALS[\'request_object\']->errors = $globalErrors;'."\n"
				. '}'."\n"
				. 'unset( $_SESSION[\'spider.global_errors\'] );'."\n"
				. '}'."\n"
				. '}'."\n"
			;
			if( !isset($build_information->processPreModuleHash)
				|| !is_array($build_information->processPreModuleHash) ){
				$build_information->processPreModuleHash	= array();
			}
			if( !isset($build_information->processPreModuleHash[$this->priority])
				|| !is_array($build_information->processPreModuleHash[$this->priority]) ){
				$build_information->processPreModuleHash[$this->priority]	= array();
			}
			array_push( $build_information->processPreModuleHash[$this->priority], $process_code );
		}
	}
}
?>