<?php
/*
 * framework-spider: Webページ利用用共通メイン実行ファイル
 * @version 1.1.02
 * 
 * CopyRight(C)Framework-Spider Developer Team. 2010. All Right Reserved. 
 * URL         : http://sourceforge.jp/projects/frameworkspider/
 * Mail        : frameworkspider-dev@lists.sourceforge.jp
 * Auther      : Masanori Nakashima
 * Modifier    : Masanori Nakashima
 * Last Updated: 2010.08.16
 * 
 */

/* 設定ファイルの読み込み	*/
require_once( dirname(__FILE__).DIRECTORY_SEPARATOR.'define.inc.php' );

// システムメール定義ファイルの読み込み
if( defined('FILE_PATH_SYSTEM_DEFINITION') && file_exists( FILE_PATH_SYSTEM_DEFINITION ) ){
	require_once( FILE_PATH_SYSTEM_DEFINITION );
}

// アクションファイルパスの取得
$action_file_path = $_SERVER['SCRIPT_FILENAME'];
if ( str_replace( '\\', '/', __FILE__ )
	== str_replace( '\\', '/', $action_file_path ) ) {
	// 本ファイル直接呼出しなら実行中止
	header( 'Content-type: text/plain;charset=UTF-8' );
	die( 'Core Error : コントロールファイルです。' );
}

/* リクエストコンテナオブジェクト	*/
require_once( DIR_PATH_LIB
	.DIRECTORY_SEPARATOR.'spider'
	.DIRECTORY_SEPARATOR.'HttpRequest.class.php' );
$GLOBALS['request']			= new spider_HttpRequest();
$GLOBALS['request_object']	= & $GLOBALS['request'];

/* 出力クラス	*/
require_once( DIR_PATH_LIB
	.DIRECTORY_SEPARATOR.'spider' 
	.DIRECTORY_SEPARATOR.'HttpOutput.class.php' );
$GLOBALS['output_object']		= new spider_HttpOutput();

/* コントローラークラス	*/
require_once( DIR_PATH_LIB
	.DIRECTORY_SEPARATOR.'spider' 
	.DIRECTORY_SEPARATOR.'Controller.class.php' );

/* グローバル関数ファイル	*/
require_once( DIR_PATH_LIB
	.DIRECTORY_SEPARATOR.'spider' 
	.DIRECTORY_SEPARATOR.'functions.inc.php' );

/* パーミッションの確認	*/
$errors	= spider_is_avairable_permittion();
if( count( $errors ) > 0 ) {
	header( 'Content-Type: text/plain;charset=UTF-8');
	echo "Core Error!!\n";
	foreach( $errors as $error ) {
		echo $error."\n";
	}
	die;
}

// POSTとGETとCOOKIEの値をオブジェクトに設定する
$GLOBALS['request_object']->setAttribute( 'postparams', $_POST );
foreach( $_POST as $key => $value ) {
	$GLOBALS['request_object']->setAttribute( 'post.'.$key, $value );
}
$GLOBALS['request_object']->setAttribute( 'getparams', $_GET );
foreach( $_GET as $key => $value ) {
	$GLOBALS['request_object']->setAttribute( 'get.'.$key, $value );
}
foreach( $_COOKIE as $key => $value ) {
	$GLOBALS['request_object']->setAttribute( 'cookie.'.$key, $value );
}
// session_idが正しく取れないのでUseSessionタグ内に移動
//// sessionのnameとidをリクエストに登録する
//$GLOBALS['request_object']->setAttribute( 'spider.session_name', session_name(), SPIDER_SESSION_SCOPE_GLOBAL );
//$GLOBALS['request_object']->setAttribute( 'spider.session_id', session_id(), SPIDER_SESSION_SCOPE_GLOBAL );

// spiderの固定値をリクエスト属性に設定する
$spiderBaseUrl = SPIDER_URL_BASE;
$GLOBALS['request_object']->setAttribute( 'SPIDER_URL_BASE', $spiderBaseUrl );
$GLOBALS['request_object']->setAttribute( 'spider.base_url', $spiderBaseUrl );
$spiderBaseUri = SPIDER_URI_BASE;
$GLOBALS['request_object']->setAttribute( 'SPIDER_URI_BASE', $spiderBaseUri );
$GLOBALS['request_object']->setAttribute( 'spider.base_uri', $spiderBaseUri );
$spiderBasePath = SPIDER_BASE_PATH;
$GLOBALS['request_object']->setAttribute( 'SPIDER_BASE_PATH', $spiderBasePath );
$GLOBALS['request_object']->setAttribute( 'spider.base_path', $spiderBasePath );
$spiderAccessUri= SPIDER_URI_REQUEST;
$GLOBALS['request_object']->setAttribute( 'SPIDER_URI_REQUEST', $spiderAccessUri );
$GLOBALS['request_object']->setAttribute( 'spider.access_uri', $spiderAccessUri );
$spiderAccessUrl= SPIDER_URL_REQUEST;
$GLOBALS['request_object']->setAttribute( 'SPIDER_URL_REQUEST', $spiderAccessUrl );
$spiderDocumentRootUrl	= SPIDER_URL_DOC;
$GLOBALS['request_object']->setAttribute( 'SPIDER_URL_DOC', $spiderDocumentRootUrl );
$spiderAppUri	= SPIDER_URI_APP;
$GLOBALS['request_object']->setAttribute( 'SPIDER_URI_APP', $spiderAppUri );
$spiderPhpSelf	= SPIDER_PHP_SELF;
$GLOBALS['request_object']->setAttribute( 'SPIDER_PHP_SELF', $spiderPhpSelf );
$spiderIsSSL	= SPIDER_IS_SSL;
$GLOBALS['request_object']->setAttribute( 'SPIDER_IS_SSL', $spiderIsSSL );

$spiderNomalUrl = APPLICATION_NML_URL;
$GLOBALS['request_object']->setAttribute( 'APPLICATION_NML_URL', $spiderNomalUrl );
$GLOBALS['request_object']->setAttribute( 'spider.nomal_url', $spiderNomalUrl );
$spiderSslUrl = APPLICATION_SSL_URL;
$GLOBALS['request_object']->setAttribute( 'APPLICATION_SSL_URL', $spiderSslUrl );
$GLOBALS['request_object']->setAttribute( 'spider.ssl_url', $spiderSslUrl );

// コントローラー
$GLOBALS['controller']	= new spider_Controller( $GLOBALS['request_object'], $GLOBALS['output_object'] );
// 前処理スクリプトの指定があるなら読み込む
if( is_array($GLOBALS['SPIDER_PREVIOUS_SCRIPT_FILE_PATH_ARRAY'])
	&& count($GLOBALS['SPIDER_PREVIOUS_SCRIPT_FILE_PATH_ARRAY']) > 0 ) {
	foreach( $GLOBALS['SPIDER_PREVIOUS_SCRIPT_FILE_PATH_ARRAY'] as $script_path ) {
		$script_path	= trim( $script_path );
		if( strlen($script_path) > 0 && file_exists( $script_path) ) {
			include_once( $script_path );
		}
	}
}
// メイン処理実行
$GLOBALS['controller']->execute( $GLOBALS['request_object'], $GLOBALS['output_object'] );

die;

?>