/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;

public class RemoveTaskEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1787178891038164920L;
    Project project;
    int row;
    Task oldTask;

    public RemoveTaskEdit(Project project, int row) {
        this.project = project;
        this.row = row;
        this.oldTask = project.getTaskAtRow(row);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.project.getController().insertTaskAtRow(this.oldTask, this.row);
        this.project.update();
        this.project.getTaskTableModel().fireTableChanged();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.project.getController().removeRow(this.row);
        this.project.update();
        this.project.getTaskTableModel().fireTableChanged();
    }

    @Override
    public void die() {
        super.die();
        this.project = null;
        this.oldTask = null;
    }
}

