/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jp.sourceforge.freegantt.data.model.MemberTableModel;
import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.swing.MemberTable;

public class MemberRootPane
extends JPanel {
    private static final long serialVersionUID = 3997661648912790931L;
    Application app;
    MemberTable memberListPane;
    JScrollPane innerScrollPane;

    public MemberRootPane(Application app) {
        this.app = app;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JLabel titleLabel = new JLabel(Resource.get("rsourceCaption"));
        titleLabel.setAlignmentX(0.0f);
        this.add(titleLabel);
        MemberTableModel tableModel = app.getProject().getMemberTableModel();
        tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                MemberRootPane.this.app.getProject().getTaskMemberComboBoxModel().fireListDataListener();
                if (MemberRootPane.this.memberListPane != null) {
                    MemberRootPane.this.memberListPane.repaint();
                }
            }
        });
        this.memberListPane = new MemberTable(app, tableModel);
        this.innerScrollPane = new JScrollPane(this.memberListPane);
        this.innerScrollPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.innerScrollPane.setAlignmentX(0.0f);
        this.add(this.innerScrollPane);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        int otherHeight = 0;
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c != this.innerScrollPane) {
                otherHeight += c.getHeight();
            }
            ++n2;
        }
        Rectangle r = this.innerScrollPane.getBounds();
        this.innerScrollPane.setBounds(r.x, r.y, r.width, this.getHeight() - 20 - otherHeight);
    }
}

