/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jp.sourceforge.freegantt.data.model.ProjectInfoChangedListener;
import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.swing.Application;

public class ProjectRootPane
extends JPanel {
    private static final long serialVersionUID = -189324575838088163L;
    Application app;
    JScrollPane summaryScrollPane;
    JTextField nameField;
    JTextArea summaryTextArea;

    public ProjectRootPane(final Application app) {
        this.app = app;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        app.getProject().getProjectInfoModel().addProjectInfoChangedListener(new ProjectInfoChangedHandler());
        JLabel titleLabel = new JLabel(Resource.get("infoName"));
        titleLabel.setAlignmentX(0.0f);
        this.add(titleLabel);
        this.nameField = new JTextField();
        this.nameField.setBounds(0, 0, 100, 16);
        this.nameField.setPreferredSize(new Dimension(Integer.MAX_VALUE, 16));
        this.nameField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 16));
        this.nameField.setAlignmentX(0.0f);
        this.nameField.setText(app.getProject().getName());
        this.nameField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                app.getProject().getController().setName(ProjectRootPane.this.nameField.getText());
            }
        });
        this.add(this.nameField);
        JLabel summaryLabel = new JLabel(Resource.get("infoSummary"));
        summaryLabel.setAlignmentX(0.0f);
        this.add(summaryLabel);
        this.summaryTextArea = new JTextArea();
        this.summaryTextArea.setLineWrap(true);
        this.summaryTextArea.setText(app.getProject().getSummary());
        this.summaryTextArea.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                app.getProject().getController().setSummary(ProjectRootPane.this.summaryTextArea.getText());
            }
        });
        this.summaryScrollPane = new JScrollPane(this.summaryTextArea);
        this.summaryScrollPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, 120));
        this.summaryScrollPane.setMinimumSize(new Dimension(1, 120));
        this.summaryScrollPane.setAlignmentX(0.0f);
        this.add(this.summaryScrollPane);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        int otherHeight = 0;
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c != this.summaryScrollPane) {
                otherHeight += c.getHeight();
            }
            ++n2;
        }
        Rectangle r = this.summaryScrollPane.getBounds();
        this.summaryScrollPane.setBounds(r.x, r.y, r.width, this.getHeight() - 20 - otherHeight);
    }

    class ProjectInfoChangedHandler
    implements ProjectInfoChangedListener {
        ProjectInfoChangedHandler() {
        }

        @Override
        public void projectInfoChanged() {
            ProjectRootPane.this.nameField.setText(ProjectRootPane.this.app.getProject().getName());
            ProjectRootPane.this.summaryTextArea.setText(ProjectRootPane.this.app.getProject().getSummary());
        }
    }
}

