/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.undo.UndoManager;
import jp.sourceforge.freegantt.data.Member;
import jp.sourceforge.freegantt.data.Print;
import jp.sourceforge.freegantt.data.Task;
import jp.sourceforge.freegantt.data.View;
import jp.sourceforge.freegantt.data.controller.ProjectController;
import jp.sourceforge.freegantt.data.model.HolidayTableModel;
import jp.sourceforge.freegantt.data.model.MemberTableModel;
import jp.sourceforge.freegantt.data.model.ProjectInfoModel;
import jp.sourceforge.freegantt.data.model.ProjectModifiedModel;
import jp.sourceforge.freegantt.data.model.ProjectViewModel;
import jp.sourceforge.freegantt.data.model.TaskListTableModel;
import jp.sourceforge.freegantt.data.model.TaskMemberComboBoxModel;
import jp.sourceforge.freegantt.data.undo.StatefullUndoManager;
import jp.sourceforge.freegantt.util.CalendarUtil;

public class Project {
    public static final int CALENDAR_MODE_DATE = 0;
    public static final int CALENDAR_MODE_WEEK = 1;
    String filename;
    String name = "";
    String summary = "";
    List<Member> members = new ArrayList<Member>();
    List<Task> tasks = new ArrayList<Task>();
    List<Integer> fixedHolidays = new ArrayList<Integer>();
    List<Calendar> additionalHolidays = new ArrayList<Calendar>();
    Dimension cellSize = new Dimension(14, 16);
    int calendarMode = 0;
    View view = new View();
    Print print = new Print();
    Calendar chartFromDate;
    Calendar chartToDate;
    long fileLastModified = Long.MAX_VALUE;
    boolean modified = false;
    protected ProjectController controller;
    protected UndoManager undoManager;
    protected TaskListTableModel taskTableModel;
    protected MemberTableModel memberTableModel;
    protected HolidayTableModel holidayTableModel;
    protected TaskMemberComboBoxModel taskMemberComboBoxModel;
    protected ProjectInfoModel projectInfoModel;
    protected ProjectViewModel projectViewModel;
    protected ProjectModifiedModel projectModifiedModel;

    public void setCellSize(Dimension cellSize) {
        this.cellSize = cellSize;
    }

    public ProjectModifiedModel getProjectModifiedModel() {
        return this.projectModifiedModel;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public ProjectViewModel getProjectViewModel() {
        return this.projectViewModel;
    }

    public ProjectInfoModel getProjectInfoModel() {
        return this.projectInfoModel;
    }

    public ProjectController getController() {
        return this.controller;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public long getFileLastModified() {
        return this.fileLastModified;
    }

    public void setFileLastModified(long fileLastModified) {
        this.fileLastModified = fileLastModified;
    }

    public void setCalendarMode(int mode) {
        this.calendarMode = mode;
    }

    public int getCalendarMode() {
        return this.calendarMode;
    }

    public boolean isCalendarModeDate() {
        return this.calendarMode == 0;
    }

    public Print getPrint() {
        return this.print;
    }

    public void setPrint(Print print) {
        this.print = print;
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public Dimension getCellSize() {
        return this.cellSize;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public List<Member> getMembers() {
        return this.members;
    }

    public void setMembers(List<Member> members) {
        this.members = members;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public List<Integer> getFixedHolidays() {
        return this.fixedHolidays;
    }

    public void setFixedHolidays(List<Integer> fixedHolidays) {
        this.fixedHolidays = fixedHolidays;
    }

    public List<Calendar> getAdditionalHolidays() {
        return this.additionalHolidays;
    }

    public void setAdditionalHolidays(List<Calendar> additionalHolidays) {
        this.additionalHolidays = additionalHolidays;
    }

    public TaskListTableModel getTaskTableModel() {
        return this.taskTableModel;
    }

    public MemberTableModel getMemberTableModel() {
        return this.memberTableModel;
    }

    public HolidayTableModel getHolidayTableModel() {
        return this.holidayTableModel;
    }

    public TaskMemberComboBoxModel getTaskMemberComboBoxModel() {
        return this.taskMemberComboBoxModel;
    }

    public Calendar getChartRangeFromDate() {
        return this.chartFromDate;
    }

    public Calendar getChartRangeToDate() {
        return this.chartToDate;
    }

    public Project() {
        this.updateTableModel();
    }

    public void updateTableModel() {
        this.controller = new ProjectController(this);
        this.undoManager = new StatefullUndoManager();
        this.taskTableModel = new TaskListTableModel(this);
        this.memberTableModel = new MemberTableModel(this);
        this.holidayTableModel = new HolidayTableModel(this);
        this.taskMemberComboBoxModel = new TaskMemberComboBoxModel(this);
        this.projectInfoModel = new ProjectInfoModel(this);
        this.projectViewModel = new ProjectViewModel(this);
        this.projectModifiedModel = new ProjectModifiedModel(this);
    }

    public boolean isHoliday(Calendar calendar) {
        int week = calendar.get(7);
        if (this.fixedHolidays.contains(week)) {
            return true;
        }
        for (Calendar holiday : this.additionalHolidays) {
            if (!CalendarUtil.dateEquals(calendar, holiday)) continue;
            return true;
        }
        return false;
    }

    public boolean isAdditionalHoliday(Calendar calendar) {
        return this.additionalHolidays.contains(calendar);
    }

    public List<Task> getRestrictionSrcTasks(Task task) {
        ArrayList<Task> result = new ArrayList<Task>();
        if (task == null) {
            return result;
        }
        for (Task src : this.getTasks()) {
            if (!src.getRestrictions().contains(task)) continue;
            result.add(src);
        }
        return result;
    }

    public List<Task> getChildTasks(Task targetTask) {
        ArrayList<Task> childTasks = new ArrayList<Task>();
        int index = this.getIndexByTask(targetTask);
        ++index;
        while (index < this.tasks.size()) {
            Task task = this.getTaskAtIndex(index);
            if (task.getLevel() <= targetTask.getLevel()) {
                return childTasks;
            }
            childTasks.add(task);
            ++index;
        }
        return childTasks;
    }

    private Task getParentTask(Task targetTask) {
        if (targetTask.getLevel() == 0) {
            return null;
        }
        int index = this.getIndexByTask(targetTask);
        --index;
        while (index >= 0) {
            Task task = this.getTaskAtIndex(index);
            if (task.getLevel() < targetTask.getLevel()) {
                return task;
            }
            --index;
        }
        return null;
    }

    public List<Integer> collectRestrictionIndexes(Task targetTask) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (targetTask == null) {
            return list;
        }
        for (Task task : targetTask.getRestrictions()) {
            int index = this.getIndexByTask(task);
            if (index < 0) continue;
            list.add(index);
        }
        return list;
    }

    public List<Task> collectTasksAtIndexes(List<Integer> indexes) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (int index : indexes) {
            Task task = this.getTaskAtIndex(index);
            if (task == null) continue;
            tasks.add(task);
        }
        return tasks;
    }

    public void update() {
        ArrayList<Task> sortedTasks = new ArrayList<Task>(this.tasks);
        Collections.sort(sortedTasks, new Comparator<Task>(){

            @Override
            public int compare(Task lhs, Task rhs) {
                if (lhs == null || rhs == null) {
                    return -1;
                }
                if (lhs.getLevel() == rhs.getLevel()) {
                    return 0;
                }
                return lhs.getLevel() > rhs.getLevel() ? -1 : 1;
            }
        });
        for (Task task : sortedTasks) {
            this.getController().setTaskGroup(!this.getChildTasks(task).isEmpty(), this.getIndexByTask(task));
            if (task.isGroup()) {
                this.updateParentPeriod(task);
                continue;
            }
            if (task.isMilestone()) {
                this.updateMilestone(task);
                continue;
            }
            this.updateChildrenPeriod(task, false);
        }
        this.updateCliticalPath();
        this.updateAllVisibility();
    }

    public void updateMilestone(Task task) {
        Task updateTask = task.clone();
        updateTask.setRealPeriod(0);
        List<Task> srcs = this.getRestrictionSrcTasks(task);
        if (srcs.size() == 0) {
            updateTask.setCompletion(100);
        } else {
            int completeTaskCount = 0;
            for (Task src : srcs) {
                if (src.getCompletion() != 100) continue;
                ++completeTaskCount;
            }
            updateTask.setCompletion(completeTaskCount * 100 / srcs.size());
        }
        if (!updateTask.equals(task)) {
            this.getController().setTaskAtIndex(updateTask, this.getIndexByTask(task));
        }
    }

    public void updateChildrenPeriod(Task task, boolean isFloating) {
        if (task.isGroup()) {
            return;
        }
        if (task.getStartDate() == null) {
            return;
        }
        if (task.getPeriod() == null) {
            task.setPeriod(0);
        }
        Task updateTask = isFloating ? task : task.clone();
        int leftPeriod = updateTask.getPeriod();
        int realPeriod = 0;
        Calendar now = (Calendar)updateTask.getStartDate().clone();
        int i = 0;
        while (i < 365 && (double)leftPeriod > 0.0) {
            if (!this.isHoliday(now)) {
                leftPeriod = (int)((double)leftPeriod - 1.0);
            }
            realPeriod = (int)((double)realPeriod + 1.0);
            now.add(5, 1);
            ++i;
        }
        updateTask.setRealPeriod(realPeriod);
        if (!isFloating && !updateTask.equals(task)) {
            this.getController().setTaskAtIndex(updateTask, this.getIndexByTask(task));
        }
    }

    public void updateParentPeriod(Task task) {
        if (!task.isGroup()) {
            return;
        }
        Task updateTask = task.clone();
        updateTask.setStartDate(null);
        updateTask.setPeriod(null);
        updateTask.setRealPeriod(null);
        long from = Long.MAX_VALUE;
        long to = Long.MIN_VALUE;
        List<Task> children = this.getChildTasks(task);
        for (Task child : children) {
            if (child.getStartDate() == null) continue;
            long childFrom = child.getStartDate().getTimeInMillis();
            if (childFrom < from) {
                from = childFrom;
            }
            if (childFrom > to) {
                to = childFrom;
            }
            if (child.getRealPeriod() == null) continue;
            long childTo = childFrom + child.getRealPeriod().longValue() * 86400000L;
            if (childTo < from) {
                from = childTo;
            }
            if (childTo <= to) continue;
            to = childTo;
        }
        if (to < from) {
            return;
        }
        Calendar startDate = Calendar.getInstance();
        startDate.setTimeInMillis(from);
        updateTask.setStartDate(startDate);
        updateTask.setPeriod(CalendarUtil.subDate(CalendarUtil.toDateCalendar(to), CalendarUtil.toDateCalendar(from)));
        updateTask.setRealPeriod(updateTask.getPeriod());
        int wholePeriod = 0;
        double completePeriod = 0.0;
        List<Task> children2 = this.getChildTasks(task);
        for (Task child : children2) {
            if (child.isGroup() || child.getPeriod() == null || child.getPeriod() <= 0) continue;
            wholePeriod += child.getPeriod().intValue();
            completePeriod += (double)(child.getPeriod() * child.getCompletion()) / 100.0;
        }
        updateTask.setCompletion((int)(completePeriod * 100.0 / (double)wholePeriod));
        if (!updateTask.equals(task)) {
            System.out.println("Group Task updated: " + updateTask.getName());
            this.getController().setTaskAtIndex(updateTask, this.getIndexByTask(task));
        }
    }

    public List<Task> getVisibleTasks() {
        ArrayList<Task> visibleTasks = new ArrayList<Task>();
        for (Task task : this.tasks) {
            if (!task.isVisible()) continue;
            visibleTasks.add(task);
        }
        return visibleTasks;
    }

    public Task getTaskAtIndex(int index) {
        if (index < 0 || this.tasks.size() <= index) {
            return null;
        }
        return this.tasks.get(index);
    }

    public Task getTaskAtRow(int row) {
        if (row < 0) {
            return null;
        }
        int index = this.getIndexFromRow(row);
        if (index < 0 || index >= this.tasks.size()) {
            return null;
        }
        return this.getTaskAtIndex(index);
    }

    public int getIndexFromRow(int row) {
        if (row < 0) {
            return -1;
        }
        int index = 0;
        int rowCount = -1;
        while (rowCount <= row) {
            Task task = this.getTaskAtIndex(index);
            if (task == null || task.isVisible()) {
                ++rowCount;
            }
            if (rowCount == row) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getRowByTask(Task targetTask) {
        if (targetTask == null) {
            return -1;
        }
        int index = 0;
        int rowCount = -1;
        while (index < this.tasks.size()) {
            Task task = this.getTaskAtIndex(index);
            if (task == null || task.isVisible()) {
                ++rowCount;
            }
            if (task == targetTask) {
                return rowCount;
            }
            ++index;
        }
        return -1;
    }

    public int getIndexByTask(Task targetTask) {
        int index = 0;
        while (index < this.tasks.size()) {
            Task task = this.getTaskAtIndex(index);
            if (task == targetTask) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public Calendar getFirstDate() {
        Calendar firstDate = Calendar.getInstance();
        boolean found = false;
        firstDate.setTimeInMillis(Long.MAX_VALUE);
        for (Task task : this.tasks) {
            if (task.getStartDate() == null || firstDate.getTimeInMillis() <= task.getStartDate().getTimeInMillis()) continue;
            found = true;
            firstDate = (Calendar)task.getStartDate().clone();
        }
        if (!found) {
            return null;
        }
        return firstDate;
    }

    public int getWholePeriod() {
        Calendar firstDate = this.getFirstDate();
        Calendar lastDate = Calendar.getInstance();
        boolean found = false;
        lastDate.setTimeInMillis(Long.MIN_VALUE);
        if (firstDate == null) {
            return 0;
        }
        for (Task task : this.tasks) {
            Calendar endDate = task.getEndDate();
            if (endDate == null || lastDate.getTimeInMillis() >= endDate.getTimeInMillis()) continue;
            found = true;
            lastDate = endDate;
        }
        if (!found) {
            return 0;
        }
        return CalendarUtil.subDate(lastDate, firstDate);
    }

    public int getRowCount() {
        int rowCount = 0;
        int index = 0;
        while (index < this.tasks.size()) {
            Task task = this.getTaskAtIndex(index);
            if (task == null || task.isVisible()) {
                ++rowCount;
            }
            ++index;
        }
        return rowCount;
    }

    public void removeMember(int index) {
        if (index >= this.members.size()) {
            return;
        }
        Member member = this.members.get(index);
        for (Task task : this.tasks) {
            if (task.getMember() != member) continue;
            task.setMember(null);
        }
        this.members.remove(index);
        this.getMemberTableModel().fireTableChanged();
        this.getTaskTableModel().fireTableChanged();
    }

    public void updateChartRange() {
        this.chartFromDate = this.getFirstDate();
        if (this.chartFromDate == null) {
            this.chartFromDate = CalendarUtil.toDateCalendar(Calendar.getInstance());
        }
        this.chartToDate = this.getFirstDate();
        int period = this.getWholePeriod();
        if (this.chartToDate != null) {
            this.chartToDate.add(5, period);
        }
        if (this.chartToDate == null) {
            this.chartToDate = CalendarUtil.toDateCalendar(Calendar.getInstance());
        }
    }

    public void updateCliticalPath() {
        ArrayList<Task> criticalTasks = new ArrayList<Task>();
        List<Task> endTasks = this.getEndTasks();
        criticalTasks.addAll(endTasks);
        for (Task endTask : endTasks) {
            criticalTasks.addAll(this.traceCliticalTask(endTask));
        }
        for (Task task : this.tasks) {
            this.getController().setTaskCriticalPath(criticalTasks.contains(task), this.getIndexByTask(task));
            task.setCriticalPath(criticalTasks.contains(task));
        }
    }

    protected List<Task> getEndTasks() {
        Calendar endDate;
        ArrayList<Task> endTasks = new ArrayList<Task>();
        long lastEndTime = 0L;
        for (Task task : this.tasks) {
            long endTime;
            endDate = task.getEndDate();
            if (endDate == null || lastEndTime >= (endTime = endDate.getTimeInMillis())) continue;
            lastEndTime = endTime;
        }
        for (Task task : this.tasks) {
            endDate = task.getEndDate();
            if (endDate == null || endDate.getTimeInMillis() != lastEndTime) continue;
            endTasks.add(task);
        }
        return endTasks;
    }

    protected List<Task> traceCliticalTask(Task endTask) {
        ArrayList<Task> criticalTasks = new ArrayList<Task>();
        criticalTasks.add(endTask);
        ArrayList<Task> restrictionTasks = new ArrayList<Task>();
        for (Task task : this.tasks) {
            Calendar endDate;
            if (task == endTask || (endDate = task.getEndDate()) == null || !task.getRestrictions().contains(endTask)) continue;
            System.out.println(CalendarUtil.subDateUsingHoliday(this, endTask.startDate, endDate));
            if (CalendarUtil.subDateUsingHoliday(this, endTask.startDate, endDate) > 0) continue;
            restrictionTasks.add(task);
        }
        for (Task task : restrictionTasks) {
            criticalTasks.addAll(this.traceCliticalTask(task));
        }
        return criticalTasks;
    }

    public void toggleTaskFold(int row) {
        Task task = this.getTaskAtRow(row);
        if (task == null) {
            return;
        }
        if (task.isOpened()) {
            task.setOpened(false);
            this.updateChildTasksVisibility(task);
        } else {
            task.setOpened(true);
            this.updateChildTasksVisibility(task);
        }
    }

    public void updateAllVisibility() {
        for (Task task : this.tasks) {
            this.updateTaskVisibility(task);
        }
    }

    private void updateChildTasksVisibility(Task targetTask) {
        List<Task> childTasks = this.getChildTasks(targetTask);
        for (Task child : childTasks) {
            this.updateTaskVisibility(child);
        }
    }

    private void updateTaskVisibility(Task targetTask) {
        Task parent = this.getParentTask(targetTask);
        while (parent != null) {
            if (!parent.isOpened()) {
                this.getController().setTaskVisible(false, this.getIndexByTask(targetTask));
                return;
            }
            parent = this.getParentTask(parent);
        }
        this.getController().setTaskVisible(true, this.getIndexByTask(targetTask));
    }

    public Member findFirstMemberByName(String memberName) {
        if (memberName == null) {
            return null;
        }
        for (Member member : this.members) {
            if (!memberName.equals(member.getName())) continue;
            return member;
        }
        return null;
    }
}

