/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.undo.CompoundEdit;
import jp.sourceforge.freegantt.data.Member;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;
import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.util.CalendarUtil;

public class TaskListTableModel
implements TableModel {
    public static int ADDITION_ROOM_COUNT = 20;
    String[] columnNames;
    public static String[] COLUMN_KEYS = new String[]{"", "name", "resource", "period", "completion", "startDate"};
    public static List<Integer> MILESTONE_UNEDITABLE = Arrays.asList(2, 4);
    public static List<Integer> PARENT_UNEDITABLE = Arrays.asList(2, 3, 4, 5);
    List<TableModelListener> tableModelListeners = new ArrayList<TableModelListener>();
    Project project;

    public TaskListTableModel(Project project) {
        this.project = project;
        this.columnNames = new String[]{"", Resource.get("listColumnName"), Resource.get("listColumnResource"), Resource.get("listColumnPeriod"), Resource.get("listColumnCompletion"), Resource.get("listColumnStartDate")};
    }

    @Override
    public int getRowCount() {
        return this.project.getRowCount() + ADDITION_ROOM_COUNT;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnNames.length) {
            return null;
        }
        return this.columnNames[columnIndex];
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String getColumnKey(int index) {
        if (index >= COLUMN_KEYS.length) {
            return null;
        }
        return COLUMN_KEYS[index];
    }

    public String[] getColumnKeys() {
        return COLUMN_KEYS;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return Member.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return false;
        }
        Task task = this.project.getTaskAtRow(rowIndex);
        return !(task != null && task.isGroup() ? PARENT_UNEDITABLE.contains(columnIndex) : task != null && task.isMilestone() && MILESTONE_UNEDITABLE.contains(columnIndex));
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return rowIndex + 1;
        }
        Task task = this.project.getTaskAtRow(rowIndex);
        if (task == null) {
            return null;
        }
        if (!task.isVisible()) {
            return null;
        }
        switch (columnIndex) {
            case 1: {
                return task.getName();
            }
            case 2: {
                return task.getMember();
            }
            case 3: {
                return task.getPeriod() == null ? null : String.valueOf(task.getPeriod());
            }
            case 4: {
                if (task.getStartDate() == null) {
                    return null;
                }
                return task.getCompletion();
            }
            case 5: {
                SimpleDateFormat dateFormat = new SimpleDateFormat(Resource.get("dateFormat"), Resource.getLocale());
                return task.getStartDate() == null ? null : dateFormat.format(task.getStartDate().getTime());
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        compound = new CompoundEdit();
        this.project.getUndoManager().addEdit(compound);
        try {
            task = this.project.getTaskAtRow(rowIndex);
            if (task == null) {
                task = this.project.getController().fillNewTaskAtIndex(this.project.getIndexFromRow(rowIndex));
            }
            newTask = task.clone();
            switch (columnIndex) {
                case 1: {
                    newTask.setName((String)aValue);
                    break;
                }
                case 2: {
                    member = null;
                    if (aValue instanceof Member) {
                        member = (Member)aValue;
                    } else if (aValue instanceof String) {
                        member = this.project.findFirstMemberByName((String)aValue);
                    }
                    newTask.setMember(member);
                    break;
                }
                case 3: {
                    try {
                        newTask.setPeriod(aValue == null || ((String)aValue).isEmpty() != false ? null : Integer.valueOf(Integer.parseInt((String)aValue)));
                    }
                    catch (NumberFormatException var8_8) {}
                    break;
                }
                case 4: {
                    if (newTask.getStartDate() == null || newTask.isMilestone()) break;
                    try {
                        newTask.setCompletion(aValue == null || ((String)aValue).isEmpty() != false ? 0 : Integer.parseInt((String)aValue));
                    }
                    catch (NumberFormatException ex) {
                        newTask.setCompletion(0);
                    }
                    break;
                }
                case 5: {
                    if (aValue == null || ((String)aValue).isEmpty()) {
                        newTask.setStartDate(null);
                        break;
                    }
                    startDate = CalendarUtil.parseDate((String)aValue, Resource.getLocale());
                    if (startDate == null) break;
                    newTask.setStartDate(startDate);
                    if (newTask.getPeriod() != null) break;
                    newTask.setPeriod(0);
                }
            }
            this.project.getController().setTaskAtIndex(newTask, this.project.getIndexFromRow(rowIndex));
            this.project.update();
        }
        finally {
            compound.end();
            ** for (listener : this.tableModelListeners)
        }
lbl-1000:
        // 1 sources

        {
            e = new TableModelEvent(this, rowIndex, rowIndex, columnIndex, 0);
            listener.tableChanged(e);
            continue;
        }
lbl54:
        // 1 sources

    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.tableModelListeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tableModelListeners.remove(l);
    }

    public void fireTableChanged() {
        for (TableModelListener listener : this.tableModelListeners) {
            TableModelEvent e = new TableModelEvent(this, 0, 0, 0, 0);
            listener.tableChanged(e);
        }
    }
}

