/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.undo;

import java.util.Calendar;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import jp.sourceforge.freegantt.data.Project;

public class CreateAdditionalHolidayEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = -4667694082936530048L;
    Project project;
    Calendar newCalendar;
    int index;

    public CreateAdditionalHolidayEdit(Project project, Calendar calendar, int index) {
        this.project = project;
        this.newCalendar = (Calendar)calendar.clone();
        this.index = index;
    }

    @Override
    public void undo() throws CannotUndoException {
        System.out.println("Undo " + this.getClass().toString());
        super.undo();
        this.project.getController().removeAdditionalHoliday(this.index);
    }

    @Override
    public void redo() throws CannotRedoException {
        System.out.println("Redo " + this.getClass().toString());
        super.redo();
        this.project.getController().addAdditionalHoliday(this.newCalendar, this.index);
    }

    @Override
    public void die() {
        super.die();
        this.project = null;
        this.newCalendar = null;
    }
}

