/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;

public class RemoveRestrictioinEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 4876365331030618017L;
    Project project;
    int srcIndex;
    int dstIndex;

    public RemoveRestrictioinEdit(Project project, int srcIndex, int dstIndex) {
        this.project = project;
        this.srcIndex = srcIndex;
        this.dstIndex = dstIndex;
    }

    @Override
    public void undo() throws CannotUndoException {
        System.out.println("Undo " + this.getClass().toString());
        super.undo();
        Task srcTask = this.project.getTaskAtIndex(this.srcIndex);
        Task dstTask = this.project.getTaskAtIndex(this.dstIndex);
        srcTask.getRestrictions().add(dstTask);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        Task srcTask = this.project.getTaskAtRow(this.srcIndex);
        Task dstTask = this.project.getTaskAtRow(this.dstIndex);
        srcTask.getRestrictions().remove(dstTask);
    }

    @Override
    public void die() {
        super.die();
        this.project = null;
    }
}

