/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.undo;

import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;

public class RemoveTaskEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1787178891038164920L;
    Project project;
    int index;
    Task oldTask;
    List<Integer> oldRestrictionIndexes;

    public RemoveTaskEdit(Project project, int index) {
        this.project = project;
        this.index = index;
        this.oldTask = project.getTaskAtIndex(index);
        this.oldRestrictionIndexes = project.collectRestrictionIndexes(this.oldTask);
    }

    @Override
    public void undo() throws CannotUndoException {
        System.out.println("Undo " + this.getClass().toString());
        super.undo();
        this.project.getController().insertTaskAtIndex(this.oldTask, this.index);
        this.oldTask.setRestrictions(this.project.collectTasksAtIndexes(this.oldRestrictionIndexes));
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.project.getController().removeIndex(this.index);
    }

    @Override
    public void die() {
        super.die();
        this.project = null;
        this.oldTask = null;
    }
}

