/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.undo;

import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import jp.sourceforge.freegantt.data.Member;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;

public class UpdateMemberEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 7198504393015944291L;
    Project project;
    Member newMember;
    Member oldMember;
    int index;
    List<Integer> srcTasks = new ArrayList<Integer>();

    public UpdateMemberEdit(Project project, Member newMember, int index) {
        this.project = project;
        this.newMember = newMember.clone();
        this.oldMember = project.getMembers().get(index);
        this.index = index;
        int i = 0;
        while (i < project.getTasks().size()) {
            Task task = project.getTasks().get(i);
            if (task.getMember() == this.oldMember) {
                this.srcTasks.add(i);
            }
            ++i;
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        System.out.println("Undo " + this.getClass().toString());
        super.undo();
        this.project.getController().setMember(this.oldMember, this.index);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.project.getController().setMember(this.newMember, this.index);
    }

    @Override
    public void die() {
        super.die();
        this.project = null;
        this.newMember = null;
        this.oldMember = null;
        this.srcTasks = null;
    }
}

