/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.undo;

import java.awt.Dimension;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import jp.sourceforge.freegantt.data.Project;

public class UpdatePrintCellSizeEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = -3573084016242143261L;
    Project project;
    Dimension oldPrintCellSize;
    Dimension newPrintCellSize;

    public UpdatePrintCellSizeEdit(Project project, Dimension newPrintCellSize) {
        this.project = project;
        this.oldPrintCellSize = project.getPrint().getPrintCellSize();
        this.newPrintCellSize = (Dimension)newPrintCellSize.clone();
    }

    @Override
    public void undo() throws CannotUndoException {
        System.out.println("Undo " + this.getClass().toString());
        super.undo();
        this.project.getController().setPrintCellSize(this.oldPrintCellSize);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.project.getController().setPrintCellSize(this.newPrintCellSize);
    }

    @Override
    public void die() {
        super.die();
        this.project = null;
        this.oldPrintCellSize = null;
        this.newPrintCellSize = null;
    }
}

