/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.undo.CompoundEdit;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;
import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.swing.CursorState;
import jp.sourceforge.freegantt.swing.TaskLinePane;
import jp.sourceforge.freegantt.util.CalendarUtil;
import jp.sourceforge.freegantt.util.GraphicsUtil;
import jp.sourceforge.freegantt.util.Pair;

public class TaskLineDataPane
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener {
    private static final long serialVersionUID = 4173201298740221449L;
    Application app;
    Project project;
    TaskLinePane taskLinePane;
    CursorState cursorState;
    boolean printRangeMode = false;
    boolean progressLineMode = false;
    TaskUI taskUI;
    RestrictionUI restrictionUI;
    PrintRangeUI printRangeUI;
    ProgressLineUI progressLineUI;
    FreeScrollUI freeScrollUI;
    int dragOperation = 0;
    int pressOperation = 0;
    Point dragStartPoint;
    int targetRow;
    Task floatingTask = null;
    Restriction floatingRestriction = null;
    Dimension floatingPrintCellSize = null;
    Timer autoScrollTimer;
    static final int OPERATION_NONE = 0;
    static final int OPERATION_TASK_CREATE = 1;
    static final int OPERATION_TASK_SLIDE = 2;
    static final int OPERATION_TASK_PERIOD = 3;
    static final int OPERATION_TASK_COMPLETION = 4;
    static final int OPERATION_RESTRICTION_CREATE = 5;
    static final int OPERATION_RESTRICTION_DELETE = 6;
    static final int OPERATION_PRINT_RANGE_X = 7;
    static final int OPERATION_PRINT_RANGE_Y = 8;
    static final int OPERATION_PRINT_RANGE = 9;
    static final int OPERATION_FREE_SCROLL = 10;
    Color weekLineColor = new Color(208, 208, 208);
    Color bgColor = Color.white;
    Color holidayBgColor = new Color(240, 240, 240);
    Color progressLineColor = new Color(240, 80, 80);
    Color borderColor = new Color(133, 81, 224);
    Color fillColor = new Color(218, 206, 252);
    Color completionColor = this.borderColor;
    Color floatingBorderColor = Color.black;
    Color floatingFillColor = new Color(144, 144, 144);
    Color floatingCompletionColor = this.floatingBorderColor;
    Color groupColor = new Color(80, 80, 80);
    Color fontColor = new Color(48, 48, 48);
    Color milestoneColor = this.groupColor;
    Color floatingMilestoneColor = Color.black;
    Color restrictionColor = new Color(80, 80, 80);
    Color floatingRestrictionColor = Color.black;
    Color criticalPathBorderColor = new Color(224, 80, 80);
    Color criticalPathFillColor = new Color(232, 184, 184);
    Color criticalPathCompletionColor = this.criticalPathBorderColor;
    Color criticalPathRestrictionColor = this.criticalPathBorderColor;

    public PrintRangeUI getPrintRange() {
        return this.printRangeUI;
    }

    public boolean isProgressLineMode() {
        return this.progressLineMode;
    }

    public void setProgressLineMode(boolean progressLineMode) {
        this.progressLineMode = progressLineMode;
    }

    public boolean isPrintRangeMode() {
        return this.printRangeMode;
    }

    public void setPrintRangeMode(boolean printRangeMode) {
        this.printRangeMode = printRangeMode;
    }

    public int getCellWidth() {
        return this.taskLinePane.getCellWidth();
    }

    public int getCellHeight() {
        return this.taskLinePane.getCellHeight();
    }

    public TaskLineDataPane(Application app, Project project, TaskLinePane taskLinePane) {
        this.app = app;
        this.project = project;
        this.taskLinePane = taskLinePane;
        this.cursorState = new CursorState(this);
        this.printRangeUI = new PrintRangeUI();
        this.taskUI = new TaskUI();
        this.restrictionUI = new RestrictionUI();
        this.progressLineUI = new ProgressLineUI();
        this.freeScrollUI = new FreeScrollUI();
        this.setBackground(this.bgColor);
        this.setFocusable(true);
        this.setPreferredSize(new Dimension(1, project.getTaskTableModel().getRowCount() * this.getCellHeight()));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    public void updateWidth() {
        Calendar fromDate = this.taskLinePane.getChartFromDate();
        Calendar toDate = this.taskLinePane.getChartToDate();
        this.setSize(CalendarUtil.subDate(toDate, fromDate) * this.getCellWidth(), this.getHeight());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawBackground(g);
        this.taskUI.drawTasks(g);
        this.restrictionUI.drawRestrictions(g);
        this.progressLineUI.drawProgressLine(g);
        this.printRangeUI.drawPrintRange(g);
    }

    private void drawBackground(Graphics g) {
        int drawableHeight = this.project.getTaskTableModel().getRowCount() * this.getCellHeight();
        g.setColor(this.bgColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Calendar now = (Calendar)this.taskLinePane.getChartFromDate().clone();
        Calendar to = this.taskLinePane.getChartToDate();
        int offset = 0;
        while (now.getTimeInMillis() < to.getTimeInMillis()) {
            if (this.project.isHoliday(now)) {
                g.setColor(this.holidayBgColor);
                g.fillRect(offset, 0, this.getCellWidth(), drawableHeight - 1);
            }
            now.add(5, 1);
            offset += this.getCellWidth();
            if (now.get(7) != 2) continue;
            g.setColor(this.weekLineColor);
            g.drawLine(offset - 1, 0, offset - 1, drawableHeight - 1);
        }
        g.setColor(this.weekLineColor);
        g.drawLine(0, drawableHeight - 1, this.getWidth(), drawableHeight - 1);
    }

    private Rectangle getTaskRect(Task task) {
        if (task == null || !task.isDrawable()) {
            return null;
        }
        int row = this.project.getRowByTask(task);
        if (task == this.floatingTask) {
            row = this.targetRow;
        }
        int dateOffset = CalendarUtil.subDate(task.getStartDate(), this.taskLinePane.getChartFromDate());
        int period = task.getRealPeriod();
        int offsetY = row * this.getCellHeight();
        return new Rectangle(dateOffset * this.getCellWidth(), offsetY + this.getCellHeight() / 4, this.getCellWidth() * period, this.getCellHeight() / 2);
    }

    private Rectangle getTaskHitRect(Task task) {
        if (task == null || task.getStartDate() == null) {
            return null;
        }
        int row = this.project.getRowByTask(task);
        if (task == this.floatingTask) {
            row = this.targetRow;
        }
        int dateOffset = (int)((task.getStartDate().getTimeInMillis() - this.taskLinePane.getChartFromDate().getTimeInMillis()) / 86400000L);
        int period = task.getRealPeriod();
        int offsetY = row * this.getCellHeight();
        return new Rectangle(dateOffset * this.getCellWidth() - this.getCellWidth() / 3, offsetY + this.getCellHeight() / 4, this.getCellWidth() * period + this.getCellWidth() / 3 * 2, this.getCellHeight() / 2);
    }

    private void repaintProject() {
        if (this.app.getTaskListTable() != null) {
            this.app.getTaskListTable().repaint();
        }
        if (this.app.getTaskLineHeaderPane() != null) {
            this.app.getTaskLineHeaderPane().repaint();
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.dragOperation != 10 && this.autoScrollTimer == null) {
            this.autoScrollTimer = new Timer(true);
            this.autoScrollTimer.schedule((TimerTask)new AutoScrollHandler(), 25L, 25L);
        }
        if (this.dragOperation == 0) {
            return;
        }
        if (this.freeScrollUI.mouseDragged(e)) {
            return;
        }
        if (this.printRangeUI.mouseDragged(e)) {
            return;
        }
        if (this.taskUI.mouseDragged(e)) {
            return;
        }
        if (this.restrictionUI.mouseDragged(e)) {
            return;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.pressOperation == 0) {
            if (this.printRangeUI.mouseMoved(e)) {
                return;
            }
            if (this.taskUI.mouseMoved(e)) {
                return;
            }
            this.cursorState.setDefaultCursor();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.triggerPopup(e);
            return;
        }
        this.targetRow = -1;
        this.dragOperation = 0;
        this.dragStartPoint = e.getPoint();
        if (e.getButton() == 1) {
            int row = this.getRowAtPoint(e.getPoint());
            if (row >= this.project.getTaskTableModel().getRowCount()) {
                return;
            }
            if (this.freeScrollUI.mousePressed(e)) {
                return;
            }
            if (this.printRangeUI.mousePressed(e)) {
                return;
            }
            if (this.restrictionUI.mousePressed(e)) {
                return;
            }
            if (this.taskUI.mousePressed(e)) {
                return;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.autoScrollTimer != null) {
            this.autoScrollTimer.cancel();
            this.autoScrollTimer = null;
        }
        if (e.isPopupTrigger()) {
            this.triggerPopup(e);
        }
        if (e.getButton() == 1) {
            if (this.freeScrollUI.mouseReleased(e)) {
                return;
            }
            if (this.taskUI.mouseReleased(e)) {
                return;
            }
            if (this.restrictionUI.mouseReleased(e)) {
                return;
            }
            if (this.printRangeUI.mouseReleased(e)) {
                return;
            }
        }
    }

    private void triggerPopup(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.requestFocus();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private Calendar getCalendarAtPoint(Point p) {
        int offsetDate = p.x / this.getCellWidth();
        Calendar calendar = (Calendar)this.taskLinePane.getChartFromDate().clone();
        calendar.add(5, offsetDate);
        return calendar;
    }

    private Calendar getEarlyBusinessDayAtPoint(Point p) {
        Calendar calendar = this.getCalendarAtPoint(p);
        int i = 0;
        while (i < 365) {
            if (!this.app.getProject().isHoliday(calendar)) break;
            calendar.add(5, -1);
            ++i;
        }
        return calendar;
    }

    private Calendar getLateBusinessDayAtPoint(Point p) {
        Calendar calendar = this.getCalendarAtPoint(p);
        int i = 0;
        while (i < 365) {
            if (!this.app.getProject().isHoliday(calendar)) break;
            calendar.add(5, 1);
            ++i;
        }
        return calendar;
    }

    private int getBusinessDayCount(Calendar from, Calendar to) {
        Calendar calendar = (Calendar)from.clone();
        int businessDayCount = 0;
        while (calendar.before(to)) {
            if (!this.app.getProject().isHoliday(calendar)) {
                ++businessDayCount;
            }
            calendar.add(5, 1);
        }
        return businessDayCount;
    }

    protected Task getTaskAtPoint(Point p) {
        if (p == null) {
            return null;
        }
        int row = this.getRowAtPoint(p);
        Task task = this.project.getTaskAtRow(row);
        if (task == null) {
            return null;
        }
        Rectangle rect = this.getTaskHitRect(task);
        if (rect == null) {
            return null;
        }
        return rect.contains(p) ? task : null;
    }

    private int getRowAtPoint(Point point) {
        return point.y / this.getCellHeight();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 17 || e.getKeyCode() == 16) {
            if (e.isShiftDown() && e.isControlDown()) {
                this.cursorState.setCursor(0x7FFFFFFC);
                this.pressOperation = 6;
            } else if (e.isControlDown()) {
                this.cursorState.setCursor(0x7FFFFFFD);
                this.pressOperation = 5;
            }
        }
        this.freeScrollUI.keyPressed(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 17 || e.getKeyCode() == 16) {
            if (e.isControlDown()) {
                this.cursorState.setCursor(0x7FFFFFFD);
                this.pressOperation = 5;
            } else {
                this.cursorState.setDefaultCursor();
                this.pressOperation = 0;
            }
        }
        this.freeScrollUI.keyReleased(e);
    }

    class AutoScrollHandler
    extends TimerTask {
        public static final int SCROLL_INTERVAL = 25;
        public static final int EDGE_LENGTH = 32;

        AutoScrollHandler() {
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JScrollBar vbar;
                    int scrollLength;
                    JScrollBar hbar;
                    JViewport viewport = ((AutoScrollHandler)AutoScrollHandler.this).TaskLineDataPane.this.app.getTaskLineRootPane().getViewport();
                    Point absolutePoint = MouseInfo.getPointerInfo().getLocation();
                    Point vpePoint = viewport.getLocationOnScreen();
                    Point relativePoint = new Point(absolutePoint.x - vpePoint.x, absolutePoint.y - vpePoint.y);
                    if (relativePoint.x <= 32) {
                        hbar = ((AutoScrollHandler)AutoScrollHandler.this).TaskLineDataPane.this.app.getTaskLineRootPane().getHorizontalScrollBar();
                        scrollLength = (32 - relativePoint.x) / 3;
                        int hvalue = Math.max(0, hbar.getValue() - scrollLength);
                        hbar.setValue(hvalue);
                        AutoScrollHandler.this.fireMouseDragEvent();
                    } else if (relativePoint.x >= viewport.getWidth() - 32) {
                        hbar = ((AutoScrollHandler)AutoScrollHandler.this).TaskLineDataPane.this.app.getTaskLineRootPane().getHorizontalScrollBar();
                        scrollLength = (relativePoint.x - (viewport.getWidth() - 32)) / 3;
                        int hvalue = Math.min(hbar.getMaximum() - hbar.getVisibleAmount(), hbar.getValue() + scrollLength);
                        hbar.setValue(hvalue);
                        AutoScrollHandler.this.fireMouseDragEvent();
                    }
                    if (relativePoint.y <= 32) {
                        vbar = ((AutoScrollHandler)AutoScrollHandler.this).TaskLineDataPane.this.app.getTaskListRootPane().getVerticalScrollBar();
                        scrollLength = (32 - relativePoint.y) / 3;
                        vbar.setValue(vbar.getValue() - scrollLength);
                        AutoScrollHandler.this.fireMouseDragEvent();
                    } else if (relativePoint.y >= viewport.getHeight() - 32) {
                        vbar = ((AutoScrollHandler)AutoScrollHandler.this).TaskLineDataPane.this.app.getTaskListRootPane().getVerticalScrollBar();
                        scrollLength = (relativePoint.y - (viewport.getHeight() - 32)) / 3;
                        vbar.setValue(vbar.getValue() + scrollLength);
                        AutoScrollHandler.this.fireMouseDragEvent();
                    }
                }
            });
        }

        public void fireMouseDragEvent() {
            Point point = MouseInfo.getPointerInfo().getLocation();
            point.x -= TaskLineDataPane.this.getLocationOnScreen().x;
            point.y -= TaskLineDataPane.this.getLocationOnScreen().y;
            MouseEvent event = new MouseEvent(TaskLineDataPane.this, 506, 0L, 0, point.x, point.y, 0, false);
            TaskLineDataPane.this.processMouseMotionEvent(event);
        }
    }

    class FreeScrollUI {
        Point freeScrollStartPoint;

        FreeScrollUI() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 32 && TaskLineDataPane.this.pressOperation == 0) {
                TaskLineDataPane.this.cursorState.setCursor(12);
                TaskLineDataPane.this.pressOperation = 10;
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 32) {
                TaskLineDataPane.this.cursorState.setDefaultCursor();
                TaskLineDataPane.this.pressOperation = 0;
            }
        }

        public boolean mousePressed(MouseEvent e) {
            if (TaskLineDataPane.this.pressOperation == 10) {
                TaskLineDataPane.this.dragStartPoint = e.getLocationOnScreen();
                this.freeScrollStartPoint = new Point(TaskLineDataPane.this.app.getTaskLineRootPane().getHorizontalScrollBar().getValue(), TaskLineDataPane.this.app.getTaskListRootPane().getVerticalScrollBar().getValue());
                TaskLineDataPane.this.dragOperation = 10;
                return true;
            }
            return false;
        }

        public boolean mouseDragged(MouseEvent e) {
            if (TaskLineDataPane.this.dragOperation == 10) {
                Point pressPoint = e.getLocationOnScreen();
                Dimension moveDistance = new Dimension(pressPoint.x - TaskLineDataPane.this.dragStartPoint.x, pressPoint.y - TaskLineDataPane.this.dragStartPoint.y);
                JScrollBar vbar = TaskLineDataPane.this.app.getTaskListRootPane().getVerticalScrollBar();
                JScrollBar hbar = TaskLineDataPane.this.app.getTaskLineRootPane().getHorizontalScrollBar();
                int vvalue = this.freeScrollStartPoint.y - moveDistance.height;
                int hvalue = this.freeScrollStartPoint.x - moveDistance.width;
                hvalue = Math.min(hbar.getMaximum() - hbar.getVisibleAmount() - 1, Math.max(1, hvalue));
                vbar.setValue(vvalue);
                hbar.setValue(hvalue);
                return true;
            }
            return false;
        }

        public boolean mouseReleased(MouseEvent e) {
            if (TaskLineDataPane.this.dragOperation == 10) {
                TaskLineDataPane.this.dragOperation = 0;
                return true;
            }
            return false;
        }
    }

    public class PrintRangeUI {
        Color printRangeFirstColor = new Color(240, 80, 80);
        Color printRangeColor = new Color(240, 160, 160);
        Color floatingPrintRangeColor = Color.black;

        public void drawPrintRange(Graphics g) {
            if (!TaskLineDataPane.this.printRangeMode) {
                return;
            }
            List<Rectangle> ranges = this.getPrintRanges();
            int page = ranges.size();
            Collections.reverse(ranges);
            for (Rectangle r : ranges) {
                this.drawPrintRange(g, page, r, false);
                --page;
            }
            if (TaskLineDataPane.this.floatingPrintCellSize != null) {
                this.drawPrintRange(g, 1, this.getFirstPrintRange(TaskLineDataPane.this.floatingPrintCellSize), true);
            }
        }

        protected void drawPrintRange(Graphics g, int page, Rectangle r, boolean floating) {
            Color printRangeColor = this.printRangeColor;
            if (page == 1) {
                printRangeColor = this.printRangeFirstColor;
            }
            if (floating) {
                printRangeColor = this.floatingPrintRangeColor;
            }
            g.setColor(printRangeColor);
            g.drawRect(r.x, r.y, r.width, r.height);
            g.drawRect(r.x + 1, r.y + 1, r.width - 2, r.height - 2);
            g.drawRect(r.x - 1, r.y - 1, r.width + 2, r.height + 2);
            Font oldFont = g.getFont();
            Font newFont = new Font(oldFont.getFontName(), 1, 32);
            g.setFont(newFont);
            String str = String.valueOf(Resource.get("chartPage")) + page;
            Shape oldClip = g.getClip();
            g.clipRect(r.x, r.y, r.width, r.height);
            GraphicsUtil.drawStringCenter(g, str, r.x, r.y, r.width, r.height);
            g.setClip(oldClip);
            g.setFont(oldFont);
        }

        public boolean mousePressed(MouseEvent e) {
            int printRangeOperation = this.getOperation(e);
            if (printRangeOperation == 0) {
                return false;
            }
            TaskLineDataPane.this.floatingPrintCellSize = (Dimension)TaskLineDataPane.this.project.getPrint().getPrintCellSize().clone();
            TaskLineDataPane.this.dragOperation = printRangeOperation;
            return true;
        }

        public boolean mouseMoved(MouseEvent e) {
            int operation = this.getOperation(e);
            switch (operation) {
                case 9: {
                    TaskLineDataPane.this.cursorState.setCursor(5);
                    return true;
                }
                case 7: {
                    TaskLineDataPane.this.cursorState.setCursor(11);
                    return true;
                }
                case 8: {
                    TaskLineDataPane.this.cursorState.setCursor(9);
                    return true;
                }
            }
            return false;
        }

        public boolean mouseDragged(MouseEvent e) {
            if (TaskLineDataPane.this.dragOperation == 7) {
                Rectangle rect = this.getFirstPrintRange(TaskLineDataPane.this.floatingPrintCellSize);
                if (rect == null) {
                    return false;
                }
                TaskLineDataPane.this.floatingPrintCellSize.width = Math.max(10, (e.getX() - rect.x) / TaskLineDataPane.this.getCellWidth());
                TaskLineDataPane.this.repaintProject();
                return true;
            }
            if (TaskLineDataPane.this.dragOperation == 8) {
                Rectangle rect = this.getFirstPrintRange(TaskLineDataPane.this.floatingPrintCellSize);
                if (rect == null) {
                    return false;
                }
                int pointY = Math.min(e.getY(), TaskLineDataPane.this.project.getTaskTableModel().getRowCount() * TaskLineDataPane.this.getCellHeight());
                TaskLineDataPane.this.floatingPrintCellSize.height = Math.max(10, (pointY - rect.y) / TaskLineDataPane.this.getCellHeight());
                TaskLineDataPane.this.repaintProject();
                return true;
            }
            if (TaskLineDataPane.this.dragOperation == 9) {
                Rectangle rect = this.getFirstPrintRange(TaskLineDataPane.this.floatingPrintCellSize);
                if (rect == null) {
                    return false;
                }
                int pointY = Math.min(e.getY(), TaskLineDataPane.this.project.getTaskTableModel().getRowCount() * TaskLineDataPane.this.getCellHeight());
                TaskLineDataPane.this.floatingPrintCellSize.width = Math.max(10, (e.getX() - rect.x) / TaskLineDataPane.this.getCellWidth());
                TaskLineDataPane.this.floatingPrintCellSize.height = Math.max(10, (pointY - rect.y) / TaskLineDataPane.this.getCellHeight());
                TaskLineDataPane.this.repaintProject();
                return true;
            }
            return false;
        }

        public boolean mouseReleased(MouseEvent e) {
            if (TaskLineDataPane.this.dragOperation == 7 || TaskLineDataPane.this.dragOperation == 8 || TaskLineDataPane.this.dragOperation == 9) {
                TaskLineDataPane.this.project.getController().setPrintCellSize(TaskLineDataPane.this.floatingPrintCellSize);
                TaskLineDataPane.this.floatingPrintCellSize = null;
                TaskLineDataPane.this.repaintProject();
                TaskLineDataPane.this.dragOperation = 0;
                return true;
            }
            return false;
        }

        public int getOperation(MouseEvent e) {
            if (!TaskLineDataPane.this.printRangeMode) {
                return 0;
            }
            Rectangle rect = this.getFirstPrintRange();
            if (rect != null && e.getX() >= rect.x + rect.width - TaskLineDataPane.this.getCellWidth() / 2 && e.getX() < rect.x + rect.width && e.getY() >= rect.y + rect.height - TaskLineDataPane.this.getCellHeight() / 2 && e.getY() < rect.y + rect.height) {
                return 9;
            }
            if (rect != null && e.getX() >= rect.x + rect.width - TaskLineDataPane.this.getCellWidth() / 2 && e.getX() < rect.x + rect.width && e.getY() >= rect.y && e.getY() < rect.y + rect.height - TaskLineDataPane.this.getCellHeight() / 2) {
                return 7;
            }
            if (rect != null && e.getX() >= rect.x && e.getX() < rect.x + rect.width - TaskLineDataPane.this.getCellWidth() / 2 && e.getY() >= rect.y + rect.height - TaskLineDataPane.this.getCellHeight() / 2 && e.getY() < rect.y + rect.height) {
                return 8;
            }
            return 0;
        }

        public Rectangle getFirstPrintRange() {
            Calendar dataRangeFirstDate = TaskLineDataPane.this.project.getFirstDate();
            if (dataRangeFirstDate == null) {
                return null;
            }
            return this.getFirstPrintRange(TaskLineDataPane.this.project.getPrint().getPrintCellSize());
        }

        public Rectangle getFirstPrintRange(Dimension printCellSize) {
            Calendar dataRangeFirstDate = TaskLineDataPane.this.project.getFirstDate();
            if (dataRangeFirstDate == null) {
                return null;
            }
            Calendar printRangeFirstDate = dataRangeFirstDate;
            printRangeFirstDate.add(5, -1);
            int offsetX = CalendarUtil.subDate(printRangeFirstDate, TaskLineDataPane.this.taskLinePane.getChartFromDate()) * TaskLineDataPane.this.getCellWidth();
            return new Rectangle(offsetX, 0, printCellSize.width * TaskLineDataPane.this.getCellWidth(), printCellSize.height * TaskLineDataPane.this.getCellHeight());
        }

        public List<Rectangle> getPrintRanges() {
            ArrayList<Rectangle> result = new ArrayList<Rectangle>();
            Calendar dataRangeFirstDate = TaskLineDataPane.this.project.getFirstDate();
            int dataRangePeriod = TaskLineDataPane.this.project.getWholePeriod();
            int rowCount = TaskLineDataPane.this.project.getRowCount();
            if (dataRangeFirstDate == null) {
                return result;
            }
            Calendar printRangeFirstDate = dataRangeFirstDate;
            printRangeFirstDate.add(5, -1);
            int printRangePeriod = dataRangePeriod + 2;
            int offsetX = CalendarUtil.subDate(printRangeFirstDate, TaskLineDataPane.this.taskLinePane.getChartFromDate()) * TaskLineDataPane.this.getCellWidth();
            Dimension printCellSize = TaskLineDataPane.this.project.getPrint().getPrintCellSize();
            int cursorY = 0;
            while (cursorY < rowCount) {
                int cursorX = 0;
                while (cursorX < printRangePeriod) {
                    Rectangle r = new Rectangle(offsetX + cursorX * TaskLineDataPane.this.getCellWidth(), cursorY * TaskLineDataPane.this.getCellHeight(), printCellSize.width * TaskLineDataPane.this.getCellWidth(), printCellSize.height * TaskLineDataPane.this.getCellHeight());
                    result.add(r);
                    cursorX += printCellSize.width;
                }
                cursorY += printCellSize.height;
            }
            return result;
        }
    }

    class ProgressLineUI {
        ProgressLineUI() {
        }

        public void drawProgressLine(Graphics g) {
            if (!TaskLineDataPane.this.progressLineMode) {
                return;
            }
            Calendar now = CalendarUtil.toDateCalendar(Calendar.getInstance());
            this.drawProgressLine(g, CalendarUtil.toDateCalendar(now));
        }

        public void drawProgressLine(Graphics g, Calendar now) {
            if (!TaskLineDataPane.this.progressLineMode) {
                return;
            }
            if (!(g instanceof Graphics)) {
                return;
            }
            Graphics2D g2d = (Graphics2D)g;
            int dateOffset = CalendarUtil.subDate(now, TaskLineDataPane.this.taskLinePane.getChartFromDate());
            int drawableHeight = TaskLineDataPane.this.project.getTaskTableModel().getRowCount() * TaskLineDataPane.this.getCellHeight();
            Path2D.Float path = new Path2D.Float();
            path.moveTo((double)(dateOffset * TaskLineDataPane.this.getCellWidth()), 0.75);
            int row = 0;
            while (row < TaskLineDataPane.this.project.getRowCount()) {
                Point2D.Float progressPoint;
                path.lineTo(dateOffset * TaskLineDataPane.this.getCellWidth(), row * TaskLineDataPane.this.getCellHeight());
                Task task = TaskLineDataPane.this.project.getTaskAtRow(row);
                if (!(task != null && task.getStartDate() != null && CalendarUtil.subDate(task.getStartDate(), now) > 0 && task.getCompletion() == 0 || task != null && task.getEndDate() != null && CalendarUtil.subDate(now, task.getEndDate()) > 0 && task.getCompletion() == 100 || (progressPoint = this.getProgressPoint(task, row)) == null)) {
                    path.lineTo(progressPoint.x, progressPoint.y);
                }
                path.lineTo(dateOffset * TaskLineDataPane.this.getCellWidth(), (row + 1) * TaskLineDataPane.this.getCellHeight());
                ++row;
            }
            path.lineTo((double)(dateOffset * TaskLineDataPane.this.getCellWidth()), (double)drawableHeight - 0.75);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(TaskLineDataPane.this.progressLineColor);
            g2d.setStroke(new BasicStroke(1.5f, 2, 0));
            g2d.draw(path);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }

        private Point2D.Float getProgressPoint(Task task, int row) {
            Rectangle rect = TaskLineDataPane.this.getTaskRect(task);
            if (rect == null) {
                return null;
            }
            int pointY = row * TaskLineDataPane.this.getCellHeight() + TaskLineDataPane.this.getCellHeight() / 2;
            int pointX = rect.x + rect.width * task.getCompletion() / 100;
            return new Point2D.Float(pointX, pointY);
        }
    }

    class Restriction {
        Task srcTask;
        Task destTask;

        public Restriction(Task src, Task dest) {
            this.srcTask = src;
            this.destTask = dest;
        }

        public Task getSrcTask() {
            return this.srcTask;
        }

        public void setSrcTask(Task srcTask) {
            this.srcTask = srcTask;
        }

        public Task getDestTask() {
            return this.destTask;
        }

        public void setDestTask(Task destTask) {
            this.destTask = destTask;
        }
    }

    public class RestrictionUI {
        public boolean mousePressed(MouseEvent e) {
            if (TaskLineDataPane.this.pressOperation == 5 || TaskLineDataPane.this.pressOperation == 6) {
                Task task = TaskLineDataPane.this.getTaskAtPoint(e.getPoint());
                if (task == null) {
                    return true;
                }
                if (TaskLineDataPane.this.pressOperation == 5) {
                    TaskLineDataPane.this.targetRow = TaskLineDataPane.this.project.getRowByTask(task);
                    TaskLineDataPane.this.floatingRestriction = new Restriction(task, null);
                    TaskLineDataPane.this.dragOperation = 5;
                    return true;
                }
                if (TaskLineDataPane.this.pressOperation == 6) {
                    this.removeRestriction(e);
                    return true;
                }
                return true;
            }
            return false;
        }

        public boolean mouseDragged(MouseEvent e) {
            if (TaskLineDataPane.this.dragOperation != 5) {
                return false;
            }
            Task dest = TaskLineDataPane.this.getTaskAtPoint(e.getPoint());
            TaskLineDataPane.this.floatingRestriction.setDestTask(dest);
            TaskLineDataPane.this.repaint();
            return true;
        }

        public boolean mouseReleased(MouseEvent e) {
            if (TaskLineDataPane.this.dragOperation != 5) {
                return false;
            }
            this.addRestriction(e);
            TaskLineDataPane.this.dragOperation = 0;
            return true;
        }

        private void addRestriction(MouseEvent e) {
            TaskLineDataPane.this.floatingRestriction = null;
            Task detTask = TaskLineDataPane.this.getTaskAtPoint(e.getPoint());
            if (detTask == null) {
                return;
            }
            CompoundEdit compound = new CompoundEdit();
            TaskLineDataPane.this.project.getUndoManager().addEdit(compound);
            try {
                TaskLineDataPane.this.project.getController().addRestriction(TaskLineDataPane.this.project.getTaskAtRow(TaskLineDataPane.this.targetRow), detTask);
                TaskLineDataPane.this.project.update();
            }
            finally {
                compound.end();
                TaskLineDataPane.this.repaintProject();
            }
        }

        private void removeRestriction(MouseEvent e) {
            Task task = TaskLineDataPane.this.getTaskAtPoint(e.getPoint());
            if (task == null) {
                return;
            }
            Rectangle rect = TaskLineDataPane.this.getTaskRect(task);
            if (rect == null) {
                return;
            }
            CompoundEdit compound = new CompoundEdit();
            TaskLineDataPane.this.project.getUndoManager().addEdit(compound);
            try {
                if (e.getX() < rect.x + rect.width / 2) {
                    TaskLineDataPane.this.project.getController().removeDestRestrictions(task);
                    TaskLineDataPane.this.repaintProject();
                } else {
                    TaskLineDataPane.this.project.getController().removeSrcRestrictions(task);
                    TaskLineDataPane.this.repaintProject();
                }
                TaskLineDataPane.this.project.update();
            }
            finally {
                compound.end();
            }
        }

        private void drawRestriction(Graphics g, Restriction restriction, boolean floating) {
            if (restriction == null || restriction.getSrcTask() == null || restriction.getDestTask() == null) {
                return;
            }
            this.drawRestriction(g, restriction.getSrcTask(), restriction.getDestTask(), floating);
        }

        private void drawRestriction(Graphics g, Task src, Task dest, boolean floating) {
            long toTime;
            long fromTime;
            int half = TaskLineDataPane.this.getCellHeight() / 2;
            int quarter = TaskLineDataPane.this.getCellHeight() / 4;
            Rectangle fromRect = TaskLineDataPane.this.getTaskRect(src);
            Rectangle toRect = TaskLineDataPane.this.getTaskRect(dest);
            if (src == dest || src.getStartDate() == null || src.getRealPeriod() == null || dest.getStartDate() == null) {
                return;
            }
            Color restrictionColor = TaskLineDataPane.this.restrictionColor;
            if (src.isCriticalPath() && dest.isCriticalPath()) {
                restrictionColor = TaskLineDataPane.this.criticalPathRestrictionColor;
            }
            if (floating) {
                restrictionColor = TaskLineDataPane.this.floatingRestrictionColor;
            }
            if ((fromTime = src.getStartDate().getTimeInMillis() + src.getRealPeriod().longValue() * 86400000L) >= (toTime = dest.getStartDate().getTimeInMillis())) {
                if (TaskLineDataPane.this.project.getRowByTask(src) < TaskLineDataPane.this.project.getRowByTask(dest)) {
                    Point startingPoint = new Point(fromRect.x + fromRect.width, fromRect.y + fromRect.height / 2);
                    Point endPoint = new Point(toRect.x + quarter, toRect.y);
                    if (src.isMilestone()) {
                        startingPoint.x -= fromRect.width;
                    }
                    if (dest.isMilestone()) {
                        endPoint.x -= quarter;
                    }
                    g.setColor(restrictionColor);
                    g.drawPolyline(new int[]{startingPoint.x, startingPoint.x + quarter, startingPoint.x + quarter, endPoint.x, endPoint.x}, new int[]{startingPoint.y, startingPoint.y, startingPoint.y + half, startingPoint.y + half, endPoint.y}, 5);
                    g.fillPolygon(new int[]{endPoint.x, endPoint.x - quarter, endPoint.x + quarter}, new int[]{endPoint.y, endPoint.y - quarter, endPoint.y - quarter}, 3);
                } else {
                    Point startingPoint = new Point(fromRect.x + fromRect.width, fromRect.y + fromRect.height / 2);
                    Point endPoint = new Point(toRect.x + quarter, toRect.y + toRect.height);
                    if (src.isMilestone()) {
                        startingPoint.x -= fromRect.width;
                    }
                    if (dest.isMilestone()) {
                        endPoint.x -= quarter;
                    }
                    g.setColor(restrictionColor);
                    g.drawPolyline(new int[]{startingPoint.x, startingPoint.x + quarter, startingPoint.x + quarter, endPoint.x, endPoint.x}, new int[]{startingPoint.y, startingPoint.y, startingPoint.y - half, startingPoint.y - half, endPoint.y}, 5);
                    g.fillPolygon(new int[]{endPoint.x, endPoint.x - quarter - 1, endPoint.x + quarter + 1}, new int[]{endPoint.y, endPoint.y + quarter + 1, endPoint.y + quarter + 1}, 3);
                }
            } else {
                Point startingPoint = new Point(fromRect.x + fromRect.width, fromRect.y + fromRect.height / 2);
                Point endPoint = new Point(toRect.x, toRect.y + fromRect.height / 2);
                if (src.isMilestone()) {
                    startingPoint.x -= fromRect.width;
                }
                if (dest.isMilestone()) {
                    endPoint.x -= quarter;
                }
                g.setColor(restrictionColor);
                g.drawPolyline(new int[]{startingPoint.x, startingPoint.x + quarter, startingPoint.x + quarter, endPoint.x}, new int[]{startingPoint.y, startingPoint.y, endPoint.y, endPoint.y}, 4);
                g.fillPolygon(new int[]{endPoint.x, endPoint.x - quarter, endPoint.x - quarter}, new int[]{endPoint.y, endPoint.y + quarter, endPoint.y - quarter}, 3);
            }
        }

        private void drawRestrictions(Graphics g) {
            List<Task> visibleTasks = TaskLineDataPane.this.project.getVisibleTasks();
            for (Task from : visibleTasks) {
                List<Task> visibleRestrictions = from.getVisibleRestrictions();
                for (Task to : visibleRestrictions) {
                    this.drawRestriction(g, from, to, false);
                }
            }
            this.drawRestriction(g, TaskLineDataPane.this.floatingRestriction, true);
        }
    }

    public class TaskUI {
        public boolean mousePressed(MouseEvent e) {
            Pair<Integer, Task> operation = this.getOperation(e);
            if (operation.getFirst() == 0) {
                TaskLineDataPane.this.targetRow = TaskLineDataPane.this.getRowAtPoint(e.getPoint());
                TaskLineDataPane.this.dragOperation = operation.getFirst();
                return false;
            }
            if (operation.getFirst() == 1) {
                TaskLineDataPane.this.floatingTask = this.createTaskOperation(e);
                TaskLineDataPane.this.targetRow = TaskLineDataPane.this.getRowAtPoint(e.getPoint());
                TaskLineDataPane.this.dragOperation = 3;
            } else {
                TaskLineDataPane.this.targetRow = TaskLineDataPane.this.getRowAtPoint(e.getPoint());
                TaskLineDataPane.this.dragOperation = operation.getFirst();
                TaskLineDataPane.this.floatingTask = TaskLineDataPane.this.project.getTaskAtRow(TaskLineDataPane.this.targetRow).clone();
            }
            return true;
        }

        public boolean mouseMoved(MouseEvent e) {
            Pair<Integer, Task> operation = this.getOperation(e);
            switch (operation.getFirst()) {
                case 2: {
                    TaskLineDataPane.this.cursorState.setCursor(11);
                    return true;
                }
                case 4: {
                    TaskLineDataPane.this.cursorState.setCursor(0x7FFFFFFB);
                    return true;
                }
                case 3: {
                    TaskLineDataPane.this.cursorState.setCursor(11);
                    return true;
                }
            }
            return false;
        }

        public boolean mouseDragged(MouseEvent e) {
            if (TaskLineDataPane.this.dragOperation == 2) {
                TaskLineDataPane.this.floatingTask.setStartDate(TaskLineDataPane.this.getLateBusinessDayAtPoint(e.getPoint()));
                TaskLineDataPane.this.project.updateChildrenPeriod(TaskLineDataPane.this.floatingTask, true);
                TaskLineDataPane.this.repaint();
                return true;
            }
            if (TaskLineDataPane.this.dragOperation == 3) {
                Calendar toCalendar = TaskLineDataPane.this.getLateBusinessDayAtPoint(e.getPoint());
                int count = TaskLineDataPane.this.getBusinessDayCount(TaskLineDataPane.this.floatingTask.getStartDate(), toCalendar);
                TaskLineDataPane.this.floatingTask.setPeriod(count);
                TaskLineDataPane.this.project.updateChildrenPeriod(TaskLineDataPane.this.floatingTask, true);
                TaskLineDataPane.this.repaint();
                return true;
            }
            if (TaskLineDataPane.this.dragOperation == 4) {
                int offset = e.getX();
                Rectangle rect = TaskLineDataPane.this.getTaskRect(TaskLineDataPane.this.project.getTaskAtRow(TaskLineDataPane.this.targetRow));
                int completion = (offset - rect.x) * 100 / rect.width / 5 * 5;
                completion = Math.min(Math.max(completion, 0), 100);
                TaskLineDataPane.this.floatingTask.setCompletion(completion);
                TaskLineDataPane.this.repaint();
                return true;
            }
            return false;
        }

        public boolean mouseReleased(MouseEvent e) {
            if (TaskLineDataPane.this.dragOperation != 2 && TaskLineDataPane.this.dragOperation != 3 && TaskLineDataPane.this.dragOperation != 4) {
                return false;
            }
            if (TaskLineDataPane.this.dragOperation == 2) {
                TaskLineDataPane.this.floatingTask.setStartDate(TaskLineDataPane.this.getLateBusinessDayAtPoint(e.getPoint()));
            } else if (TaskLineDataPane.this.dragOperation == 3) {
                Calendar toCalendar = TaskLineDataPane.this.getLateBusinessDayAtPoint(e.getPoint());
                int count = TaskLineDataPane.this.getBusinessDayCount(TaskLineDataPane.this.floatingTask.getStartDate(), toCalendar);
                TaskLineDataPane.this.floatingTask.setStartDate(TaskLineDataPane.this.floatingTask.getStartDate());
                TaskLineDataPane.this.floatingTask.setPeriod(count);
            } else if (TaskLineDataPane.this.dragOperation == 4) {
                int offset = e.getX();
                Rectangle rect = TaskLineDataPane.this.getTaskRect(TaskLineDataPane.this.project.getTaskAtRow(TaskLineDataPane.this.targetRow));
                int completion = (offset - rect.x) * 100 / rect.width / 5 * 5;
                completion = Math.min(Math.max(completion, 0), 100);
                TaskLineDataPane.this.floatingTask.setCompletion(completion);
            }
            CompoundEdit compound = new CompoundEdit();
            TaskLineDataPane.this.project.getUndoManager().addEdit(compound);
            try {
                TaskLineDataPane.this.project.getController().setTaskAtIndex(TaskLineDataPane.this.floatingTask, TaskLineDataPane.this.project.getIndexFromRow(TaskLineDataPane.this.targetRow));
                TaskLineDataPane.this.project.update();
            }
            finally {
                compound.end();
                TaskLineDataPane.this.project.getTaskTableModel().fireTableChanged();
            }
            TaskLineDataPane.this.dragOperation = 0;
            TaskLineDataPane.this.floatingTask = null;
            TaskLineDataPane.this.repaintProject();
            return true;
        }

        public Pair<Integer, Task> getOperation(MouseEvent e) {
            int row = TaskLineDataPane.this.getRowAtPoint(e.getPoint());
            Task task = TaskLineDataPane.this.project.getTaskAtRow(row);
            if (task != null && task.isGroup()) {
                return new Pair<Integer, Object>(0, null);
            }
            if (task == null || task.getStartDate() == null) {
                return new Pair<Integer, Object>(1, null);
            }
            Rectangle rect = TaskLineDataPane.this.getTaskHitRect(task);
            int margin = TaskLineDataPane.this.getCellWidth() / 3 * 2;
            if (task.isMilestone()) {
                rect.x -= margin / 2;
                rect.width += margin;
            }
            int left = rect.x;
            int right = rect.x + rect.width;
            if (rect.contains(e.getPoint())) {
                if (e.getPoint().x < left + margin) {
                    return new Pair<Integer, Task>(2, task);
                }
                if (e.getPoint().x >= right - margin) {
                    return new Pair<Integer, Task>(3, task);
                }
                return new Pair<Integer, Task>(4, task);
            }
            return new Pair<Integer, Object>(0, null);
        }

        public Task createTaskOperation(MouseEvent e) {
            int row = TaskLineDataPane.this.getRowAtPoint(e.getPoint());
            Task task = TaskLineDataPane.this.project.getTaskAtRow(row);
            if (task == null) {
                task = new Task();
                task.setName(Resource.get("projectNewTaskName"));
            }
            task.setStartDate(TaskLineDataPane.this.getEarlyBusinessDayAtPoint(e.getPoint()));
            task.setPeriod(0);
            task.setRealPeriod(0);
            return task;
        }

        private void drawTasks(Graphics g) {
            List<Task> visibleTasks = TaskLineDataPane.this.project.getVisibleTasks();
            for (Task task : visibleTasks) {
                this.drawTask(g, task);
            }
            if (TaskLineDataPane.this.floatingTask != null) {
                if (TaskLineDataPane.this.floatingTask.isMilestone()) {
                    this.drawMilestone(g, TaskLineDataPane.this.floatingTask, true);
                } else {
                    this.drawBasicTask(g, TaskLineDataPane.this.floatingTask, true);
                }
            }
        }

        private void drawTask(Graphics g, Task task) {
            if (task == null) {
                return;
            }
            if (task.isMilestone()) {
                this.drawMilestone(g, task, false);
            } else if (task.isGroup()) {
                this.drawParentTask(g, task);
            } else {
                this.drawBasicTask(g, task, false);
            }
        }

        private void drawMilestone(Graphics g, Task task, boolean floating) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            if (task == null) {
                return;
            }
            Rectangle rect = TaskLineDataPane.this.getTaskRect(task);
            if (rect == null) {
                return;
            }
            Color groupColor = TaskLineDataPane.this.groupColor;
            if (floating) {
                groupColor = TaskLineDataPane.this.floatingMilestoneColor;
            }
            if (task.isCriticalPath()) {
                groupColor = TaskLineDataPane.this.criticalPathBorderColor;
            }
            g.setColor(groupColor);
            int half = rect.height / 2;
            Polygon polygon = new Polygon(new int[]{rect.x, rect.x - half, rect.x, rect.x + half}, new int[]{rect.y, rect.y + half, rect.y + rect.height, rect.y + half}, 4);
            g.fillPolygon(polygon);
        }

        private void drawParentTask(Graphics g, Task task) {
            if (task == null) {
                return;
            }
            Rectangle rect = TaskLineDataPane.this.getTaskRect(task);
            if (rect == null) {
                return;
            }
            g.setColor(TaskLineDataPane.this.groupColor);
            int half = rect.height * 2 / 3;
            Polygon polygon = new Polygon(new int[]{rect.x, rect.x, rect.x + half, rect.x + rect.width - half, rect.x + rect.width, rect.x + rect.width, rect.x + rect.width}, new int[]{rect.y, rect.y + rect.height, rect.y + rect.height - half, rect.y + rect.height - half, rect.y + rect.height, rect.y}, 6);
            g.fillPolygon(polygon);
        }

        private void drawBasicTask(Graphics g, Task task, boolean floating) {
            if (task == null) {
                return;
            }
            Rectangle rect = TaskLineDataPane.this.getTaskRect(task);
            if (rect == null) {
                return;
            }
            Color borderColor = TaskLineDataPane.this.borderColor;
            Color fillColor = TaskLineDataPane.this.fillColor;
            Color completionColor = TaskLineDataPane.this.completionColor;
            if (task.isCriticalPath()) {
                borderColor = TaskLineDataPane.this.criticalPathBorderColor;
                fillColor = TaskLineDataPane.this.criticalPathFillColor;
                completionColor = TaskLineDataPane.this.criticalPathCompletionColor;
            }
            if (floating) {
                borderColor = TaskLineDataPane.this.floatingBorderColor;
                fillColor = TaskLineDataPane.this.floatingFillColor;
                completionColor = TaskLineDataPane.this.floatingCompletionColor;
            }
            g.setColor(fillColor);
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            if (task.getCompletion() > 0) {
                g.setColor(completionColor);
                g.fillRect(rect.x, rect.y, rect.width * task.getCompletion() / 100, rect.height);
            }
            if (TaskLineDataPane.this.project.getRowByTask(task) != TaskLineDataPane.this.targetRow || TaskLineDataPane.this.dragOperation != 4) {
                StringBuilder builder = new StringBuilder();
                if (task.getMember() != null) {
                    builder.append(String.valueOf(task.getMember().getName()) + " ");
                }
                if (task.getCompletion() > 0) {
                    MessageFormat format = new MessageFormat("[{0}%]");
                    builder.append(format.format(new Object[]{task.getCompletion()}));
                }
                if (builder.length() > 0) {
                    g.setColor(TaskLineDataPane.this.fontColor);
                    GraphicsUtil.drawStringLeft(g, builder.toString(), rect.x + rect.width + TaskLineDataPane.this.getCellWidth() / 2, rect.y - TaskLineDataPane.this.getCellHeight() / 4, 1, TaskLineDataPane.this.getCellHeight());
                }
            }
            g.setColor(borderColor);
            GraphicsUtil.drawRect(g, rect.x, rect.y, rect.width - 1, rect.height - 1);
        }
    }
}

