/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.undo.CompoundEdit;
import jp.sourceforge.freegantt.data.Column;
import jp.sourceforge.freegantt.data.Member;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;
import jp.sourceforge.freegantt.data.model.ProjectViewChangedListener;
import jp.sourceforge.freegantt.data.model.TaskListTableModel;
import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.swing.NumberCellRenderer;
import jp.sourceforge.freegantt.swing.TaskLineDataPane;
import jp.sourceforge.freegantt.swing.TaskMemberCellEditor;
import jp.sourceforge.freegantt.swing.TaskMemberCellRenderer;
import jp.sourceforge.freegantt.swing.TaskNameCellRenderer;

public class TaskListTable
extends JTable
implements MouseListener {
    private static final long serialVersionUID = -2059641956588584594L;
    Application app;
    Project project;
    TaskListTableModel tableModel;
    TaskNameCellRenderer taskNameCellRenderer;
    NumberCellRenderer numberCellRenderer;
    boolean initialized = false;
    Color borderColor = new Color(192, 192, 192);

    public TaskListTableModel getTaskListTableModel() {
        return this.tableModel;
    }

    public TaskListTable(Application app) {
        this.app = app;
        this.project = app.getProject();
        this.taskNameCellRenderer = new TaskNameCellRenderer(this.project);
        this.numberCellRenderer = new NumberCellRenderer();
        HeaderSwitchMouseHandler headerSwitchMouseHandler = new HeaderSwitchMouseHandler();
        this.getTableHeader().addMouseListener(new HeaderPopupMouseListener());
        this.getTableHeader().addMouseListener(headerSwitchMouseHandler);
        this.getTableHeader().addMouseMotionListener(headerSwitchMouseHandler);
        this.project.getProjectViewModel().addProjectViewChangedListener(new ProjectViewChangedHandler());
        this.setGridColor(this.borderColor);
        this.setAutoResizeMode(4);
        this.addMouseListener(this);
        this.registerKeyboardAction(new RemoveAction(), KeyStroke.getKeyStroke(127, 0), 0);
        this.registerKeyboardAction(new InsertAction(), KeyStroke.getKeyStroke(155, 0), 0);
        this.registerKeyboardAction(app.getMenu().getCutAction(), KeyStroke.getKeyStroke(88, 128), 0);
        this.registerKeyboardAction(app.getMenu().getCopyAction(), KeyStroke.getKeyStroke(67, 128), 0);
        this.registerKeyboardAction(app.getMenu().getPasteAction(), KeyStroke.getKeyStroke(86, 128), 0);
        this.registerKeyboardAction(app.getMenu().getUndoAction(), KeyStroke.getKeyStroke(90, 128), 0);
        this.registerKeyboardAction(app.getMenu().getRedoAction(), KeyStroke.getKeyStroke(89, 128), 0);
        this.tableModel = this.project.getTaskTableModel();
        this.setModel(this.tableModel);
        TableColumnModel columnModel = this.getColumnModel();
        String[] columnKeys = this.tableModel.getColumnKeys();
        int i = 0;
        while (i < columnKeys.length) {
            TableColumn column = columnModel.getColumn(i);
            column.setIdentifier(columnKeys[i]);
            column.setMinWidth(0);
            ++i;
        }
        this.updateColumnArrangement();
        columnModel.getColumn(2).setCellRenderer(new TaskMemberCellRenderer());
        columnModel.getColumn(2).setCellEditor(new DefaultCellEditor(new TaskMemberCellEditor(this.project)));
        columnModel.getColumn(0).setCellRenderer(this.getTableHeader().getDefaultRenderer());
        columnModel.getColumn(0).setMaxWidth(30);
        columnModel.getColumn(0).setMinWidth(30);
        columnModel.getColumn(1).setCellRenderer(this.taskNameCellRenderer);
        columnModel.getColumn(3).setCellRenderer(this.numberCellRenderer);
        columnModel.getColumn(4).setCellRenderer(this.numberCellRenderer);
        this.initialized = true;
    }

    private void updateColumnArrangement() {
        List<Column> columns = this.project.getView().getColumns();
        int index = 1;
        for (Column column : columns) {
            this.getColumnModel().moveColumn(this.getColumnModel().getColumnIndex(column.getKey()), index);
            TableColumn tableColumn = this.getColumn(column.getKey());
            tableColumn.setPreferredWidth(column.getWidth());
            tableColumn.setWidth(column.getWidth());
            ++index;
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (this.app == null) {
            return;
        }
        TaskLineDataPane taskLineDataPane = this.app.getTaskLineDataPane();
        if (taskLineDataPane != null) {
            taskLineDataPane.setSize(new Dimension(taskLineDataPane.getWidth(), this.getTaskListTableModel().getRowCount() * 16));
            taskLineDataPane.setPreferredSize(new Dimension(taskLineDataPane.getWidth(), this.getTaskListTableModel().getRowCount() * 16));
            System.out.println("DataPane setPreferredSize: " + taskLineDataPane.getWidth() + "," + this.getTaskListTableModel().getRowCount() * 16);
        }
        this.repaint();
        if (this.app.getTaskListRootPane() != null) {
            this.app.getTaskListRootPane().getViewport().validate();
        }
        if (this.app.getTaskLineDataPane() != null) {
            this.app.getTaskLineDataPane().repaint();
        }
        if (this.app.getTaskListTable() != null) {
            this.app.getTaskListTable().repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.triggerPopup(e);
            return;
        }
        if (this.handleFoldOperation(e)) {
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.triggerPopup(e);
            return;
        }
    }

    public void removeSelectedRows() {
        CompoundEdit compound = new CompoundEdit();
        this.project.getUndoManager().addEdit(compound);
        try {
            int[] selectedRows;
            int deleted = 0;
            int[] nArray = selectedRows = this.getSelectedRows();
            int n = selectedRows.length;
            int n2 = 0;
            while (n2 < n) {
                int s = nArray[n2];
                int row = s - deleted;
                this.project.getController().removeIndex(this.project.getIndexFromRow(row));
                ++deleted;
                ++n2;
            }
            this.project.update();
        }
        finally {
            compound.end();
        }
    }

    public void insertSelectedRows() {
        CompoundEdit compound = new CompoundEdit();
        this.project.getUndoManager().addEdit(compound);
        try {
            int[] selectedRows;
            int inserted = 0;
            int chained = 0;
            int preSelected = -2;
            int[] nArray = selectedRows = this.getSelectedRows();
            int n = selectedRows.length;
            int n2 = 0;
            while (n2 < n) {
                int s = nArray[n2];
                chained = preSelected + 1 == s ? ++chained : 0;
                int row = s + inserted - chained;
                Task newTask = new Task();
                this.project.getController().insertTaskAtIndex(newTask, this.project.getIndexFromRow(row));
                ++inserted;
                preSelected = s;
                ++n2;
            }
            this.project.update();
        }
        finally {
            compound.end();
        }
    }

    private void triggerPopup(MouseEvent e) {
        int[] selectedRows;
        int row = this.rowAtPoint(e.getPoint());
        if (row < 0) {
            return;
        }
        boolean found = false;
        int[] nArray = selectedRows = this.getSelectedRows();
        int n = selectedRows.length;
        int n2 = 0;
        while (n2 < n) {
            int s = nArray[n2];
            if (s == row) {
                found = true;
            }
            ++n2;
        }
        if (!found) {
            this.setRowSelectionInterval(row, row);
            this.repaint();
        }
        boolean isAvailableLevelUp = true;
        boolean isAvailableLevelDown = true;
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem(Resource.get("listLevelUp"));
        item.setEnabled(isAvailableLevelUp);
        item.addActionListener(new LevelUpAction());
        menu.add(item);
        item = new JMenuItem(Resource.get("listLevelDown"));
        item.setEnabled(isAvailableLevelDown);
        item.addActionListener(new LevelDownAction());
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(Resource.get("listRemoveTask"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskListTable.this.removeSelectedRows();
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("listInsertTask"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskListTable.this.insertSelectedRows();
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuEditCut"));
        item.addActionListener(this.app.getMenu().getCutAction());
        menu.add(item);
        item = new JMenuItem(Resource.get("menuEditCopy"));
        item.addActionListener(this.app.getMenu().getCopyAction());
        menu.add(item);
        item = new JMenuItem(Resource.get("menuEditPaste"));
        item.addActionListener(this.app.getMenu().getPasteAction());
        menu.add(item);
        menu.show(this, e.getX(), e.getY());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private boolean handleFoldOperation(MouseEvent e) {
        TableColumnModel columnModel = this.getColumnModel();
        int row = this.rowAtPoint(e.getPoint());
        int column = this.columnAtPoint(e.getPoint());
        int columnIndex = columnModel.getColumnIndexAtX(e.getX());
        Object columnKey = columnModel.getColumn(columnIndex).getIdentifier();
        if (!columnKey.equals("name")) {
            return false;
        }
        Rectangle cellRect = this.getCellRect(row, column, false);
        Point cellPoint = new Point(e.getX() - cellRect.x, e.getY() - cellRect.y);
        this.taskNameCellRenderer.getTableCellRendererComponent(this, "", true, true, row, column);
        Border border = this.taskNameCellRenderer.getBorder();
        if (!(border instanceof TaskNameCellRenderer.FoldBorder)) {
            return false;
        }
        Rectangle foldRect = ((TaskNameCellRenderer.FoldBorder)border).getFoldRect();
        if (foldRect == null) {
            return false;
        }
        if (!foldRect.contains(cellPoint)) {
            return false;
        }
        this.project.toggleTaskFold(row);
        this.project.getTaskTableModel().fireTableChanged();
        return true;
    }

    @Override
    public void doLayout() {
        JTableHeader header = this.getTableHeader();
        TableColumn resizingColumn = header.getResizingColumn();
        if (resizingColumn != null) {
            resizingColumn.setPreferredWidth(resizingColumn.getWidth());
        }
        TableColumnModel model = this.getColumnModel();
        int i = 0;
        while (i < model.getColumnCount()) {
            TableColumn column = model.getColumn(i);
            column.setWidth(column.getPreferredWidth());
            ++i;
        }
    }

    private List<Column> getCurrentColumns() {
        ArrayList<Column> columns = new ArrayList<Column>();
        int i = 1;
        while (i < this.getColumnModel().getColumnCount()) {
            TableColumn column = this.getColumnModel().getColumn(i);
            String key = (String)column.getIdentifier();
            columns.add(new Column(key, column.getWidth()));
            ++i;
        }
        return columns;
    }

    public void copySelectedToClipboard() {
        int[] selectedRows = this.getSelectedRows();
        StringBuilder builder = new StringBuilder();
        int[] nArray = selectedRows;
        int n = selectedRows.length;
        int n2 = 0;
        while (n2 < n) {
            int s = nArray[n2];
            int i = 0;
            while (i < this.getColumnCount()) {
                Object value = this.getValueAt(s, i);
                if (value instanceof Member) {
                    value = ((Member)value).getName();
                }
                builder.append(value == null ? "" : value.toString());
                builder.append(i + 1 == this.getColumnCount() ? "\n" : "\t");
                ++i;
            }
            ++n2;
        }
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(builder.toString());
        clip.setContents(ss, ss);
    }

    public void insertFromClipboard() throws UnsupportedFlavorException, IOException {
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        String data = (String)clip.getData(DataFlavor.stringFlavor);
        CompoundEdit compound = new CompoundEdit();
        this.project.getUndoManager().addEdit(compound);
        try {
            int[] selectedRows = this.getSelectedRows();
            int baseRow = selectedRows.length > 0 ? selectedRows[0] : 0;
            String[] lines = data.split("\n");
            int l = 0;
            while (l < lines.length) {
                String line = lines[l];
                String[] fragments = line.split("\t");
                this.project.getController().insertTaskAtIndex(new Task(), this.project.getIndexFromRow(baseRow + l));
                int f = 0;
                while (f < fragments.length) {
                    this.setValueAt(fragments[f], baseRow + l, f);
                    ++f;
                }
                ++l;
            }
            this.project.update();
        }
        finally {
            compound.end();
        }
    }

    class ColumnNameActionListener
    implements ActionListener {
        int index;

        public ColumnNameActionListener(int index) {
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean equals;
            List oldColumns = TaskListTable.this.getCurrentColumns();
            ArrayList<Column> newColumns = new ArrayList<Column>();
            for (Column column : oldColumns) {
                newColumns.add(column.clone());
            }
            String key = TaskListTable.this.tableModel.getColumnKey(this.index);
            for (Column column : newColumns) {
                if (!column.getKey().equals(key)) continue;
                int width = column.getWidth() == 0 ? TaskListTable.this.project.getView().getDefaultColumn(key).getWidth() : 0;
                column.setWidth(width);
            }
            boolean bl = equals = oldColumns.size() == newColumns.size();
            if (equals) {
                int i = 0;
                while (i < oldColumns.size()) {
                    equals = equals && ((Column)oldColumns.get(i)).equals((Column)newColumns.get(i));
                    ++i;
                }
            }
            if (equals) {
                return;
            }
            CompoundEdit compound = new CompoundEdit();
            TaskListTable.this.project.getUndoManager().addEdit(compound);
            try {
                TaskListTable.this.project.getController().setViewTaskTableColumns(TaskListTable.this.project, oldColumns, newColumns);
            }
            finally {
                compound.end();
            }
        }
    }

    class HeaderPopupMouseListener
    implements MouseListener {
        HeaderPopupMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.triggerPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.triggerPopup(e);
            }
        }

        public void triggerPopup(MouseEvent e) {
            JPopupMenu menu = new JPopupMenu();
            String[] columnNames = TaskListTable.this.getTaskListTableModel().getColumnNames();
            int index = 0;
            while (index < columnNames.length) {
                if (index != 0) {
                    JMenuItem item = new JMenuItem(columnNames[index]);
                    item.addActionListener(new ColumnNameActionListener(index));
                    menu.add(item);
                }
                ++index;
            }
            menu.show(e.getComponent(), e.getX(), e.getY());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    class HeaderSwitchMouseHandler
    implements MouseListener,
    MouseMotionListener {
        boolean dragged = false;
        List<Column> oldColumns;
        List<Column> newColumns;

        HeaderSwitchMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            this.oldColumns = TaskListTable.this.getCurrentColumns();
            this.dragged = false;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            boolean equals;
            if (e.getButton() != 1) {
                return;
            }
            if (!this.dragged) {
                return;
            }
            this.newColumns = TaskListTable.this.getCurrentColumns();
            boolean bl = equals = this.oldColumns.size() == this.newColumns.size();
            if (equals) {
                int i = 0;
                while (i < this.oldColumns.size()) {
                    equals = equals && this.oldColumns.get(i).equals(this.newColumns.get(i));
                    ++i;
                }
            }
            if (equals) {
                return;
            }
            CompoundEdit compound = new CompoundEdit();
            TaskListTable.this.project.getUndoManager().addEdit(compound);
            try {
                TaskListTable.this.project.getController().setViewTaskTableColumns(TaskListTable.this.project, this.oldColumns, this.newColumns);
            }
            finally {
                compound.end();
                this.dragged = false;
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.dragged = true;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    class InsertAction
    implements ActionListener {
        InsertAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TaskListTable.this.insertSelectedRows();
        }
    }

    class LevelDownAction
    extends AbstractAction {
        private static final long serialVersionUID = 785583037631700955L;

        LevelDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CompoundEdit compound = new CompoundEdit();
            TaskListTable.this.project.getUndoManager().addEdit(compound);
            try {
                int[] rows;
                int[] nArray = rows = TaskListTable.this.getSelectedRows();
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    int row = nArray[n2];
                    TaskListTable.this.project.getController().levelDownTask(TaskListTable.this.project.getTaskAtRow(row));
                    ++n2;
                }
                TaskListTable.this.project.update();
            }
            finally {
                compound.end();
                TaskListTable.this.tableModel.fireTableChanged();
            }
        }
    }

    class LevelUpAction
    extends AbstractAction {
        private static final long serialVersionUID = 785583037631700955L;

        LevelUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CompoundEdit compound = new CompoundEdit();
            TaskListTable.this.project.getUndoManager().addEdit(compound);
            try {
                int[] rows;
                int[] nArray = rows = TaskListTable.this.getSelectedRows();
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    int row = nArray[n2];
                    TaskListTable.this.project.getController().levelUpTask(TaskListTable.this.project.getTaskAtRow(row));
                    ++n2;
                }
                TaskListTable.this.project.update();
            }
            finally {
                compound.end();
                TaskListTable.this.tableModel.fireTableChanged();
            }
        }
    }

    class ProjectViewChangedHandler
    implements ProjectViewChangedListener {
        ProjectViewChangedHandler() {
        }

        @Override
        public void projectViewChanged() {
            TaskListTable.this.updateColumnArrangement();
        }
    }

    class RemoveAction
    implements ActionListener {
        RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TaskListTable.this.removeSelectedRows();
        }
    }
}

