#include <stdlib.h>

#include <iostream>
#include <iomanip>
#include <fstream>
#include <string>
#include <cerrno>
#include <exception>

#include "parse.h"

#ifndef CONSOLENAME
#if defined(__BORLANDC__) || defined(_MSC_VER) || defined(__MINGW32__)
#define CONSOLENAME "CON:"
#else
#define CONSOLENAME "/dev/stdin"
#endif
#endif

void run(std::istream &ifs);
static std::string trim(const std::string &s);

void traverse(tagrec *p);

int main(int argc, char *argv[]) {
  std::ifstream ifs;
  switch (argc) {
  case 1:
    ifs.open(CONSOLENAME);
    if (!ifs.good()) {
      std::cerr 
       << "usage:" << argv[0] << " [filename]" << std::endl;
    }
    try {
      run(ifs);
    } catch (std::exception &e) {
      std::cerr << e.what() << std::endl;
    }
    break;
  case 2:
    ifs.open(argv[1], std::ios::binary | std::ios::in);
    if (!ifs.good()) {
      std::cerr 
       << "\"" << argv[1] << "\":" 
       << "cannot open." << std::endl;
      exit(-1);
    }
    std::cout << "START:\"" << argv[1] << "\"" << std::endl;
    try {
      run(ifs);
    } catch (std::exception &e) {
      std::cerr << e.what() << std::endl;
    }
    break;
  default:
    std::cerr << "usage:" << argv[0] << " [filename]" << std::endl;
    exit(1);
    break;
  }
  return 0;
}

/*
http://www.doraneko.org/xml/xml-c14n/WD990729.html
[1]  canonXML ::=  element #xA 
[2]  element ::=  Stag (Datachar | element)* Etag 
[3]  Stag ::=  '<' Name NSDecl? (Att NSDecl?)* '>' 
[4]  Etag ::=  '</' Name '>' 
[5]  NSDecl ::=  #x20 'xmlns:' Prefix '=' '"' Attvalchar* '"' 
[6]  Att ::=  #x20 Name '=' '"' Attvalchar* '"' 
[7]  Datachar 
     ::=  '&amp;' | '&lt;' | '&gt;' | '&#xD;' 
     | (Char - ('&' | '<' | '>' | #xD )) 
[8]  Attvalchar 
     ::=  '&amp;' | '&lt;' | '&quot;' | '&#x9;' | '&#xA;' | '&#xD;' 
     | (Char - ('&' | '<' | '"' | #x9 | #xA | #xD)) 
[9]  Name ::=  (Prefix ':')? NCName 
[10]  Prefix ::=  'n' [1-9] [0-9]* 

̾ˤϥե٥åȡ:, -, ʤɡϥ

   < / > ! - " = s .
0  1 0 0 0 0 0 0 0 0
1  e 1 0 X e e e e 2
2  e e 0 

structure:
list
node
 label
 value
 attrs
 child

 */

void run(std::istream &ifs) {
  parser ps;
  std::string ms;
  char c;
  while (ifs.get(c), ifs.good()) {
    if (ps.step(c)) break;
  }
  if (ps.checkerror()) {
    std::cerr << "SYNTAX ERROR" << std::endl;
  } else if (!ps.acceptable()) {
    std::cerr << "NOT COMPLEETE" << std::endl;
  } else {
    ;
  }
  if (ps.root) {
    std::vector<tagrec *> ls;
    if (ps.root->find(ls, "title")) {
      for (std::vector<tagrec *>::iterator it = ls.begin();
       it != ls.end(); it++) {
         std::cout << "TITLE:" << (*it)->value << std::endl;
      }
    }
    ls.clear();
    if (ps.root->find(ls, "poet")) {
      for (std::vector<tagrec *>::iterator it = ls.begin();
       it != ls.end(); it++) {
         std::cout << "poet:" << (*it)->value << std::endl;
      }
    }
    ls.clear();
    if (ps.root->path(ls, "manyosyu/volume/poem/yomi")) {
      for (std::vector<tagrec *>::iterator it = ls.begin();
       it != ls.end(); it++) {
        std::cout << "YOMI:\"" << (*it)->value << "\"" << std::endl;
      }
    }
    ls.clear();
    if (ps.root->path(ls, "?xml")) {
      std::pair<std::string, std::string> encoding;
      if (ls[0]->scanattr(encoding, "encoding")) {
        std::cout << "encoding=" << encoding.second << std::endl;
      }
    }
    std::cout << std::endl;
    std::cout << "--------" << std::endl;
    std::cout << ps.root->dump();
    std::cout << "--------" << std::endl;
  }
}

void traverse(tagrec *p) {
  if (p->label.size()) {
    std::cout << "<" << p->label;
  }
  for (std::list<std::pair<std::string, std::string> >::iterator
   it = p->attrs.begin(); it != p->attrs.end(); it++) {
    std::cout 
     << " " 
     << it->first;
    if (it->second.size()) {
      std::cout << "=\"" << it->second << "\"";
    }
  }
  if (p->label[p->label.size() - 1] == L'?') { std::cout << "?"; }
  if (p->label.size() && (p->label[0] == '?')) { std::cout << "?"; }
  if (p->label.size()) { std::cout << ">"; }
  for (std::list<tagrec *>::iterator it = p->child.begin(); 
   it != p->child.end(); it++) { traverse(*it); }
  if (p->label.size() && (p->label[p->label.size() - 1] == '/')) {
    std::cout << std::endl;
  } else if (p->label.size() && (p->label[0] == '?')) {
    std::cout << std::endl;
  } else if (p->label.size() && (p->label[0] == '!')) {
    std::cout << std::endl;
  } else if (p->label.size()) {
    if (p->value.size()) {
      #if 1
      std::cout << trim(p->value) << std::flush;
      #else
      for (std::string::iterator it = p->value.begin();
       it != p->value.end(); it++) {
        std::cout << std::hex << std::setw(2) << std::setfill('0')
	 << *it << " " << std::flush;
      }
      #endif
    }
    std::cout << "</" << p->label << ">" << std::endl;
  }
  return;
}

static std::string trim(const std::string &s) {
  std::string d;
  std::string::const_iterator it = s.begin();
  while (it != s.end()) {
    if ((*it & 0xff) > int(' ')) {
      d += (*it & 0xff);
    } else {
      if (d.size() && ((d[d.size() - 1] & 0xff) > int(' '))) {
        d += ' ';
      }
    }
    it++;
  }
  return d;
}
