#!/usr/local/bin/perl
############################################################
#
# WikiեޥåȤHTML륹ץ
#
############################################################
use lib "$ENV{'FSWIKI_HOME'}/lib";
use Wiki;
use Util;
use Jcode;
use Cwd;

#===========================================================
# ­ʤ
#===========================================================
if($#ARGV==-1){
	die "wiki2html.pl filename [-title=title] [-output=sjis|euc]\n";
}

#===========================================================
# ѿν
#===========================================================
my $from   = "";
my $title  = "";
my $css    = "";
my $output = "euc";
my $count = 0;

#===========================================================
# ޥɥ饤󥪥ץβ
#===========================================================
foreach(@ARGV){
	if($count==0){
		$from = $_;
	} else {
		my ($key,$value)=split(/=/,$_);
		if($key eq "-title"){
			$title = $value;
		} elsif($key eq "-css"){
			$css = $value;
		} elsif($key eq "-input"){
			$input = $value;
		} elsif($key eq "-output"){
			$output = $value;
		} else {
			die $key." is Unknown Option.\n";
		}
	}
	$count++;
}

if($title eq ""){
	$title = $from;
}

#===========================================================
# Wiki
#===========================================================
my $source = "";
open(DATA,$from) or die "File Open Error :$from\n";
while(<DATA>){
	$source .= $_;
}
close(DATA);
&Jcode::convert(\$source,"euc");

#===========================================================
# HTML
#===========================================================
chdir($ENV{'FSWIKI_HOME'});
my $wiki = Wiki->new();

my $buf = "<html>\n".
          "<head>\n".
          "  <title>".Util::escapeHTML($title)."</title>\n";
if($css ne ""){
	$buf .= "  <link rel=\"stylesheet\" type=\"text/css\" href=\"".$css."\">\n";
}
$buf .= "</head>\n".
        "<body>\n".$wiki->process_wiki($source)."</body>\n".
        "</html>\n";

&Jcode::convert(\$buf,$output);
print $buf;
