# PDFJ::Type1
# 2004 nakajima@netstock.co.jp
package PDFJ::Type1;
use Carp;
use SelfLoader;
use strict;

my %FontWidth;
sub fontwidth {
	my($fontname, $encoding) = @_;
	return $FontWidth{$fontname, $encoding} if $FontWidth{$fontname, $encoding};
	my $sub;
	$sub = "${encoding}Array";
	my $ea = eval { no strict 'refs'; &$sub(); };
	croak $@ if $@;
	$sub = "afmwx_$fontname";
	$sub =~ s/-/_/g;
	my $wf = eval { no strict 'refs'; &$sub(); };
	croak $@ if $@;
	my $result = [ map {$wf->{$ea->[$_]}} (0..255) ];
	$FontWidth{$fontname, $encoding} = $result;
	$result;
}

1;

# for SelfLoader;
__DATA__

sub WinAnsiEncodingArray {
	return [
'.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', 
'.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', 
'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent', 'ampersand', 'quotesingle', 'parenleft', 'parenright', 'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash', 
'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 
'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 
'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore', 
'grave', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 
'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', 'bullet', 
'Euro', 'bullet', 'quotesinglbase', 'florin', 'quotedblbase', 'ellipsis', 'dagger', 'daggerdbl', 'circumflex', 'perthousand', 'Scaron', 'guilsinglleft', 'OE', 'bullet', 'Zcaron', 'bullet', 
'bullet', 'quoteleft', 'quoteright', 'quotedblleft', 'quotedblright', 'bullet', 'endash', 'emdash', 'tilde', 'trademark', 'scaron', 'guilsinglright', 'oe', 'bullet', 'zcaron', 'Ydieresis', 
'space', 'exclamdown', 'cent', 'sterling', 'currency', 'yen', 'brokenbar', 'section', 'dieresis', 'copyright', 'ordfeminine', 'guillemotleft', 'logicalnot', 'hyphen', 'registered', 'macron', 
'degree', 'plusminus', 'twosuperior', 'threesuperior', 'acute', 'mu', 'paragraph', 'periodcentered', 'cedilla', 'onesuperior', 'ordmasculine', 'guillemotright', 'onequarter', 'onehalf', 'threequarters', 'questiondown', 
'Agrave', 'Aacute', 'Acircumflex', 'Atilde', 'Adieresis', 'Aring', 'AE', 'Ccedilla', 'Egrave', 'Eacute', 'Ecircumflex', 'Edieresis', 'Igrave', 'Iacute', 'Icircumflex', 'Idieresis', 
'Eth', 'Ntilde', 'Ograve', 'Oacute', 'Ocircumflex', 'Otilde', 'Odieresis', 'multiply', 'Oslash', 'Ugrave', 'Uacute', 'Ucircumflex', 'Udieresis', 'Yacute', 'Thorn', 'germandbls', 
'agrave', 'aacute', 'acircumflex', 'atilde', 'adieresis', 'aring', 'ae', 'ccedilla', 'egrave', 'eacute', 'ecircumflex', 'edieresis', 'igrave', 'iacute', 'icircumflex', 'idieresis', 
'eth', 'ntilde', 'ograve', 'oacute', 'ocircumflex', 'otilde', 'odieresis', 'divide', 'oslash', 'ugrave', 'uacute', 'ucircumflex', 'udieresis', 'yacute', 'thorn', 'ydieresis', 
	];
}

sub MacRomanEncodingArray {
	return [
'.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', 
'.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', 
'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent', 'ampersand', 'quotesingle', 'parenleft', 'parenright', 'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash', 
'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 
'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 
'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore', 
'grave', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 
'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', '.notdef', 
'Adieresis', 'Aring', 'Ccedilla', 'Eacute', 'Ntilde', 'Odieresis', 'Udieresis', 'aacute', 'agrave', 'acircumflex', 'adieresis', 'atilde', 'aring', 'ccedilla', 'eacute', 'egrave', 
'ecircumflex', 'edieresis', 'iacute', 'igrave', 'icircumflex', 'idieresis', 'ntilde', 'oacute', 'ograve', 'ocircumflex', 'odieresis', 'otilde', 'uacute', 'ugrave', 'ucircumflex', 'udieresis', 
'dagger', 'degree', 'cent', 'sterling', 'section', 'bullet', 'paragraph', 'germandbls', 'registered', 'copyright', 'trademark', 'acute', 'dieresis', '.notdef', 'AE', 'Oslash', 
'.notdef', 'plusminus', '.notdef', '.notdef', 'yen', 'mu', '.notdef', '.notdef', '.notdef', '.notdef', '.notdef', 'ordfeminine', 'ordmasculine', '.notdef', 'ae', 'oslash', 
'questiondown', 'exclamdown', 'logicalnot', '.notdef', 'florin', '.notdef', '.notdef', 'guillemotleft', 'guillemotright', 'ellipsis', 'space', 'Agrave', 'Atilde', 'Otilde', 'OE', 'oe', 
'endash', 'emdash', 'quotedblleft', 'quotedblright', 'quoteleft', 'quoteright', 'divide', '.notdef', 'ydieresis', 'Ydieresis', 'fraction', 'currency', 'guilsinglleft', 'guilsinglright', 'fi', 'fl', 
'daggerdbl', 'periodcentered', 'quotesinglbase', 'quotedblbase', 'perthousand', 'Acircumflex', 'Ecircumflex', 'Aacute', 'Edieresis', 'Egrave', 'Iacute', 'Icircumflex', 'Idieresis', 'Igrave', 'Oacute', 'Ocircumflex', 
'.notdef', 'Ograve', 'Uacute', 'Ucircumflex', 'Ugrave', 'dotlessi', 'circumflex', 'tilde', 'macron', 'breve', 'dotaccent', 'ring', 'cedilla', 'hungarumlaut', 'ogonek', 'caron'
	];
}


sub afmwx_Courier {
	return {
	A => 600,
	AE => 600,
	Aacute => 600,
	Abreve => 600,
	Acircumflex => 600,
	Adieresis => 600,
	Agrave => 600,
	Amacron => 600,
	Aogonek => 600,
	Aring => 600,
	Atilde => 600,
	B => 600,
	C => 600,
	Cacute => 600,
	Ccaron => 600,
	Ccedilla => 600,
	D => 600,
	Dcaron => 600,
	Dcroat => 600,
	Delta => 600,
	E => 600,
	Eacute => 600,
	Ecaron => 600,
	Ecircumflex => 600,
	Edieresis => 600,
	Edotaccent => 600,
	Egrave => 600,
	Emacron => 600,
	Eogonek => 600,
	Eth => 600,
	Euro => 600,
	F => 600,
	G => 600,
	Gbreve => 600,
	Gcommaaccent => 600,
	H => 600,
	I => 600,
	Iacute => 600,
	Icircumflex => 600,
	Idieresis => 600,
	Idotaccent => 600,
	Igrave => 600,
	Imacron => 600,
	Iogonek => 600,
	J => 600,
	K => 600,
	Kcommaaccent => 600,
	L => 600,
	Lacute => 600,
	Lcaron => 600,
	Lcommaaccent => 600,
	Lslash => 600,
	M => 600,
	N => 600,
	Nacute => 600,
	Ncaron => 600,
	Ncommaaccent => 600,
	Ntilde => 600,
	O => 600,
	OE => 600,
	Oacute => 600,
	Ocircumflex => 600,
	Odieresis => 600,
	Ograve => 600,
	Ohungarumlaut => 600,
	Omacron => 600,
	Oslash => 600,
	Otilde => 600,
	P => 600,
	Q => 600,
	R => 600,
	Racute => 600,
	Rcaron => 600,
	Rcommaaccent => 600,
	S => 600,
	Sacute => 600,
	Scaron => 600,
	Scedilla => 600,
	Scommaaccent => 600,
	T => 600,
	Tcaron => 600,
	Tcommaaccent => 600,
	Thorn => 600,
	U => 600,
	Uacute => 600,
	Ucircumflex => 600,
	Udieresis => 600,
	Ugrave => 600,
	Uhungarumlaut => 600,
	Umacron => 600,
	Uogonek => 600,
	Uring => 600,
	V => 600,
	W => 600,
	X => 600,
	Y => 600,
	Yacute => 600,
	Ydieresis => 600,
	Z => 600,
	Zacute => 600,
	Zcaron => 600,
	Zdotaccent => 600,
	a => 600,
	aacute => 600,
	abreve => 600,
	acircumflex => 600,
	acute => 600,
	adieresis => 600,
	ae => 600,
	agrave => 600,
	amacron => 600,
	ampersand => 600,
	aogonek => 600,
	aring => 600,
	asciicircum => 600,
	asciitilde => 600,
	asterisk => 600,
	at => 600,
	atilde => 600,
	b => 600,
	backslash => 600,
	bar => 600,
	braceleft => 600,
	braceright => 600,
	bracketleft => 600,
	bracketright => 600,
	breve => 600,
	brokenbar => 600,
	bullet => 600,
	c => 600,
	cacute => 600,
	caron => 600,
	ccaron => 600,
	ccedilla => 600,
	cedilla => 600,
	cent => 600,
	circumflex => 600,
	colon => 600,
	comma => 600,
	commaaccent => 600,
	copyright => 600,
	currency => 600,
	d => 600,
	dagger => 600,
	daggerdbl => 600,
	dcaron => 600,
	dcroat => 600,
	degree => 600,
	dieresis => 600,
	divide => 600,
	dollar => 600,
	dotaccent => 600,
	dotlessi => 600,
	e => 600,
	eacute => 600,
	ecaron => 600,
	ecircumflex => 600,
	edieresis => 600,
	edotaccent => 600,
	egrave => 600,
	eight => 600,
	ellipsis => 600,
	emacron => 600,
	emdash => 600,
	endash => 600,
	eogonek => 600,
	equal => 600,
	eth => 600,
	exclam => 600,
	exclamdown => 600,
	f => 600,
	fi => 600,
	five => 600,
	fl => 600,
	florin => 600,
	four => 600,
	fraction => 600,
	g => 600,
	gbreve => 600,
	gcommaaccent => 600,
	germandbls => 600,
	grave => 600,
	greater => 600,
	greaterequal => 600,
	guillemotleft => 600,
	guillemotright => 600,
	guilsinglleft => 600,
	guilsinglright => 600,
	h => 600,
	hungarumlaut => 600,
	hyphen => 600,
	i => 600,
	iacute => 600,
	icircumflex => 600,
	idieresis => 600,
	igrave => 600,
	imacron => 600,
	iogonek => 600,
	j => 600,
	k => 600,
	kcommaaccent => 600,
	l => 600,
	lacute => 600,
	lcaron => 600,
	lcommaaccent => 600,
	less => 600,
	lessequal => 600,
	logicalnot => 600,
	lozenge => 600,
	lslash => 600,
	m => 600,
	macron => 600,
	minus => 600,
	mu => 600,
	multiply => 600,
	n => 600,
	nacute => 600,
	ncaron => 600,
	ncommaaccent => 600,
	nine => 600,
	notequal => 600,
	ntilde => 600,
	numbersign => 600,
	o => 600,
	oacute => 600,
	ocircumflex => 600,
	odieresis => 600,
	oe => 600,
	ogonek => 600,
	ograve => 600,
	ohungarumlaut => 600,
	omacron => 600,
	one => 600,
	onehalf => 600,
	onequarter => 600,
	onesuperior => 600,
	ordfeminine => 600,
	ordmasculine => 600,
	oslash => 600,
	otilde => 600,
	p => 600,
	paragraph => 600,
	parenleft => 600,
	parenright => 600,
	partialdiff => 600,
	percent => 600,
	period => 600,
	periodcentered => 600,
	perthousand => 600,
	plus => 600,
	plusminus => 600,
	q => 600,
	question => 600,
	questiondown => 600,
	quotedbl => 600,
	quotedblbase => 600,
	quotedblleft => 600,
	quotedblright => 600,
	quoteleft => 600,
	quoteright => 600,
	quotesinglbase => 600,
	quotesingle => 600,
	r => 600,
	racute => 600,
	radical => 600,
	rcaron => 600,
	rcommaaccent => 600,
	registered => 600,
	ring => 600,
	s => 600,
	sacute => 600,
	scaron => 600,
	scedilla => 600,
	scommaaccent => 600,
	section => 600,
	semicolon => 600,
	seven => 600,
	six => 600,
	slash => 600,
	space => 600,
	sterling => 600,
	summation => 600,
	t => 600,
	tcaron => 600,
	tcommaaccent => 600,
	thorn => 600,
	three => 600,
	threequarters => 600,
	threesuperior => 600,
	tilde => 600,
	trademark => 600,
	two => 600,
	twosuperior => 600,
	u => 600,
	uacute => 600,
	ucircumflex => 600,
	udieresis => 600,
	ugrave => 600,
	uhungarumlaut => 600,
	umacron => 600,
	underscore => 600,
	uogonek => 600,
	uring => 600,
	v => 600,
	w => 600,
	x => 600,
	y => 600,
	yacute => 600,
	ydieresis => 600,
	yen => 600,
	z => 600,
	zacute => 600,
	zcaron => 600,
	zdotaccent => 600,
	zero => 600,
	};
}
sub afmwx_Courier_Bold {
	return {
	A => 600,
	AE => 600,
	Aacute => 600,
	Abreve => 600,
	Acircumflex => 600,
	Adieresis => 600,
	Agrave => 600,
	Amacron => 600,
	Aogonek => 600,
	Aring => 600,
	Atilde => 600,
	B => 600,
	C => 600,
	Cacute => 600,
	Ccaron => 600,
	Ccedilla => 600,
	D => 600,
	Dcaron => 600,
	Dcroat => 600,
	Delta => 600,
	E => 600,
	Eacute => 600,
	Ecaron => 600,
	Ecircumflex => 600,
	Edieresis => 600,
	Edotaccent => 600,
	Egrave => 600,
	Emacron => 600,
	Eogonek => 600,
	Eth => 600,
	Euro => 600,
	F => 600,
	G => 600,
	Gbreve => 600,
	Gcommaaccent => 600,
	H => 600,
	I => 600,
	Iacute => 600,
	Icircumflex => 600,
	Idieresis => 600,
	Idotaccent => 600,
	Igrave => 600,
	Imacron => 600,
	Iogonek => 600,
	J => 600,
	K => 600,
	Kcommaaccent => 600,
	L => 600,
	Lacute => 600,
	Lcaron => 600,
	Lcommaaccent => 600,
	Lslash => 600,
	M => 600,
	N => 600,
	Nacute => 600,
	Ncaron => 600,
	Ncommaaccent => 600,
	Ntilde => 600,
	O => 600,
	OE => 600,
	Oacute => 600,
	Ocircumflex => 600,
	Odieresis => 600,
	Ograve => 600,
	Ohungarumlaut => 600,
	Omacron => 600,
	Oslash => 600,
	Otilde => 600,
	P => 600,
	Q => 600,
	R => 600,
	Racute => 600,
	Rcaron => 600,
	Rcommaaccent => 600,
	S => 600,
	Sacute => 600,
	Scaron => 600,
	Scedilla => 600,
	Scommaaccent => 600,
	T => 600,
	Tcaron => 600,
	Tcommaaccent => 600,
	Thorn => 600,
	U => 600,
	Uacute => 600,
	Ucircumflex => 600,
	Udieresis => 600,
	Ugrave => 600,
	Uhungarumlaut => 600,
	Umacron => 600,
	Uogonek => 600,
	Uring => 600,
	V => 600,
	W => 600,
	X => 600,
	Y => 600,
	Yacute => 600,
	Ydieresis => 600,
	Z => 600,
	Zacute => 600,
	Zcaron => 600,
	Zdotaccent => 600,
	a => 600,
	aacute => 600,
	abreve => 600,
	acircumflex => 600,
	acute => 600,
	adieresis => 600,
	ae => 600,
	agrave => 600,
	amacron => 600,
	ampersand => 600,
	aogonek => 600,
	aring => 600,
	asciicircum => 600,
	asciitilde => 600,
	asterisk => 600,
	at => 600,
	atilde => 600,
	b => 600,
	backslash => 600,
	bar => 600,
	braceleft => 600,
	braceright => 600,
	bracketleft => 600,
	bracketright => 600,
	breve => 600,
	brokenbar => 600,
	bullet => 600,
	c => 600,
	cacute => 600,
	caron => 600,
	ccaron => 600,
	ccedilla => 600,
	cedilla => 600,
	cent => 600,
	circumflex => 600,
	colon => 600,
	comma => 600,
	commaaccent => 600,
	copyright => 600,
	currency => 600,
	d => 600,
	dagger => 600,
	daggerdbl => 600,
	dcaron => 600,
	dcroat => 600,
	degree => 600,
	dieresis => 600,
	divide => 600,
	dollar => 600,
	dotaccent => 600,
	dotlessi => 600,
	e => 600,
	eacute => 600,
	ecaron => 600,
	ecircumflex => 600,
	edieresis => 600,
	edotaccent => 600,
	egrave => 600,
	eight => 600,
	ellipsis => 600,
	emacron => 600,
	emdash => 600,
	endash => 600,
	eogonek => 600,
	equal => 600,
	eth => 600,
	exclam => 600,
	exclamdown => 600,
	f => 600,
	fi => 600,
	five => 600,
	fl => 600,
	florin => 600,
	four => 600,
	fraction => 600,
	g => 600,
	gbreve => 600,
	gcommaaccent => 600,
	germandbls => 600,
	grave => 600,
	greater => 600,
	greaterequal => 600,
	guillemotleft => 600,
	guillemotright => 600,
	guilsinglleft => 600,
	guilsinglright => 600,
	h => 600,
	hungarumlaut => 600,
	hyphen => 600,
	i => 600,
	iacute => 600,
	icircumflex => 600,
	idieresis => 600,
	igrave => 600,
	imacron => 600,
	iogonek => 600,
	j => 600,
	k => 600,
	kcommaaccent => 600,
	l => 600,
	lacute => 600,
	lcaron => 600,
	lcommaaccent => 600,
	less => 600,
	lessequal => 600,
	logicalnot => 600,
	lozenge => 600,
	lslash => 600,
	m => 600,
	macron => 600,
	minus => 600,
	mu => 600,
	multiply => 600,
	n => 600,
	nacute => 600,
	ncaron => 600,
	ncommaaccent => 600,
	nine => 600,
	notequal => 600,
	ntilde => 600,
	numbersign => 600,
	o => 600,
	oacute => 600,
	ocircumflex => 600,
	odieresis => 600,
	oe => 600,
	ogonek => 600,
	ograve => 600,
	ohungarumlaut => 600,
	omacron => 600,
	one => 600,
	onehalf => 600,
	onequarter => 600,
	onesuperior => 600,
	ordfeminine => 600,
	ordmasculine => 600,
	oslash => 600,
	otilde => 600,
	p => 600,
	paragraph => 600,
	parenleft => 600,
	parenright => 600,
	partialdiff => 600,
	percent => 600,
	period => 600,
	periodcentered => 600,
	perthousand => 600,
	plus => 600,
	plusminus => 600,
	q => 600,
	question => 600,
	questiondown => 600,
	quotedbl => 600,
	quotedblbase => 600,
	quotedblleft => 600,
	quotedblright => 600,
	quoteleft => 600,
	quoteright => 600,
	quotesinglbase => 600,
	quotesingle => 600,
	r => 600,
	racute => 600,
	radical => 600,
	rcaron => 600,
	rcommaaccent => 600,
	registered => 600,
	ring => 600,
	s => 600,
	sacute => 600,
	scaron => 600,
	scedilla => 600,
	scommaaccent => 600,
	section => 600,
	semicolon => 600,
	seven => 600,
	six => 600,
	slash => 600,
	space => 600,
	sterling => 600,
	summation => 600,
	t => 600,
	tcaron => 600,
	tcommaaccent => 600,
	thorn => 600,
	three => 600,
	threequarters => 600,
	threesuperior => 600,
	tilde => 600,
	trademark => 600,
	two => 600,
	twosuperior => 600,
	u => 600,
	uacute => 600,
	ucircumflex => 600,
	udieresis => 600,
	ugrave => 600,
	uhungarumlaut => 600,
	umacron => 600,
	underscore => 600,
	uogonek => 600,
	uring => 600,
	v => 600,
	w => 600,
	x => 600,
	y => 600,
	yacute => 600,
	ydieresis => 600,
	yen => 600,
	z => 600,
	zacute => 600,
	zcaron => 600,
	zdotaccent => 600,
	zero => 600,
	};
}
sub afmwx_Courier_BoldOblique {
	return {
	A => 600,
	AE => 600,
	Aacute => 600,
	Abreve => 600,
	Acircumflex => 600,
	Adieresis => 600,
	Agrave => 600,
	Amacron => 600,
	Aogonek => 600,
	Aring => 600,
	Atilde => 600,
	B => 600,
	C => 600,
	Cacute => 600,
	Ccaron => 600,
	Ccedilla => 600,
	D => 600,
	Dcaron => 600,
	Dcroat => 600,
	Delta => 600,
	E => 600,
	Eacute => 600,
	Ecaron => 600,
	Ecircumflex => 600,
	Edieresis => 600,
	Edotaccent => 600,
	Egrave => 600,
	Emacron => 600,
	Eogonek => 600,
	Eth => 600,
	Euro => 600,
	F => 600,
	G => 600,
	Gbreve => 600,
	Gcommaaccent => 600,
	H => 600,
	I => 600,
	Iacute => 600,
	Icircumflex => 600,
	Idieresis => 600,
	Idotaccent => 600,
	Igrave => 600,
	Imacron => 600,
	Iogonek => 600,
	J => 600,
	K => 600,
	Kcommaaccent => 600,
	L => 600,
	Lacute => 600,
	Lcaron => 600,
	Lcommaaccent => 600,
	Lslash => 600,
	M => 600,
	N => 600,
	Nacute => 600,
	Ncaron => 600,
	Ncommaaccent => 600,
	Ntilde => 600,
	O => 600,
	OE => 600,
	Oacute => 600,
	Ocircumflex => 600,
	Odieresis => 600,
	Ograve => 600,
	Ohungarumlaut => 600,
	Omacron => 600,
	Oslash => 600,
	Otilde => 600,
	P => 600,
	Q => 600,
	R => 600,
	Racute => 600,
	Rcaron => 600,
	Rcommaaccent => 600,
	S => 600,
	Sacute => 600,
	Scaron => 600,
	Scedilla => 600,
	Scommaaccent => 600,
	T => 600,
	Tcaron => 600,
	Tcommaaccent => 600,
	Thorn => 600,
	U => 600,
	Uacute => 600,
	Ucircumflex => 600,
	Udieresis => 600,
	Ugrave => 600,
	Uhungarumlaut => 600,
	Umacron => 600,
	Uogonek => 600,
	Uring => 600,
	V => 600,
	W => 600,
	X => 600,
	Y => 600,
	Yacute => 600,
	Ydieresis => 600,
	Z => 600,
	Zacute => 600,
	Zcaron => 600,
	Zdotaccent => 600,
	a => 600,
	aacute => 600,
	abreve => 600,
	acircumflex => 600,
	acute => 600,
	adieresis => 600,
	ae => 600,
	agrave => 600,
	amacron => 600,
	ampersand => 600,
	aogonek => 600,
	aring => 600,
	asciicircum => 600,
	asciitilde => 600,
	asterisk => 600,
	at => 600,
	atilde => 600,
	b => 600,
	backslash => 600,
	bar => 600,
	braceleft => 600,
	braceright => 600,
	bracketleft => 600,
	bracketright => 600,
	breve => 600,
	brokenbar => 600,
	bullet => 600,
	c => 600,
	cacute => 600,
	caron => 600,
	ccaron => 600,
	ccedilla => 600,
	cedilla => 600,
	cent => 600,
	circumflex => 600,
	colon => 600,
	comma => 600,
	commaaccent => 600,
	copyright => 600,
	currency => 600,
	d => 600,
	dagger => 600,
	daggerdbl => 600,
	dcaron => 600,
	dcroat => 600,
	degree => 600,
	dieresis => 600,
	divide => 600,
	dollar => 600,
	dotaccent => 600,
	dotlessi => 600,
	e => 600,
	eacute => 600,
	ecaron => 600,
	ecircumflex => 600,
	edieresis => 600,
	edotaccent => 600,
	egrave => 600,
	eight => 600,
	ellipsis => 600,
	emacron => 600,
	emdash => 600,
	endash => 600,
	eogonek => 600,
	equal => 600,
	eth => 600,
	exclam => 600,
	exclamdown => 600,
	f => 600,
	fi => 600,
	five => 600,
	fl => 600,
	florin => 600,
	four => 600,
	fraction => 600,
	g => 600,
	gbreve => 600,
	gcommaaccent => 600,
	germandbls => 600,
	grave => 600,
	greater => 600,
	greaterequal => 600,
	guillemotleft => 600,
	guillemotright => 600,
	guilsinglleft => 600,
	guilsinglright => 600,
	h => 600,
	hungarumlaut => 600,
	hyphen => 600,
	i => 600,
	iacute => 600,
	icircumflex => 600,
	idieresis => 600,
	igrave => 600,
	imacron => 600,
	iogonek => 600,
	j => 600,
	k => 600,
	kcommaaccent => 600,
	l => 600,
	lacute => 600,
	lcaron => 600,
	lcommaaccent => 600,
	less => 600,
	lessequal => 600,
	logicalnot => 600,
	lozenge => 600,
	lslash => 600,
	m => 600,
	macron => 600,
	minus => 600,
	mu => 600,
	multiply => 600,
	n => 600,
	nacute => 600,
	ncaron => 600,
	ncommaaccent => 600,
	nine => 600,
	notequal => 600,
	ntilde => 600,
	numbersign => 600,
	o => 600,
	oacute => 600,
	ocircumflex => 600,
	odieresis => 600,
	oe => 600,
	ogonek => 600,
	ograve => 600,
	ohungarumlaut => 600,
	omacron => 600,
	one => 600,
	onehalf => 600,
	onequarter => 600,
	onesuperior => 600,
	ordfeminine => 600,
	ordmasculine => 600,
	oslash => 600,
	otilde => 600,
	p => 600,
	paragraph => 600,
	parenleft => 600,
	parenright => 600,
	partialdiff => 600,
	percent => 600,
	period => 600,
	periodcentered => 600,
	perthousand => 600,
	plus => 600,
	plusminus => 600,
	q => 600,
	question => 600,
	questiondown => 600,
	quotedbl => 600,
	quotedblbase => 600,
	quotedblleft => 600,
	quotedblright => 600,
	quoteleft => 600,
	quoteright => 600,
	quotesinglbase => 600,
	quotesingle => 600,
	r => 600,
	racute => 600,
	radical => 600,
	rcaron => 600,
	rcommaaccent => 600,
	registered => 600,
	ring => 600,
	s => 600,
	sacute => 600,
	scaron => 600,
	scedilla => 600,
	scommaaccent => 600,
	section => 600,
	semicolon => 600,
	seven => 600,
	six => 600,
	slash => 600,
	space => 600,
	sterling => 600,
	summation => 600,
	t => 600,
	tcaron => 600,
	tcommaaccent => 600,
	thorn => 600,
	three => 600,
	threequarters => 600,
	threesuperior => 600,
	tilde => 600,
	trademark => 600,
	two => 600,
	twosuperior => 600,
	u => 600,
	uacute => 600,
	ucircumflex => 600,
	udieresis => 600,
	ugrave => 600,
	uhungarumlaut => 600,
	umacron => 600,
	underscore => 600,
	uogonek => 600,
	uring => 600,
	v => 600,
	w => 600,
	x => 600,
	y => 600,
	yacute => 600,
	ydieresis => 600,
	yen => 600,
	z => 600,
	zacute => 600,
	zcaron => 600,
	zdotaccent => 600,
	zero => 600,
	};
}
sub afmwx_Courier_Oblique {
	return {
	A => 600,
	AE => 600,
	Aacute => 600,
	Abreve => 600,
	Acircumflex => 600,
	Adieresis => 600,
	Agrave => 600,
	Amacron => 600,
	Aogonek => 600,
	Aring => 600,
	Atilde => 600,
	B => 600,
	C => 600,
	Cacute => 600,
	Ccaron => 600,
	Ccedilla => 600,
	D => 600,
	Dcaron => 600,
	Dcroat => 600,
	Delta => 600,
	E => 600,
	Eacute => 600,
	Ecaron => 600,
	Ecircumflex => 600,
	Edieresis => 600,
	Edotaccent => 600,
	Egrave => 600,
	Emacron => 600,
	Eogonek => 600,
	Eth => 600,
	Euro => 600,
	F => 600,
	G => 600,
	Gbreve => 600,
	Gcommaaccent => 600,
	H => 600,
	I => 600,
	Iacute => 600,
	Icircumflex => 600,
	Idieresis => 600,
	Idotaccent => 600,
	Igrave => 600,
	Imacron => 600,
	Iogonek => 600,
	J => 600,
	K => 600,
	Kcommaaccent => 600,
	L => 600,
	Lacute => 600,
	Lcaron => 600,
	Lcommaaccent => 600,
	Lslash => 600,
	M => 600,
	N => 600,
	Nacute => 600,
	Ncaron => 600,
	Ncommaaccent => 600,
	Ntilde => 600,
	O => 600,
	OE => 600,
	Oacute => 600,
	Ocircumflex => 600,
	Odieresis => 600,
	Ograve => 600,
	Ohungarumlaut => 600,
	Omacron => 600,
	Oslash => 600,
	Otilde => 600,
	P => 600,
	Q => 600,
	R => 600,
	Racute => 600,
	Rcaron => 600,
	Rcommaaccent => 600,
	S => 600,
	Sacute => 600,
	Scaron => 600,
	Scedilla => 600,
	Scommaaccent => 600,
	T => 600,
	Tcaron => 600,
	Tcommaaccent => 600,
	Thorn => 600,
	U => 600,
	Uacute => 600,
	Ucircumflex => 600,
	Udieresis => 600,
	Ugrave => 600,
	Uhungarumlaut => 600,
	Umacron => 600,
	Uogonek => 600,
	Uring => 600,
	V => 600,
	W => 600,
	X => 600,
	Y => 600,
	Yacute => 600,
	Ydieresis => 600,
	Z => 600,
	Zacute => 600,
	Zcaron => 600,
	Zdotaccent => 600,
	a => 600,
	aacute => 600,
	abreve => 600,
	acircumflex => 600,
	acute => 600,
	adieresis => 600,
	ae => 600,
	agrave => 600,
	amacron => 600,
	ampersand => 600,
	aogonek => 600,
	aring => 600,
	asciicircum => 600,
	asciitilde => 600,
	asterisk => 600,
	at => 600,
	atilde => 600,
	b => 600,
	backslash => 600,
	bar => 600,
	braceleft => 600,
	braceright => 600,
	bracketleft => 600,
	bracketright => 600,
	breve => 600,
	brokenbar => 600,
	bullet => 600,
	c => 600,
	cacute => 600,
	caron => 600,
	ccaron => 600,
	ccedilla => 600,
	cedilla => 600,
	cent => 600,
	circumflex => 600,
	colon => 600,
	comma => 600,
	commaaccent => 600,
	copyright => 600,
	currency => 600,
	d => 600,
	dagger => 600,
	daggerdbl => 600,
	dcaron => 600,
	dcroat => 600,
	degree => 600,
	dieresis => 600,
	divide => 600,
	dollar => 600,
	dotaccent => 600,
	dotlessi => 600,
	e => 600,
	eacute => 600,
	ecaron => 600,
	ecircumflex => 600,
	edieresis => 600,
	edotaccent => 600,
	egrave => 600,
	eight => 600,
	ellipsis => 600,
	emacron => 600,
	emdash => 600,
	endash => 600,
	eogonek => 600,
	equal => 600,
	eth => 600,
	exclam => 600,
	exclamdown => 600,
	f => 600,
	fi => 600,
	five => 600,
	fl => 600,
	florin => 600,
	four => 600,
	fraction => 600,
	g => 600,
	gbreve => 600,
	gcommaaccent => 600,
	germandbls => 600,
	grave => 600,
	greater => 600,
	greaterequal => 600,
	guillemotleft => 600,
	guillemotright => 600,
	guilsinglleft => 600,
	guilsinglright => 600,
	h => 600,
	hungarumlaut => 600,
	hyphen => 600,
	i => 600,
	iacute => 600,
	icircumflex => 600,
	idieresis => 600,
	igrave => 600,
	imacron => 600,
	iogonek => 600,
	j => 600,
	k => 600,
	kcommaaccent => 600,
	l => 600,
	lacute => 600,
	lcaron => 600,
	lcommaaccent => 600,
	less => 600,
	lessequal => 600,
	logicalnot => 600,
	lozenge => 600,
	lslash => 600,
	m => 600,
	macron => 600,
	minus => 600,
	mu => 600,
	multiply => 600,
	n => 600,
	nacute => 600,
	ncaron => 600,
	ncommaaccent => 600,
	nine => 600,
	notequal => 600,
	ntilde => 600,
	numbersign => 600,
	o => 600,
	oacute => 600,
	ocircumflex => 600,
	odieresis => 600,
	oe => 600,
	ogonek => 600,
	ograve => 600,
	ohungarumlaut => 600,
	omacron => 600,
	one => 600,
	onehalf => 600,
	onequarter => 600,
	onesuperior => 600,
	ordfeminine => 600,
	ordmasculine => 600,
	oslash => 600,
	otilde => 600,
	p => 600,
	paragraph => 600,
	parenleft => 600,
	parenright => 600,
	partialdiff => 600,
	percent => 600,
	period => 600,
	periodcentered => 600,
	perthousand => 600,
	plus => 600,
	plusminus => 600,
	q => 600,
	question => 600,
	questiondown => 600,
	quotedbl => 600,
	quotedblbase => 600,
	quotedblleft => 600,
	quotedblright => 600,
	quoteleft => 600,
	quoteright => 600,
	quotesinglbase => 600,
	quotesingle => 600,
	r => 600,
	racute => 600,
	radical => 600,
	rcaron => 600,
	rcommaaccent => 600,
	registered => 600,
	ring => 600,
	s => 600,
	sacute => 600,
	scaron => 600,
	scedilla => 600,
	scommaaccent => 600,
	section => 600,
	semicolon => 600,
	seven => 600,
	six => 600,
	slash => 600,
	space => 600,
	sterling => 600,
	summation => 600,
	t => 600,
	tcaron => 600,
	tcommaaccent => 600,
	thorn => 600,
	three => 600,
	threequarters => 600,
	threesuperior => 600,
	tilde => 600,
	trademark => 600,
	two => 600,
	twosuperior => 600,
	u => 600,
	uacute => 600,
	ucircumflex => 600,
	udieresis => 600,
	ugrave => 600,
	uhungarumlaut => 600,
	umacron => 600,
	underscore => 600,
	uogonek => 600,
	uring => 600,
	v => 600,
	w => 600,
	x => 600,
	y => 600,
	yacute => 600,
	ydieresis => 600,
	yen => 600,
	z => 600,
	zacute => 600,
	zcaron => 600,
	zdotaccent => 600,
	zero => 600,
	};
}
sub afmwx_Helvetica {
	return {
	A => 667,
	AE => 1000,
	Aacute => 667,
	Abreve => 667,
	Acircumflex => 667,
	Adieresis => 667,
	Agrave => 667,
	Amacron => 667,
	Aogonek => 667,
	Aring => 667,
	Atilde => 667,
	B => 667,
	C => 722,
	Cacute => 722,
	Ccaron => 722,
	Ccedilla => 722,
	D => 722,
	Dcaron => 722,
	Dcroat => 722,
	Delta => 612,
	E => 667,
	Eacute => 667,
	Ecaron => 667,
	Ecircumflex => 667,
	Edieresis => 667,
	Edotaccent => 667,
	Egrave => 667,
	Emacron => 667,
	Eogonek => 667,
	Eth => 722,
	Euro => 556,
	F => 611,
	G => 778,
	Gbreve => 778,
	Gcommaaccent => 778,
	H => 722,
	I => 278,
	Iacute => 278,
	Icircumflex => 278,
	Idieresis => 278,
	Idotaccent => 278,
	Igrave => 278,
	Imacron => 278,
	Iogonek => 278,
	J => 500,
	K => 667,
	Kcommaaccent => 667,
	L => 556,
	Lacute => 556,
	Lcaron => 556,
	Lcommaaccent => 556,
	Lslash => 556,
	M => 833,
	N => 722,
	Nacute => 722,
	Ncaron => 722,
	Ncommaaccent => 722,
	Ntilde => 722,
	O => 778,
	OE => 1000,
	Oacute => 778,
	Ocircumflex => 778,
	Odieresis => 778,
	Ograve => 778,
	Ohungarumlaut => 778,
	Omacron => 778,
	Oslash => 778,
	Otilde => 778,
	P => 667,
	Q => 778,
	R => 722,
	Racute => 722,
	Rcaron => 722,
	Rcommaaccent => 722,
	S => 667,
	Sacute => 667,
	Scaron => 667,
	Scedilla => 667,
	Scommaaccent => 667,
	T => 611,
	Tcaron => 611,
	Tcommaaccent => 611,
	Thorn => 667,
	U => 722,
	Uacute => 722,
	Ucircumflex => 722,
	Udieresis => 722,
	Ugrave => 722,
	Uhungarumlaut => 722,
	Umacron => 722,
	Uogonek => 722,
	Uring => 722,
	V => 667,
	W => 944,
	X => 667,
	Y => 667,
	Yacute => 667,
	Ydieresis => 667,
	Z => 611,
	Zacute => 611,
	Zcaron => 611,
	Zdotaccent => 611,
	a => 556,
	aacute => 556,
	abreve => 556,
	acircumflex => 556,
	acute => 333,
	adieresis => 556,
	ae => 889,
	agrave => 556,
	amacron => 556,
	ampersand => 667,
	aogonek => 556,
	aring => 556,
	asciicircum => 469,
	asciitilde => 584,
	asterisk => 389,
	at => 1015,
	atilde => 556,
	b => 556,
	backslash => 278,
	bar => 260,
	braceleft => 334,
	braceright => 334,
	bracketleft => 278,
	bracketright => 278,
	breve => 333,
	brokenbar => 260,
	bullet => 350,
	c => 500,
	cacute => 500,
	caron => 333,
	ccaron => 500,
	ccedilla => 500,
	cedilla => 333,
	cent => 556,
	circumflex => 333,
	colon => 278,
	comma => 278,
	commaaccent => 250,
	copyright => 737,
	currency => 556,
	d => 556,
	dagger => 556,
	daggerdbl => 556,
	dcaron => 643,
	dcroat => 556,
	degree => 400,
	dieresis => 333,
	divide => 584,
	dollar => 556,
	dotaccent => 333,
	dotlessi => 278,
	e => 556,
	eacute => 556,
	ecaron => 556,
	ecircumflex => 556,
	edieresis => 556,
	edotaccent => 556,
	egrave => 556,
	eight => 556,
	ellipsis => 1000,
	emacron => 556,
	emdash => 1000,
	endash => 556,
	eogonek => 556,
	equal => 584,
	eth => 556,
	exclam => 278,
	exclamdown => 333,
	f => 278,
	fi => 500,
	five => 556,
	fl => 500,
	florin => 556,
	four => 556,
	fraction => 167,
	g => 556,
	gbreve => 556,
	gcommaaccent => 556,
	germandbls => 611,
	grave => 333,
	greater => 584,
	greaterequal => 549,
	guillemotleft => 556,
	guillemotright => 556,
	guilsinglleft => 333,
	guilsinglright => 333,
	h => 556,
	hungarumlaut => 333,
	hyphen => 333,
	i => 222,
	iacute => 278,
	icircumflex => 278,
	idieresis => 278,
	igrave => 278,
	imacron => 278,
	iogonek => 222,
	j => 222,
	k => 500,
	kcommaaccent => 500,
	l => 222,
	lacute => 222,
	lcaron => 299,
	lcommaaccent => 222,
	less => 584,
	lessequal => 549,
	logicalnot => 584,
	lozenge => 471,
	lslash => 222,
	m => 833,
	macron => 333,
	minus => 584,
	mu => 556,
	multiply => 584,
	n => 556,
	nacute => 556,
	ncaron => 556,
	ncommaaccent => 556,
	nine => 556,
	notequal => 549,
	ntilde => 556,
	numbersign => 556,
	o => 556,
	oacute => 556,
	ocircumflex => 556,
	odieresis => 556,
	oe => 944,
	ogonek => 333,
	ograve => 556,
	ohungarumlaut => 556,
	omacron => 556,
	one => 556,
	onehalf => 834,
	onequarter => 834,
	onesuperior => 333,
	ordfeminine => 370,
	ordmasculine => 365,
	oslash => 611,
	otilde => 556,
	p => 556,
	paragraph => 537,
	parenleft => 333,
	parenright => 333,
	partialdiff => 476,
	percent => 889,
	period => 278,
	periodcentered => 278,
	perthousand => 1000,
	plus => 584,
	plusminus => 584,
	q => 556,
	question => 556,
	questiondown => 611,
	quotedbl => 355,
	quotedblbase => 333,
	quotedblleft => 333,
	quotedblright => 333,
	quoteleft => 222,
	quoteright => 222,
	quotesinglbase => 222,
	quotesingle => 191,
	r => 333,
	racute => 333,
	radical => 453,
	rcaron => 333,
	rcommaaccent => 333,
	registered => 737,
	ring => 333,
	s => 500,
	sacute => 500,
	scaron => 500,
	scedilla => 500,
	scommaaccent => 500,
	section => 556,
	semicolon => 278,
	seven => 556,
	six => 556,
	slash => 278,
	space => 278,
	sterling => 556,
	summation => 600,
	t => 278,
	tcaron => 317,
	tcommaaccent => 278,
	thorn => 556,
	three => 556,
	threequarters => 834,
	threesuperior => 333,
	tilde => 333,
	trademark => 1000,
	two => 556,
	twosuperior => 333,
	u => 556,
	uacute => 556,
	ucircumflex => 556,
	udieresis => 556,
	ugrave => 556,
	uhungarumlaut => 556,
	umacron => 556,
	underscore => 556,
	uogonek => 556,
	uring => 556,
	v => 500,
	w => 722,
	x => 500,
	y => 500,
	yacute => 500,
	ydieresis => 500,
	yen => 556,
	z => 500,
	zacute => 500,
	zcaron => 500,
	zdotaccent => 500,
	zero => 556,
	};
}
sub afmwx_Helvetica_Bold {
	return {
	A => 722,
	AE => 1000,
	Aacute => 722,
	Abreve => 722,
	Acircumflex => 722,
	Adieresis => 722,
	Agrave => 722,
	Amacron => 722,
	Aogonek => 722,
	Aring => 722,
	Atilde => 722,
	B => 722,
	C => 722,
	Cacute => 722,
	Ccaron => 722,
	Ccedilla => 722,
	D => 722,
	Dcaron => 722,
	Dcroat => 722,
	Delta => 612,
	E => 667,
	Eacute => 667,
	Ecaron => 667,
	Ecircumflex => 667,
	Edieresis => 667,
	Edotaccent => 667,
	Egrave => 667,
	Emacron => 667,
	Eogonek => 667,
	Eth => 722,
	Euro => 556,
	F => 611,
	G => 778,
	Gbreve => 778,
	Gcommaaccent => 778,
	H => 722,
	I => 278,
	Iacute => 278,
	Icircumflex => 278,
	Idieresis => 278,
	Idotaccent => 278,
	Igrave => 278,
	Imacron => 278,
	Iogonek => 278,
	J => 556,
	K => 722,
	Kcommaaccent => 722,
	L => 611,
	Lacute => 611,
	Lcaron => 611,
	Lcommaaccent => 611,
	Lslash => 611,
	M => 833,
	N => 722,
	Nacute => 722,
	Ncaron => 722,
	Ncommaaccent => 722,
	Ntilde => 722,
	O => 778,
	OE => 1000,
	Oacute => 778,
	Ocircumflex => 778,
	Odieresis => 778,
	Ograve => 778,
	Ohungarumlaut => 778,
	Omacron => 778,
	Oslash => 778,
	Otilde => 778,
	P => 667,
	Q => 778,
	R => 722,
	Racute => 722,
	Rcaron => 722,
	Rcommaaccent => 722,
	S => 667,
	Sacute => 667,
	Scaron => 667,
	Scedilla => 667,
	Scommaaccent => 667,
	T => 611,
	Tcaron => 611,
	Tcommaaccent => 611,
	Thorn => 667,
	U => 722,
	Uacute => 722,
	Ucircumflex => 722,
	Udieresis => 722,
	Ugrave => 722,
	Uhungarumlaut => 722,
	Umacron => 722,
	Uogonek => 722,
	Uring => 722,
	V => 667,
	W => 944,
	X => 667,
	Y => 667,
	Yacute => 667,
	Ydieresis => 667,
	Z => 611,
	Zacute => 611,
	Zcaron => 611,
	Zdotaccent => 611,
	a => 556,
	aacute => 556,
	abreve => 556,
	acircumflex => 556,
	acute => 333,
	adieresis => 556,
	ae => 889,
	agrave => 556,
	amacron => 556,
	ampersand => 722,
	aogonek => 556,
	aring => 556,
	asciicircum => 584,
	asciitilde => 584,
	asterisk => 389,
	at => 975,
	atilde => 556,
	b => 611,
	backslash => 278,
	bar => 280,
	braceleft => 389,
	braceright => 389,
	bracketleft => 333,
	bracketright => 333,
	breve => 333,
	brokenbar => 280,
	bullet => 350,
	c => 556,
	cacute => 556,
	caron => 333,
	ccaron => 556,
	ccedilla => 556,
	cedilla => 333,
	cent => 556,
	circumflex => 333,
	colon => 333,
	comma => 278,
	commaaccent => 250,
	copyright => 737,
	currency => 556,
	d => 611,
	dagger => 556,
	daggerdbl => 556,
	dcaron => 743,
	dcroat => 611,
	degree => 400,
	dieresis => 333,
	divide => 584,
	dollar => 556,
	dotaccent => 333,
	dotlessi => 278,
	e => 556,
	eacute => 556,
	ecaron => 556,
	ecircumflex => 556,
	edieresis => 556,
	edotaccent => 556,
	egrave => 556,
	eight => 556,
	ellipsis => 1000,
	emacron => 556,
	emdash => 1000,
	endash => 556,
	eogonek => 556,
	equal => 584,
	eth => 611,
	exclam => 333,
	exclamdown => 333,
	f => 333,
	fi => 611,
	five => 556,
	fl => 611,
	florin => 556,
	four => 556,
	fraction => 167,
	g => 611,
	gbreve => 611,
	gcommaaccent => 611,
	germandbls => 611,
	grave => 333,
	greater => 584,
	greaterequal => 549,
	guillemotleft => 556,
	guillemotright => 556,
	guilsinglleft => 333,
	guilsinglright => 333,
	h => 611,
	hungarumlaut => 333,
	hyphen => 333,
	i => 278,
	iacute => 278,
	icircumflex => 278,
	idieresis => 278,
	igrave => 278,
	imacron => 278,
	iogonek => 278,
	j => 278,
	k => 556,
	kcommaaccent => 556,
	l => 278,
	lacute => 278,
	lcaron => 400,
	lcommaaccent => 278,
	less => 584,
	lessequal => 549,
	logicalnot => 584,
	lozenge => 494,
	lslash => 278,
	m => 889,
	macron => 333,
	minus => 584,
	mu => 611,
	multiply => 584,
	n => 611,
	nacute => 611,
	ncaron => 611,
	ncommaaccent => 611,
	nine => 556,
	notequal => 549,
	ntilde => 611,
	numbersign => 556,
	o => 611,
	oacute => 611,
	ocircumflex => 611,
	odieresis => 611,
	oe => 944,
	ogonek => 333,
	ograve => 611,
	ohungarumlaut => 611,
	omacron => 611,
	one => 556,
	onehalf => 834,
	onequarter => 834,
	onesuperior => 333,
	ordfeminine => 370,
	ordmasculine => 365,
	oslash => 611,
	otilde => 611,
	p => 611,
	paragraph => 556,
	parenleft => 333,
	parenright => 333,
	partialdiff => 494,
	percent => 889,
	period => 278,
	periodcentered => 278,
	perthousand => 1000,
	plus => 584,
	plusminus => 584,
	q => 611,
	question => 611,
	questiondown => 611,
	quotedbl => 474,
	quotedblbase => 500,
	quotedblleft => 500,
	quotedblright => 500,
	quoteleft => 278,
	quoteright => 278,
	quotesinglbase => 278,
	quotesingle => 238,
	r => 389,
	racute => 389,
	radical => 549,
	rcaron => 389,
	rcommaaccent => 389,
	registered => 737,
	ring => 333,
	s => 556,
	sacute => 556,
	scaron => 556,
	scedilla => 556,
	scommaaccent => 556,
	section => 556,
	semicolon => 333,
	seven => 556,
	six => 556,
	slash => 278,
	space => 278,
	sterling => 556,
	summation => 600,
	t => 333,
	tcaron => 389,
	tcommaaccent => 333,
	thorn => 611,
	three => 556,
	threequarters => 834,
	threesuperior => 333,
	tilde => 333,
	trademark => 1000,
	two => 556,
	twosuperior => 333,
	u => 611,
	uacute => 611,
	ucircumflex => 611,
	udieresis => 611,
	ugrave => 611,
	uhungarumlaut => 611,
	umacron => 611,
	underscore => 556,
	uogonek => 611,
	uring => 611,
	v => 556,
	w => 778,
	x => 556,
	y => 556,
	yacute => 556,
	ydieresis => 556,
	yen => 556,
	z => 500,
	zacute => 500,
	zcaron => 500,
	zdotaccent => 500,
	zero => 556,
	};
}
sub afmwx_Helvetica_BoldOblique {
	return {
	A => 722,
	AE => 1000,
	Aacute => 722,
	Abreve => 722,
	Acircumflex => 722,
	Adieresis => 722,
	Agrave => 722,
	Amacron => 722,
	Aogonek => 722,
	Aring => 722,
	Atilde => 722,
	B => 722,
	C => 722,
	Cacute => 722,
	Ccaron => 722,
	Ccedilla => 722,
	D => 722,
	Dcaron => 722,
	Dcroat => 722,
	Delta => 612,
	E => 667,
	Eacute => 667,
	Ecaron => 667,
	Ecircumflex => 667,
	Edieresis => 667,
	Edotaccent => 667,
	Egrave => 667,
	Emacron => 667,
	Eogonek => 667,
	Eth => 722,
	Euro => 556,
	F => 611,
	G => 778,
	Gbreve => 778,
	Gcommaaccent => 778,
	H => 722,
	I => 278,
	Iacute => 278,
	Icircumflex => 278,
	Idieresis => 278,
	Idotaccent => 278,
	Igrave => 278,
	Imacron => 278,
	Iogonek => 278,
	J => 556,
	K => 722,
	Kcommaaccent => 722,
	L => 611,
	Lacute => 611,
	Lcaron => 611,
	Lcommaaccent => 611,
	Lslash => 611,
	M => 833,
	N => 722,
	Nacute => 722,
	Ncaron => 722,
	Ncommaaccent => 722,
	Ntilde => 722,
	O => 778,
	OE => 1000,
	Oacute => 778,
	Ocircumflex => 778,
	Odieresis => 778,
	Ograve => 778,
	Ohungarumlaut => 778,
	Omacron => 778,
	Oslash => 778,
	Otilde => 778,
	P => 667,
	Q => 778,
	R => 722,
	Racute => 722,
	Rcaron => 722,
	Rcommaaccent => 722,
	S => 667,
	Sacute => 667,
	Scaron => 667,
	Scedilla => 667,
	Scommaaccent => 667,
	T => 611,
	Tcaron => 611,
	Tcommaaccent => 611,
	Thorn => 667,
	U => 722,
	Uacute => 722,
	Ucircumflex => 722,
	Udieresis => 722,
	Ugrave => 722,
	Uhungarumlaut => 722,
	Umacron => 722,
	Uogonek => 722,
	Uring => 722,
	V => 667,
	W => 944,
	X => 667,
	Y => 667,
	Yacute => 667,
	Ydieresis => 667,
	Z => 611,
	Zacute => 611,
	Zcaron => 611,
	Zdotaccent => 611,
	a => 556,
	aacute => 556,
	abreve => 556,
	acircumflex => 556,
	acute => 333,
	adieresis => 556,
	ae => 889,
	agrave => 556,
	amacron => 556,
	ampersand => 722,
	aogonek => 556,
	aring => 556,
	asciicircum => 584,
	asciitilde => 584,
	asterisk => 389,
	at => 975,
	atilde => 556,
	b => 611,
	backslash => 278,
	bar => 280,
	braceleft => 389,
	braceright => 389,
	bracketleft => 333,
	bracketright => 333,
	breve => 333,
	brokenbar => 280,
	bullet => 350,
	c => 556,
	cacute => 556,
	caron => 333,
	ccaron => 556,
	ccedilla => 556,
	cedilla => 333,
	cent => 556,
	circumflex => 333,
	colon => 333,
	comma => 278,
	commaaccent => 250,
	copyright => 737,
	currency => 556,
	d => 611,
	dagger => 556,
	daggerdbl => 556,
	dcaron => 743,
	dcroat => 611,
	degree => 400,
	dieresis => 333,
	divide => 584,
	dollar => 556,
	dotaccent => 333,
	dotlessi => 278,
	e => 556,
	eacute => 556,
	ecaron => 556,
	ecircumflex => 556,
	edieresis => 556,
	edotaccent => 556,
	egrave => 556,
	eight => 556,
	ellipsis => 1000,
	emacron => 556,
	emdash => 1000,
	endash => 556,
	eogonek => 556,
	equal => 584,
	eth => 611,
	exclam => 333,
	exclamdown => 333,
	f => 333,
	fi => 611,
	five => 556,
	fl => 611,
	florin => 556,
	four => 556,
	fraction => 167,
	g => 611,
	gbreve => 611,
	gcommaaccent => 611,
	germandbls => 611,
	grave => 333,
	greater => 584,
	greaterequal => 549,
	guillemotleft => 556,
	guillemotright => 556,
	guilsinglleft => 333,
	guilsinglright => 333,
	h => 611,
	hungarumlaut => 333,
	hyphen => 333,
	i => 278,
	iacute => 278,
	icircumflex => 278,
	idieresis => 278,
	igrave => 278,
	imacron => 278,
	iogonek => 278,
	j => 278,
	k => 556,
	kcommaaccent => 556,
	l => 278,
	lacute => 278,
	lcaron => 400,
	lcommaaccent => 278,
	less => 584,
	lessequal => 549,
	logicalnot => 584,
	lozenge => 494,
	lslash => 278,
	m => 889,
	macron => 333,
	minus => 584,
	mu => 611,
	multiply => 584,
	n => 611,
	nacute => 611,
	ncaron => 611,
	ncommaaccent => 611,
	nine => 556,
	notequal => 549,
	ntilde => 611,
	numbersign => 556,
	o => 611,
	oacute => 611,
	ocircumflex => 611,
	odieresis => 611,
	oe => 944,
	ogonek => 333,
	ograve => 611,
	ohungarumlaut => 611,
	omacron => 611,
	one => 556,
	onehalf => 834,
	onequarter => 834,
	onesuperior => 333,
	ordfeminine => 370,
	ordmasculine => 365,
	oslash => 611,
	otilde => 611,
	p => 611,
	paragraph => 556,
	parenleft => 333,
	parenright => 333,
	partialdiff => 494,
	percent => 889,
	period => 278,
	periodcentered => 278,
	perthousand => 1000,
	plus => 584,
	plusminus => 584,
	q => 611,
	question => 611,
	questiondown => 611,
	quotedbl => 474,
	quotedblbase => 500,
	quotedblleft => 500,
	quotedblright => 500,
	quoteleft => 278,
	quoteright => 278,
	quotesinglbase => 278,
	quotesingle => 238,
	r => 389,
	racute => 389,
	radical => 549,
	rcaron => 389,
	rcommaaccent => 389,
	registered => 737,
	ring => 333,
	s => 556,
	sacute => 556,
	scaron => 556,
	scedilla => 556,
	scommaaccent => 556,
	section => 556,
	semicolon => 333,
	seven => 556,
	six => 556,
	slash => 278,
	space => 278,
	sterling => 556,
	summation => 600,
	t => 333,
	tcaron => 389,
	tcommaaccent => 333,
	thorn => 611,
	three => 556,
	threequarters => 834,
	threesuperior => 333,
	tilde => 333,
	trademark => 1000,
	two => 556,
	twosuperior => 333,
	u => 611,
	uacute => 611,
	ucircumflex => 611,
	udieresis => 611,
	ugrave => 611,
	uhungarumlaut => 611,
	umacron => 611,
	underscore => 556,
	uogonek => 611,
	uring => 611,
	v => 556,
	w => 778,
	x => 556,
	y => 556,
	yacute => 556,
	ydieresis => 556,
	yen => 556,
	z => 500,
	zacute => 500,
	zcaron => 500,
	zdotaccent => 500,
	zero => 556,
	};
}
sub afmwx_Helvetica_Oblique {
	return {
	A => 667,
	AE => 1000,
	Aacute => 667,
	Abreve => 667,
	Acircumflex => 667,
	Adieresis => 667,
	Agrave => 667,
	Amacron => 667,
	Aogonek => 667,
	Aring => 667,
	Atilde => 667,
	B => 667,
	C => 722,
	Cacute => 722,
	Ccaron => 722,
	Ccedilla => 722,
	D => 722,
	Dcaron => 722,
	Dcroat => 722,
	Delta => 612,
	E => 667,
	Eacute => 667,
	Ecaron => 667,
	Ecircumflex => 667,
	Edieresis => 667,
	Edotaccent => 667,
	Egrave => 667,
	Emacron => 667,
	Eogonek => 667,
	Eth => 722,
	Euro => 556,
	F => 611,
	G => 778,
	Gbreve => 778,
	Gcommaaccent => 778,
	H => 722,
	I => 278,
	Iacute => 278,
	Icircumflex => 278,
	Idieresis => 278,
	Idotaccent => 278,
	Igrave => 278,
	Imacron => 278,
	Iogonek => 278,
	J => 500,
	K => 667,
	Kcommaaccent => 667,
	L => 556,
	Lacute => 556,
	Lcaron => 556,
	Lcommaaccent => 556,
	Lslash => 556,
	M => 833,
	N => 722,
	Nacute => 722,
	Ncaron => 722,
	Ncommaaccent => 722,
	Ntilde => 722,
	O => 778,
	OE => 1000,
	Oacute => 778,
	Ocircumflex => 778,
	Odieresis => 778,
	Ograve => 778,
	Ohungarumlaut => 778,
	Omacron => 778,
	Oslash => 778,
	Otilde => 778,
	P => 667,
	Q => 778,
	R => 722,
	Racute => 722,
	Rcaron => 722,
	Rcommaaccent => 722,
	S => 667,
	Sacute => 667,
	Scaron => 667,
	Scedilla => 667,
	Scommaaccent => 667,
	T => 611,
	Tcaron => 611,
	Tcommaaccent => 611,
	Thorn => 667,
	U => 722,
	Uacute => 722,
	Ucircumflex => 722,
	Udieresis => 722,
	Ugrave => 722,
	Uhungarumlaut => 722,
	Umacron => 722,
	Uogonek => 722,
	Uring => 722,
	V => 667,
	W => 944,
	X => 667,
	Y => 667,
	Yacute => 667,
	Ydieresis => 667,
	Z => 611,
	Zacute => 611,
	Zcaron => 611,
	Zdotaccent => 611,
	a => 556,
	aacute => 556,
	abreve => 556,
	acircumflex => 556,
	acute => 333,
	adieresis => 556,
	ae => 889,
	agrave => 556,
	amacron => 556,
	ampersand => 667,
	aogonek => 556,
	aring => 556,
	asciicircum => 469,
	asciitilde => 584,
	asterisk => 389,
	at => 1015,
	atilde => 556,
	b => 556,
	backslash => 278,
	bar => 260,
	braceleft => 334,
	braceright => 334,
	bracketleft => 278,
	bracketright => 278,
	breve => 333,
	brokenbar => 260,
	bullet => 350,
	c => 500,
	cacute => 500,
	caron => 333,
	ccaron => 500,
	ccedilla => 500,
	cedilla => 333,
	cent => 556,
	circumflex => 333,
	colon => 278,
	comma => 278,
	commaaccent => 250,
	copyright => 737,
	currency => 556,
	d => 556,
	dagger => 556,
	daggerdbl => 556,
	dcaron => 643,
	dcroat => 556,
	degree => 400,
	dieresis => 333,
	divide => 584,
	dollar => 556,
	dotaccent => 333,
	dotlessi => 278,
	e => 556,
	eacute => 556,
	ecaron => 556,
	ecircumflex => 556,
	edieresis => 556,
	edotaccent => 556,
	egrave => 556,
	eight => 556,
	ellipsis => 1000,
	emacron => 556,
	emdash => 1000,
	endash => 556,
	eogonek => 556,
	equal => 584,
	eth => 556,
	exclam => 278,
	exclamdown => 333,
	f => 278,
	fi => 500,
	five => 556,
	fl => 500,
	florin => 556,
	four => 556,
	fraction => 167,
	g => 556,
	gbreve => 556,
	gcommaaccent => 556,
	germandbls => 611,
	grave => 333,
	greater => 584,
	greaterequal => 549,
	guillemotleft => 556,
	guillemotright => 556,
	guilsinglleft => 333,
	guilsinglright => 333,
	h => 556,
	hungarumlaut => 333,
	hyphen => 333,
	i => 222,
	iacute => 278,
	icircumflex => 278,
	idieresis => 278,
	igrave => 278,
	imacron => 278,
	iogonek => 222,
	j => 222,
	k => 500,
	kcommaaccent => 500,
	l => 222,
	lacute => 222,
	lcaron => 299,
	lcommaaccent => 222,
	less => 584,
	lessequal => 549,
	logicalnot => 584,
	lozenge => 471,
	lslash => 222,
	m => 833,
	macron => 333,
	minus => 584,
	mu => 556,
	multiply => 584,
	n => 556,
	nacute => 556,
	ncaron => 556,
	ncommaaccent => 556,
	nine => 556,
	notequal => 549,
	ntilde => 556,
	numbersign => 556,
	o => 556,
	oacute => 556,
	ocircumflex => 556,
	odieresis => 556,
	oe => 944,
	ogonek => 333,
	ograve => 556,
	ohungarumlaut => 556,
	omacron => 556,
	one => 556,
	onehalf => 834,
	onequarter => 834,
	onesuperior => 333,
	ordfeminine => 370,
	ordmasculine => 365,
	oslash => 611,
	otilde => 556,
	p => 556,
	paragraph => 537,
	parenleft => 333,
	parenright => 333,
	partialdiff => 476,
	percent => 889,
	period => 278,
	periodcentered => 278,
	perthousand => 1000,
	plus => 584,
	plusminus => 584,
	q => 556,
	question => 556,
	questiondown => 611,
	quotedbl => 355,
	quotedblbase => 333,
	quotedblleft => 333,
	quotedblright => 333,
	quoteleft => 222,
	quoteright => 222,
	quotesinglbase => 222,
	quotesingle => 191,
	r => 333,
	racute => 333,
	radical => 453,
	rcaron => 333,
	rcommaaccent => 333,
	registered => 737,
	ring => 333,
	s => 500,
	sacute => 500,
	scaron => 500,
	scedilla => 500,
	scommaaccent => 500,
	section => 556,
	semicolon => 278,
	seven => 556,
	six => 556,
	slash => 278,
	space => 278,
	sterling => 556,
	summation => 600,
	t => 278,
	tcaron => 317,
	tcommaaccent => 278,
	thorn => 556,
	three => 556,
	threequarters => 834,
	threesuperior => 333,
	tilde => 333,
	trademark => 1000,
	two => 556,
	twosuperior => 333,
	u => 556,
	uacute => 556,
	ucircumflex => 556,
	udieresis => 556,
	ugrave => 556,
	uhungarumlaut => 556,
	umacron => 556,
	underscore => 556,
	uogonek => 556,
	uring => 556,
	v => 500,
	w => 722,
	x => 500,
	y => 500,
	yacute => 500,
	ydieresis => 500,
	yen => 556,
	z => 500,
	zacute => 500,
	zcaron => 500,
	zdotaccent => 500,
	zero => 556,
	};
}
sub afmwx_Times_Bold {
	return {
	A => 722,
	AE => 1000,
	Aacute => 722,
	Abreve => 722,
	Acircumflex => 722,
	Adieresis => 722,
	Agrave => 722,
	Amacron => 722,
	Aogonek => 722,
	Aring => 722,
	Atilde => 722,
	B => 667,
	C => 722,
	Cacute => 722,
	Ccaron => 722,
	Ccedilla => 722,
	D => 722,
	Dcaron => 722,
	Dcroat => 722,
	Delta => 612,
	E => 667,
	Eacute => 667,
	Ecaron => 667,
	Ecircumflex => 667,
	Edieresis => 667,
	Edotaccent => 667,
	Egrave => 667,
	Emacron => 667,
	Eogonek => 667,
	Eth => 722,
	Euro => 500,
	F => 611,
	G => 778,
	Gbreve => 778,
	Gcommaaccent => 778,
	H => 778,
	I => 389,
	Iacute => 389,
	Icircumflex => 389,
	Idieresis => 389,
	Idotaccent => 389,
	Igrave => 389,
	Imacron => 389,
	Iogonek => 389,
	J => 500,
	K => 778,
	Kcommaaccent => 778,
	L => 667,
	Lacute => 667,
	Lcaron => 667,
	Lcommaaccent => 667,
	Lslash => 667,
	M => 944,
	N => 722,
	Nacute => 722,
	Ncaron => 722,
	Ncommaaccent => 722,
	Ntilde => 722,
	O => 778,
	OE => 1000,
	Oacute => 778,
	Ocircumflex => 778,
	Odieresis => 778,
	Ograve => 778,
	Ohungarumlaut => 778,
	Omacron => 778,
	Oslash => 778,
	Otilde => 778,
	P => 611,
	Q => 778,
	R => 722,
	Racute => 722,
	Rcaron => 722,
	Rcommaaccent => 722,
	S => 556,
	Sacute => 556,
	Scaron => 556,
	Scedilla => 556,
	Scommaaccent => 556,
	T => 667,
	Tcaron => 667,
	Tcommaaccent => 667,
	Thorn => 611,
	U => 722,
	Uacute => 722,
	Ucircumflex => 722,
	Udieresis => 722,
	Ugrave => 722,
	Uhungarumlaut => 722,
	Umacron => 722,
	Uogonek => 722,
	Uring => 722,
	V => 722,
	W => 1000,
	X => 722,
	Y => 722,
	Yacute => 722,
	Ydieresis => 722,
	Z => 667,
	Zacute => 667,
	Zcaron => 667,
	Zdotaccent => 667,
	a => 500,
	aacute => 500,
	abreve => 500,
	acircumflex => 500,
	acute => 333,
	adieresis => 500,
	ae => 722,
	agrave => 500,
	amacron => 500,
	ampersand => 833,
	aogonek => 500,
	aring => 500,
	asciicircum => 581,
	asciitilde => 520,
	asterisk => 500,
	at => 930,
	atilde => 500,
	b => 556,
	backslash => 278,
	bar => 220,
	braceleft => 394,
	braceright => 394,
	bracketleft => 333,
	bracketright => 333,
	breve => 333,
	brokenbar => 220,
	bullet => 350,
	c => 444,
	cacute => 444,
	caron => 333,
	ccaron => 444,
	ccedilla => 444,
	cedilla => 333,
	cent => 500,
	circumflex => 333,
	colon => 333,
	comma => 250,
	commaaccent => 250,
	copyright => 747,
	currency => 500,
	d => 556,
	dagger => 500,
	daggerdbl => 500,
	dcaron => 672,
	dcroat => 556,
	degree => 400,
	dieresis => 333,
	divide => 570,
	dollar => 500,
	dotaccent => 333,
	dotlessi => 278,
	e => 444,
	eacute => 444,
	ecaron => 444,
	ecircumflex => 444,
	edieresis => 444,
	edotaccent => 444,
	egrave => 444,
	eight => 500,
	ellipsis => 1000,
	emacron => 444,
	emdash => 1000,
	endash => 500,
	eogonek => 444,
	equal => 570,
	eth => 500,
	exclam => 333,
	exclamdown => 333,
	f => 333,
	fi => 556,
	five => 500,
	fl => 556,
	florin => 500,
	four => 500,
	fraction => 167,
	g => 500,
	gbreve => 500,
	gcommaaccent => 500,
	germandbls => 556,
	grave => 333,
	greater => 570,
	greaterequal => 549,
	guillemotleft => 500,
	guillemotright => 500,
	guilsinglleft => 333,
	guilsinglright => 333,
	h => 556,
	hungarumlaut => 333,
	hyphen => 333,
	i => 278,
	iacute => 278,
	icircumflex => 278,
	idieresis => 278,
	igrave => 278,
	imacron => 278,
	iogonek => 278,
	j => 333,
	k => 556,
	kcommaaccent => 556,
	l => 278,
	lacute => 278,
	lcaron => 394,
	lcommaaccent => 278,
	less => 570,
	lessequal => 549,
	logicalnot => 570,
	lozenge => 494,
	lslash => 278,
	m => 833,
	macron => 333,
	minus => 570,
	mu => 556,
	multiply => 570,
	n => 556,
	nacute => 556,
	ncaron => 556,
	ncommaaccent => 556,
	nine => 500,
	notequal => 549,
	ntilde => 556,
	numbersign => 500,
	o => 500,
	oacute => 500,
	ocircumflex => 500,
	odieresis => 500,
	oe => 722,
	ogonek => 333,
	ograve => 500,
	ohungarumlaut => 500,
	omacron => 500,
	one => 500,
	onehalf => 750,
	onequarter => 750,
	onesuperior => 300,
	ordfeminine => 300,
	ordmasculine => 330,
	oslash => 500,
	otilde => 500,
	p => 556,
	paragraph => 540,
	parenleft => 333,
	parenright => 333,
	partialdiff => 494,
	percent => 1000,
	period => 250,
	periodcentered => 250,
	perthousand => 1000,
	plus => 570,
	plusminus => 570,
	q => 556,
	question => 500,
	questiondown => 500,
	quotedbl => 555,
	quotedblbase => 500,
	quotedblleft => 500,
	quotedblright => 500,
	quoteleft => 333,
	quoteright => 333,
	quotesinglbase => 333,
	quotesingle => 278,
	r => 444,
	racute => 444,
	radical => 549,
	rcaron => 444,
	rcommaaccent => 444,
	registered => 747,
	ring => 333,
	s => 389,
	sacute => 389,
	scaron => 389,
	scedilla => 389,
	scommaaccent => 389,
	section => 500,
	semicolon => 333,
	seven => 500,
	six => 500,
	slash => 278,
	space => 250,
	sterling => 500,
	summation => 600,
	t => 333,
	tcaron => 416,
	tcommaaccent => 333,
	thorn => 556,
	three => 500,
	threequarters => 750,
	threesuperior => 300,
	tilde => 333,
	trademark => 1000,
	two => 500,
	twosuperior => 300,
	u => 556,
	uacute => 556,
	ucircumflex => 556,
	udieresis => 556,
	ugrave => 556,
	uhungarumlaut => 556,
	umacron => 556,
	underscore => 500,
	uogonek => 556,
	uring => 556,
	v => 500,
	w => 722,
	x => 500,
	y => 500,
	yacute => 500,
	ydieresis => 500,
	yen => 500,
	z => 444,
	zacute => 444,
	zcaron => 444,
	zdotaccent => 444,
	zero => 500,
	};
}
sub afmwx_Times_BoldItalic {
	return {
	A => 667,
	AE => 944,
	Aacute => 667,
	Abreve => 667,
	Acircumflex => 667,
	Adieresis => 667,
	Agrave => 667,
	Amacron => 667,
	Aogonek => 667,
	Aring => 667,
	Atilde => 667,
	B => 667,
	C => 667,
	Cacute => 667,
	Ccaron => 667,
	Ccedilla => 667,
	D => 722,
	Dcaron => 722,
	Dcroat => 722,
	Delta => 612,
	E => 667,
	Eacute => 667,
	Ecaron => 667,
	Ecircumflex => 667,
	Edieresis => 667,
	Edotaccent => 667,
	Egrave => 667,
	Emacron => 667,
	Eogonek => 667,
	Eth => 722,
	Euro => 500,
	F => 667,
	G => 722,
	Gbreve => 722,
	Gcommaaccent => 722,
	H => 778,
	I => 389,
	Iacute => 389,
	Icircumflex => 389,
	Idieresis => 389,
	Idotaccent => 389,
	Igrave => 389,
	Imacron => 389,
	Iogonek => 389,
	J => 500,
	K => 667,
	Kcommaaccent => 667,
	L => 611,
	Lacute => 611,
	Lcaron => 611,
	Lcommaaccent => 611,
	Lslash => 611,
	M => 889,
	N => 722,
	Nacute => 722,
	Ncaron => 722,
	Ncommaaccent => 722,
	Ntilde => 722,
	O => 722,
	OE => 944,
	Oacute => 722,
	Ocircumflex => 722,
	Odieresis => 722,
	Ograve => 722,
	Ohungarumlaut => 722,
	Omacron => 722,
	Oslash => 722,
	Otilde => 722,
	P => 611,
	Q => 722,
	R => 667,
	Racute => 667,
	Rcaron => 667,
	Rcommaaccent => 667,
	S => 556,
	Sacute => 556,
	Scaron => 556,
	Scedilla => 556,
	Scommaaccent => 556,
	T => 611,
	Tcaron => 611,
	Tcommaaccent => 611,
	Thorn => 611,
	U => 722,
	Uacute => 722,
	Ucircumflex => 722,
	Udieresis => 722,
	Ugrave => 722,
	Uhungarumlaut => 722,
	Umacron => 722,
	Uogonek => 722,
	Uring => 722,
	V => 667,
	W => 889,
	X => 667,
	Y => 611,
	Yacute => 611,
	Ydieresis => 611,
	Z => 611,
	Zacute => 611,
	Zcaron => 611,
	Zdotaccent => 611,
	a => 500,
	aacute => 500,
	abreve => 500,
	acircumflex => 500,
	acute => 333,
	adieresis => 500,
	ae => 722,
	agrave => 500,
	amacron => 500,
	ampersand => 778,
	aogonek => 500,
	aring => 500,
	asciicircum => 570,
	asciitilde => 570,
	asterisk => 500,
	at => 832,
	atilde => 500,
	b => 500,
	backslash => 278,
	bar => 220,
	braceleft => 348,
	braceright => 348,
	bracketleft => 333,
	bracketright => 333,
	breve => 333,
	brokenbar => 220,
	bullet => 350,
	c => 444,
	cacute => 444,
	caron => 333,
	ccaron => 444,
	ccedilla => 444,
	cedilla => 333,
	cent => 500,
	circumflex => 333,
	colon => 333,
	comma => 250,
	commaaccent => 250,
	copyright => 747,
	currency => 500,
	d => 500,
	dagger => 500,
	daggerdbl => 500,
	dcaron => 608,
	dcroat => 500,
	degree => 400,
	dieresis => 333,
	divide => 570,
	dollar => 500,
	dotaccent => 333,
	dotlessi => 278,
	e => 444,
	eacute => 444,
	ecaron => 444,
	ecircumflex => 444,
	edieresis => 444,
	edotaccent => 444,
	egrave => 444,
	eight => 500,
	ellipsis => 1000,
	emacron => 444,
	emdash => 1000,
	endash => 500,
	eogonek => 444,
	equal => 570,
	eth => 500,
	exclam => 389,
	exclamdown => 389,
	f => 333,
	fi => 556,
	five => 500,
	fl => 556,
	florin => 500,
	four => 500,
	fraction => 167,
	g => 500,
	gbreve => 500,
	gcommaaccent => 500,
	germandbls => 500,
	grave => 333,
	greater => 570,
	greaterequal => 549,
	guillemotleft => 500,
	guillemotright => 500,
	guilsinglleft => 333,
	guilsinglright => 333,
	h => 556,
	hungarumlaut => 333,
	hyphen => 333,
	i => 278,
	iacute => 278,
	icircumflex => 278,
	idieresis => 278,
	igrave => 278,
	imacron => 278,
	iogonek => 278,
	j => 278,
	k => 500,
	kcommaaccent => 500,
	l => 278,
	lacute => 278,
	lcaron => 382,
	lcommaaccent => 278,
	less => 570,
	lessequal => 549,
	logicalnot => 606,
	lozenge => 494,
	lslash => 278,
	m => 778,
	macron => 333,
	minus => 606,
	mu => 576,
	multiply => 570,
	n => 556,
	nacute => 556,
	ncaron => 556,
	ncommaaccent => 556,
	nine => 500,
	notequal => 549,
	ntilde => 556,
	numbersign => 500,
	o => 500,
	oacute => 500,
	ocircumflex => 500,
	odieresis => 500,
	oe => 722,
	ogonek => 333,
	ograve => 500,
	ohungarumlaut => 500,
	omacron => 500,
	one => 500,
	onehalf => 750,
	onequarter => 750,
	onesuperior => 300,
	ordfeminine => 266,
	ordmasculine => 300,
	oslash => 500,
	otilde => 500,
	p => 500,
	paragraph => 500,
	parenleft => 333,
	parenright => 333,
	partialdiff => 494,
	percent => 833,
	period => 250,
	periodcentered => 250,
	perthousand => 1000,
	plus => 570,
	plusminus => 570,
	q => 500,
	question => 500,
	questiondown => 500,
	quotedbl => 555,
	quotedblbase => 500,
	quotedblleft => 500,
	quotedblright => 500,
	quoteleft => 333,
	quoteright => 333,
	quotesinglbase => 333,
	quotesingle => 278,
	r => 389,
	racute => 389,
	radical => 549,
	rcaron => 389,
	rcommaaccent => 389,
	registered => 747,
	ring => 333,
	s => 389,
	sacute => 389,
	scaron => 389,
	scedilla => 389,
	scommaaccent => 389,
	section => 500,
	semicolon => 333,
	seven => 500,
	six => 500,
	slash => 278,
	space => 250,
	sterling => 500,
	summation => 600,
	t => 278,
	tcaron => 366,
	tcommaaccent => 278,
	thorn => 500,
	three => 500,
	threequarters => 750,
	threesuperior => 300,
	tilde => 333,
	trademark => 1000,
	two => 500,
	twosuperior => 300,
	u => 556,
	uacute => 556,
	ucircumflex => 556,
	udieresis => 556,
	ugrave => 556,
	uhungarumlaut => 556,
	umacron => 556,
	underscore => 500,
	uogonek => 556,
	uring => 556,
	v => 444,
	w => 667,
	x => 500,
	y => 444,
	yacute => 444,
	ydieresis => 444,
	yen => 500,
	z => 389,
	zacute => 389,
	zcaron => 389,
	zdotaccent => 389,
	zero => 500,
	};
}
sub afmwx_Times_Italic {
	return {
	A => 611,
	AE => 889,
	Aacute => 611,
	Abreve => 611,
	Acircumflex => 611,
	Adieresis => 611,
	Agrave => 611,
	Amacron => 611,
	Aogonek => 611,
	Aring => 611,
	Atilde => 611,
	B => 611,
	C => 667,
	Cacute => 667,
	Ccaron => 667,
	Ccedilla => 667,
	D => 722,
	Dcaron => 722,
	Dcroat => 722,
	Delta => 612,
	E => 611,
	Eacute => 611,
	Ecaron => 611,
	Ecircumflex => 611,
	Edieresis => 611,
	Edotaccent => 611,
	Egrave => 611,
	Emacron => 611,
	Eogonek => 611,
	Eth => 722,
	Euro => 500,
	F => 611,
	G => 722,
	Gbreve => 722,
	Gcommaaccent => 722,
	H => 722,
	I => 333,
	Iacute => 333,
	Icircumflex => 333,
	Idieresis => 333,
	Idotaccent => 333,
	Igrave => 333,
	Imacron => 333,
	Iogonek => 333,
	J => 444,
	K => 667,
	Kcommaaccent => 667,
	L => 556,
	Lacute => 556,
	Lcaron => 611,
	Lcommaaccent => 556,
	Lslash => 556,
	M => 833,
	N => 667,
	Nacute => 667,
	Ncaron => 667,
	Ncommaaccent => 667,
	Ntilde => 667,
	O => 722,
	OE => 944,
	Oacute => 722,
	Ocircumflex => 722,
	Odieresis => 722,
	Ograve => 722,
	Ohungarumlaut => 722,
	Omacron => 722,
	Oslash => 722,
	Otilde => 722,
	P => 611,
	Q => 722,
	R => 611,
	Racute => 611,
	Rcaron => 611,
	Rcommaaccent => 611,
	S => 500,
	Sacute => 500,
	Scaron => 500,
	Scedilla => 500,
	Scommaaccent => 500,
	T => 556,
	Tcaron => 556,
	Tcommaaccent => 556,
	Thorn => 611,
	U => 722,
	Uacute => 722,
	Ucircumflex => 722,
	Udieresis => 722,
	Ugrave => 722,
	Uhungarumlaut => 722,
	Umacron => 722,
	Uogonek => 722,
	Uring => 722,
	V => 611,
	W => 833,
	X => 611,
	Y => 556,
	Yacute => 556,
	Ydieresis => 556,
	Z => 556,
	Zacute => 556,
	Zcaron => 556,
	Zdotaccent => 556,
	a => 500,
	aacute => 500,
	abreve => 500,
	acircumflex => 500,
	acute => 333,
	adieresis => 500,
	ae => 667,
	agrave => 500,
	amacron => 500,
	ampersand => 778,
	aogonek => 500,
	aring => 500,
	asciicircum => 422,
	asciitilde => 541,
	asterisk => 500,
	at => 920,
	atilde => 500,
	b => 500,
	backslash => 278,
	bar => 275,
	braceleft => 400,
	braceright => 400,
	bracketleft => 389,
	bracketright => 389,
	breve => 333,
	brokenbar => 275,
	bullet => 350,
	c => 444,
	cacute => 444,
	caron => 333,
	ccaron => 444,
	ccedilla => 444,
	cedilla => 333,
	cent => 500,
	circumflex => 333,
	colon => 333,
	comma => 250,
	commaaccent => 250,
	copyright => 760,
	currency => 500,
	d => 500,
	dagger => 500,
	daggerdbl => 500,
	dcaron => 544,
	dcroat => 500,
	degree => 400,
	dieresis => 333,
	divide => 675,
	dollar => 500,
	dotaccent => 333,
	dotlessi => 278,
	e => 444,
	eacute => 444,
	ecaron => 444,
	ecircumflex => 444,
	edieresis => 444,
	edotaccent => 444,
	egrave => 444,
	eight => 500,
	ellipsis => 889,
	emacron => 444,
	emdash => 889,
	endash => 500,
	eogonek => 444,
	equal => 675,
	eth => 500,
	exclam => 333,
	exclamdown => 389,
	f => 278,
	fi => 500,
	five => 500,
	fl => 500,
	florin => 500,
	four => 500,
	fraction => 167,
	g => 500,
	gbreve => 500,
	gcommaaccent => 500,
	germandbls => 500,
	grave => 333,
	greater => 675,
	greaterequal => 549,
	guillemotleft => 500,
	guillemotright => 500,
	guilsinglleft => 333,
	guilsinglright => 333,
	h => 500,
	hungarumlaut => 333,
	hyphen => 333,
	i => 278,
	iacute => 278,
	icircumflex => 278,
	idieresis => 278,
	igrave => 278,
	imacron => 278,
	iogonek => 278,
	j => 278,
	k => 444,
	kcommaaccent => 444,
	l => 278,
	lacute => 278,
	lcaron => 300,
	lcommaaccent => 278,
	less => 675,
	lessequal => 549,
	logicalnot => 675,
	lozenge => 471,
	lslash => 278,
	m => 722,
	macron => 333,
	minus => 675,
	mu => 500,
	multiply => 675,
	n => 500,
	nacute => 500,
	ncaron => 500,
	ncommaaccent => 500,
	nine => 500,
	notequal => 549,
	ntilde => 500,
	numbersign => 500,
	o => 500,
	oacute => 500,
	ocircumflex => 500,
	odieresis => 500,
	oe => 667,
	ogonek => 333,
	ograve => 500,
	ohungarumlaut => 500,
	omacron => 500,
	one => 500,
	onehalf => 750,
	onequarter => 750,
	onesuperior => 300,
	ordfeminine => 276,
	ordmasculine => 310,
	oslash => 500,
	otilde => 500,
	p => 500,
	paragraph => 523,
	parenleft => 333,
	parenright => 333,
	partialdiff => 476,
	percent => 833,
	period => 250,
	periodcentered => 250,
	perthousand => 1000,
	plus => 675,
	plusminus => 675,
	q => 500,
	question => 500,
	questiondown => 500,
	quotedbl => 420,
	quotedblbase => 556,
	quotedblleft => 556,
	quotedblright => 556,
	quoteleft => 333,
	quoteright => 333,
	quotesinglbase => 333,
	quotesingle => 214,
	r => 389,
	racute => 389,
	radical => 453,
	rcaron => 389,
	rcommaaccent => 389,
	registered => 760,
	ring => 333,
	s => 389,
	sacute => 389,
	scaron => 389,
	scedilla => 389,
	scommaaccent => 389,
	section => 500,
	semicolon => 333,
	seven => 500,
	six => 500,
	slash => 278,
	space => 250,
	sterling => 500,
	summation => 600,
	t => 278,
	tcaron => 300,
	tcommaaccent => 278,
	thorn => 500,
	three => 500,
	threequarters => 750,
	threesuperior => 300,
	tilde => 333,
	trademark => 980,
	two => 500,
	twosuperior => 300,
	u => 500,
	uacute => 500,
	ucircumflex => 500,
	udieresis => 500,
	ugrave => 500,
	uhungarumlaut => 500,
	umacron => 500,
	underscore => 500,
	uogonek => 500,
	uring => 500,
	v => 444,
	w => 667,
	x => 444,
	y => 444,
	yacute => 444,
	ydieresis => 444,
	yen => 500,
	z => 389,
	zacute => 389,
	zcaron => 389,
	zdotaccent => 389,
	zero => 500,
	};
}
sub afmwx_Times_Roman {
	return {
	A => 722,
	AE => 889,
	Aacute => 722,
	Abreve => 722,
	Acircumflex => 722,
	Adieresis => 722,
	Agrave => 722,
	Amacron => 722,
	Aogonek => 722,
	Aring => 722,
	Atilde => 722,
	B => 667,
	C => 667,
	Cacute => 667,
	Ccaron => 667,
	Ccedilla => 667,
	D => 722,
	Dcaron => 722,
	Dcroat => 722,
	Delta => 612,
	E => 611,
	Eacute => 611,
	Ecaron => 611,
	Ecircumflex => 611,
	Edieresis => 611,
	Edotaccent => 611,
	Egrave => 611,
	Emacron => 611,
	Eogonek => 611,
	Eth => 722,
	Euro => 500,
	F => 556,
	G => 722,
	Gbreve => 722,
	Gcommaaccent => 722,
	H => 722,
	I => 333,
	Iacute => 333,
	Icircumflex => 333,
	Idieresis => 333,
	Idotaccent => 333,
	Igrave => 333,
	Imacron => 333,
	Iogonek => 333,
	J => 389,
	K => 722,
	Kcommaaccent => 722,
	L => 611,
	Lacute => 611,
	Lcaron => 611,
	Lcommaaccent => 611,
	Lslash => 611,
	M => 889,
	N => 722,
	Nacute => 722,
	Ncaron => 722,
	Ncommaaccent => 722,
	Ntilde => 722,
	O => 722,
	OE => 889,
	Oacute => 722,
	Ocircumflex => 722,
	Odieresis => 722,
	Ograve => 722,
	Ohungarumlaut => 722,
	Omacron => 722,
	Oslash => 722,
	Otilde => 722,
	P => 556,
	Q => 722,
	R => 667,
	Racute => 667,
	Rcaron => 667,
	Rcommaaccent => 667,
	S => 556,
	Sacute => 556,
	Scaron => 556,
	Scedilla => 556,
	Scommaaccent => 556,
	T => 611,
	Tcaron => 611,
	Tcommaaccent => 611,
	Thorn => 556,
	U => 722,
	Uacute => 722,
	Ucircumflex => 722,
	Udieresis => 722,
	Ugrave => 722,
	Uhungarumlaut => 722,
	Umacron => 722,
	Uogonek => 722,
	Uring => 722,
	V => 722,
	W => 944,
	X => 722,
	Y => 722,
	Yacute => 722,
	Ydieresis => 722,
	Z => 611,
	Zacute => 611,
	Zcaron => 611,
	Zdotaccent => 611,
	a => 444,
	aacute => 444,
	abreve => 444,
	acircumflex => 444,
	acute => 333,
	adieresis => 444,
	ae => 667,
	agrave => 444,
	amacron => 444,
	ampersand => 778,
	aogonek => 444,
	aring => 444,
	asciicircum => 469,
	asciitilde => 541,
	asterisk => 500,
	at => 921,
	atilde => 444,
	b => 500,
	backslash => 278,
	bar => 200,
	braceleft => 480,
	braceright => 480,
	bracketleft => 333,
	bracketright => 333,
	breve => 333,
	brokenbar => 200,
	bullet => 350,
	c => 444,
	cacute => 444,
	caron => 333,
	ccaron => 444,
	ccedilla => 444,
	cedilla => 333,
	cent => 500,
	circumflex => 333,
	colon => 278,
	comma => 250,
	commaaccent => 250,
	copyright => 760,
	currency => 500,
	d => 500,
	dagger => 500,
	daggerdbl => 500,
	dcaron => 588,
	dcroat => 500,
	degree => 400,
	dieresis => 333,
	divide => 564,
	dollar => 500,
	dotaccent => 333,
	dotlessi => 278,
	e => 444,
	eacute => 444,
	ecaron => 444,
	ecircumflex => 444,
	edieresis => 444,
	edotaccent => 444,
	egrave => 444,
	eight => 500,
	ellipsis => 1000,
	emacron => 444,
	emdash => 1000,
	endash => 500,
	eogonek => 444,
	equal => 564,
	eth => 500,
	exclam => 333,
	exclamdown => 333,
	f => 333,
	fi => 556,
	five => 500,
	fl => 556,
	florin => 500,
	four => 500,
	fraction => 167,
	g => 500,
	gbreve => 500,
	gcommaaccent => 500,
	germandbls => 500,
	grave => 333,
	greater => 564,
	greaterequal => 549,
	guillemotleft => 500,
	guillemotright => 500,
	guilsinglleft => 333,
	guilsinglright => 333,
	h => 500,
	hungarumlaut => 333,
	hyphen => 333,
	i => 278,
	iacute => 278,
	icircumflex => 278,
	idieresis => 278,
	igrave => 278,
	imacron => 278,
	iogonek => 278,
	j => 278,
	k => 500,
	kcommaaccent => 500,
	l => 278,
	lacute => 278,
	lcaron => 344,
	lcommaaccent => 278,
	less => 564,
	lessequal => 549,
	logicalnot => 564,
	lozenge => 471,
	lslash => 278,
	m => 778,
	macron => 333,
	minus => 564,
	mu => 500,
	multiply => 564,
	n => 500,
	nacute => 500,
	ncaron => 500,
	ncommaaccent => 500,
	nine => 500,
	notequal => 549,
	ntilde => 500,
	numbersign => 500,
	o => 500,
	oacute => 500,
	ocircumflex => 500,
	odieresis => 500,
	oe => 722,
	ogonek => 333,
	ograve => 500,
	ohungarumlaut => 500,
	omacron => 500,
	one => 500,
	onehalf => 750,
	onequarter => 750,
	onesuperior => 300,
	ordfeminine => 276,
	ordmasculine => 310,
	oslash => 500,
	otilde => 500,
	p => 500,
	paragraph => 453,
	parenleft => 333,
	parenright => 333,
	partialdiff => 476,
	percent => 833,
	period => 250,
	periodcentered => 250,
	perthousand => 1000,
	plus => 564,
	plusminus => 564,
	q => 500,
	question => 444,
	questiondown => 444,
	quotedbl => 408,
	quotedblbase => 444,
	quotedblleft => 444,
	quotedblright => 444,
	quoteleft => 333,
	quoteright => 333,
	quotesinglbase => 333,
	quotesingle => 180,
	r => 333,
	racute => 333,
	radical => 453,
	rcaron => 333,
	rcommaaccent => 333,
	registered => 760,
	ring => 333,
	s => 389,
	sacute => 389,
	scaron => 389,
	scedilla => 389,
	scommaaccent => 389,
	section => 500,
	semicolon => 278,
	seven => 500,
	six => 500,
	slash => 278,
	space => 250,
	sterling => 500,
	summation => 600,
	t => 278,
	tcaron => 326,
	tcommaaccent => 278,
	thorn => 500,
	three => 500,
	threequarters => 750,
	threesuperior => 300,
	tilde => 333,
	trademark => 980,
	two => 500,
	twosuperior => 300,
	u => 500,
	uacute => 500,
	ucircumflex => 500,
	udieresis => 500,
	ugrave => 500,
	uhungarumlaut => 500,
	umacron => 500,
	underscore => 500,
	uogonek => 500,
	uring => 500,
	v => 500,
	w => 722,
	x => 500,
	y => 500,
	yacute => 500,
	ydieresis => 500,
	yen => 500,
	z => 444,
	zacute => 444,
	zcaron => 444,
	zdotaccent => 444,
	zero => 500,
	};
}

