/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.run.plugins;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.run.plugins.TestCaseCreator;
import com.ftinc.si.assist.test.AssertRecord;
import com.ftinc.si.assist.test.FakeMethodRecord;
import com.ftinc.si.assist.test.Fson;
import com.ftinc.si.assist.test.ObjectRecord;
import com.ftinc.si.assist.test.Record;
import com.ftinc.si.assist.test.TestCaseRecord;
import com.ftinc.si.assist.test.TestCommandRecord;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.gui.ClassReadDialog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.CannotCompileException;
import javassist.NotFoundException;

public class ObjectTestCreator
extends TestCaseCreator {
    @Override
    public int command(HashMap<String, Object> map) {
        String cmd;
        switch (cmd = map.get("verb").toString()) {
            case "#outline": {
                return this.getClassOutline(map);
            }
            case "#xmlmap": {
                return this.getXMLStructure(map);
            }
        }
        return super.command(map);
    }

    private int getClassOutline(HashMap<String, Object> map) {
        File t_f;
        String t_result = "";
        String cname = "";
        if (map.containsKey("class") && map.get("class") != null) {
            cname = map.get("class").toString();
        }
        String mname = null;
        TestCommandRecord cmd = new TestCommandRecord(2);
        cmd.className = cname;
        ClassReadDialog m_dial = new ClassReadDialog(null, Tool.target_dirs, cmd);
        m_dial.setVisible(true);
        if (m_dial.className != null && m_dial.methodName != null) {
            t_result = "<class name=\"" + m_dial.className + "\"/>";
            String[] m_info = m_dial.methodName.split(" ", -1);
            boolean isStatic = false;
            Integer v_argpos = -1;
            if (m_info.length == 1) {
                mname = m_info[0];
            } else if (m_info.length == 2) {
                if (m_info[0].matches("^.*static")) {
                    isStatic = true;
                    mname = m_info[1];
                } else {
                    mname = m_info[0].equals("^final") ? m_info[1] : m_info[0];
                }
            } else if (m_info.length == 3) {
                if (m_info[0].matches("^.*static")) {
                    isStatic = true;
                }
                mname = m_info[1];
                v_argpos = new Integer(m_info[2]);
            }
            t_result = String.valueOf(t_result) + "<method name=\"" + mname + "\"";
            if (isStatic) {
                t_result = String.valueOf(t_result) + " static=true";
            }
            if (v_argpos >= 0) {
                t_result = String.valueOf(t_result) + " vargpos=" + v_argpos.toString();
            }
            t_result = String.valueOf(t_result) + "/>";
            int a_size = m_dial.objs.length;
            int i = 0;
            while (a_size > i) {
                String obj_rep = m_dial.objs[i];
                if (obj_rep.startsWith("$_")) {
                    t_result = String.valueOf(t_result) + "<$_ type=\"" + Tool.replaceB(obj_rep, "$_=", "") + "\"/>";
                } else if (obj_rep.startsWith("$0")) {
                    t_result = String.valueOf(t_result) + "<$0 type=\"" + m_dial.className + "\"/>";
                } else {
                    String num = obj_rep.replaceAll("^\\$([0-9]+)=.*$", "$1");
                    Integer n = new Integer(num);
                    t_result = String.valueOf(t_result) + "<$" + n.toString() + " type=\"" + obj_rep.replaceAll("^\\$[0-9]+=(.*)$", "$1") + "\"/>";
                }
                ++i;
            }
        }
        if (!(t_f = Tool._libfile("$LIBDIR\\_object.req")).exists()) {
            Tool.logForTesting(null, Messages.getString("ObjectTestCreator.26"));
            return -1;
        }
        File t_resfile = Tool._libfile("$LIBDIR\\_object.res");
        if (t_result != null && t_result.length() > 0) {
            try {
                if (!t_resfile.exists()) {
                    t_resfile.createNewFile();
                }
            }
            catch (IOException e1) {
                Tool.alertMSG(null, e1.getMessage());
                this.renameReq(t_f);
                return -1;
            }
            try {
                FileWriter t_w = new FileWriter(t_resfile);
                t_w.write(t_result);
                t_w.close();
            }
            catch (IOException e1) {
                Tool.alertMSG(null, e1.getMessage());
                this.renameReq(t_f);
                return -1;
            }
        }
        this.renameReq(t_f);
        return 0;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    private int getXMLStructure(HashMap<String, Object> map) {
        File t_f = Tool._libfile("$LIBDIR\\_object.req");
        Object var3_3 = null;
        HashMap<String, Object> t_obj = null;
        try {
            String cname = map.get("class").toString();
            if (Tool.isFake(cname)) {
                t_obj = Tool.getFakeInstance(cname);
                ArrayList<Object> t_ans = Fson.valueByJsonPath(t_obj, "$");
                if (t_ans != null && t_ans.size() > 0) {
                    HashMap v_map = (HashMap)t_ans.get(0);
                    HashMap<String, Object> v2_map = new HashMap<String, Object>();
                    for (Map.Entry entry : v_map.entrySet()) {
                        v2_map.put((String)entry.getKey(), entry.getValue());
                    }
                    HashMap<String, String> f_map = FakeMethodRecord.getVFields(cname);
                    for (Map.Entry<String, String> entry : f_map.entrySet()) {
                        if (v2_map.containsKey(entry.getKey())) continue;
                        if (Tool.hasDefaultConstructor(entry.getValue(), true)) {
                            Class<?> fc = Tool.forName(entry.getValue());
                            Object f_obj = Tool.newObject(fc, new Class[0], new Object[0]);
                            v2_map.put(entry.getKey(), f_obj);
                            continue;
                        }
                        v2_map.put(entry.getKey(), null);
                    }
                    t_obj = v2_map;
                    Class<HashMap> clazz = HashMap.class;
                }
            } else {
                Class<?> clazz = Tool.forName(cname);
                if (!cname.endsWith("[]") && Tool.isPrimitive2(clazz)) {
                    Tool.logForTesting(null, "ERROR:" + cname + Messages.getString("ObjectTestCreator.34"));
                    return -1;
                }
                String t_src = "";
                if (t_f.exists()) {
                    try {
                        String buf;
                        BufferedReader t_br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(t_f), Tool.charset));
                        while ((buf = t_br.readLine()) != null) {
                            t_src = String.valueOf(t_src) + buf + "\n";
                        }
                        t_br.close();
                    }
                    catch (IOException e1) {
                        Tool.logForTesting(null, e1.getMessage());
                        return -1;
                    }
                } else if (Tool.tryDefaultConstructor(clazz) == null && t_src.length() == 0) {
                    Tool.logForTesting(null, Messages.getString("ObjectTestCreator.27"));
                    return -1;
                }
                t_obj = Tool.constructObject(cname, t_src);
            }
            String t_xml = Messages.getString("ObjectTestCreator.35");
            if (t_obj != null) {
                void var3_6;
                Integer _depth = 5;
                if (map.containsKey("depth")) {
                    _depth = new Integer(map.get("depth").toString());
                }
                t_xml = Fson.toXML(t_obj, var3_6, _depth);
            }
            File t_result = Tool._libfile("$LIBDIR\\_object.res");
            if (t_xml != null) {
                try {
                    if (!t_result.exists()) {
                        t_result.createNewFile();
                    }
                }
                catch (IOException e1) {
                    Tool.alertMSG(null, e1.getMessage());
                    this.renameReq(t_f);
                    return -1;
                }
                try {
                    FileWriter t_w = new FileWriter(t_result);
                    t_w.write(t_xml);
                    t_w.close();
                }
                catch (IOException e1) {
                    Tool.alertMSG(null, e1.getMessage());
                    this.renameReq(t_f);
                    return -1;
                }
            }
            this.renameReq(t_f);
            return 0;
        }
        catch (Fson.NotSupportedClassException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException | CannotCompileException | NotFoundException e) {
            String e_msg = "msg=" + e.getMessage() + Tool.getStackMessage(e, 0, 10);
            Tool.alertMSG(null, e_msg);
            this.renameReq(t_f);
            return -1;
        }
    }

    private void renameReq(File f) {
        String fname = f.getAbsolutePath();
        fname = fname.replaceFirst(".req$", Matcher.quoteReplacement(".done"));
        f.renameTo(new File(fname));
    }

    @Override
    protected int createTestRecords(String s) {
        TestCaseRecord n_case = null;
        String class_name = "";
        String method_name = "";
        String arg_types = "";
        String t_json = "";
        String rtype = "";
        Pattern pat_case = Pattern.compile("<testcase\\s+name=\"([^\"]+)\"\\s+class=\"([^\"]+)\"\\s+method=\"([^\"]+)\"\\s+arg_types=\"([^\"]*)\"\\s+rtype=\"([^\"]+)\"\\s+include=\"([^\"]*)\">([\\s\\S]+?)</testcase>");
        Matcher t_m = pat_case.matcher(s);
        if (t_m.find()) {
            block21: {
                String case_name = t_m.group(1);
                ArrayList<String> str_cmds = new ArrayList<String>();
                Pattern pat_cmd = Pattern.compile("<cmd>([\\s\\S]+?)</cmd>");
                Matcher t_m2 = pat_cmd.matcher(s);
                while (t_m2.find()) {
                    str_cmds.add(t_m2.group(1));
                }
                HashMap<Integer, TestCaseRecord> t_casemap = this.lookupTestCaseWithLength(case_name, str_cmds.size());
                n_case = t_casemap.get(0);
                if (n_case == null) {
                    n_case = t_casemap.get(1);
                }
                n_case.changed();
                n_case.include = t_m.group(6);
                class_name = t_m.group(2);
                method_name = t_m.group(3);
                arg_types = t_m.group(4);
                rtype = t_m.group(5);
                t_json = t_m.group(7);
                HashMap<Integer, TestCommandRecord> t_cmds = new HashMap<Integer, TestCommandRecord>();
                HashMap<String, ObjectRecord> t_objs = new HashMap<String, ObjectRecord>();
                HashMap<Integer, AssertRecord> t_asserts = new HashMap<Integer, AssertRecord>();
                if (method_name.endsWith("?")) {
                    if (ObjectTestCreator.createFairyCase(n_case, class_name, method_name, arg_types, t_json, t_cmds, t_objs) < 0) {
                        return -1;
                    }
                } else {
                    HashMap<String, Object> v_map = new HashMap<String, Object>();
                    Pattern dbadd_pat = Pattern.compile("<dbadd>([\\s\\S]+?)</dbadd>");
                    t_m = dbadd_pat.matcher(s);
                    if (t_m.find()) {
                        String[] init_cmds = t_m.group(1).split("\n", -1);
                        int i = 0;
                        while (i < init_cmds.length) {
                            String v_key = "dbadd ";
                            Pattern db_pat1 = Pattern.compile("(\\w+):=([^,\\[]+?)(,|:\\[)");
                            t_m = db_pat1.matcher(init_cmds[i]);
                            while (t_m.find()) {
                                String t_key = t_m.group(1);
                                String t_val = t_m.group(2);
                                v_key = String.valueOf(v_key) + "[?(@." + t_key + "='" + t_val + "')]";
                            }
                            Pattern db_pat2 = Pattern.compile(":(\\[.*)\\s*$");
                            t_m = db_pat2.matcher(init_cmds[i]);
                            if (t_m.find()) {
                                v_map.put(v_key, Tool.getObjectfromJSON(ArrayList.class, t_m.group(1)));
                            }
                            ++i;
                        }
                    }
                    int t_id = 0;
                    if (v_map.size() != 0) {
                        TestCommandRecord t_cmd = new TestCommandRecord(2);
                        t_cmd.id = n_case.begin + t_id;
                        t_cmd.className = "com.ftinc.si.assist.run.VCentral";
                        t_cmd.enable = true;
                        t_cmd.methodName = "prepare";
                        t_cmd.subject = "null";
                        t_cmd.setArgTypes("[[java.util.HashMap,$1]]");
                        t_cmd.argStatus = "[true,true,true]";
                        t_cmd.returnType = "void";
                        t_cmd.testCase = case_name;
                        t_cmds.put(t_id, t_cmd);
                        ObjectRecord t_obj = new ObjectRecord(2);
                        t_obj.className = "java.util.HashMap";
                        t_obj.id = String.valueOf(Integer.toString(t_cmd.id)) + "$1";
                        t_obj.stack = "$1";
                        t_obj.testCase = case_name;
                        t_obj.testID = t_cmd.id;
                        t_obj.jSON = Tool.getJSONfromObject(v_map);
                        t_objs.put(t_obj.id, t_obj);
                        AssertRecord t_ast = new AssertRecord(2);
                        t_ast.enable = false;
                        t_ast.id = t_cmd.id;
                        t_asserts.put(t_cmd.id, t_ast);
                        ++t_id;
                    }
                    TestCommandRecord snap = new TestCommandRecord(2);
                    snap.id = n_case.begin + t_id;
                    snap.testCase = n_case.name;
                    snap.className = class_name;
                    snap.returnType = rtype;
                    snap.methodName = method_name;
                    snap.subject = "$0";
                    n_case.snapshot = snap.id;
                    String[] types_list = arg_types.split(",", -1);
                    String t_types = "";
                    int i = 0;
                    while (i < types_list.length) {
                        if (i > 0) {
                            t_types = String.valueOf(t_types) + ",";
                        }
                        t_types = String.valueOf(t_types) + "[" + types_list[i] + "," + "$" + Integer.toString(i + 1) + "]";
                        ++i;
                    }
                    snap.setArgTypes("[" + t_types + "]");
                    i = 0;
                    while (i < types_list.length) {
                        snap.setArgStatus(i + 1, true);
                        ++i;
                    }
                    snap.setArgStatus(0, true);
                    snap.setArgStatus(types_list.length + 1, true);
                    t_cmds.put(snap.id, snap);
                    ObjectTestCreator.makeObjectRecordsOfSnapshot(snap, t_json, t_objs);
                    i = 0;
                    while (i < str_cmds.size()) {
                        ObjectTestCreator.makeSnapCommandRecord(snap, i, (String)str_cmds.get(i), t_cmds, t_objs);
                        ++i;
                    }
                }
                try {
                    ArrayList<Record> removings = null;
                    if (t_casemap.containsKey(0)) {
                        Tool._db().clearCase(n_case, true);
                    } else if (t_casemap.containsKey(-1)) {
                        removings = new ArrayList<Record>();
                        removings.add(t_casemap.get(-1));
                        Tool._db().clearCase(n_case, true);
                    }
                    if (Tool._db().saveTestCase(n_case, removings, t_cmds, t_objs, t_asserts)) break block21;
                    return -1;
                }
                catch (SQLException e) {
                    Tool.alertMSG(null, "ERROR:failed to rollback. " + e.getMessage());
                    return -1;
                }
            }
            Tool.alertMSG(null, Messages.getString("ObjectTestCreator.58"));
            return 0;
        }
        return -1;
    }

    private static int createFairyCase(TestCaseRecord n_case, String class_name, String method_name, String arg_types, String src, HashMap<Integer, TestCommandRecord> cmds, HashMap<String, ObjectRecord> objs) {
        method_name = method_name.replace("?", "");
        String[] o_types = (String[])Tool.getObjectfromJSON(String[].class, "[" + arg_types + "]");
        FakeMethodRecord fr = Tool._db().getMethodSource(class_name, method_name, o_types, Tool.version);
        if (fr == null) {
            fr = new FakeMethodRecord(2);
            fr.className = class_name;
            fr.methodName = method_name;
            fr.argTypes = o_types;
        }
        try {
            fr.source = src;
            fr.changed();
            Tool._db().updateRecordBySQL(fr.getUpdateSQL(), true);
        }
        catch (SQLException e) {
            Tool.alertMSG(null, String.valueOf(Messages.getString("ObjectTestCreator.63")) + fr.getUpdateSQL() + "\nmsg=" + e.getMessage());
            return -1;
        }
        n_case.loggable = false;
        TestCommandRecord fairy = new TestCommandRecord(2);
        fairy.id = n_case.begin;
        fairy.className = "com.ftinc.si.assist.run.CodeFairy";
        fairy.returnType = "void";
        fairy.methodName = "prepare";
        fairy.subject = "null";
        fairy.argTypes = new String[][]{{"java.lang.String", "$1"}};
        fairy.testCase = n_case.name;
        ObjectRecord o_rec = new ObjectRecord(2);
        o_rec.id = String.valueOf(Integer.toString(fairy.id)) + "$1";
        o_rec.testID = fairy.id;
        o_rec.className = "java.lang.String";
        o_rec.testCase = fairy.testCase;
        o_rec.jSON = class_name;
        o_rec.isPOJO = true;
        o_rec.stack = "$1";
        cmds.put(fairy.id, fairy);
        objs.put(o_rec.id, o_rec);
        return 0;
    }

    private static void makeObjectRecordsOfSnapshot(TestCommandRecord cmd, String json, HashMap<String, ObjectRecord> objs) {
        String[] jsons = json.split(",\n", -1);
        HashMap<String, String> t_map = new HashMap<String, String>();
        Pattern t_pat1 = Pattern.compile("^(\\??\\$\\d+)\t([\\s\\S]+)\\s*\\Z");
        int i = 0;
        while (i < jsons.length) {
            Matcher t_m = t_pat1.matcher(jsons[i]);
            if (t_m.find()) {
                String t_key = t_m.group(1);
                t_map.put(t_key, t_m.group(2));
            }
            ++i;
        }
        String[][] argTypes = cmd.argTypes;
        HashMap<String, String> arg_infos = new HashMap<String, String>();
        int i2 = 0;
        while (i2 < argTypes.length) {
            String[] info = argTypes[i2];
            arg_infos.put(info[1], info[0]);
            ++i2;
        }
        for (Map.Entry entry : t_map.entrySet()) {
            String t_stack = (String)entry.getKey();
            String t_json = (String)entry.getValue();
            String t_id = String.valueOf(Integer.toString(cmd.id)) + t_stack;
            boolean isPOJO = !t_stack.startsWith("?");
            t_stack = t_stack.replace("?", "");
            ObjectRecord o_rec = objs.get(t_id);
            if (o_rec == null) {
                o_rec = new ObjectRecord(2);
                o_rec.id = String.valueOf(Integer.toString(cmd.id)) + t_stack;
                o_rec.testID = cmd.id;
                o_rec.testCase = cmd.testCase;
                o_rec.jSON = "";
                o_rec.isPOJO = isPOJO;
                o_rec.stack = t_stack;
                o_rec.className = (String)arg_infos.get(t_stack);
                if ((o_rec.className == null || o_rec.className.length() == 0) && t_stack.equals("$0")) {
                    o_rec.className = cmd.className;
                }
            }
            o_rec.jSON = o_rec.jSON.length() > 0 ? String.valueOf(o_rec.jSON) + "\n" + t_json : t_json;
            objs.put(o_rec.id, o_rec);
        }
    }

    private static void makeSnapCommandRecord(TestCommandRecord snap, int m, String json, HashMap<Integer, TestCommandRecord> cmds, HashMap<String, ObjectRecord> objs) {
        int n = snap.id + m + 1;
        TestCommandRecord t_cmd = snap._dup(n);
        t_cmd.setClassName("com.ftinc.si.assist.run.SnapshotCommandRecord");
        t_cmd.id = n;
        t_cmd.setMethod("$replay(" + Integer.toString(snap.id) + ")", false, 0);
        t_cmd.setReturnType("void");
        cmds.put(n, t_cmd);
        String[] jsons = json.split(",\n", -1);
        int i = 0;
        while (i < jsons.length) {
            if (jsons[i] != null && jsons[i].trim().length() > 0) {
                ObjectTestCreator.makeObjectRecords(snap.className, t_cmd, jsons[i], objs);
            }
            ++i;
        }
    }

    private static void makeObjectRecords(String cname, TestCommandRecord cmd, String json, HashMap<String, ObjectRecord> objs) {
        String[] jsons = json.split(",\n", -1);
        HashMap<String, String> t_map = new HashMap<String, String>();
        Pattern t_pat0 = Pattern.compile("^(\\??\\$\\d+)\\?([\\s\\S]+?)\\s*\\Z");
        Pattern t_pat1 = Pattern.compile("^(\\??\\$\\d+)(//\\?[\\s\\S]+?)\\s*\\Z");
        Pattern t_pat2 = Pattern.compile("^(//\\?[\\s\\S]+?)\\s*\\Z");
        int i = 0;
        while (i < jsons.length) {
            String t_str0;
            String t_key;
            Matcher t_m = t_pat0.matcher(jsons[i]);
            if (t_m.find()) {
                t_key = t_m.group(1);
                t_str0 = t_m.group(2);
                if (t_map.containsKey(t_key)) {
                    t_str0 = String.valueOf((String)t_map.get(t_key)) + "\n" + t_str0;
                }
                t_map.put(t_key, t_m.group(2));
            } else {
                t_m = t_pat1.matcher(jsons[i]);
                if (t_m.find()) {
                    t_key = t_m.group(1);
                    t_str0 = t_m.group(2);
                    if (t_map.containsKey(t_key)) {
                        t_str0 = String.valueOf((String)t_map.get(t_key)) + "\n" + t_str0;
                    }
                    t_map.put(t_key, t_m.group(2));
                } else {
                    t_m = t_pat2.matcher(jsons[i]);
                    if (t_m.find()) {
                        t_str0 = (String)t_map.get("$0");
                        t_str0 = t_str0 == null ? t_m.group(1) : String.valueOf(t_str0) + "\n" + t_m.group(1);
                        t_map.put("$0", t_str0);
                    }
                }
            }
            ++i;
        }
        String[][] argTypes = cmd.argTypes;
        HashMap<String, String> arg_infos = new HashMap<String, String>();
        int i2 = 0;
        while (i2 < argTypes.length) {
            String[] info = argTypes[i2];
            arg_infos.put(info[1], info[0]);
            ++i2;
        }
        for (Map.Entry entry : t_map.entrySet()) {
            String t_stack = (String)entry.getKey();
            t_stack = t_stack.replace("?", "");
            String t_json = (String)entry.getValue();
            String t_id = String.valueOf(Integer.toString(cmd.id)) + t_stack;
            ObjectRecord o_rec = objs.get(t_id);
            if (o_rec == null) {
                boolean isPOJO = !t_stack.startsWith("?");
                o_rec = new ObjectRecord(2);
                o_rec.id = t_id;
                o_rec.jSON = "";
                o_rec.testID = cmd.id;
                o_rec.testCase = cmd.testCase;
                o_rec.isPOJO = isPOJO;
                o_rec.stack = t_stack;
                o_rec.className = (String)arg_infos.get(t_stack);
                if ((o_rec.className == null || o_rec.className.length() == 0) && t_stack.equals("$0")) {
                    o_rec.className = cname;
                }
            }
            o_rec.jSON = o_rec.jSON.length() > 0 ? String.valueOf(o_rec.jSON) + "\n" + t_json : t_json;
            objs.put(o_rec.id, o_rec);
        }
    }
}

