/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test;

import com.ftinc.si.assist.test.FakeMethodRecord;
import com.ftinc.si.assist.test.Tool;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;

public class ClassOutLine {
    private CtClass m_class;
    private boolean is_fake;

    public CtClass getCtClass() {
        return this.m_class;
    }

    public ClassOutLine(CtClass ctc, boolean isfake) {
        this.m_class = ctc;
        this.is_fake = isfake;
    }

    public ClassOutLine getSuper() {
        if ("java.lang.Object".equals(this.m_class.getName())) {
            return null;
        }
        try {
            CtClass t_class = this.m_class.getSuperclass();
            if (t_class != null) {
                return new ClassOutLine(t_class, this.is_fake);
            }
        }
        catch (NotFoundException e) {
            Tool.logIfDebug(e, "@ClassOutLine#getSuper");
        }
        return null;
    }

    public ArrayList<ClassOutLine> getInterfaces() {
        ArrayList<ClassOutLine> t_list = new ArrayList<ClassOutLine>();
        try {
            CtClass[] t_classes = this.m_class.getInterfaces();
            int i = 0;
            while (i < t_classes.length) {
                ClassOutLine t_co = new ClassOutLine(t_classes[i], false);
                t_list.add(t_co);
                t_list.addAll(t_co.getInterfaces());
                ++i;
            }
            return t_list;
        }
        catch (NotFoundException e) {
            Tool.logIfDebug(e, "@ClassOutLine#getInterface");
            return null;
        }
    }

    public String getClassName() {
        if (this.m_class == null) {
            return null;
        }
        return this.m_class.getName();
    }

    public boolean isInterface() {
        return this.m_class.isInterface();
    }

    public HashMap<String, String> getDeclaredMethods() {
        CtMethod[] t_m = this.m_class.getDeclaredMethods();
        HashMap<String, String> t_map = new HashMap<String, String>();
        Integer i = 0;
        while (i < t_m.length) {
            String t_ant;
            String num = String.format("%1$03d", i);
            String name_key = String.valueOf(num) + "_name";
            String mName = t_m[i].getName();
            String head = "";
            if (Modifier.isStatic(t_m[i].getModifiers()) && !mName.matches("^access\\$[0-9]+$")) {
                head = "static";
            }
            if (Modifier.isFinal(t_m[i].getModifiers())) {
                if (head.length() > 0) {
                    head = "/" + head;
                }
                head = "final" + head;
            }
            if (Modifier.isAbstract(t_m[i].getModifiers())) {
                if (head.length() > 0) {
                    head = "/" + head;
                }
                head = "abstract" + head;
            }
            mName = String.valueOf(head) + " " + mName;
            String arg_key = String.valueOf(num) + "_$_";
            try {
                t_map.put(arg_key, t_m[i].getReturnType().getName());
            }
            catch (NotFoundException e) {
                Tool.alertMSG(null, String.valueOf(e.getMessage()) + " failed in getMethods.(NotFound)");
            }
            try {
                CtClass[] t_args = t_m[i].getParameterTypes();
                if (t_args.length > 0) {
                    Integer j = 1;
                    while (j < t_args.length) {
                        arg_key = String.valueOf(num) + "_$" + j.toString();
                        t_map.put(arg_key, t_args[j - 1].getName());
                        j = j + 1;
                    }
                    arg_key = String.valueOf(num) + "_$" + Integer.toString(t_args.length);
                    CtClass t_last = t_args[t_args.length - 1];
                    String cname = t_last.getName();
                    if ((0x80 & t_m[i].getModifiers()) != 0 && t_last.isArray()) {
                        cname = cname.replaceFirst("\\[\\]", "");
                        mName = String.valueOf(mName) + " " + Integer.toString(t_args.length - 1);
                    }
                    t_map.put(arg_key, cname);
                }
            }
            catch (NotFoundException e) {
                Tool.alertMSG(null, String.valueOf(e.getMessage()) + " failed in getMethods.(NotFound)");
            }
            if ((t_ant = Tool.readAnnotationFromMethod(t_m[i], "updated")).length() > 0) {
                t_map.put(String.valueOf(num) + "_updated", t_ant);
            }
            t_map.put(name_key, mName);
            i = i + 1;
        }
        return t_map;
    }

    public HashMap<String, String> getDeclaredConstructors() {
        CtConstructor[] t_m = this.m_class.getDeclaredConstructors();
        HashMap<String, String> t_map = new HashMap<String, String>();
        Integer i = 0;
        while (i < t_m.length) {
            String num = String.format("%1$03d", i);
            String t_key = String.valueOf(num) + "_name";
            t_map.put(t_key, "constructor_" + num);
            try {
                CtClass[] t_args = t_m[i].getParameterTypes();
                if (t_args.length > 0) {
                    String arg_key;
                    Integer j = 1;
                    while (j < t_args.length) {
                        arg_key = String.valueOf(num) + "_$" + j.toString();
                        t_map.put(arg_key, t_args[j - 1].getName());
                        j = j + 1;
                    }
                    arg_key = String.valueOf(num) + "_$" + Integer.toString(t_args.length);
                    CtClass t_last = t_args[t_args.length - 1];
                    String cname = t_last.getName();
                    if (t_last.isArray() && t_m[i].getModifiers() == 128) {
                        cname = cname.replaceFirst("\\[\\]", "");
                        t_map.put(String.valueOf(num) + "_varArgPos", Integer.toString(t_args.length - 1));
                    }
                    t_map.put(arg_key, cname);
                }
            }
            catch (NotFoundException e) {
                Tool.alertMSG(null, String.valueOf(e.getMessage()) + " failed in getMethods.(NotFound)");
            }
            i = i + 1;
        }
        return t_map;
    }

    public HashMap<String, String> getFields(FakeMethodRecord frec) {
        if (this.getSuper() == null) {
            return this.getDeclaredFields(frec);
        }
        HashMap<String, String> t_m = this.getDeclaredFields(frec);
        t_m.putAll(this.getSuper().getFields(frec));
        return t_m;
    }

    public HashMap<String, String> getDeclaredFields(FakeMethodRecord frec) {
        HashMap<String, String> t_map = new HashMap<String, String>();
        CtField[] t_m = this.m_class.getDeclaredFields();
        int i = 0;
        while (i < t_m.length) {
            try {
                if (!Modifier.isStatic(t_m[i].getModifiers()) && !Modifier.isFinal(t_m[i].getModifiers())) {
                    t_map.put(t_m[i].getName(), t_m[i].getType().getName());
                }
            }
            catch (NotFoundException e) {
                Tool.alertMSG(null, "The type of " + t_m[i].getName() + " not found.");
            }
            ++i;
        }
        if (this.is_fake) {
            ArrayList<FakeMethodRecord> frecs = Tool._db().getFakeMethods(this.m_class.getName(), Tool.version);
            int k = 0;
            while (k < frecs.size()) {
                String[][] t_list;
                if (!frecs.get(k).equals(frec) && (t_list = frecs.get((int)k).fields) != null) {
                    int j = 0;
                    while (j < t_list.length) {
                        if (t_list[j] == null) break;
                        if (!t_map.containsValue(t_list[j][0])) {
                            t_map.put(t_list[j][0], t_list[j][1]);
                        } else if (!t_map.get(t_list[j][0]).equals(t_list[j][1])) {
                            return null;
                        }
                        ++j;
                    }
                }
                ++k;
            }
        }
        return t_map;
    }

    /*
     * Unable to fully structure code
     */
    public Class<?> getFieldType(String fname) {
        block9: {
            block8: {
                try {
                    tfld = this.m_class.getField(fname);
                    return Tool.forName(tfld.getType().getName());
                }
                catch (NotFoundException e) {
                    if (!this.is_fake) break block8;
                    frecs = Tool._db().getFakeMethods(this.m_class.getName(), Tool.version);
                    k = 0;
                    ** while (k < frecs.size())
                }
lbl-1000:
                // 1 sources

                {
                    t_type = frecs.get(k).getFieldType(fname);
                    if (t_type != null && t_type.length() > 0) {
                        try {
                            return Tool.forName(t_type);
                        }
                        catch (ClassNotFoundException e1) {
                            return null;
                        }
                    }
                    ++k;
                    continue;
                }
            }
            if ((t_s = this.getSuper()) != null && !t_s.getClassName().equals("java.lang.Object")) {
                return t_s.getFieldType(fname);
            }
            break block9;
            catch (ClassNotFoundException e) {
                Tool.logIfDebug(e, "@ClassOutLine#getFieldType");
            }
        }
        return null;
    }
}

