package com.ftinc.si.assist.test.web;

import java.util.ArrayList;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.security.UserAndPassword;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

import com.ftinc.si.assist.test.Fson;
import com.ftinc.si.assist.test.Tool;

public class Prompt extends PageAction {
	
	public ArrayList<String> doAction(WebDriver drv) {
		int t_sec = getTimeout();
		if (arg_map.containsKey("usr")) {
			t_sec = 3;
			try {
				WebDriverWait wait = new WebDriverWait(drv, t_sec);
				wait.until(ExpectedConditions.alertIsPresent());
			} catch (Exception e) {
				//Proxy認証が求められれば対処するだけなので、見つからなくてもエラーではない。
				Tool.logIfDebug(null, "authentication dialog not found @Prompt");
				return null;
			}
		} else {
			WebDriverWait wait = new WebDriverWait(drv, t_sec);
			wait.until(ExpectedConditions.alertIsPresent());
		}
		org.openqa.selenium.Alert t_alert = drv.switchTo().alert();
		
		if (arg_map.containsKey("usr")) {
			Tool.logIfDebug(null, "authentication dialog found @Prompt");
			
			String uid = arg_map.get("usr").toString();
			String pwd = (String)arg_map.get("pwd");
			if (pwd == null) {
				pwd = "";
			}
			t_alert.authenticateUsing(new UserAndPassword(uid, pwd));
			Tool.logIfDebug(null, "tried to input to the authentication dialog @Prompt");
		} else {
			String t_str = (String)arg_map.get("keys");
			if (t_str != null) {
				t_alert.sendKeys(t_str);
				t_alert.accept();
			}
		}
		return null;
	}
	
	//path情報を持つアクションかどうか
	protected boolean hasPath() {
		return false;
	}

	//以下、Assertと二重の書き込みになるが自動的に整合性は保たれる。
	//WebElementGetterのArgument欄の値を指定する。
	protected ArrayList<String> getLabelAndParams() {
		ArrayList<String> t_list2 = new ArrayList<String>();
		t_list2.add("Keys");
		Object t_keys = arg_map.get("keys");
		if (t_keys != null) {
			t_list2.add(t_keys.toString());
		}
		return t_list2;
	}

	
	//PageActionEditorの第二列に書き込む内容を合成する。
	protected String getJsonElement(String target, String arg) {
		if (target == null && arg == null) {
			return super.getJsonElement(target, arg);
		}
		return target + ",\"keys\":\"" + Fson.escape(arg) + "\"";
	}

}
