package com.ftinc.si.assist.test.js;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;

import com.ftinc.si.assist.test.TestLogger;
import com.ftinc.si.assist.test.Tool;

public class JSTester {

	private static JSDriver s_driver = null;

	//infoは、実行環境（ブラウザの指定）、includeするファイルもしくは出発点のURLのリスト
	//cmdsはJavascriptの命令一式
	//返却値は評価が成功した数
	public Integer test(HashMap<String, Object> infoDic, ArrayList<String> cmds, ArrayList<String> exprs) {
		try {
			s_driver = (JSDriver)Tool.newObject(Tool.forName(infoDic.get("driver").toString()), new Class[] {}, new Object[] {});
		} catch (SecurityException | NoSuchMethodException | IllegalArgumentException | InstantiationException
				| IllegalAccessException | InvocationTargetException | ClassNotFoundException e) {
			TestLogger.err("Class=" + infoDic.get("driver").toString() + " not found.>>"+ Tool.getStackMessage(e, 0, 10));
			return -3;
		}
		int n = -2;
		if (s_driver.load(infoDic)) {
			n = -1;
			for (int i = 0; i < cmds.size(); i++) {
				if (!s_driver.execute(cmds.get(i))) {
					return n;
				}
			}
			n = 0;
			for (int i = 0; i < exprs.size(); i++) {
				if (!s_driver.execute(cmds.get(i))) {
					return n;
				}
				n = i + 1;
			}
			//TestCommandごとにリセットする。
			s_driver.reset();
		}
		return n;//負値はincludeで失敗。
	}

	protected static void quit() {
		if (s_driver != null) {
			s_driver.quit();
		}
	}

}
