package com.ftinc.si.assist.test.web;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;


//テスト仕様書駆動用。$KEYのバリエーション設定を行う。
//$KEYを保持するだけのクラス。
public class IndexSetter extends PageAction {

	//Action実行の本体
	protected void doCore(WebDriver drv, WebElement elm) {
		if (arg_map.containsKey("value") && refer_to != null) {
			String t_val = (String)arg_map.get("value");
			String t_pos = "[1]";

			//最後が、[...]のパターン。最後など位置指定したくなる場合がある。
			String[] temp = t_val.split("\t");
			if (temp.length > 1) {
				t_val = temp[0];
				t_pos = temp[1];
			}
			final Pattern t_pat = Pattern.compile("\\[contains\\([^\\]]*?,''\\)\\]");
			Matcher t_m = t_pat.matcher(t_val);
			if (t_m.find()) {
				//「空文字を含む」という条件は無意味なので外す。$VAR=""が指定された場合。
				t_val = t_m.replaceAll("");
			}
			final Pattern t_pat2 = Pattern.compile("\\[[@\\.][^\\]=]*?=''\\]");
			t_m = t_pat2.matcher(t_val);
			if (t_m.find()) {
				//「空文字と等しい」という条件は考えにくいので外す。$VAR=""が指定された場合。
				t_val = t_m.replaceAll("");
			}
			
			refer_to.setArg("$KEY", t_val);
			refer_to.setArg("$POSITION", t_pos);
		}
	}
}
