/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test;

import com.ftinc.si.assist.test.Record;
import com.ftinc.si.assist.test.Tool;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class FakeMethodRecord
extends Record {
    public String[] argTypes;
    public String className;
    public String methodName;
    public String source;
    public String[][] fields;
    public String superName;
    public String version;

    public FakeMethodRecord() {
        super(0);
    }

    public FakeMethodRecord(int i) {
        super(i);
    }

    @Override
    public void read(ResultSet r) throws SQLException {
        this.className = r.getString("ClassName");
        this.source = r.getString("Source");
        this.setArgTypes(r.getString("ArgTypes"));
        this.methodName = r.getString("MethodName");
        this.setFields(r.getString("Fields"));
        this.version = r.getString("Version");
    }

    public int numArgs() {
        if (this.argTypes == null) {
            return 0;
        }
        return this.argTypes.length;
    }

    public String jsonOfArgTypes() {
        if (this.argTypes != null) {
            return Tool.getJSONfromObject(this.argTypes);
        }
        return "";
    }

    public void setArgTypes(String json) {
        this.argTypes = json == null || json.length() == 0 ? new String[0] : (String[])Tool.getObjectfromJSON(String[].class, json);
    }

    public int numFields() {
        if (this.fields == null) {
            return 0;
        }
        return this.fields.length;
    }

    private String jsonOfFields() {
        if (this.fields != null && this.fields.length > 0 && this.fields[0] != null) {
            return Tool.getJSONfromObject(this.fields);
        }
        return "";
    }

    public void setFields(String json) {
        this.fields = json == null || json.length() == 0 ? new String[0][] : (String[][])Tool.getObjectfromJSON(String[][].class, json);
    }

    public void addField(String cname, String fname) {
        String[][] t_list = new String[this.numFields() + 1][2];
        int i = 0;
        while (i < this.numFields()) {
            if (this.fields[i][0].equals(fname)) {
                return;
            }
            t_list[i][0] = this.fields[i][0];
            t_list[i][1] = this.fields[i][1];
            ++i;
        }
        t_list[this.numFields()][0] = fname;
        t_list[this.numFields()][1] = cname;
        this.fields = t_list;
    }

    public String getFieldType(String fname) {
        int i = 0;
        while (i < this.numFields()) {
            if (this.fields[i][0].equals(fname)) {
                return this.fields[i][1];
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getUpdateSQL() {
        if (this.removed && this.isNew()) {
            return null;
        }
        if (this.removed) {
            String sql_where = " where \"ClassName\"='" + this.className + "' and \"MethodName\"='" + this.methodName + "' and \"ArgTypes\"='" + this.jsonOfArgTypes() + "' and \"Version\"='" + this.version + "'";
            return "delete from \"tbl_AssertRecord\" " + sql_where;
        }
        String t_sql = null;
        if (this.isNew()) {
            t_sql = "insert into \"tbl_FakeMethodRecord\" (\"MethodName\", \"ClassName\", \"ArgTypes\", \"Source\", \"Version\", \"Fields\")values ('" + this.methodName + "','" + this.className + "','" + this.jsonOfArgTypes() + "','" + this._source() + "','" + this.version + "','" + this.jsonOfFields() + "')";
        } else if (this.isUpdated()) {
            String sql_where = " where \"ClassName\"='" + this.className + "' and \"MethodName\"='" + this.methodName + "' and \"ArgTypes\"='" + this.jsonOfArgTypes() + "' and \"Version\"='" + this.version + "'";
            t_sql = "update \"tbl_FakeMethodRecord\" set \"Source\"='" + this._source() + "', \"Fields\"='" + this.jsonOfFields() + "'" + sql_where;
        }
        return t_sql;
    }

    public boolean differed(String cname, String mname, String[] argtypes, String src) {
        if (this.className.equals(cname) && this.methodName.equals(mname) && Arrays.equals(this.argTypes, argtypes)) {
            if (this.source != null) {
                return !this.source.equals(src);
            }
            if (src == null) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 42;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().getName().equals("com.ftinc.si.assist.test.FakeMethodRecord")) {
            FakeMethodRecord frec = (FakeMethodRecord)obj;
            if (this.className.equals(frec.className) && this.methodName.equals(frec.methodName) && (this.argTypes == null ? frec.argTypes == null : this.argTypes == frec.argTypes)) {
                return true;
            }
        }
        return false;
    }

    private String _source() {
        return this.esq(this.source);
    }

    public static HashMap<String, String> getVFields(String cname) {
        HashMap<String, String> t_map = new HashMap<String, String>();
        cname = cname.replace("?", "");
        ArrayList<FakeMethodRecord> t_list = Tool._db().getFakeMethods(cname, Tool.version);
        int i = 0;
        while (i < t_list.size()) {
            String[][] t_flds = t_list.get((int)i).fields;
            int j = 0;
            while (j < t_flds.length) {
                if (!t_map.containsKey(t_flds[j][0])) {
                    t_map.put(t_flds[j][0], t_flds[j][1]);
                }
                ++j;
            }
            ++i;
        }
        return t_map;
    }
}

