/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.gui;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.FakeMethodRecord;
import com.ftinc.si.assist.test.Fson;
import com.ftinc.si.assist.test.JSONRecord;
import com.ftinc.si.assist.test.ObjectRecord;
import com.ftinc.si.assist.test.TestCaseRecord;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.gui.JSONChooser;
import com.ftinc.si.assist.test.gui.JSONEditor;
import com.ftinc.si.assist.test.gui.MethodEditor;
import com.ftinc.si.assist.test.gui.TestCaseEditor;
import com.ftinc.si.assist.test.gui.TestCmdNode;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.im.InputContext;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.Caret;

public class ArgumentEditor
extends JDialog {
    public static TestCaseEditor s_owner;
    private JTextField textTestID;
    private JTextField textCName;
    private JComboBox<String> stackBox;
    private JTextArea textJSON;
    private JButton btnCreateFake;
    ObjectRecord m_original;
    public ObjectRecord m_work;
    private String m_stack0;
    boolean is_pojo = false;

    public ArgumentEditor(TestCaseEditor owner, ObjectRecord rec, String stack0) {
        super((Dialog)owner, true);
        this.setResizable(false);
        this.m_original = rec;
        this.m_work = rec._dup(true);
        this.m_stack0 = stack0;
        this.is_pojo = rec.isPOJO;
        this.setTitle(Messages.getString("ArgumentEditor.0"));
        this.getContentPane().setLayout(null);
        this.setBounds(120, 120, 620, 526);
        JLabel lblTestid = new JLabel(Messages.getString("ArgumentEditor.1"));
        lblTestid.setBounds(12, 10, 50, 13);
        this.getContentPane().add(lblTestid);
        this.textTestID = new JTextField();
        this.textTestID.setEditable(false);
        this.textTestID.setBounds(81, 7, 120, 19);
        this.getContentPane().add(this.textTestID);
        this.textTestID.setColumns(10);
        this.textTestID.setText(new Integer(rec.testID).toString());
        JLabel lblClassname = new JLabel(Messages.getString("ArgumentEditor.2"));
        lblClassname.setBounds(12, 43, 66, 13);
        this.getContentPane().add(lblClassname);
        this.textCName = new JTextField();
        this.textCName.setBounds(12, 66, 285, 19);
        this.getContentPane().add(this.textCName);
        this.textCName.setColumns(10);
        this.textCName.setText(rec.className);
        JLabel lblStack = new JLabel(Messages.getString("ArgumentEditor.3"));
        lblStack.setHorizontalAlignment(2);
        lblStack.setBounds(309, 43, 75, 13);
        this.getContentPane().add(lblStack);
        JCheckBox notFake = new JCheckBox(Messages.getString("ArgumentEditor.4"));
        notFake.setEnabled(true);
        notFake.setSelected(this.is_pojo);
        notFake.setBounds(309, 6, 135, 21);
        this.getContentPane().add(notFake);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(12, 141, 586, 325);
        this.getContentPane().add(scrollPane);
        this.textJSON = new JTextArea();
        this.textJSON.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                Font t_font = Tool.resizeFont(e, ArgumentEditor.this.textJSON.getFont());
                if (t_font != null) {
                    ArgumentEditor.this.textJSON.setFont(t_font);
                }
            }
        });
        this.textJSON.setFont(new Font("MS UI Gothic", 0, 14));
        scrollPane.setViewportView(this.textJSON);
        this.textJSON.setText(rec.jSON);
        this.textJSON.enableInputMethods(false);
        this.textJSON.setEditable(!TestCaseEditor.unableMode);
        InputContext ic = this.textJSON.getInputContext();
        ic.setCompositionEnabled(true);
        final JButton btnFindTemplate = new JButton(Messages.getString("ArgumentEditor.5"));
        btnFindTemplate.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!btnFindTemplate.isEnabled()) {
                    return;
                }
                if (!ArgumentEditor.this.textJSON.getText().equals(ArgumentEditor.this.m_work.jSON)) {
                    ArgumentEditor.this.m_work.jSON = ArgumentEditor.this.textJSON.getText();
                    ArgumentEditor.this.m_work.changed();
                }
                if (!ArgumentEditor.this.insertByJSONChooser()) {
                    ArrayList<JSONRecord> t_data = Tool._db().getJSONRecWhere(ArgumentEditor.this.m_work.className, null, Tool.version);
                    if (t_data.size() > 0) {
                        JSONChooser chooser = new JSONChooser((JDialog)Tool.getParent((Component)e.getSource(), "JDialog"), t_data);
                        chooser.setVisible(true);
                        if (chooser.is_ok) {
                            ArgumentEditor.this.textJSON.setText(chooser.m_json);
                            ArgumentEditor.this.m_work.setJSON(chooser.m_json);
                        }
                    } else {
                        Tool.alertMSG(null, Messages.getString("ArgumentEditor.11"));
                    }
                }
            }
        });
        btnFindTemplate.setBounds(346, 103, 120, 21);
        btnFindTemplate.setEnabled(!TestCaseEditor.unableMode);
        this.getContentPane().add(btnFindTemplate);
        this.stackBox = new JComboBox();
        this.stackBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object t_obj = ArgumentEditor.this.stackBox.getSelectedItem();
                if (t_obj != null) {
                    String t_strid = t_obj.toString();
                    if (ArgumentEditor.this.isSnapshot(t_strid)) {
                        Tool.alertMSG(null, "SnapshotCommand can not be specified.");
                        ArgumentEditor.this.stackBox.setSelectedItem(null);
                    } else {
                        ArgumentEditor.this.m_work.stack = t_strid;
                    }
                }
            }
        });
        this.stackBox.setEditable(true);
        this.stackBox.setBounds(309, 67, 289, 16);
        this.getContentPane().add(this.stackBox);
        JLabel lblJson = new JLabel(Messages.getString("ArgumentEditor.6"));
        lblJson.setBounds(12, 107, 50, 13);
        this.getContentPane().add(lblJson);
        final JButton btnOK = new JButton(Messages.getString("ArgumentEditor.7"));
        btnOK.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                block23: {
                    if (!btnOK.isEnabled()) {
                        return;
                    }
                    if (!ArgumentEditor.this.m_work.className.equals(ArgumentEditor.this.m_original.typeName)) {
                        Class<?> e_class;
                        Class<?> o_class;
                        try {
                            o_class = Tool.forName(ArgumentEditor.this.m_original.typeName);
                        }
                        catch (ClassNotFoundException e1) {
                            Tool.alertMSG(null, String.valueOf(Messages.getString("ArgumentEditor.13")) + ArgumentEditor.this.m_original.typeName);
                            return;
                        }
                        try {
                            e_class = Tool.forName(ArgumentEditor.this.m_work.className);
                        }
                        catch (ClassNotFoundException e1) {
                            Tool.alertMSG(null, String.valueOf(Messages.getString("ArgumentEditor.14")) + ArgumentEditor.this.m_work.className);
                            return;
                        }
                        if (!o_class.isAssignableFrom(e_class)) {
                            Tool.alertMSG(null, String.valueOf(Messages.getString("ArgumentEditor.15")) + ArgumentEditor.this.m_work.className + Messages.getString("ArgumentEditor.16") + ArgumentEditor.this.m_original.typeName);
                            return;
                        }
                    }
                    if (!ArgumentEditor.this.textJSON.getText().equals(ArgumentEditor.this.m_work.jSON)) {
                        ArgumentEditor.this.m_work.setJSON(ArgumentEditor.this.textJSON.getText());
                    }
                    if (ArgumentEditor.this.m_work.jSON.equals(Messages.getString("ArgumentEditor.17"))) {
                        ArgumentEditor.this.m_work.completed = true;
                    } else if (ArgumentEditor.this.m_work.jSON.length() > 0) {
                        try {
                            Object t_obj;
                            String cname = ArgumentEditor.this.m_work.className;
                            if (!ArgumentEditor.this.is_pojo) {
                                cname = "java.util.HashMap";
                            }
                            Class<?> t_c = null;
                            if (!cname.equals("java.lang.Class")) {
                                t_c = Tool.forName(Tool.primitiveToFQN(cname));
                            }
                            if ((t_obj = Tool.getObjectfromJSON(t_c, ArgumentEditor.this.m_work.jSON)) == null && ArgumentEditor.this.m_work.jSON.length() > 0 && !ArgumentEditor.this.m_work.jSON.equals("null")) {
                                ArgumentEditor.this.m_work.completed = false;
                                return;
                            }
                            if (ArgumentEditor.this.is_pojo && t_obj != null) {
                                ArgumentEditor.this.m_work.completed = false;
                                if (t_c == null) {
                                    ArgumentEditor.this.m_work.completed = true;
                                } else if (ArgumentEditor.this.checkJSONField(Tool.forName(Tool.primitiveToFQN(ArgumentEditor.this.m_work.className)), ArgumentEditor.this.m_work.jSON)) {
                                    ArgumentEditor.this.m_work.completed = true;
                                }
                                break block23;
                            }
                            ArgumentEditor.this.m_work.completed = true;
                        }
                        catch (ClassNotFoundException e1) {
                            Tool.alertMSG(null, e1.getMessage());
                        }
                    } else {
                        String t_strid;
                        Object t_obj = ArgumentEditor.this.stackBox.getSelectedItem();
                        if (t_obj != null && (t_strid = t_obj.toString()).matches("^[0-9]+\\$[_0-9]+[\\w\\(\\)\\.]*$")) {
                            ArgumentEditor.this.m_work.completed = true;
                        }
                    }
                }
                if (!ArgumentEditor.this.m_work.equals(ArgumentEditor.this.m_original)) {
                    ArgumentEditor.this.m_original.isPOJO = ArgumentEditor.this.m_work.isPOJO;
                    ArgumentEditor.this.m_original.completed = ArgumentEditor.this.m_work.completed;
                    ArgumentEditor.this.m_original.jSON = ArgumentEditor.this.m_work.jSON;
                    ArgumentEditor.this.m_original.className = ArgumentEditor.this.m_work.className;
                    ArgumentEditor.this.m_original.removed = ArgumentEditor.this.m_work.removed;
                    ArgumentEditor.this.m_original.stack = ArgumentEditor.this.m_work.stack;
                    ArgumentEditor.this.m_original.enable = ArgumentEditor.this.m_work.enable;
                    ArgumentEditor.this.m_original.changed();
                }
                ArgumentEditor.this.setVisible(false);
            }
        });
        btnOK.setBounds(186, 470, 91, 21);
        btnOK.setEnabled(!TestCaseEditor.unableMode);
        this.getContentPane().add(btnOK);
        final JButton btnAddTemplate = new JButton(Messages.getString("ArgumentEditor.8"));
        btnAddTemplate.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!btnAddTemplate.isEnabled()) {
                    return;
                }
                if (!ArgumentEditor.this.m_work.jSON.matches("^\\s*\\([\\w\\.]+\\)\\$1=.*$")) {
                    String t_val = JOptionPane.showInputDialog(this, (Object)(String.valueOf(Messages.getString("ArgumentEditor.19")) + ArgumentEditor.this.m_work.className + Messages.getString("ArgumentEditor.20")));
                    if (t_val != null) {
                        if (Tool._db().getJSONRecord(ArgumentEditor.this.m_work.className, t_val, Tool.version) != null) {
                            ArgumentEditor.this.saveJson(t_val, true);
                        } else {
                            ArgumentEditor.this.saveJson(t_val, false);
                        }
                    }
                } else {
                    Tool.alertMSG(null, Messages.getString("ArgumentEditor.21"));
                }
            }
        });
        btnAddTemplate.setBounds(478, 103, 120, 21);
        btnAddTemplate.setEnabled(!TestCaseEditor.unableMode);
        this.getContentPane().add(btnAddTemplate);
        this.btnCreateFake = new JButton(Messages.getString("ArgumentEditor.9"));
        this.btnCreateFake.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!ArgumentEditor.this.btnCreateFake.isEnabled()) {
                    return;
                }
                String cname = ArgumentEditor.this.textCName.getText();
                MethodEditor t_br = new MethodEditor(null, cname, null, null, null);
                t_br.setBounds(e.getXOnScreen() - 200, e.getYOnScreen(), t_br.getWidth(), t_br.getHeight());
                t_br.setVisible(true);
                FakeMethodRecord t_rec = t_br.getFakeMethodRecord();
                if (t_rec != null) {
                    try {
                        if (Tool.existClass(t_rec.className)) {
                            Tool._db().updateRecordBySQL(t_rec.getUpdateSQL(), true);
                        } else {
                            Tool._db().updateRecordBySQL(t_rec.getUpdateSQL(), true);
                            Tool.getFakeInstance(cname);
                        }
                    }
                    catch (SQLException e1) {
                        Tool.alertMSG(null, String.valueOf(Messages.getString("ArgumentEditor.12")) + e1.getMessage());
                    }
                }
            }
        });
        this.btnCreateFake.setBounds(478, 6, 120, 21);
        this.btnCreateFake.setEnabled(false);
        this.getContentPane().add(this.btnCreateFake);
        notFake.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ArgumentEditor.this.m_work.isPOJO = ArgumentEditor.this.is_pojo = !ArgumentEditor.this.is_pojo;
                ArgumentEditor.this.m_work.changed();
                if (!TestCaseEditor.unableMode) {
                    if (ArgumentEditor.this.is_pojo) {
                        ArgumentEditor.this.btnCreateFake.setEnabled(false);
                        ArgumentEditor.this.stackBox.setEnabled(true);
                    } else {
                        ArgumentEditor.this.stackBox.setEnabled(false);
                        ArgumentEditor.this.btnCreateFake.setEnabled(true);
                    }
                }
            }
        });
        notFake.setSelected(rec.isPOJO);
        JButton btnCancel = new JButton(Messages.getString("ArgumentEditor.btnCancel.text"));
        btnCancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ArgumentEditor.this.setVisible(false);
            }
        });
        btnCancel.setBounds(289, 470, 91, 21);
        this.getContentPane().add(btnCancel);
        final JButton editJson = new JButton(Messages.getString("ArgumentEditor.22"));
        editJson.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!editJson.isEnabled()) {
                    return;
                }
                String cname = ArgumentEditor.this.textCName.getText();
                if (!ArgumentEditor.this.is_pojo) {
                    cname = "java.util.HashMap";
                }
                JSONEditor t_ed = new JSONEditor(null, cname, "", ArgumentEditor.this.textJSON.getText());
                t_ed.setVisible(true);
                if (!ArgumentEditor.this.textJSON.getText().equals(t_ed.getJson())) {
                    ArgumentEditor.this.textJSON.setText(t_ed.getJson());
                }
            }
        });
        editJson.setBounds(57, 103, 120, 21);
        editJson.setEnabled(!TestCaseEditor.unableMode);
        this.getContentPane().add(editJson);
        final JButton btnDefalutJson = new JButton(Messages.getString("ArgumentEditor.btnDefalutJson.text"));
        btnDefalutJson.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!btnDefalutJson.isEnabled()) {
                    return;
                }
                String t_cname = ArgumentEditor.this.textCName.getText();
                String str_j = Tool.classToJSON(t_cname);
                if (str_j != null) {
                    ArgumentEditor.this.textJSON.setText(str_j);
                }
            }
        });
        btnDefalutJson.setBounds(186, 103, 111, 21);
        btnDefalutJson.setEnabled(!TestCaseEditor.unableMode);
        this.getContentPane().add(btnDefalutJson);
        this.initStack();
    }

    private void initStack() {
        ArrayList<String> refered = new ArrayList<String>();
        ArrayList<String> reusables = new ArrayList<String>();
        ArrayList<TestCaseRecord> case_list = Tool._db().getTestCaseList(this.m_work.testCase, 0, 0, "", Tool.version);
        if (case_list.size() > 0) {
            TestCaseRecord t_rec = case_list.get(0);
            ArrayList<String> testIDs = Tool._db().getTestIDsByReturnType(this.m_work.testCase, this.m_work.className, t_rec.begin, t_rec.end);
            int i = 0;
            while (testIDs.size() > i) {
                Integer k = new Integer(testIDs.get(i));
                if (this.m_work.testID > k && !reusables.contains(String.valueOf(testIDs.get(i)) + "$_") && !this.isSnapshot(String.valueOf(testIDs.get(i)) + "$_")) {
                    reusables.add(String.valueOf(testIDs.get(i)) + "$_");
                }
                ++i;
            }
            ArrayList<ObjectRecord> t_stacks1 = Tool._db().getReusableObjectRecord(this.m_work.testCase, this.m_work.className, this.m_work.testID, t_rec.begin);
            int j = 0;
            while (t_stacks1.size() > j) {
                String num = t_stacks1.get((int)j).id.replaceFirst("\\$.+", "");
                Integer k = new Integer(num);
                if (this.m_work.testID > k) {
                    if (!reusables.contains(t_stacks1.get((int)j).id) && !this.isSnapshot(t_stacks1.get((int)j).id)) {
                        reusables.add(t_stacks1.get((int)j).id);
                    }
                    if (t_stacks1.get((int)j).id.matches("^[0-9]+\\$.+$") && !refered.contains(t_stacks1.get((int)j).id) && this.isSnapshot(t_stacks1.get((int)j).id)) {
                        refered.add(t_stacks1.get((int)j).id);
                    }
                }
                ++j;
            }
        }
        this.stackBox.addItem(this.m_work.stack);
        if (!this.m_work.stack.equals(this.m_stack0)) {
            this.stackBox.addItem(this.m_stack0);
        }
        int j = 0;
        while (j < reusables.size()) {
            String t_obj = (String)reusables.get(j);
            if (!refered.contains(t_obj)) {
                this.stackBox.addItem(t_obj);
            }
            ++j;
        }
        this.stackBox.setSelectedIndex(0);
        if (!TestCaseEditor.unableMode) {
            if (this.is_pojo) {
                this.btnCreateFake.setEnabled(false);
                this.stackBox.setEnabled(true);
            } else {
                this.stackBox.setEnabled(false);
                this.btnCreateFake.setEnabled(true);
            }
        }
    }

    private boolean isSnapshot(String sid) {
        if (sid != null && sid.matches("^[0-9]+\\$[_0-9]+$")) {
            Integer t_id = new Integer(sid.replaceFirst("^([0-9]+)\\$[_0-9]+$", "$1"));
            TestCmdNode t_cmd = ArgumentEditor.s_owner.m_snapshot;
            if (t_cmd != null) {
                if (t_cmd.getID() == t_id.intValue()) {
                    return true;
                }
            } else {
                ArrayList<TestCaseRecord> t_list = Tool._db().getTestCaseList(ArgumentEditor.s_owner.m_include, 0, 0, "", Tool.version);
                if (t_list.size() > 0) {
                    String num = Integer.toString(t_list.get((int)0).snapshot);
                    if (t_id.toString().equals(num)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean checkJSONField(Class<?> xclass, String s_json) {
        if (this.isMap(xclass) && s_json != null && s_json.length() > 0) {
            return true;
        }
        if (xclass.getName().startsWith("java.lang")) {
            try {
                Object t_obj = Tool.getObjectfromJSON(xclass, s_json);
                return t_obj != null;
            }
            catch (Exception e) {
                return false;
            }
        }
        HashMap t_map = (HashMap)Tool.getObjectfromJSON(HashMap.class, s_json);
        for (Map.Entry entry : t_map.entrySet()) {
            String fname = (String)entry.getKey();
            Field t_f = Tool.getField(xclass, fname = fname.replaceFirst("\\(.*\\)", ""));
            if (t_f != null) continue;
            return false;
        }
        return true;
    }

    private boolean isMap(Class<?> xc) {
        Class<?>[] clist = xc.getInterfaces();
        int i = 0;
        while (i < clist.length) {
            if (clist[i].getName().equals("java.util.Map") || this.isMap(clist[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean insertByJSONChooser() {
        String s_str = this.textJSON.getText();
        Caret t_ca = this.textJSON.getCaret();
        if ((s_str = s_str.substring(0, t_ca.getDot())) != null) {
            String cname = null;
            Pattern t_pat1 = Pattern.compile("[{,\\s\"]\\$[0-9]+\\(([\\w\\.\\[\\]]+)\\)[\\s\"]*:$");
            Matcher t_m = t_pat1.matcher(s_str);
            if (t_m.find()) {
                cname = t_m.group(1);
            } else {
                Pattern t_pat2 = Pattern.compile("[{,\\s\"][\\$\\w]+[\\s\"]*:\\s*\\([\\w\\.\\[\\]]\\)$");
                t_m = t_pat2.matcher(s_str);
                if (t_m.find()) {
                    cname = t_m.group(1);
                }
            }
            if (cname != null) {
                ArrayList<JSONRecord> t_data = Tool._db().getJSONRecWhere(cname, null, Tool.version);
                if (t_data.size() > 0) {
                    JSONChooser chooser = new JSONChooser(this, t_data);
                    chooser.setVisible(true);
                    if (chooser.is_ok) {
                        int pos = this.textJSON.getCaretPosition();
                        String str_h = this.textJSON.getText();
                        String str_tail = str_h.substring(pos);
                        String t_str = chooser.m_json;
                        str_h = str_h.substring(0, pos);
                        str_h = String.valueOf(str_h) + t_str + str_tail;
                        this.textJSON.setText(str_h);
                        this.textJSON.setCaretPosition(pos + t_str.length());
                        this.m_work.setJSON(this.textJSON.getText());
                    }
                } else {
                    Tool.alertMSG(null, Messages.getString("ArgumentEditor.64"));
                }
                return true;
            }
        }
        return false;
    }

    private void saveJson(String name, boolean newFlag) {
        JSONRecord t_j = null;
        if (newFlag) {
            t_j = new JSONRecord(2);
            t_j.name = name;
            t_j.className = this.m_work.className;
            t_j.content = this.m_work.jSON;
        } else {
            t_j = new JSONRecord(1);
            t_j.name = name;
            t_j.className = this.m_work.className;
            t_j.content = this.m_work.jSON;
        }
        HashMap<Object, Object> f_map = new HashMap();
        try {
            f_map = Fson.getFieldMapOfJson(this.m_work.jSON);
        }
        catch (ParseException e1) {
            Tool.logIfDebug(e1, " Illegal Json.");
            return;
        }
        boolean _1st = true;
        String t_res = "";
        for (Map.Entry<Object, Object> entry : f_map.entrySet()) {
            if (!_1st) {
                t_res = String.valueOf(t_res) + ",\n";
            } else {
                _1st = false;
            }
            t_res = String.valueOf(t_res) + (String)entry.getKey();
        }
        t_j.fields = t_res;
        if (t_j != null) {
            try {
                Tool._db().updateRecordBySQL(t_j.getUpdateSQL(), true);
            }
            catch (SQLException e) {
                Tool.alertMSG(null, String.valueOf(Messages.getString("ArgumentEditor.18")) + e.getMessage());
            }
        }
    }
}

