/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.gui;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.ClassOutLine;
import com.ftinc.si.assist.test.TestCommandRecord;
import com.ftinc.si.assist.test.Tool;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ClassReadDialog
extends JDialog {
    public static JDialog s_owner;
    private ArrayList<String> m_targets;
    private JTextField textClass;
    public ClassOutLine m_curClass;
    private DefaultListModel<String> methd_model = new DefaultListModel();
    private DefaultListModel<String> const_model = new DefaultListModel();
    private JList<String> method_list;
    private JList<String> const_list;
    private JTextArea textArgs;
    public String className = null;
    public String methodName;
    public String[] objs;
    private JComboBox<String> focusedClass;

    public ClassReadDialog(JDialog p, ArrayList<String> dirs, TestCommandRecord test) {
        super((Dialog)p, true);
        this.setTitle(Messages.getString("ClassReadDialog.0"));
        this.setResizable(false);
        if (p != null) {
            this.setBounds(p.getX() + 100, p.getY() + 100, 545, 470);
        } else {
            this.setBounds(100, 100, 545, 470);
        }
        this.m_targets = (ArrayList)dirs.clone();
        this.m_targets.add(Tool.fake_dir);
        this.getContentPane().setLayout(null);
        JLabel lblClass = new JLabel(Messages.getString("ClassReadDialog.4"));
        lblClass.setBounds(12, 10, 50, 13);
        this.getContentPane().add(lblClass);
        this.textClass = new JTextField();
        this.textClass.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && ClassReadDialog.this.textClass.getText().length() > 0) {
                    ClassReadDialog.this.className = ClassReadDialog.this.textClass.getText();
                    ClassReadDialog.this.setClassName(ClassReadDialog.this.className);
                }
            }
        });
        this.textClass.setBounds(74, 10, 378, 19);
        this.getContentPane().add(this.textClass);
        this.textClass.setColumns(10);
        JButton btnFind = new JButton(Messages.getString("ClassReadDialog.5"));
        btnFind.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String cname = Tool.findClassName(Tool.getParent((Component)e.getSource(), "JDialog"), ClassReadDialog.this.m_targets);
                if (ClassReadDialog.this.m_targets.size() > 0 && cname == null) {
                    Tool.alertMSG(null, Messages.getString("ClassReadDialog.8"));
                } else if (cname.length() > 0) {
                    ClassReadDialog.this.className = cname;
                    ClassReadDialog.this.setClassName(ClassReadDialog.this.className);
                }
            }
        });
        btnFind.setBounds(464, 6, 63, 21);
        this.getContentPane().add(btnFind);
        JLabel lblArgs = new JLabel(Messages.getString("ClassReadDialog.16"));
        lblArgs.setBounds(12, 289, 50, 13);
        this.getContentPane().add(lblArgs);
        JButton btnOk = new JButton(Messages.getString("ClassReadDialog.17"));
        btnOk.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ClassReadDialog.this.setVisible(false);
            }
        });
        btnOk.setBounds(196, 410, 91, 21);
        this.getContentPane().add(btnOk);
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setBounds(74, 283, 453, 117);
        this.getContentPane().add(scrollPane_1);
        this.textArgs = new JTextArea();
        scrollPane_1.setViewportView(this.textArgs);
        JTabbedPane tabbedPane = new JTabbedPane(1);
        tabbedPane.setBounds(12, 104, 515, 157);
        this.getContentPane().add(tabbedPane);
        JScrollPane scrollPane = new JScrollPane();
        tabbedPane.addTab(Messages.getString("ClassReadDialog.18"), null, scrollPane, null);
        this.method_list = new JList<String>(this.methd_model);
        scrollPane.setViewportView(this.method_list);
        this.method_list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ClassReadDialog.this.className == null) {
                    return;
                }
                String t_str = (String)ClassReadDialog.this.method_list.getSelectedValue();
                if (t_str == null) {
                    return;
                }
                String num = t_str.replaceAll("^([0-9]+):.*$", "$1");
                ClassReadDialog.this.methodName = t_str.replaceFirst("^[0-9]+:\\s*", "");
                String mName = ClassReadDialog.this.methodName.replaceFirst("\\s*[0-9]+$", "");
                if (ClassReadDialog.this.m_curClass != null) {
                    String t_res = "$_=" + ClassReadDialog.this.m_curClass.getDeclaredMethods().get(String.valueOf(num) + "_$_") + "\n";
                    if (!mName.matches("^.*\\sstatic\\s.*$")) {
                        t_res = String.valueOf(t_res) + "$0=" + ClassReadDialog.this.m_curClass.getClassName() + "\n";
                    }
                    Integer j = 1;
                    String type_name = null;
                    while ((type_name = ClassReadDialog.this.m_curClass.getDeclaredMethods().get(String.valueOf(num) + "_$" + j.toString())) != null) {
                        t_res = String.valueOf(t_res) + "$" + j.toString() + "=" + type_name + "\n";
                        j = j + 1;
                    }
                    ClassReadDialog.this.objs = t_res.split(Pattern.quote("\n"));
                    t_res = t_res.replaceAll(Pattern.quote("test.fake."), "");
                    t_res = t_res.replaceAll(Pattern.quote("test.impl."), "");
                    if (ClassReadDialog.this.methodName.matches("^.+\\s[0-9]+$")) {
                        t_res = String.valueOf(t_res) + "$" + j.toString() + "=...\n";
                    }
                    if (ClassReadDialog.this.m_curClass.getDeclaredMethods().get(String.valueOf(num) + "_updated") != null) {
                        t_res = String.valueOf(t_res) + "\n Updated = " + ClassReadDialog.this.m_curClass.getDeclaredMethods().get(String.valueOf(num) + "_updated");
                    }
                    ClassReadDialog.this.textArgs.setText(t_res);
                }
            }
        });
        this.method_list.setSelectionMode(0);
        JScrollPane scrollPane_2 = new JScrollPane();
        tabbedPane.addTab(Messages.getString("ClassReadDialog.34"), null, scrollPane_2, null);
        this.const_list = new JList<String>(this.const_model);
        this.const_list.setToolTipText("");
        if (s_owner == null) {
            this.const_list.setEnabled(false);
        }
        this.const_list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ClassReadDialog.this.className == null || ClassReadDialog.this.m_curClass == null || s_owner == null) {
                    return;
                }
                HashMap<String, String> t_map = ClassReadDialog.this.m_curClass.getDeclaredConstructors();
                if (t_map == null) {
                    Tool.alertMSG(null, Messages.getString("ClassReadDialog.36"));
                    return;
                }
                String t_con = (String)ClassReadDialog.this.const_list.getSelectedValue();
                t_con = t_con.replaceFirst(":constructor", "");
                String vPos = t_map.get(String.valueOf(t_con) + "_varArgPos");
                ClassReadDialog.this.methodName = ClassReadDialog.this.m_curClass.getClassName();
                if (vPos != null) {
                    ClassReadDialog.this.methodName = String.valueOf(ClassReadDialog.this.methodName) + " " + vPos;
                }
                String t_res = "$_=" + ClassReadDialog.this.m_curClass.getClassName() + "\n";
                Integer j = 1;
                String type_name = null;
                while ((type_name = t_map.get(String.valueOf(t_con) + "_$" + j.toString())) != null) {
                    t_res = String.valueOf(t_res) + "$" + j.toString() + "=" + type_name + "\n";
                    j = j + 1;
                }
                ClassReadDialog.this.objs = t_res.split(Pattern.quote("\n"));
                if (vPos != null) {
                    t_res = String.valueOf(t_res) + "$" + j.toString() + "=...\n";
                }
                ClassReadDialog.this.textArgs.setText(t_res);
            }
        });
        scrollPane_2.setViewportView(this.const_list);
        JLabel lblFocused = new JLabel(Messages.getString("ClassReadDialog.46"));
        lblFocused.setBounds(12, 59, 91, 13);
        this.getContentPane().add(lblFocused);
        this.focusedClass = new JComboBox();
        this.focusedClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ClassReadDialog.this.className == null) {
                    return;
                }
                String t_str = ClassReadDialog.this.focusedClass.getSelectedItem().toString();
                ClassReadDialog.this.setMethods(t_str);
            }
        });
        this.focusedClass.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.focusedClass.setBounds(115, 56, 383, 16);
        this.getContentPane().add(this.focusedClass);
        JButton btnCancel = new JButton(Messages.getString("ClassReadDialog.btnCancel.text"));
        btnCancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ClassReadDialog.this.className = null;
                ClassReadDialog.this.setVisible(false);
            }
        });
        btnCancel.setBounds(301, 410, 91, 21);
        this.getContentPane().add(btnCancel);
        if (test != null) {
            this.setTitle(String.valueOf(Messages.getString("ClassReadDialog.1")) + new Integer(test.id).toString());
            if (test.className != null && test.className.length() > 0) {
                this.className = test.className;
                this.setClassName(this.className);
            }
        } else {
            this.setTitle(Messages.getString("ClassReadDialog.3"));
        }
    }

    public boolean setClassName(String c_name) {
        this.className = c_name;
        this.textClass.setText(this.className);
        if (c_name != null && c_name.length() > 0) {
            this.m_curClass = Tool.getClassOutLine(this.className);
            if (this.m_curClass != null) {
                this.setMethods(this.m_curClass.getClassName());
                this.focusedClass.removeAll();
                this.focusedClass.addItem(this.m_curClass.getClassName());
                ClassOutLine s_class = this.m_curClass;
                while (s_class != null) {
                    this.focusedClass.addItem(s_class.getClassName());
                    s_class = s_class.getSuper();
                }
                ArrayList<ClassOutLine> t_lines = this.m_curClass.getInterfaces();
                int i = 0;
                while (i < t_lines.size()) {
                    this.focusedClass.addItem(t_lines.get(i).getClassName());
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    private void setMethods(String c_name) {
        this.m_curClass = Tool.getClassOutLine(c_name);
        if (this.m_curClass == null) {
            return;
        }
        HashMap<String, String> t_con = this.m_curClass.getDeclaredConstructors();
        ArrayList<String> t_list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : t_con.entrySet()) {
            if (!entry.getKey().endsWith("_name")) continue;
            String t_key = entry.getKey();
            t_key = t_key.replaceFirst("_name", "");
            t_key = String.format("%1$03d", new Integer(t_key));
            t_list.add(String.valueOf(t_key) + ":constructor");
        }
        this.const_list.removeAll();
        this.sort(t_list, this.const_model);
        this.const_list.setModel(this.const_model);
        t_list.clear();
        HashMap<String, String> t_met = this.m_curClass.getDeclaredMethods();
        for (Map.Entry<String, String> entry : t_met.entrySet()) {
            if (!entry.getKey().endsWith("_name")) continue;
            String t_key = entry.getKey();
            t_key = t_key.replaceFirst("_name", "");
            t_key = String.format("%1$03d", new Integer(t_key));
            t_list.add(String.valueOf(t_key) + ":" + t_met.get(entry.getKey()));
        }
        this.method_list.removeAll();
        this.sort(t_list, this.methd_model);
        this.method_list.setModel(this.methd_model);
    }

    private void sort(ArrayList<String> list, DefaultListModel<String> model) {
        model.removeAllElements();
        Collections.sort(list);
        int i = 0;
        while (i < list.size()) {
            model.addElement(list.get(i));
            ++i;
        }
    }

    public String getArgTypes() {
        String t_res = "";
        if (this.objs != null) {
            int i = 0;
            while (i < this.objs.length) {
                t_res = String.valueOf(t_res) + this.objs[i];
                if (i < this.objs.length - 1) {
                    t_res = String.valueOf(t_res) + ",\n";
                }
                ++i;
            }
        }
        t_res = t_res.replaceAll(Pattern.quote("test.fake."), "");
        t_res = t_res.replaceAll(Pattern.quote("test.impl."), "");
        return t_res;
    }
}

