/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.js;

import com.ftinc.si.assist.test.TestLogger;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.js.JSDriver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public class JSDriverOnBrowser
implements JSDriver {
    private WebDriver m_driver = null;

    @Override
    public void quit() {
        if (this.m_driver != null) {
            this.m_driver.quit();
            this.m_driver = null;
        }
    }

    @Override
    public boolean load(HashMap<String, Object> map) {
        if (this.m_driver == null) {
            this.m_driver = this.getDriver();
        }
        if (this.m_driver == null) {
            TestLogger.err("Execution Failed: BROWSER not specified.");
            return false;
        }
        ArrayList flist = (ArrayList)map.get("includes");
        if (flist.size() == 1) {
            this.m_driver.get(Tool.convert2Alias((String)flist.get(0)));
            WebDriverWait wait = new WebDriverWait(this.m_driver, 20L);
            ExpectedCondition<Boolean> u_ec = new ExpectedCondition<Boolean>(){

                public Boolean apply(WebDriver drv) {
                    Object t_state = ((JavascriptExecutor)drv).executeScript("return document.readyState", new Object[0]);
                    if (t_state.equals("complete")) {
                        return true;
                    }
                    return false;
                }
            };
            try {
                wait.until((Function)u_ec);
            }
            catch (Exception e) {
                TestLogger.err(String.valueOf((String)flist.get(0)) + " >>" + e.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean execute(String str) {
        try {
            Object xret = ((JavascriptExecutor)this.m_driver).executeScript(str, new Object[0]);
            return !str.startsWith("if") || xret != null && !xret.toString().equals("false");
        }
        catch (Exception e) {
            TestLogger.err("Execution Failed:" + str + " >>" + e.getMessage());
            return false;
        }
    }

    private WebDriver getDriver() {
        FirefoxDriver drv = null;
        String bname = System.getProperty("webtest.browser").toLowerCase();
        try {
            if (bname.equals("firefox")) {
                drv = new FirefoxDriver();
            } else if (bname.equals("ie")) {
                InternetExplorerOptions ieCap = new InternetExplorerOptions();
                ieCap.setCapability("ignoreProtectedModeSettings", true);
                drv = new InternetExplorerDriver(ieCap);
            } else if (bname.equals("chrome")) {
                drv = new ChromeDriver();
            } else if (bname.equals("edge")) {
                drv = new EdgeDriver();
            }
        }
        catch (Throwable e) {
            Tool.alertMSG(null, "Failed to connect browser=<" + bname + ">\n" + e.getMessage());
            if (drv != null) {
                drv.quit();
            }
            return null;
        }
        return drv;
    }

    @Override
    public void reset() {
        this.m_driver.get("about:blank");
    }
}

