package com.ftinc.si.assist.test.gui.plugins;

import java.util.HashMap;

import javax.swing.JMenuItem;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.run.VCentral;
import com.ftinc.si.assist.test.ArgumentIF;
import com.ftinc.si.assist.test.AssertIF;
import com.ftinc.si.assist.test.AssertRecord;
import com.ftinc.si.assist.test.TestCaseIF;
import com.ftinc.si.assist.test.TestCommandIF;
import com.ftinc.si.assist.test.gui.JSONEditor;
import com.ftinc.si.assist.test.gui.Plugin;
import com.ftinc.si.assist.test.gui.TestCaseEditor;

public class DictionaryPlugin implements Plugin{
	@Override
	public JMenuItem getMenuItem(String s) {
		if (s.equals("addCommand")) { //$NON-NLS-1$
			return TestCaseEditor.getMenuItem(s, Messages.getString("DictionaryPlugin.1"), null, this); //$NON-NLS-1$
		} else if (s.equals("editArg")) { //$NON-NLS-1$
			return TestCaseEditor.getMenuItem(s, Messages.getString("DictionaryPlugin.3"), null, this); //$NON-NLS-1$
		}
		return null;
	}


	@Override
	public int getPriority(TestCaseIF cs, TestCommandIF rec, String stack) {
		if (rec != null && VCentral.class.getName().equals(rec.getClassName())) {
			if (rec.isStatic() && "prepare".equals(rec.getMethodName())) { //$NON-NLS-1$
				if (stack != null) {
//直接、JSONエディタを開いてみたが、やや戸惑うのでコメントアウトした。
//					return 2;//編集：デフォルトのメニューを排除する。編集や再利用など。
				}
			} else if ("ASSERT".equals(stack) ) {
				return 2;
			}
		} else if (stack == null) {
			//TestCaseの上もしくは空白。常に使う
			return 1;//追加
		}
		return 0;
	}

	@Override
	public int initCommand(TestCommandIF cmd) {
		cmd.setClassName(VCentral.class.getName());
		cmd.setMethod("prepare", true, 1); //$NON-NLS-1$
		cmd.setReturnType("void"); //$NON-NLS-1$
		return 2;//$0+最初の引数
	}

	@Override
	public void initArguments(ArgumentIF[] a) {
		for (int i = 1; i < a.length; i++) {
			a[i].setClassName("java.util.HashMap"); //$NON-NLS-1$
		}
	}

	@Override
	public void initArgument(ArgumentIF a, String opt) {
		a.setClassName("java.util.HashMap"); //$NON-NLS-1$
	}

	@Override
	public int varArgsPos() {
		return -1;
	}

	@Override
	public boolean hasSubject() {
		return false;
	}

	@Override
	public boolean hasAssert() {
		return false;
	}

	@Override
	public void editArgument(ArgumentIF a, AssertIF ast, String opt) {
		String cname = a.getClassName();
		JSONEditor t_ed = new JSONEditor(JSONEditor.s_owner, cname, "varDictionary", a.getJSON()); //$NON-NLS-1$ //$NON-NLS-2$
		t_ed.setVisible(true);
		
		String t_json = t_ed.getJson();
		if (t_json != null && !t_json.equals(a.getJSON())) {
			a.setJSON(t_json);
		}
	}

	//nullは何もしない
	@Override
	public TestCommandIF extendCommand(TestCommandIF a) {
		return null;
	}
	
	//Assertの内容を設定する。
	public void initAssert(AssertIF ast) {
		((AssertRecord)ast).enable = false;
	}


	@Override
	public void editProperties(HashMap<String, String> map) {
	}


	@Override
	public void initProperties(HashMap<String, String> map) {
	}

	@Override
	public void editAssert(AssertIF ast, TestCommandIF atd) {
	}
	
	@Override
	public void destroy() {
	}

}
