/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.gui;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.ClassOutLine;
import com.ftinc.si.assist.test.Fson;
import com.ftinc.si.assist.test.JSONRecord;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.gui.ConstructorSelector;
import com.ftinc.si.assist.test.gui.JSONChooser;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ListUI;

public class JSONEditor
extends JDialog {
    public static JDialog s_owner;
    private JTextField className;
    private JTextField cnameCurField;
    private ArrayList<String> m_targets;
    private ClassOutLine m_curOutline;
    private JComboBox<String> comboNames;
    private JComboBox<String> comboClasses;
    private String curFieldName;
    private HashMap<String, String> m_f2cname;
    private HashMap<String, String> m_f2json;
    private HashMap<String, String> m_f2editing;
    private JEditorPane jsonPane;
    private DefaultListModel<String> m_lmodel = null;
    private DefaultComboBoxModel<String> m_cmodel;
    private String in_json;
    private boolean updatingComboNames = false;
    private ArrayList<JSONRecord> m_comboData = null;

    public JSONEditor(JDialog p, String cname, String subname, String source) {
        super((Dialog)p, true);
        this.in_json = source;
        this.setTitle(Messages.getString("JSONEditor.0"));
        this.setResizable(false);
        if (p != null) {
            this.setBounds(p.getX() + 100, p.getY() + 100, 800, 450);
        } else {
            this.setBounds(100, 100, 800, 450);
        }
        this.getContentPane().setLayout(null);
        this.m_targets = Tool.target_dirs;
        this.m_curOutline = Tool.getClassOutLine(cname);
        JLabel cnameLabel = new JLabel(Messages.getString("JSONEditor.1"));
        cnameLabel.setBounds(12, 10, 77, 13);
        this.getContentPane().add(cnameLabel);
        this.m_cmodel = new DefaultComboBoxModel();
        JButton findClass = new JButton(Messages.getString("JSONEditor.2"));
        findClass.setBounds(428, 6, 100, 21);
        this.getContentPane().add(findClass);
        this.comboClasses = new JComboBox<String>(this.m_cmodel);
        this.comboClasses.setEditable(true);
        this.comboClasses.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    JSONEditor.this.updateCurFieldJson();
                    String t_str = (String)JSONEditor.this.comboClasses.getSelectedItem();
                    JSONEditor.this.setFieldList(t_str);
                }
            }
        });
        this.comboClasses.setBounds(540, 7, 242, 19);
        this.getContentPane().add(this.comboClasses);
        this.setClassList2Combo(this.m_cmodel);
        JButton preview = new JButton(Messages.getString("JSONEditor.3"));
        preview.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (JSONEditor.this.m_curOutline != null) {
                    try {
                        String t_str = JSONEditor.this.getJson();
                        Object t_obj = Tool.getObjectfromJSON(Tool.forName(JSONEditor.this.className.getText()), t_str);
                        Tool.alertMSG(s_owner, t_obj.toString());
                    }
                    catch (ClassNotFoundException e1) {
                        Tool.alertMSG(s_owner, String.valueOf(JSONEditor.this.className.getText()) + Messages.getString("JSONEditor.4"));
                    }
                }
            }
        });
        preview.setBounds(69, 390, 91, 21);
        this.getContentPane().add(preview);
        JPanel panel = new JPanel();
        panel.setBounds(12, 33, 770, 347);
        this.getContentPane().add(panel);
        panel.setLayout(null);
        JLabel fieldsLabel = new JLabel(Messages.getString("JSONEditor.5"));
        fieldsLabel.setBounds(12, 10, 114, 13);
        panel.add(fieldsLabel);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(12, 36, 201, 301);
        panel.add(scrollPane);
        this.m_lmodel = new DefaultListModel();
        final JList<String> fieldList = new JList<String>(this.m_lmodel);
        fieldList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    ListUI t_ui = fieldList.getUI();
                    int j = t_ui.locationToIndex(fieldList, e.getPoint());
                    if (j >= 0) {
                        String label = JSONEditor.this.m_lmodel.get(j);
                        JSONEditor.this.goFieldPopUp(e, label.substring(3));
                    } else {
                        JSONEditor.this.goFieldPopUp(e, null);
                    }
                }
            }
        });
        scrollPane.setViewportView(fieldList);
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setBounds(225, 36, 533, 301);
        panel.add(scrollPane_1);
        this.jsonPane = new JEditorPane();
        this.jsonPane.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                Font t_font = Tool.resizeFont(e, JSONEditor.this.jsonPane.getFont());
                if (t_font != null) {
                    JSONEditor.this.jsonPane.setFont(t_font);
                }
            }
        });
        this.jsonPane.setFont(new Font("MS UI Gothic", 0, 14));
        scrollPane_1.setViewportView(this.jsonPane);
        this.cnameCurField = new JTextField();
        this.cnameCurField.setEnabled(false);
        this.cnameCurField.setBounds(225, 7, 288, 19);
        panel.add(this.cnameCurField);
        this.cnameCurField.setColumns(10);
        final JButton templateButton = new JButton(Messages.getString("JSONEditor.6"));
        templateButton.setBounds(530, 6, 123, 21);
        panel.add(templateButton);
        templateButton.setEnabled(false);
        JButton btnTojson = new JButton(Messages.getString("JSONEditor.7"));
        btnTojson.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String t_cname = JSONEditor.this.cnameCurField.getText();
                String str_j = Tool.classToJSON(t_cname);
                if (str_j != null) {
                    JSONEditor.this.jsonPane.setText(str_j);
                }
            }
        });
        btnTojson.setBounds(667, 6, 91, 21);
        panel.add(btnTojson);
        JButton btnSave = new JButton(Messages.getString("JSONEditor.8"));
        btnSave.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (JSONEditor.this.comboNames.getSelectedItem().equals(Messages.getString("JSONEditor.17"))) {
                    Tool.alertMSG(null, Messages.getString("JSONEditor.10"));
                } else {
                    JSONEditor.this.saveJson((String)JSONEditor.this.comboNames.getSelectedItem());
                }
            }
        });
        btnSave.setBounds(346, 390, 91, 21);
        this.getContentPane().add(btnSave);
        if (this.in_json != null && this.in_json.length() > 0) {
            btnSave.setEnabled(false);
        }
        JButton btnClose = new JButton(Messages.getString("JSONEditor.13"));
        btnClose.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JSONEditor.this.setVisible(false);
            }
        });
        btnClose.setBounds(449, 390, 91, 21);
        this.getContentPane().add(btnClose);
        this.className = new JTextField(cname);
        this.className.setBounds(86, 7, 202, 19);
        this.getContentPane().add(this.className);
        this.className.setColumns(10);
        this.comboNames = new JComboBox();
        this.comboNames.setFont(new Font("MS UI Gothic", 0, 10));
        this.comboNames.setEditable(true);
        this.comboNames.setBounds(303, 7, 113, 19);
        this.getContentPane().add(this.comboNames);
        fieldList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JSONEditor.this.updateCurFieldJson();
                String t_fname = (String)fieldList.getSelectedValue();
                if (t_fname != null && t_fname.length() > 4) {
                    JSONEditor.this.curFieldName = t_fname.substring(3);
                    JSONEditor.this.cnameCurField.setText(JSONEditor.this.m_f2cname.get(JSONEditor.this.curFieldName));
                    if (JSONEditor.this.m_f2editing.containsKey(JSONEditor.this.curFieldName)) {
                        JSONEditor.this.jsonPane.setText(JSONEditor.this.m_f2editing.get(JSONEditor.this.curFieldName));
                    } else if (JSONEditor.this.m_f2json.containsKey(JSONEditor.this.curFieldName)) {
                        JSONEditor.this.jsonPane.setText(JSONEditor.this.m_f2json.get(JSONEditor.this.curFieldName));
                    } else {
                        JSONEditor.this.jsonPane.setText("");
                    }
                    templateButton.setEnabled(true);
                } else {
                    JSONEditor.this.jsonPane.setText("");
                }
            }
        });
        templateButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (JSONEditor.this.curFieldName != null && JSONEditor.this.curFieldName.length() > 0) {
                    JSONChooser chooser = new JSONChooser((JDialog)Tool.getParent((Component)e.getSource(), "JDialog"), Tool._db().getJSONRecWhere(JSONEditor.this.m_f2cname.get(JSONEditor.this.curFieldName), null, Tool.version));
                    chooser.setVisible(true);
                    if (chooser.is_ok) {
                        JSONEditor.this.jsonPane.setText(chooser.m_json);
                        int i = fieldList.getSelectedIndex();
                        String t_fname = (String)fieldList.getSelectedValue();
                        String fName = t_fname.substring(3);
                        if (t_fname.startsWith(Pattern.quote("(U)"))) {
                            JSONEditor.this.m_lmodel.set(i, "(E)" + fName);
                        }
                    }
                }
            }
        });
        findClass.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String cName;
                if (!JSONEditor.this.jsonPane.getText().equals("")) {
                    int rc = JOptionPane.showConfirmDialog(null, Messages.getString("JSONEditor.19"), Messages.getString("JSONEditor.20"), 2);
                    switch (rc) {
                        case 0: {
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                if ((cName = Tool.findClassName(Tool.getParent((Component)e.getSource(), "JDialog"), JSONEditor.this.m_targets)) != null && cName.length() > 0) {
                    JSONEditor.this.m_curOutline = Tool.getClassOutLine(cName);
                    JSONEditor.this.className.setText(cName);
                    JSONEditor.this.setNameList2Combo(cName);
                    JSONEditor.this.setClassList2Combo(JSONEditor.this.m_cmodel);
                    JSONEditor.this.clear();
                    JSONEditor.this.updateComboNames();
                    JSONEditor.this.initByDB();
                    if (JSONEditor.this.comboNames.getSelectedItem() != null) {
                        JSONEditor.this.setFieldList(JSONEditor.this.className.getText());
                    }
                }
            }
        });
        this.initByDB();
        if (this.comboNames.getSelectedItem() != null) {
            this.setFieldList(this.className.getText());
        }
        this.className.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int t_key = e.getKeyCode();
                if (t_key == 10) {
                    if (JSONEditor.this.className.getText().length() > 0) {
                        JSONEditor.this.clear();
                        JSONEditor.this.initByDB();
                        if (!JSONEditor.this.updatingComboNames) {
                            if (JSONEditor.this.comboNames.getItemCount() == 0) {
                                JSONEditor.this.setNameList2Combo(JSONEditor.this.className.getText());
                            } else {
                                Object t_name = JSONEditor.this.comboNames.getSelectedItem();
                                if (t_name == null) {
                                    Tool.alertMSG(null, "Subname shoud be specified.");
                                } else {
                                    JSONEditor.this.setFieldList(JSONEditor.this.className.getText());
                                }
                            }
                        }
                    } else {
                        Tool.alertMSG(null, "Class Name not specified.");
                    }
                }
            }
        });
        this.comboNames.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!JSONEditor.this.updatingComboNames && e.getStateChange() == 1) {
                    if (JSONEditor.this.className.getText().length() > 0) {
                        JSONEditor.this.clear();
                        JSONEditor.this.updateComboNames();
                        JSONEditor.this.initByDB();
                        JSONEditor.this.setFieldList(JSONEditor.this.className.getText());
                    } else {
                        Tool.alertMSG(null, "Class Name not specified.");
                    }
                }
            }
        });
    }

    public void updateComboNames() {
        String name = (String)this.comboNames.getSelectedItem();
        if (name == null || name.length() == 0) {
            return;
        }
        this.updatingComboNames = true;
        int j = 0;
        while (j < this.comboNames.getItemCount()) {
            String t_name = this.comboNames.getItemAt(j);
            if (name.equals(t_name) && this.m_comboData != null) {
                int k = 0;
                while (k < this.m_comboData.size()) {
                    if (this.m_comboData.get((int)k).name.equals(name)) {
                        this.className.setText(this.m_comboData.get((int)k).className);
                    }
                    ++k;
                }
                this.updatingComboNames = false;
                return;
            }
            ++j;
        }
        this.m_comboData = Tool._db().getJSONRecWhere(this.className.getText(), name, Tool.version);
        if (this.m_comboData.size() > 0) {
            this.comboNames.removeAllItems();
            int i = 0;
            while (i < this.m_comboData.size()) {
                this.comboNames.addItem(this.m_comboData.get((int)i).name);
                if (i + 1 == this.m_comboData.size()) {
                    this.comboNames.setSelectedItem(this.m_comboData.get((int)i).name);
                    this.className.setText(this.m_comboData.get((int)i).className);
                }
                ++i;
            }
        }
        this.updatingComboNames = false;
    }

    private void clear() {
        if (this.m_lmodel != null) {
            this.m_lmodel.removeAllElements();
            this.jsonPane.setText("");
        }
    }

    private boolean hasFields() {
        if (this.m_curOutline != null) {
            Class<?> t_c;
            try {
                t_c = Tool.forName(this.m_curOutline.getClassName());
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            if (Tool.isPrimitive2(t_c) || List.class.isAssignableFrom(t_c)) {
                return false;
            }
        }
        return true;
    }

    private void initByDB() {
        this.m_f2cname = new HashMap();
        this.m_f2json = new HashMap();
        this.m_f2editing = new HashMap();
        Object t_name = this.comboNames.getSelectedItem();
        if (this.className.getText().length() > 0 && (this.in_json != null || this.comboNames.getSelectedItem() != null)) {
            this.m_curOutline = Tool.getClassOutLine(this.className.getText());
            if (this.hasFields()) {
                HashMap<String, String> t_list = null;
                String src = "";
                String[] fnames = null;
                if (this.in_json != null) {
                    src = this.in_json;
                    try {
                        t_list = Fson.getFieldMapOfJson(src);
                    }
                    catch (ParseException e) {
                        Tool.logIfDebug(e, " Illegal Json.");
                        return;
                    }
                    ArrayList<String> flist = new ArrayList<String>();
                    for (Map.Entry<String, String> entry : this.m_f2json.entrySet()) {
                        flist.add(entry.getKey());
                    }
                    fnames = flist.toArray(new String[flist.size()]);
                } else {
                    String name = (String)this.comboNames.getSelectedItem();
                    JSONRecord jrec = Tool._db().getJSONRecord(this.className.getText(), name, Tool.version);
                    if (jrec != null) {
                        fnames = jrec.fields.split(",\n*");
                        src = jrec.content;
                    }
                    try {
                        t_list = Fson.getFieldMapOfJson(src);
                    }
                    catch (ParseException e) {
                        Tool.logIfDebug(e, " Illegal Json.");
                        return;
                    }
                }
                if (t_list != null) {
                    this.m_f2json = t_list;
                } else {
                    this.m_f2json.clear();
                }
                if (fnames != null && this.className.getText().matches("^.*Map[<,>\\w]*$")) {
                    int i = 0;
                    while (i < fnames.length) {
                        this.m_lmodel.addElement("(D)" + fnames[i]);
                        ++i;
                    }
                }
            } else {
                this.cnameCurField.setText(this.className.getText());
                String src = "";
                if (this.in_json != null) {
                    src = this.in_json;
                } else {
                    String name = (String)this.comboNames.getSelectedItem();
                    JSONRecord jrec = Tool._db().getJSONRecord(this.className.getText(), name, Tool.version);
                    src = jrec.content;
                }
                this.jsonPane.setText(src);
            }
        }
    }

    private void setNameList2Combo(String cname) {
        if (cname != null && cname.length() > 0) {
            this.m_curOutline = Tool.getClassOutLine(cname);
            ArrayList<JSONRecord> jdata = Tool._db().getJSONRecWhere(cname, null, Tool.version);
            this.comboNames.removeAllItems();
            int i = 0;
            while (i < jdata.size()) {
                this.comboNames.addItem(jdata.get((int)i).name);
                ++i;
            }
            if (this.m_curOutline != null && !Tool.hasDefaultConstructor(this.m_curOutline.getCtClass(), false)) {
                this.comboNames.addItem("CONSTRUCTOR");
            }
            if (this.comboNames.getItemCount() == 0) {
                Tool.alertMSG(null, Messages.getString("JSONEditor.14"));
            }
        }
    }

    private void setFieldList(String t_str) {
        if (this.hasFields()) {
            this.clear();
            ClassOutLine co = Tool.getClassOutLine(t_str);
            if (co != null && this.m_lmodel != null) {
                this.m_lmodel.removeAllElements();
                if (!co.getClassName().matches("^.*Map[<,>\\w]*$")) {
                    ConstructorSelector t_cs;
                    String t_comboName = "";
                    if (this.comboNames.getSelectedItem() != null) {
                        t_comboName = this.comboNames.getSelectedItem().toString();
                    }
                    HashMap<String, String> t_flds = null;
                    if ("CONSTRUCTOR".equals(t_comboName)) {
                        if (Tool.hasDefaultConstructor(co.getCtClass(), false)) {
                            Tool.alertMSG(null, Messages.getString("JSONEditor.15"));
                            return;
                        }
                        t_cs = new ConstructorSelector(this, co);
                        t_cs.setVisible(true);
                        if (!t_cs.is_OK || t_cs.getParameters(false).size() == 0) {
                            Tool.alertMSG(null, Messages.getString("JSONEditor.16"));
                            return;
                        }
                        t_flds = t_cs.getParameters(false);
                    } else {
                        t_flds = co.getDeclaredFields(null);
                        if (!Tool.hasDefaultConstructor(co.getCtClass(), false)) {
                            t_cs = new ConstructorSelector(this, co);
                            t_flds.putAll(t_cs.getParameters(true));
                        }
                    }
                    for (Map.Entry<String, String> entry : t_flds.entrySet()) {
                        String t_fname = entry.getKey();
                        String t_item = null;
                        t_item = this.m_f2editing.containsKey(t_fname) ? "(E)" + t_fname : (this.m_f2json.containsKey(t_fname) ? "(D)" + t_fname : "(U)" + t_fname);
                        if (t_item != null) {
                            this.m_lmodel.addElement(t_item);
                        }
                        if (this.m_f2cname.containsKey(t_fname)) continue;
                        this.m_f2cname.put(t_fname, entry.getValue());
                    }
                } else {
                    for (Map.Entry<String, String> entry : this.m_f2json.entrySet()) {
                        this.m_lmodel.addElement("(D)" + entry.getKey());
                    }
                }
            }
            this.curFieldName = "";
        }
    }

    private void setClassList2Combo(DefaultComboBoxModel<String> model) {
        if (this.m_curOutline != null && this.hasFields()) {
            model.removeAllElements();
            String cname = this.m_curOutline.getClassName();
            model.addElement(cname);
            ClassOutLine s_class = this.m_curOutline;
            while ((s_class = s_class.getSuper()) != null) {
                if (s_class.getClassName().equals("java.lang.Object")) continue;
                model.addElement(s_class.getClassName());
            }
        }
    }

    private String getFields() {
        String t_res = "";
        boolean _1st = true;
        for (Map.Entry<String, String> entry : this.m_f2editing.entrySet()) {
            if (!_1st) {
                t_res = String.valueOf(t_res) + ",\n";
            } else {
                _1st = false;
            }
            t_res = String.valueOf(t_res) + entry.getKey();
        }
        for (Map.Entry<String, String> entry : this.m_f2json.entrySet()) {
            if (!_1st) {
                t_res = String.valueOf(t_res) + ",\n";
            } else {
                _1st = false;
            }
            t_res = String.valueOf(t_res) + entry.getKey();
        }
        return t_res;
    }

    public String getJson() {
        if (this.hasFields()) {
            String t_str = "{\n";
            boolean _1st = true;
            ArrayList<String> t_flds = new ArrayList<String>();
            for (Map.Entry<String, String> entry : this.m_f2editing.entrySet()) {
                if (!_1st) {
                    t_str = String.valueOf(t_str) + ",\n";
                } else {
                    _1st = false;
                }
                t_str = String.valueOf(t_str) + entry.getKey() + ":" + entry.getValue();
                t_flds.add(entry.getKey());
            }
            for (Map.Entry<String, String> entry : this.m_f2json.entrySet()) {
                if (!_1st) {
                    t_str = String.valueOf(t_str) + ",\n";
                } else {
                    _1st = false;
                }
                t_str = String.valueOf(t_str) + entry.getKey() + ":" + entry.getValue();
            }
            return String.valueOf(t_str) + "}";
        }
        return this.jsonPane.getText();
    }

    private void updateCurFieldJson() {
        if (this.curFieldName != null) {
            if (this.m_f2json.containsKey(this.curFieldName)) {
                this.m_f2json.put(this.curFieldName, this.jsonPane.getText());
            } else if (!this.jsonPane.getText().equals("")) {
                this.m_f2editing.put(this.curFieldName, this.jsonPane.getText());
                int i = 0;
                while (i < this.m_lmodel.size()) {
                    if (this.m_lmodel.getElementAt(i).equals("(U)" + this.curFieldName)) {
                        this.m_lmodel.setElementAt("(E)" + this.curFieldName, i);
                        break;
                    }
                    ++i;
                }
            } else if (this.m_f2editing.get(this.curFieldName) != null) {
                this.m_f2editing.remove(this.curFieldName);
            }
        }
    }

    private void goFieldPopUp(MouseEvent e, String label) {
        JPopupMenu t_pop = new JPopupMenu();
        if (this.m_curOutline.getClassName().matches("^.*Map[<,>\\w]*$")) {
            if (label != null) {
                t_pop.add(new JMenuItem(new JSONAction(Messages.getString("JSONEditor.56"), this, label)));
                t_pop.add(new JMenuItem(new JSONAction(Messages.getString("JSONEditor.57"), this, label)));
            }
            t_pop.add(new JMenuItem(new JSONAction(Messages.getString("JSONEditor.58"), this, label)));
            t_pop.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void addField() {
        String t_val = JOptionPane.showInputDialog(this, (Object)Messages.getString("JSONEditor.62"));
        if (t_val != null) {
            this.m_lmodel.addElement("(U)" + t_val);
        }
    }

    private void removeField(String label) {
        int i = 0;
        while (i < this.m_lmodel.size()) {
            if (this.m_lmodel.getElementAt(i).equals("(U)" + label)) {
                this.m_lmodel.removeElementAt(i);
                break;
            }
            ++i;
        }
    }

    private void editField(String label) {
        String t_val = JOptionPane.showInputDialog(this, (Object)Messages.getString("JSONEditor.65"));
        if (t_val != null) {
            int i = 0;
            while (i < this.m_lmodel.size()) {
                if (this.m_lmodel.getElementAt(i).equals("(U)" + label)) {
                    this.m_lmodel.setElementAt(t_val, i);
                    break;
                }
                ++i;
            }
        }
    }

    private void saveJson(String name) {
        this.updateCurFieldJson();
        JSONRecord t_j = Tool._db().getJSONRecord(this.className.getText(), name, Tool.version);
        if (t_j == null) {
            t_j = new JSONRecord(2);
            t_j.name = name;
            t_j.className = this.className.getText();
            t_j.content = this.getJson();
            t_j.fields = this.getFields();
        } else {
            t_j.content = this.getJson();
            t_j.fields = this.getFields();
        }
        if (t_j != null) {
            try {
                Tool._db().updateRecordBySQL(t_j.getUpdateSQL(), true);
            }
            catch (SQLException e) {
                Tool.alertMSG(null, String.valueOf(Messages.getString("JSONEditor.9")) + e.getMessage());
            }
        }
    }

    class JSONAction
    extends AbstractAction {
        String m_actname;
        JSONEditor m_master;
        String m_label;

        JSONAction(String aname, JSONEditor master, String cname) {
            this.putValue("Name", aname);
            this.m_actname = aname;
            this.m_master = master;
            this.m_label = cname;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.m_actname.equals(Messages.getString("JSONEditor.59"))) {
                this.m_master.editField(this.m_label);
            } else if (this.m_actname.equals(Messages.getString("JSONEditor.60"))) {
                this.m_master.addField();
            } else if (this.m_actname.equals(Messages.getString("JSONEditor.61"))) {
                this.m_master.removeField(this.m_label);
            }
        }
    }
}

