/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.web;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.web.PageAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public class LoadURL
extends PageAction {
    @Override
    protected void doCore(WebDriver drv, WebElement elm) {
        String t_url = (String)this.arg_map.get("url");
        if (t_url == null) {
            return;
        }
        if ((t_url = Tool.convert2Alias(t_url)).length() == 0) {
            return;
        }
        String t_auth = (String)this.arg_map.get("auth");
        if (t_auth != null && t_auth.length() > 0 && t_auth.matches("^\\w+:\\w+@$")) {
            Pattern t_pat = Pattern.compile("^(https?://)(.+)$");
            Matcher t_m = t_pat.matcher(t_url);
            if (t_m.find()) {
                t_url = t_url.replaceFirst(Pattern.quote(t_url), "$1" + Matcher.quoteReplacement(t_auth) + "$2");
            }
            Tool.logIfDebug(null, "Trying to add auth=" + t_auth + " to URL.");
        }
        drv.get(t_url);
        WebDriverWait wait = new WebDriverWait(drv, (long)this.getTimeout());
        ExpectedCondition<Boolean> u_ec = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver drv) {
                Object t_state = ((JavascriptExecutor)drv).executeScript("return document.readyState", new Object[0]);
                if (t_state.equals("complete")) {
                    return true;
                }
                return false;
            }
        };
        try {
            wait.until((Function)u_ec);
        }
        catch (Exception e) {
            throw new TimeoutException(String.valueOf(Messages.getString("LoadURL.1")) + e.getMessage());
        }
    }

    @Override
    protected String getTarget() {
        return (String)this.arg_map.get("url");
    }

    @Override
    protected ArrayList<String> getLabelAndParams() {
        ArrayList<String> t_list2 = new ArrayList<String>();
        t_list2.add(Messages.getString("LoadURL.0"));
        Object t_auth = this.arg_map.get("auth");
        if (t_auth != null) {
            t_list2.add(t_auth.toString());
        } else {
            t_list2.add("");
        }
        t_list2.add("user:password@");
        return t_list2;
    }

    @Override
    protected boolean hasPath() {
        return false;
    }

    @Override
    protected boolean getFocussingElements(WebDriver drv, ArrayList<WebElement> el_list, ArrayList<String> xp_list, String xpaths) {
        if (drv != null) {
            this.arg_map.put("url", drv.getCurrentUrl());
        }
        return true;
    }

    @Override
    protected String getJsonElement(String target, String arg) {
        if (target != null && target.length() > 0) {
            this.arg_map = new HashMap();
            this.arg_map.put("url", target);
            if (arg.length() > 0) {
                this.arg_map.put("auth", arg);
            }
        }
        return super.getJsonElement(null, null);
    }
}

