/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test;

import com.ftinc.si.assist.test.FakeMethodRecord;
import com.ftinc.si.assist.test.Fson;
import com.ftinc.si.assist.test.Tool;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.NotFoundException;

public class CodeProcessor {
    public static HashMap<String, String> _importList = null;
    public static HashMap<String, String> _memVars = new HashMap();
    private static final String[][] reg_macros = new String[][]{{"VGET\\(", "com.ftinc.si.assist.run.VCentral#getValue("}, {"VSET\\(", "com.ftinc.si.assist.test.Tool#fieldValue("}, {"MOCK\\(", "com.ftinc.si.assist.run.VCentral#getFakeObject("}, {"XROOT\\(", "com.ftinc.si.assist.run.VCentral#loadXML("}, {"XELM\\(", "com.ftinc.si.assist.run.VCentral#xmlContent("}, {"OUT\\(", "com.ftinc.si.assist.run.VCentral#logging("}, {"ASSERTING\\(", "asserting("}};
    private static final Pattern s_aliasMacro = Pattern.compile("\\$([^\\(]+)\\(");
    private static final Pattern _atPat = Pattern.compile("(MOCK|VGET)\\([^\\)\\(]+?\\)");
    private static final Pattern _atStrFnPat = Pattern.compile("XELM\\(.+?\\)");
    private static final Pattern _declarePat = Pattern.compile("([\\}\\{;]\\s*)([a-z_]\\w+\\.[\\w\\.\\$\\[\\]]+)(\\s+[\\w\\$]+[;=])");
    private static final Pattern _fieldPat = Pattern.compile("([\\}\\{\\s,\\+\\-\\*/\\(])([\\$\\w]+)\\.([a-z_]\\w+)([\\.;=\\-\\+\\*/\\s\\[])");
    private static final Pattern _methodBraPat = Pattern.compile("([\\{\\};\\s\\(,=\\+\\-\\*/])([a-z_\\$][_\\w]*)\\.([a-z_]\\w+)\\(");
    private static final Pattern _cast1Pat = Pattern.compile("\\(([a-z][\\w\\.]+\\.[A-Z][\\w_\\[\\]]+)\\)(.*?)[\\s;\\+\\-\\*]");
    private static final Pattern _cast2Pat = Pattern.compile("\\(\\(([a-z][\\w\\.]+\\.[A-Z][\\w_\\[\\]]+)\\).*\\)");
    private static Pattern p_symbol = Pattern.compile("var[0-9]+");

    public static String checkSyntaxOfCode(String src) {
        String err_msg = "";
        String warning_msg = "";
        int err_num = 0;
        int warning_num = 0;
        String jst_version = Tool.getPackageVersion(CtClass.class);
        jst_version = jst_version.replaceFirst("^(\\d+\\.\\d+)\\..*", "$1");
        Float n_version = Float.valueOf(jst_version);
        if (src == null) {
            return "ERROR: Source is null.\n";
        }
        String t_src = src;
        if (!t_src.startsWith("{")) {
            t_src = "{" + t_src + "}";
        }
        String str_break = "";
        Pattern pat_break = Pattern.compile("(break|continue)(\\s*\\w+\\s*;)");
        Matcher t_m = pat_break.matcher(t_src);
        while (t_m.find()) {
            if (str_break.length() > 0) {
                str_break = String.valueOf(str_break) + "\n\t";
            }
            str_break = String.valueOf(str_break) + t_m.group(1) + t_m.group(2) + "@" + t_m.start(1);
            ++err_num;
        }
        if (str_break.length() > 0) {
            err_msg = String.valueOf(err_msg) + "label not supported>>" + str_break + "\n";
        }
        String str_enum = "";
        Pattern pat_enum = Pattern.compile("enum\\s+[^\\s]+\\s*\\{");
        t_m = pat_enum.matcher(t_src);
        while (t_m.find()) {
            if (str_enum.length() > 0) {
                str_enum = String.valueOf(str_enum) + "\n\t";
            }
            str_enum = String.valueOf(str_enum) + t_m.group() + "@" + t_m.start();
            ++err_num;
        }
        if (str_enum.length() > 0) {
            err_msg = String.valueOf(err_msg) + "enum not supported.>>" + str_enum + "\n";
        }
        String str_array = "";
        Pattern pat_array = Pattern.compile("(=|new\\s+[\\w\\.]+\\[\\])\\s*\\{\\s*\\{");
        t_m = pat_array.matcher(t_src);
        while (t_m.find()) {
            if (str_array.length() > 0) {
                str_array = String.valueOf(str_array) + "\n\t";
            }
            str_array = String.valueOf(str_array) + t_m.group() + "@" + t_m.start();
            ++err_num;
        }
        if (str_array.length() > 0) {
            err_msg = String.valueOf(err_msg) + "initialization of array with >1 dimension not supported.>>" + str_array + "\n";
        }
        String t_src2 = CodeProcessor.preProcess4Import(t_src);
        String str_decl = "";
        Pattern pat_decl = Pattern.compile("[\\s\\};\\{][A-Z]\\w+(\\[\\]|\\w)\\s+\\w[\\w\\[\\]]*\\s*(=[^;]+;|;)");
        t_m = pat_decl.matcher(t_src2);
        if (t_m.find()) {
            t_m = pat_decl.matcher(t_src);
            while (t_m.find()) {
                if (str_decl.length() > 0) {
                    str_decl = String.valueOf(str_decl) + "\n\t";
                }
                str_decl = String.valueOf(str_decl) + t_m.group() + "@" + t_m.start();
                ++err_num;
            }
            if (str_decl.length() > 0) {
                err_msg = String.valueOf(err_msg) + "FQN is required.>>" + str_decl + "\n";
            }
        }
        String str_cast = "";
        Pattern pat_cast = Pattern.compile("\\([^\\(\\)\\s]+\\[\\]\\s*\\)\\s*VGET\\([^\\)]*\\)");
        t_m = pat_cast.matcher(t_src);
        while (t_m.find()) {
            if (str_cast.length() > 0) {
                str_cast = String.valueOf(str_cast) + "\n\t";
            }
            str_cast = String.valueOf(str_cast) + t_m.group() + "@" + t_m.start();
            ++warning_num;
        }
        if (str_cast.length() > 0) {
            warning_msg = String.valueOf(warning_msg) + "Trying to cast Object to Array>>" + str_cast + "\n";
        }
        if ((double)n_version.floatValue() < 2.2) {
            String str_final = "";
            Pattern pat_final = Pattern.compile("\\}\\sfinally\\s*\\{");
            t_m = pat_final.matcher(t_src);
            while (t_m.find()) {
                if (str_final.length() > 0) {
                    str_final = String.valueOf(str_final) + "\n\t";
                }
                str_final = String.valueOf(str_final) + t_m.group(1) + t_m.group(2) + "@" + t_m.start(1);
                ++warning_num;
            }
            if (str_final.length() > 0) {
                warning_msg = String.valueOf(warning_msg) + "'} finally{' was not supported.>>" + str_final + "\n";
            }
            String str_array2 = "";
            Pattern pat_array2 = Pattern.compile("(=|new\\s+[\\w\\.]+\\[\\])\\s*\\{\\s*\\{[^\\{\\}]*\\}\\s*;");
            t_m = pat_array2.matcher(t_src);
            while (t_m.find()) {
                if (str_array2.length() > 0) {
                    str_array2 = String.valueOf(str_array2) + "\n\t";
                }
                str_array2 = String.valueOf(str_array2) + t_m.group() + "@" + t_m.start();
                ++warning_num;
            }
            if (str_array2.length() > 0) {
                warning_msg = String.valueOf(warning_msg) + "initialization of array with 1 dimension not supported.>>" + str_array2 + "\n";
            }
            String str_catch = "";
            Pattern pat_catch = Pattern.compile("\\}\\s*catch\\s+\\([^\\)+]\\)\\s*\\{");
            t_m = pat_catch.matcher(t_src);
            while (t_m.find()) {
                if (str_catch.length() > 0) {
                    str_catch = String.valueOf(str_catch) + "\n\t";
                }
                str_catch = String.valueOf(str_catch) + t_m.group() + "@" + t_m.start();
                ++warning_num;
            }
            if (str_catch.length() > 0) {
                warning_msg = String.valueOf(warning_msg) + "'catch' was not supported.>>" + str_catch + "\n";
            }
            String str_sync = "";
            Pattern pat_sync = Pattern.compile("^.*syncronized[^\\(]+");
            t_m = pat_sync.matcher(t_src);
            while (t_m.find()) {
                if (str_sync.length() > 0) {
                    str_sync = String.valueOf(str_sync) + "\n\t";
                }
                str_sync = String.valueOf(str_sync) + t_m.group() + "@" + t_m.start();
                ++warning_num;
            }
            if (str_sync.length() > 0) {
                warning_msg = String.valueOf(warning_msg) + "'synchronized' was not supported.>>" + str_sync + "\n";
            }
        }
        String msg = "";
        if (err_num > 0) {
            msg = String.valueOf(msg) + Integer.toString(err_num) + " errors found. " + err_msg;
        }
        if (warning_num > 0) {
            msg = String.valueOf(msg) + Integer.toString(warning_num) + " warnings found. " + warning_msg;
        }
        if (msg.length() > 0) {
            Tool.logForTesting(null, msg);
        }
        if (err_num == 0) {
            return null;
        }
        return "ERROR:" + Integer.toString(err_num) + " errors found. " + err_msg + "(Warnings may be in log file.)";
    }

    public static String preProcess4Import(String src) {
        if (_importList == null) {
            _importList = new HashMap();
        }
        _importList.clear();
        String t_src = src;
        Pattern t_importPT = Pattern.compile("import\\s+([a-z][\\w\\.]+)\\.([A-Z\\w\\[\\]]+);");
        Matcher t_m = t_importPT.matcher(src);
        while (t_m.find()) {
            String w_str = t_m.group();
            String s_name = t_m.group(2);
            String c_name = String.valueOf(t_m.group(1)) + "." + s_name;
            _importList.put(s_name, c_name);
            t_src = t_src.replaceFirst(Pattern.quote(w_str), "");
        }
        src = t_src;
        Pattern t_sclass = Pattern.compile("([\\{\\;\\s\\(])([A-Z][\\w\\[\\]]+)(\\s*[\\)\\(\\.\\[]?\\w?)");
        t_m = t_sclass.matcher(src);
        while (t_m.find()) {
            String w_str = t_m.group();
            String t_h = t_m.group(1);
            String s_class = t_m.group(2);
            String s_tail = t_m.group(3);
            if (!_importList.containsKey(s_class)) continue;
            t_src = t_src.replaceFirst(Pattern.quote(w_str), Matcher.quoteReplacement(String.valueOf(t_h) + _importList.get(s_class) + "$$$" + s_tail));
        }
        String prim_int = "^(\\{\\;[\\s\\(])int(\\s*[\\)\\(\\.\\[]*\\w?)$";
        t_src = t_src.replaceAll(prim_int, "$1 Integer $2");
        String prim_float = "^(\\{\\;[\\s\\(])float(\\s*[\\)\\(\\.\\[]*\\w?)$";
        t_src = t_src.replaceAll(prim_float, "$1 Float $2");
        String prim_w = "^(\\{\\;[\\s\\(])double(\\s*[\\)\\(\\.\\[]*\\w?)$";
        t_src = t_src.replaceAll(prim_w, "$1 Double $2");
        String prim_b = "^(\\{\\;[\\s\\(])boolean(\\s*[\\)\\(\\.\\[]*\\w?)$";
        t_src = t_src.replaceAll(prim_b, "$1 Boolean $2");
        return t_src.replaceAll(Pattern.quote("$$$"), "");
    }

    public static void preProcess4MemInfos(String src) {
        _memVars.clear();
        Pattern t_sclass0 = Pattern.compile("[\\{\\;\\s,\\(/]field\\s+([\\w]+)\\s+([\\w\\$]+)\\s*[;=,\\)\\[]");
        Matcher t_m = t_sclass0.matcher(src);
        while (t_m.find()) {
            String c_name = t_m.group(2);
            String v_name = t_m.group(3);
            _memVars.put(v_name, Tool.primitiveToFQN(c_name));
        }
        Pattern t_sclass1 = Pattern.compile("[\\{;\\s/]field\\s+([a-z][\\w\\.]+\\.[A-Z][\\w\\[\\]]+)\\s+([\\w\\$]+)\\s*[;=,\\)\\[]");
        t_m = t_sclass1.matcher(src);
        while (t_m.find()) {
            String c_name = t_m.group(1);
            String v_name = t_m.group(2);
            _memVars.put(v_name, c_name);
        }
    }

    private static String preProcess4MemUse(String src) {
        String t_src = src;
        String fValueStr = "(CNAME)com.ftinc.si.assist.test.Tool#fieldValue(_parent,\"VNAME\",";
        Pattern t_parent = Pattern.compile("/\\*\\s+parent=(\\$[0-9]+)\\s+\\*/");
        Matcher t_m = t_parent.matcher(t_src);
        if (t_m.find()) {
            t_src = t_m.replaceFirst(Matcher.quoteReplacement("java.lang.Object _parent=com.ftinc.si.assist.run.VCentral#getValue(\"" + t_m.group(1) + "\");"));
        } else if (_memVars.size() > 0) {
            t_src = t_src.replaceFirst("\\s*\\{", Matcher.quoteReplacement("{java.lang.Object _parent=this;"));
        }
        Pattern t_pat0 = Pattern.compile("([\\{;\\s/])field\\s+(\\w+\\.[\\.\\w\\[\\]]+)\\s+(\\w+)\\s*;");
        t_m = t_pat0.matcher(t_src);
        if (t_m.find()) {
            t_src = t_m.replaceAll("$1");
        }
        Pattern t_pat1 = Pattern.compile("([\\{;\\s/])field\\s+([\\.\\w\\[\\]]+)\\s+([\\w\\$]+)\\s*=\\s*(.+?)\\s*;");
        t_m = t_pat1.matcher(t_src);
        while (t_m.find()) {
            String cname = Tool.primitiveToFQN(t_m.group(2));
            String vname = t_m.group(3);
            String repl = fValueStr.replace("CNAME", cname).replace("VNAME", vname);
            t_src = t_m.replaceFirst("$1" + Matcher.quoteReplacement(repl) + "$4);");
            t_m = t_pat1.matcher(t_src);
        }
        String set_reg = "([;\\s\\}\\{/])(\\w+)\\s*=\\s*([^=].*?)\\s*;";
        Pattern set_pat = Pattern.compile(set_reg);
        t_m = set_pat.matcher(t_src);
        while (t_m.find()) {
            String t_key = t_m.group(2);
            if (!_memVars.containsKey(t_key)) continue;
            String cname = _memVars.get(t_key);
            String target = t_m.group();
            String head = t_m.group(1);
            String repl = fValueStr.replace("CNAME", cname).replace("VNAME", t_key);
            String val = t_m.group(3);
            t_src = t_src.replaceFirst(Pattern.quote(target), Matcher.quoteReplacement(String.valueOf(head) + repl + val + ");"));
            t_m = set_pat.matcher(t_src);
        }
        String set_reg2 = "\\(\\s*(\\w+)\\s*=\\s*([^=].*?)\\)";
        Pattern set_pat2 = Pattern.compile(set_reg2);
        t_m = set_pat2.matcher(t_src);
        while (t_m.find()) {
            String t_key;
            int start = t_m.start();
            String target = Tool.getClosedBlock(t_src, start, "(", ")");
            Pattern set_pat3 = Pattern.compile("^\\(\\s*(\\w+)\\s*=\\s*([^=].*?)\\s*\\)$");
            Matcher t_m2 = set_pat3.matcher(target);
            if (t_m2.find() && _memVars.containsKey(t_key = t_m2.group(1))) {
                String cname = _memVars.get(t_key);
                String repl = fValueStr.replace("CNAME", cname).replace("VNAME", t_key);
                String val = t_m2.group(2);
                t_src = t_src.replaceFirst(Pattern.quote(target), Matcher.quoteReplacement("(" + repl + val + "))"));
            }
            t_m = set_pat2.matcher(t_src);
        }
        String ref_reg = "([\\s=\\+\\-\\*/\\(,\\)><=])(\\w+)([!\\s\\.\\+\\-\\*/<>\\);,\\[])";
        Pattern ref_pat = Pattern.compile(ref_reg);
        t_m = ref_pat.matcher(t_src);
        while (t_m.find()) {
            String t_key = t_m.group(2);
            if (!_memVars.containsKey(t_key)) continue;
            String cname = _memVars.get(t_key);
            String target = t_m.group();
            String head = t_m.group(1);
            String expr = t_m.group(3);
            String repl = fValueStr.replace("CNAME", cname).replace("VNAME", t_key);
            t_src = t_src.replaceFirst(Pattern.quote(target), Matcher.quoteReplacement(String.valueOf(head) + "(" + repl + "null))" + expr));
            t_m = ref_pat.matcher(t_src);
        }
        return t_src;
    }

    public static ArrayList<String> escDQStrings(String src, String repl) {
        return CodeProcessor.escDQStrings2(src, repl, -1);
    }

    public static ArrayList<String> escDQStrings2(String src, String repl, int n) {
        if (repl.matches("!!|##")) {
            Tool.alertMSG(null, String.valueOf(repl) + " includes bad string!!");
        }
        src = Tool.regReplaceAll(src, "(?<!\\\\)" + Pattern.quote("\\\""), "_BACKDQT_");
        String t_src = Tool.replaceB(src, "\\\\", "$" + repl + "_BQ$");
        String dq_reg = "\"(.*?)\"";
        ArrayList<String> t_list = new ArrayList<String>();
        Integer i = 1;
        Pattern t_p = Pattern.compile(dq_reg);
        Matcher t_m = t_p.matcher(t_src);
        while (t_m.find()) {
            String w_str = t_m.group(0);
            String w_str2 = Tool.replaceB(t_m.group(1), "$" + repl + "$", "\\\"");
            if (w_str2.indexOf("!##!") >= 0) {
                Tool.alertMSG(null, String.valueOf(w_str2) + " is strange.");
            }
            if (n > 1 && w_str2.length() > n) {
                w_str2 = w_str2.substring(0, n);
            }
            t_list.add(w_str2);
            t_src = Tool.replaceB(t_src, w_str, "!##!" + repl + i.toString() + "!##!");
            t_m = t_p.matcher(t_src);
            i = i + 1;
        }
        String dq_reg2 = "'(.*?)'";
        Pattern t_p2 = Pattern.compile(dq_reg2);
        t_m = t_p2.matcher(t_src);
        while (t_m.find()) {
            String w_str = t_m.group(0);
            String w_str2 = Tool.replaceB(t_m.group(1), "$" + repl + "$", "\\\"");
            w_str2 = CodeProcessor.restoreDQString(w_str2, repl, t_list);
            t_list.add(w_str2);
            t_src = Tool.replaceB(t_src, w_str, "!##!" + repl + i.toString() + "!##!");
            t_m = t_p2.matcher(t_src);
            i = i + 1;
        }
        t_src = Tool.replaceB(t_src, "!##!", "\"");
        t_list.add(0, t_src);
        return t_list;
    }

    public static String restoreDQString(String wstr, String repl, ArrayList<String> list) {
        String t_str = wstr;
        int i = 1;
        while (i < list.size()) {
            String t_repl = list.get(i);
            t_str = Tool.regReplaceAll(t_str, "\"" + Pattern.quote(repl) + Integer.toString(i) + "\"", "\"" + Matcher.quoteReplacement(t_repl) + "\"");
            ++i;
        }
        t_str = Tool.replaceB(t_str, "$" + repl + "\uff3fBQ$", "\\\\");
        t_str = Tool.replaceB(t_str, "_BACKDQT_", Matcher.quoteReplacement("\\\""));
        return t_str;
    }

    public static String preProcessMain(CtClass c, CtBehavior b, String src) {
        String msg = CodeProcessor.checkSyntaxOfCode(src);
        if (msg != null) {
            return null;
        }
        if (!src.startsWith("{")) {
            src = "{" + src + "}";
        }
        String str_q = "|_%%_|";
        ArrayList<String> t_list = CodeProcessor.escDQStrings(src, str_q);
        String t_src = t_list.get(0);
        t_src = CodeProcessor.preProcess4Import(t_src);
        t_src = CodeProcessor.preProcess4Macro(t_src);
        CodeProcessor.preProcess4MemInfos(t_src);
        t_src = CodeProcessor.preProcess4MemUse(t_src);
        return CodeProcessor.restoreDQString(t_src, str_q, t_list);
    }

    private static String preProcess4Macro(String src) {
        Matcher t_m;
        String t_src = src;
        int i = 0;
        while (i < reg_macros.length) {
            String[] temp_reg = reg_macros[i];
            src = t_src;
            Pattern dec_pat = Pattern.compile(temp_reg[0]);
            t_m = dec_pat.matcher(src);
            if (t_m.find()) {
                t_src = t_m.replaceAll(Matcher.quoteReplacement(temp_reg[1]));
            }
            ++i;
        }
        src = t_src;
        t_m = s_aliasMacro.matcher(src);
        while (t_m.find()) {
            String w_str = t_m.group();
            String t_repl = Tool.convert2Alias(t_m.group(1));
            if (t_m.group(1).equals(t_repl)) continue;
            t_src = t_src.replaceFirst(Pattern.quote(w_str), Matcher.quoteReplacement(String.valueOf(t_repl) + "("));
        }
        return t_src;
    }

    public static HashMap<String, Class<?>> analyzeVarToClass(StringBuilder sb_src, HashMap<String, Class<?>> map) throws ClassNotFoundException, SecurityException, NoSuchFieldException, NoSuchMethodException, NotFoundException, InstantiationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ParseException, Fson.NotSupportedClassException {
        String t_var;
        String src = sb_src.toString();
        if (!(src = src.replaceAll("^//.*?\n$", "")).startsWith("{")) {
            src = "{" + src + "}";
        }
        HashMap t_res = (HashMap)map.clone();
        int num = 0;
        Matcher t_m = _atPat.matcher(src);
        while (t_m.find()) {
            String at_str = t_m.group();
            t_res.put(at_str, Object.class);
        }
        t_m = _atStrFnPat.matcher(src);
        while (t_m.find()) {
            String __var = t_m.group();
            t_res.put(__var, String.class);
        }
        CodeProcessor.preProcess4MemInfos(src);
        HashMap<String, String> var_dic = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : _memVars.entrySet()) {
            String cname = entry.getValue();
            String vname = entry.getKey();
            if (var_dic.containsKey(vname)) continue;
            t_var = "var" + Integer.toString(num);
            try {
                Class<?> t_c = null;
                if (cname.endsWith("[]")) {
                    Class<?> comp_c = Tool.forName(cname.replaceFirst(Pattern.quote("[]"), ""));
                    t_c = Array.newInstance(comp_c, 0).getClass();
                } else {
                    t_c = Tool.forName(cname);
                }
                ++num;
                var_dic.put(t_var, vname);
                var_dic.put(vname, vname);
                t_res.put(vname, t_c);
            }
            catch (ClassNotFoundException e) {
                Tool.logIfDebug(e, "@CodeProcessot#checkReturnType");
            }
        }
        ArrayList<String> t_declared = new ArrayList<String>();
        String t_src = CodeProcessor.analyzeMethod(src, num, var_dic, t_res, t_declared);
        int i = 0;
        while (i < t_declared.size()) {
            t_src = t_src.replaceFirst("__DECLARED__" + Integer.toString(i) + "__", Matcher.quoteReplacement(t_declared.get(i)));
            ++i;
        }
        sb_src.replace(0, sb_src.length(), t_src);
        for (Map.Entry<String, String> entry : var_dic.entrySet()) {
            String t_value;
            t_var = entry.getKey();
            if (!t_var.matches("^var[0-9]+$") || (t_value = CodeProcessor.restoreSymbol(entry.getValue(), var_dic)) == null || t_res.containsKey(t_value)) continue;
            t_res.put(t_value, (Class)t_res.get(t_var));
        }
        return t_res;
    }

    private static String analyzeMethod(String src, int num, HashMap<String, String> var_map, HashMap<String, Class<?>> cmap, ArrayList<String> declared_list) throws ClassNotFoundException, NoSuchMethodException, SecurityException, NotFoundException, InstantiationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ParseException, Fson.NotSupportedClassException {
        Class<?> comp_c;
        Class<?> t_c;
        String w_str;
        String c_name;
        String t_var;
        Matcher t_m;
        Matcher t_m2;
        if (src == null || src.length() == 0) {
            return src;
        }
        String t_src = src;
        if (declared_list.size() == 0 && (t_m2 = _declarePat.matcher(src)).find()) {
            String i_src = t_m2.group(2);
            src = t_m2.replaceFirst("$1__DECLARED__" + Integer.toString(declared_list.size()) + "__$3");
            declared_list.add(i_src);
            t_m2 = _declarePat.matcher(src);
        }
        if ((t_m = _methodBraPat.matcher(src)).find()) {
            Method ms;
            Class<?> t_c2;
            ArrayList<String> t_4restore;
            String[] t_args;
            String t_obj = t_m.group(2);
            String t_methodName = t_m.group(3);
            int begin = t_m.end() - 1;
            String w_str2 = Tool.getClosedBlock(src, begin, "(", ")");
            String w_str22 = w_str2.substring(1, w_str2.length() - 1).replaceAll("\\s", "");
            String t_repl = String.valueOf(t_obj) + "." + t_methodName + w_str2;
            String z_str = "";
            if (w_str22.length() > 0) {
                z_str = CodeProcessor.analyzeMethod(w_str22, num, var_map, cmap, declared_list);
            }
            t_var = "var" + Integer.toString(num);
            ++num;
            src = src.replaceFirst(Pattern.quote(t_repl), t_var);
            var_map.put(t_var, String.valueOf(t_obj) + "." + t_methodName + "(" + z_str + ")");
            Class[] a_clist = new Class[]{};
            if (z_str.length() > 0 && (t_args = (t_4restore = Fson.escapeBraket(z_str, null)).get(0).split(",")).length > 0) {
                ArrayList c_list = new ArrayList();
                int j = 0;
                while (j < t_args.length) {
                    Class<?> a_c = cmap.get(Fson.restoreBraket(t_args[j], t_4restore));
                    if (a_c != null) {
                        c_list.add(a_c);
                    } else {
                        Object temp = Fson.fromJson(Fson.restore(t_args[j]), null);
                        if (temp != null) {
                            c_list.add(temp.getClass());
                        }
                    }
                    ++j;
                }
                a_clist = c_list.toArray(new Class[c_list.size()]);
            }
            if ((t_c2 = cmap.get(t_obj)) != null && (ms = Tool.getMethod(t_c2, t_methodName, a_clist)) != null) {
                Class<?> t_class = ms.getReturnType();
                cmap.put(t_var, t_class);
                String t_cname = t_class.getName();
                if (t_class.isArray()) {
                    t_cname = String.valueOf(t_class.getComponentType().getName()) + "[]";
                }
                src = CodeProcessor.insertDeclaredPartToSrc(src, t_cname, t_var, String.valueOf(t_obj) + "." + t_methodName + "(" + z_str + ")", declared_list);
            }
            src = CodeProcessor.analyzeMethod(src, num, var_map, cmap, declared_list);
        }
        if ((t_m = _fieldPat.matcher(src)).find()) {
            String o_str = t_m.group();
            String head_str = t_m.group(1);
            String obj_str = t_m.group(2);
            String f_str = t_m.group(3);
            String last_str = t_m.group(4);
            if (var_map.containsKey(obj_str) && cmap.containsKey(obj_str)) {
                Class<?> t_c3 = cmap.get(obj_str);
                String t_cname = t_c3.getName();
                if (!t_c3.equals(Object.class)) {
                    String i_src;
                    t_var = "var" + Integer.toString(num);
                    ++num;
                    var_map.put(t_var, String.valueOf(obj_str) + "." + f_str);
                    src = src.replaceFirst(Pattern.quote(o_str), Matcher.quoteReplacement(String.valueOf(head_str) + t_var + last_str));
                    Field t_f = Tool.getField(t_c3, f_str);
                    if (t_f != null) {
                        Class<?> r_c = t_f.getType();
                        if (r_c.isArray()) {
                            Class<?> comp_c2 = r_c.getComponentType();
                            t_cname = String.valueOf(comp_c2.getName()) + "[]";
                        }
                        cmap.put(t_var, r_c);
                        i_src = "(" + t_cname + ")com.ftinc.si.assist.test.Tool.getFieldValue(" + obj_str + ",\"" + f_str + "\")";
                        src = CodeProcessor.insertDeclaredPartToSrc(src, t_cname, t_var, i_src, declared_list);
                    } else {
                        ArrayList<FakeMethodRecord> fakes = Tool._db().getFakeMethods(t_c3.getName(), Tool.version);
                        if (fakes.size() > 0) {
                            t_cname = Tool.getFieldTypeNameForFake(t_c3.getName(), f_str);
                            if (t_cname == null) {
                                Tool.alertMSG(null, String.valueOf(t_c3.getName()) + " has not field of " + f_str);
                            } else {
                                cmap.put(t_var, Tool.forName(t_cname));
                                i_src = "(" + t_cname + ")com.ftinc.si.assist.test.Tool.getFieldValue(" + obj_str + ",\"" + f_str + "\")";
                                src = CodeProcessor.insertDeclaredPartToSrc(src, t_cname, t_var, i_src, declared_list);
                            }
                        }
                    }
                    src = CodeProcessor.analyzeMethod(src, num, var_map, cmap, declared_list);
                }
            }
        }
        if ((t_m = _cast1Pat.matcher(src)).find()) {
            c_name = t_m.group(1);
            w_str = "(" + c_name + ")" + t_m.group(2);
            String t_var2 = "var" + Integer.toString(num);
            ++num;
            t_c = null;
            if (c_name.endsWith("[]")) {
                comp_c = Tool.forName(c_name.replaceFirst(Pattern.quote("[]"), ""));
                t_c = Array.newInstance(comp_c, 0).getClass();
            } else {
                t_c = Tool.forName(c_name);
            }
            src = src.replaceFirst(Pattern.quote(w_str), t_var2);
            var_map.put(t_var2, w_str);
            if (!cmap.containsKey(t_var2)) {
                cmap.put(t_var2, t_c);
                src = CodeProcessor.insertDeclaredPartToSrc(src, c_name, t_var2, w_str, declared_list);
            }
        }
        if ((t_m = _cast2Pat.matcher(src)).find()) {
            w_str = t_m.group();
            c_name = t_m.group(1);
            w_str = Tool.getClosedBlock(w_str, 0, "(", "");
            String t_var3 = "var" + Integer.toString(num);
            ++num;
            t_c = null;
            if (c_name.endsWith("[]")) {
                comp_c = Tool.forName(c_name.replaceFirst(Pattern.quote("[]"), ""));
                t_c = Array.newInstance(comp_c, 0).getClass();
            } else {
                t_c = Tool.forName(c_name);
            }
            src = src.replaceFirst(Pattern.quote(w_str), t_var3);
            var_map.put(t_var3, w_str);
            if (!cmap.containsKey(t_var3)) {
                cmap.put(t_var3, t_c);
                src = CodeProcessor.insertDeclaredPartToSrc(src, c_name, t_var3, w_str, declared_list);
            }
        }
        if (!src.equals(t_src)) {
            t_src = CodeProcessor.analyzeMethod(src, num, var_map, cmap, declared_list);
        }
        return t_src;
    }

    private static String insertDeclaredPartToSrc(String src, String cname, String var, String val, ArrayList<String> declared_list) {
        Pattern _forInsert = Pattern.compile("([\\s\\S]*[\\{\\};]\\n*?)([^;\\}\\{]*?" + var + "[^0-9])");
        Matcher t_m = _forInsert.matcher(src);
        if (t_m.find()) {
            String i_src = String.valueOf(cname) + " " + var + "=" + val;
            String num = Integer.toString(declared_list.size());
            src = t_m.replaceFirst("$1__DECLARED__" + num + "__;\n$2");
            declared_list.add(i_src);
        }
        return src;
    }

    private static String restoreSymbol(String vname, HashMap<String, String> var_map) {
        Matcher t_m = p_symbol.matcher(vname);
        if (t_m.find()) {
            String w_str = t_m.group();
            String l_name = var_map.get(w_str);
            vname = vname.replaceFirst(w_str, Matcher.quoteReplacement(l_name));
            return CodeProcessor.restoreSymbol(vname, var_map);
        }
        return vname;
    }

    public static String checkReturnType(String rtype, String src, HashMap<String, Class<?>> map) {
        if ("void".equals(rtype)) {
            return null;
        }
        HashMap<String, Class<?>> t_cmap = null;
        try {
            t_cmap = CodeProcessor.analyzeVarToClass(new StringBuilder(src), map);
        }
        catch (Fson.NotSupportedClassException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException | ParseException | NotFoundException e) {
            Tool.logIfDebug(e, "@CodeProcessot#checkReturnType");
            return null;
        }
        String rtype2 = Tool.primitiveToFQN(rtype);
        boolean t_found = false;
        Pattern t_pat = Pattern.compile("[\\s\\}\\{;]?return\\s+([@\\w\\$#\\.,\\+\\-\\*/\"\\(\\)\\s\\[\\]]+);");
        Matcher t_m = t_pat.matcher(src);
        while (t_m.find()) {
            String oname;
            Class<?> _c;
            t_found = true;
            String w_str = t_m.group(1);
            Class<?> t_c = t_cmap.get(w_str.replaceAll("\\s", ""));
            if (t_c != null) {
                String tc_name = t_c.getName();
                if (rtype2.equals(tc_name)) continue;
                return String.valueOf(w_str) + " : WRONG RETURN TYPE.EXPECTED" + tc_name;
            }
            if ("null".equals(w_str) || (w_str.startsWith("\"") || w_str.endsWith(".toString()")) && rtype.equals("java.lang.String")) continue;
            String[] temp = w_str.split("[\\-\\s\\*\\+/]");
            if (temp.length == 1) {
                if (w_str.matches("^[0-9]+$|^-[0-9]+$")) {
                    if (!rtype2.equals("java.lang.Integer")) {
                        return String.valueOf(w_str) + " : WRONG RETURN TYPE.(not " + rtype + ")";
                    }
                } else if (w_str.matches("^[0-9]+\\.[0-9]+$|^-[0-9]+\\.[0-9]+$")) {
                    if (!rtype2.equals("java.lang.Float")) {
                        return String.valueOf(w_str) + " : WRONG RETURN TYPE.(not " + rtype + ")";
                    }
                } else if (w_str.matches("^true$|^false$")) {
                    if (!rtype2.equals("java.lang.Boolean")) {
                        return String.valueOf(w_str) + " : WRONG RETURN TYPE.(not " + rtype + ")";
                    }
                } else if (w_str.matches("^\"[^\"]+\"$")) {
                    if (!rtype2.equals("java.lang.String")) {
                        return String.valueOf(w_str) + " : WRONG RETURN TYPE.(not " + rtype + ")";
                    }
                } else {
                    return String.valueOf(w_str) + " : WRONG RETURN TYPE.(not " + rtype + ")";
                }
            }
            if ((_c = t_cmap.get(oname = temp[0])) != null) {
                if (rtype2.equals(_c.getName()) || rtype.equals(_c.getName())) continue;
                if (rtype2.endsWith("[]") && _c.isArray()) {
                    Class<?> a_c = _c.getComponentType();
                    if (rtype2.startsWith(a_c.getName())) continue;
                    return String.valueOf(w_str) + " : WRONG RETURN TYPE.";
                }
                return String.valueOf(w_str) + " : WRONG RETURN TYPE.";
            }
            if (oname.matches("^[0-9]+$|^-[0-9]+$")) {
                if (rtype2.equals("java.lang.Integer") && rtype2.equals("java.lang.Long") && rtype2.equals("java.math.BigInteger")) continue;
                return String.valueOf(w_str) + " : WRONG RETURN TYPE.(not " + rtype + ")";
            }
            if (oname.matches("^[0-9]+\\.[0-9]+$|^-[0-9]+\\.[0-9]+$")) {
                if (rtype2.equals("java.lang.Float") && rtype2.equals("java.lang.Double") && rtype2.equals("java.math.BigDecimal")) continue;
                return String.valueOf(w_str) + " : WRONG RETURN TYPE.(not " + rtype + ")";
            }
            if (oname.matches("^true$|^false$")) {
                if (rtype2.equals("java.lang.Boolean")) continue;
                return String.valueOf(w_str) + " : WRONG RETURN TYPE.(not " + rtype + ")";
            }
            if (oname.matches("^\"[^\"]+\"$")) {
                if (rtype2.equals("java.lang.String")) continue;
                return String.valueOf(w_str) + " : WRONG RETURN TYPE.(not " + rtype + ")";
            }
            return String.valueOf(w_str) + " : MAYBE WRONG RETURN TYPE.(not " + rtype + "?)";
        }
        if (!t_found) {
            return "RETURN STATEMENT not found.";
        }
        return null;
    }
}

