/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test;

import com.ftinc.si.assist.run.VCentral;
import com.ftinc.si.assist.test.AssertIF;
import com.ftinc.si.assist.test.CodeProcessor;
import com.ftinc.si.assist.test.Fson;
import com.ftinc.si.assist.test.Inspector;
import com.ftinc.si.assist.test.Record;
import com.ftinc.si.assist.test.TestCommandRecord;
import com.ftinc.si.assist.test.TestLogger;
import com.ftinc.si.assist.test.Tool;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.CannotCompileException;
import javassist.NotFoundException;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class AssertRecord
extends Record
implements Cloneable,
AssertIF {
    public int id;
    public String targetObj;
    public String criteriaType = "Inspect";
    public String criteriaRex = "[]";
    public String description;
    public int snapshot_id = -1;
    protected static Date start;
    protected static Date end;
    public String m_prefix = "";
    private static String m_lost;
    static final Pattern remove_space;

    static {
        remove_space = Pattern.compile("\\A\\s*([^\\s].*[^\\s])\\s*\\Z", 32);
    }

    public AssertRecord() {
        super(0);
    }

    public AssertRecord(int i) {
        super(i);
    }

    @Override
    public void read(ResultSet r) throws SQLException {
        this.targetObj = r.getString("TargetObj");
        this.description = r.getString("Description");
        this.criteriaType = r.getString("CriteriaType");
        this.criteriaRex = r.getString("CriteriaRex");
        Pattern t_pat0 = Pattern.compile("^\\s*\"([\\s\\S]+)\"\\s*$");
        Matcher t_m = t_pat0.matcher(this.criteriaRex);
        if (t_m.find()) {
            this.criteriaRex = t_m.group(1);
        }
        this.id = r.getInt("ID");
    }

    public static void setStart(Date d) {
        start = d;
        end = null;
    }

    public static void setEnd(Date d) {
        if (end == null) {
            end = d;
        }
    }

    public long getMiliSec() {
        return end.getTime() - start.getTime();
    }

    public static void setLost(String cname, String mname) {
        m_lost = cname == null ? null : String.valueOf(cname) + "#" + mname;
    }

    public static void setLost(String str) {
        m_lost = str;
    }

    public AssertRecord _dup(boolean notNew) {
        AssertRecord t_rec = new AssertRecord(2);
        t_rec.id = this.id;
        t_rec.targetObj = this.targetObj;
        t_rec.criteriaType = this.criteriaType;
        t_rec.criteriaRex = this.criteriaRex;
        t_rec.description = this.description;
        if (notNew) {
            t_rec.m_status = this.m_status;
        }
        return t_rec;
    }

    private String _targetObj() {
        return this.esq(this.targetObj);
    }

    private String _criteriaRex() {
        return this.esq(this.criteriaRex);
    }

    @Override
    public String getUpdateSQL() {
        if (this.removed && this.isNew()) {
            return null;
        }
        if (this.targetObj == null && this.criteriaRex == null) {
            return null;
        }
        if (this.removed) {
            return "delete from \"tbl_AssertRecord\" where \"ID\"='" + Integer.toString(this.id) + "'";
        }
        if (this.isNew()) {
            return "insert into \"tbl_AssertRecord\" (\"ID\", \"TargetObj\", \"CriteriaType\", \"CriteriaRex\", \"Description\", \"Completed\") values ('" + Integer.toString(this.id) + "','" + this._targetObj() + "','" + this.criteriaType + "','" + this._criteriaRex() + "','" + this.description + "','" + Boolean.toString(this.isCompleted()) + "')";
        }
        if (this.isUpdated()) {
            return "update \"tbl_AssertRecord\" set \"TargetObj\"='" + this._targetObj() + "', \"CriteriaType\"='" + this.criteriaType + "', \"CriteriaRex\"='" + this._criteriaRex() + "', \"Description\"='" + this.description + "', \"Completed\"='" + Boolean.toString(this.isCompleted()) + "' where \"ID\"=" + Integer.toString(this.id);
        }
        return null;
    }

    public boolean isCompleted() {
        if (this.criteriaType != null && this.criteriaRex != null) {
            if ("Exception".equals(this.criteriaType) && "$null".equals(this.criteriaRex)) {
                return true;
            }
            if (this.id > 0 && this.targetObj != null && this.targetObj.length() > 0 && this.criteriaType.length() > 0 && this.criteriaRex.length() > 0) {
                String[] rexlist;
                block9: {
                    if (this.targetObj.startsWith("!")) {
                        return false;
                    }
                    rexlist = (String[])Fson.fromJson(this.criteriaRex, String[].class);
                    if (rexlist != null) break block9;
                    return false;
                }
                try {
                    int i = 0;
                    while (i < rexlist.length) {
                        String t_rex = rexlist[i];
                        if (t_rex != null) {
                            Pattern pattern = Pattern.compile(t_rex);
                        }
                        ++i;
                    }
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        assert (false);
        return 0;
    }

    public boolean equals(Object ast) {
        if (ast == null) {
            return false;
        }
        AssertRecord t_ast = (AssertRecord)ast;
        boolean result = true;
        if (this.targetObj != null) {
            if (!this.targetObj.equals(t_ast.targetObj)) {
                result = false;
            }
        } else if (t_ast.targetObj != null) {
            result = false;
        }
        if (this.criteriaRex != null) {
            if (!this.criteriaRex.equals(t_ast.criteriaRex)) {
                result = false;
            }
        } else if (t_ast.criteriaRex != null) {
            result = false;
        }
        if (this.criteriaType != null) {
            if (!this.criteriaType.equals(t_ast.criteriaType)) {
                result = false;
            }
        } else if (t_ast.criteriaType != null) {
            result = false;
        }
        return result;
    }

    public void evaluate(int phase, TestCommandRecord rec) {
        long msec = this.getMiliSec();
        ArrayList<Object> target = null;
        try {
            target = this.getResultString(rec);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException | ParseException | NoSuchElementException | CannotCompileException e) {
            TestLogger.cmdCauseError(msec, String.valueOf(Tool.getStackMessage(e, 0, 10)) + "\\n source = " + this.targetObj, this.m_prefix, e);
            return;
        }
        catch (Error e) {
            TestLogger.cmdCauseError(msec, Tool.getStackMessage(e, 0, 10), this.m_prefix, e);
            return;
        }
        catch (Exception e) {
            TestLogger.cmdCauseError(msec, Tool.getStackMessage(e, 0, 10), this.m_prefix, e);
            return;
        }
        String t_message = "";
        boolean b_result = true;
        ArrayList p_str = new ArrayList();
        if (this.criteriaRex == null) {
            return;
        }
        p_str = (ArrayList)Tool.getObjectfromJSON(ArrayList.class, this.criteriaRex);
        if (target == null || target.size() != p_str.size()) {
            TestLogger.cmdFailed(msec, "Asserting Objects must be " + Integer.toString(p_str.size()) + " elements.", this.m_prefix, p_str.size());
            return;
        }
        int i = 0;
        while (i < p_str.size()) {
            Object crexobj = p_str.get(i);
            if (target.get(i) == null) {
                if (!this.isEquivalentTo(target.get(i), crexobj.toString())) {
                    b_result = false;
                }
            } else if (target.get(i).getClass().equals(String.class)) {
                String crex = crexobj.toString();
                if (crex != null) {
                    if (crex.toLowerCase().startsWith("select")) {
                        if (!target.get(i).toString().equals("true")) {
                            b_result = false;
                        }
                    } else if (crex.startsWith("verify(")) {
                        String t_msg = crex.replaceFirst("^verify\\((.*)\\)$", "$1");
                        t_msg = "Verify! >> " + target.get(i).toString() + "\n" + t_msg;
                        JOptionPane optionPane = new JOptionPane(t_msg, 3, 0, null, new Object[]{"YES", "NO"}, "YES");
                        JDialog t_dialog = optionPane.createDialog(null, "Verification");
                        t_dialog.setLocation(0, 0);
                        t_dialog.setVisible(true);
                        Object res = optionPane.getValue();
                        if (res.toString().equals("NO")) {
                            b_result = false;
                        }
                    } else if (crex.startsWith("$")) {
                        boolean b_big = false;
                        boolean b_eq = false;
                        if (crex.startsWith("$B")) {
                            b_big = true;
                        }
                        if (crex.matches("^\\$B?[><]?=.*$")) {
                            b_eq = true;
                        }
                        String t_num = crex.replaceFirst("^[\\$<>=B]*\\s*([^\\s]+)\\s*$", "$1");
                        String result_num = target.get(i).toString();
                        if (crex.matches("^\\$B?>\\s*[0-9\\.\\-\\+]+\\s*$")) {
                            if (!VCentral.greaterThan(result_num, t_num, b_eq, b_big)) {
                                b_result = false;
                            }
                        } else if (crex.matches("^\\$B?<\\s*[0-9\\.\\-\\+]+\\s*$")) {
                            if (!VCentral.lessThan(result_num, t_num, b_eq, b_big)) {
                                b_result = false;
                            }
                        } else if (b_eq) {
                            if (t_num.matches("^[0-9\\.\\-\\+]+$")) {
                                if (!VCentral.equalN(result_num, t_num, b_big)) {
                                    b_result = false;
                                }
                            } else if (crex.matches("^\\$=\\s*null\\s*$")) {
                                if (!result_num.equals("$null")) {
                                    b_result = false;
                                }
                            } else if (crex.indexOf("$=~") == 0) {
                                Pattern xpat = Pattern.compile(crex.replaceFirst("^\\$=\\~\\s*([^\\s]+)\\s*$", "$1"));
                                Matcher xmat = xpat.matcher(result_num);
                                b_result = xmat.find();
                            } else {
                                b_result = t_num.replace("$=", "").trim().equals(result_num);
                            }
                        }
                    } else {
                        String tobe_compared;
                        Matcher t_m = remove_space.matcher(crex);
                        if (t_m.find()) {
                            crex = t_m.group(1);
                        }
                        if (crex.length() == 0 || crex.equals("$null")) {
                            crex = "\\$null";
                        }
                        Pattern t_pat = Pattern.compile(crex);
                        if (this.criteriaType.equals("Exception")) {
                            if (crex.equals("\\$null")) {
                                TestLogger.cmdIsOK(msec, this.m_prefix, p_str.size());
                                return;
                            }
                        } else if (this.criteriaType.equals("Inspect") && !(t_m = t_pat.matcher(tobe_compared = target.get(i).toString())).find()) {
                            b_result = false;
                        }
                    }
                }
            } else if (crexobj != null && !this.isEquivalentTo(target.get(i), crexobj.toString())) {
                b_result = false;
            }
            if (crexobj == null) {
                t_message = String.valueOf(t_message) + Integer.toString(i + 1) + "th=SKIPPED (EXPECTED)]\n";
            } else if (b_result) {
                t_message = String.valueOf(t_message) + Integer.toString(i + 1) + "th=TRUE (EXPECTED)]\n";
            } else if (target.get(i) == null) {
                t_message = String.valueOf(t_message) + Integer.toString(i + 1) + "th=FALSE (EVAL\u3000FAILED):value=null in regex=" + crexobj.toString() + "\n";
            } else {
                String j_target = Tool.getJSONfromObject(target.get(i));
                t_message = String.valueOf(t_message) + Integer.toString(i + 1) + "th=FALSE (UNEXPECTED):value=" + j_target + " in regex=" + crexobj.toString() + "\n";
            }
            ++i;
        }
        if (b_result) {
            TestLogger.cmdIsOK(msec, this.m_prefix, p_str.size());
        } else {
            TestLogger.cmdFailed(msec, t_message, this.m_prefix, p_str.size());
        }
    }

    private boolean isEquivalentTo(Object obj, String json) {
        if (json == null) {
            return obj == null;
        }
        if (obj == null) {
            return false;
        }
        Class<?> cl = obj.getClass();
        if (Tool.isPrimitive2(cl) && !cl.isArray() || cl.isEnum()) {
            return obj.equals(Tool.getObjectfromJSON(cl, json));
        }
        if (Map.class.isAssignableFrom(cl) && json.matches("^\\{[\\s\\S]+\\}$")) {
            HashMap t_map = (HashMap)Tool.getObjectfromJSON(HashMap.class, json);
            HashMap t_obj = (HashMap)obj;
            if (t_map != null) {
                for (Map.Entry entry : t_map.entrySet()) {
                    if (t_obj.containsKey(entry.getKey())) {
                        if (t_obj.get(entry.getKey()).equals(entry.getValue())) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }
        if ((cl.isArray() || List.class.isAssignableFrom(cl)) && json.matches("^\\[[\\s\\S]+\\]$")) {
            ArrayList t_list1 = (ArrayList)Tool.getObjectfromJSON(ArrayList.class, json);
            ArrayList t_list2 = (ArrayList)Tool.getObjectfromJSON(ArrayList.class, Tool.getJSONfromObject(obj));
            if (t_list1 != null && t_list2 != null && t_list1.size() == t_list2.size()) {
                int i = 0;
                while (i < t_list1.size()) {
                    if (!(t_list1.get(i) == null && t_list2.get(i) == null || t_list1.get(i).equals(t_list2.get(i)))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        HashMap t_map = (HashMap)Tool.getObjectfromJSON(HashMap.class, json);
        if (t_map != null) {
            for (Map.Entry entry : t_map.entrySet()) {
                ArrayList<Object> t_list = Fson.valueByJsonPath(obj, "$." + (String)entry.getKey());
                if (t_list.size() == 1) {
                    if (this.isEquivalentTo(t_list.get(0), Tool.getJSONfromObject(entry.getValue()))) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void evaluateException(int phase, TestCommandRecord rec, String fakeInfo, Throwable ... excepts) {
        long msec = this.getMiliSec();
        if (excepts != null) {
            String internal_msg = "";
            String t_stacks = "";
            int i = 0;
            while (i < excepts.length) {
                if (excepts[i].getMessage() == null || excepts[i].getMessage().length() == 0) {
                    String str_cause = "Inspector.\n";
                    if (phase < 200 && phase >= 100) {
                        switch (phase) {
                            case 150: {
                                str_cause = "Cannot find the method.\n";
                                break;
                            }
                            case 152: {
                                str_cause = "Exception in the invokation.\n";
                                break;
                            }
                            case 100: {
                                str_cause = "Can not find the class to construct.\n";
                                break;
                            }
                            case 101: {
                                str_cause = "Failed to make snapshot.\n";
                                break;
                            }
                            case 120: {
                                str_cause = "Failed to invoke the constructor.\n";
                                break;
                            }
                            default: {
                                str_cause = "invokation.\n";
                            }
                        }
                        if (fakeInfo != null) {
                            str_cause = String.valueOf(str_cause) + fakeInfo + "\n";
                        }
                    } else if (phase < 100) {
                        str_cause = "constructing arguments?.\n";
                    }
                    internal_msg = ": occurred in the " + str_cause;
                }
                internal_msg = String.valueOf(internal_msg) + excepts[i].getClass().getName() + " caused by \n" + Tool.removeRedundancy(excepts[i], "") + ".\n";
                t_stacks = String.valueOf(t_stacks) + Tool.getStackMessage(excepts[i], 0, 10);
                ++i;
            }
            if (m_lost != null) {
                internal_msg = String.valueOf(m_lost) + " not found. " + internal_msg;
            }
            if (this.criteriaType.equals("Exception")) {
                if (excepts.getClass().getName().matches(Pattern.quote(this.criteriaRex))) {
                    TestLogger.cmdIsOK(msec, this.m_prefix, 1);
                } else {
                    TestLogger.cmdCauseError(msec, String.valueOf(internal_msg) + t_stacks, this.m_prefix, excepts);
                }
            } else {
                TestLogger.cmdCauseError(msec, String.valueOf(internal_msg) + t_stacks, this.m_prefix, excepts);
            }
        }
    }

    protected ArrayList<Object> getResultString(TestCommandRecord curCmd) throws SecurityException, IllegalArgumentException, CannotCompileException, InstantiationException, IllegalAccessException, ClassNotFoundException, NotFoundException, NoSuchMethodException, InvocationTargetException, NoSuchFieldException, ParseException, Fson.NotSupportedClassException {
        String t_targetObj;
        ArrayList<String> t_esqlist = CodeProcessor.escDQStrings(this.targetObj, "@DQT");
        String t_src = t_targetObj = t_esqlist.get(0);
        HashMap<String, String> cmap = new HashMap<String, String>();
        ArrayList<String> t_list = new ArrayList<String>();
        Pattern t_pat2 = Pattern.compile("([\\(=\\;\\s\\+\\-\\*/,\\[\\|\\&])\\$([_0-9]+)([\\.;/=\\+\\*\\s\\-\\)\\[\\|\\&\\]])");
        Matcher t_m = t_pat2.matcher(this.targetObj);
        while (t_m.find()) {
            String w_str = t_m.group();
            t_src = t_src.replaceFirst(Pattern.quote(w_str), Matcher.quoteReplacement(String.valueOf(t_m.group(1)) + "_x" + t_m.group(2) + t_m.group(3)));
            String t_curvar = t_m.group(2);
            if (t_list.contains("$" + t_curvar)) continue;
            t_list.add("$" + t_curvar);
            String t_key = "_x" + t_curvar;
            if (cmap.containsKey(t_key)) continue;
            cmap.put(t_key, curCmd.getArgClassByName("$" + t_curvar));
        }
        t_src = CodeProcessor.restoreDQString(t_src, "@DQT", t_esqlist);
        int i = 0;
        while (i < t_list.size()) {
            String t_str = ((String)t_list.get(i)).substring(1);
            String v_str = "_x" + t_str;
            String dec_str = String.valueOf((String)cmap.get(v_str)) + " " + v_str + "=(" + (String)cmap.get(v_str) + ")getInstance(\"" + Integer.toString(this.id) + "$" + t_str + "\");";
            t_src = String.valueOf(dec_str) + t_src;
            ++i;
        }
        StringBuilder t_b = new StringBuilder(t_src);
        HashMap t_map = new HashMap();
        for (Map.Entry entry : cmap.entrySet()) {
            Class<?> t_c = Tool.forName((String)entry.getValue());
            t_map.put((String)entry.getKey(), t_c);
        }
        CodeProcessor.analyzeVarToClass(t_b, t_map);
        t_src = t_b.toString();
        int t_id = this.id;
        if (this.snapshot_id > 0) {
            t_id = this.snapshot_id;
        }
        return this.doInspect(t_id, t_src);
    }

    private ArrayList<Object> doInspect(int id, String src) throws SecurityException, IllegalArgumentException, CannotCompileException, InstantiationException, IllegalAccessException, ClassNotFoundException, NotFoundException, NoSuchMethodException, InvocationTargetException {
        Inspector t_i = Tool.createInspector(id, src);
        if (t_i != null) {
            t_i.inspect();
            return t_i.results;
        }
        return null;
    }
}

