/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.web;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.Fson;
import com.ftinc.si.assist.test.JSONRecord;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.gui.JSONChooser;
import com.ftinc.si.assist.test.web.PageAction;
import com.ftinc.si.assist.test.web.WebElementGetter;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.WebDriver;

public class JQExec
extends PageAction {
    private static HashMap<String, String> s_scripts = new HashMap();
    private static final String s_objByXpath = "function _objByXPath(elm){return document.evaluate(elm,document,null,XPathResult.ORDERED_NODE_SNAPSHOT_TYPE,null);}";
    private static final Pattern lambda_pat = Pattern.compile("\\s*\\(\\s*([^\n]+)\\s*\\)\\s*\\->\\s*\\{\\s*([\\s\\S]+)\\s*\\}\\s*\\z");
    private static final Pattern xelm_pat = Pattern.compile("\\$x\\(\"?(.+?)\"?\\)\\.");
    private static final Pattern srcid_pat = Pattern.compile("^@ScriptId\\s*\\(\\s*\"?([^\\n]+)\"?\\s*\\)");

    @Override
    public final ArrayList<String> doAction(WebDriver drv) {
        ArrayList<String> result = new ArrayList<String>();
        String raw_reg = (String)this.arg_map.get("value");
        if (":SKIP".equals(raw_reg)) {
            result.add("");
            return result;
        }
        this.waitUntil(drv);
        String t_src = this.scriptFromLambda(true);
        String t_script = s_objByXpath + t_src;
        try {
            JavascriptExecutor jsexe = (JavascriptExecutor)((Object)drv);
            Object t_obj = jsexe.executeScript(t_script, new Object[0]);
            if (t_obj == null) {
                result.add("");
                return result;
            }
            result.add(t_obj.toString());
        }
        catch (Exception e) {
            result.add("JQ target=" + Messages.getString("JQExec.6") + e.getMessage());
        }
        return result;
    }

    private String[] argsList(String src) {
        if (src != null && src.length() > 0) {
            try {
                ArrayList<String> esq_args = Fson.escapeBraket(src, "\"(");
                String[] ar_args = esq_args.get(0).split(",");
                int i = 0;
                while (i < ar_args.length) {
                    ar_args[i] = Fson.restoreBraket(ar_args[i], esq_args);
                    ar_args[i] = ar_args[i].replaceFirst("=", Matcher.quoteReplacement("\t"));
                    ++i;
                }
                return ar_args;
            }
            catch (ParseException e) {
                Tool.logForTesting(e, String.valueOf(src) + " @JQExec.argList");
            }
        }
        return null;
    }

    private String scriptFromLambda(boolean convertMacro) {
        Object src = this.arg_map.get("script");
        if (src == null) {
            return "";
        }
        String t_id = "";
        Matcher t_m = srcid_pat.matcher(src.toString());
        if (t_m.find()) {
            t_id = t_m.group(1);
            src = s_scripts.get(t_id);
            if (src == null) {
                JSONRecord t_jrec = JSONRecord.getJSONRec("java.lang.String", t_id);
                if (t_jrec == null) {
                    throw new NotFoundException(String.valueOf(Messages.getString("JQExec.11")) + t_id + ".");
                }
                src = t_jrec.content;
                s_scripts.put(t_id, (String)src);
            }
            t_id = "@ScriptId(" + t_id + ")\n";
        }
        if ((t_m = lambda_pat.matcher(src.toString())).find()) {
            String[] t_args = this.argsList(t_m.group(1));
            ArrayList<String> i_args = this.getArgValuesForLamda(t_args);
            if (convertMacro) {
                String t_script = "{" + t_m.group(2) + "}";
                t_m = xelm_pat.matcher(t_script);
                while (t_m.find()) {
                    String target = t_m.group(1);
                    if ("xpath".equals(target)) {
                        String xpath = this.getXpath();
                        t_script = t_script.replace("$x(xpath)", "_objByXPath(\"" + xpath + "\")");
                        continue;
                    }
                    t_script = t_m.replaceAll(String.valueOf(Matcher.quoteReplacement("_objByXPath(")) + "$1" + Matcher.quoteReplacement(")."));
                }
                int i = 0;
                while (i < t_args.length) {
                    String str_pat = "([\\.,\\{\\}\\(\\s\\-\\*/\\+\\[])" + t_args[i] + "([\\]\\s,\\);\\+\\-/\\*\\.\\(])";
                    t_script = t_script.replaceAll(str_pat, "$1" + Matcher.quoteReplacement(i_args.get(i)) + "$2");
                    ++i;
                }
                t_script = t_script.substring(1, t_script.length() - 1);
                return t_script;
            }
            String head = "(";
            int i = 0;
            while (i < t_args.length) {
                if (head.length() > 1) {
                    head = String.valueOf(head) + ",";
                }
                head = String.valueOf(head) + t_args[i] + "=" + Fson.restore(i_args.get(i));
                ++i;
            }
            head = String.valueOf(head) + ") -> ";
            return String.valueOf(t_id) + head + t_m.group(2);
        }
        if (!convertMacro) {
            src = String.valueOf(t_id) + src;
        }
        return src.toString();
    }

    private ArrayList<String> getArgValuesForLamda(String[] argNames) {
        ArrayList<String> t_result = new ArrayList<String>();
        int i = 0;
        while (i < argNames.length) {
            if (this.arg_map.containsKey(argNames[i])) {
                Object t_val = this.arg_map.get(argNames[i]);
                if (t_val != null) {
                    if (t_val.toString().matches("^(false|true)$") || t_val.toString().matches("^\\-?[0-9]*\\.?[0-9]+$")) {
                        t_result.add(t_val.toString());
                    } else if (t_val.toString().matches("^\\$\\(.*\\)$")) {
                        Matcher t_m = xelm_pat.matcher(t_val.toString());
                        if (t_m.find()) {
                            t_result.add(t_m.replaceAll(String.valueOf(Matcher.quoteReplacement("_objByXPath(")) + "$1" + Matcher.quoteReplacement(").")));
                        }
                    } else {
                        String t_str = t_val.toString();
                        t_str = t_str.replaceFirst("^[\\\"']?(.*)[\"']?$", "$1");
                        t_result.add("\"" + t_str + "\"");
                    }
                } else {
                    t_result.add("null");
                }
            }
            ++i;
        }
        return t_result;
    }

    @Override
    protected boolean assertable() {
        Object src = this.arg_map.get("value");
        return src != null;
    }

    @Override
    protected String getTarget() {
        return this.scriptFromLambda(false);
    }

    @Override
    protected ArrayList<String> getLabelAndParams() {
        ArrayList<String> t_list2 = super.getLabelAndParams();
        t_list2.add((String)this.arg_map.get("value"));
        return t_list2;
    }

    @Override
    protected String getJsonElement(String target, String arg) {
        if (arg != null) {
            this.arg_map.put("value", arg);
        }
        if (target != null) {
            ArrayList<String> a_list = new ArrayList<String>();
            Matcher t_m = lambda_pat.matcher(target);
            if (t_m.find()) {
                String[] t_args = this.argsList(t_m.group(1));
                String t_script = t_m.group(2);
                String res_lambda = "(";
                int i = 0;
                while (i < t_args.length) {
                    String[] temp = t_args[i].split("\t");
                    if (temp.length > 0) {
                        if (res_lambda.length() > 1) {
                            res_lambda = String.valueOf(res_lambda) + ",";
                        }
                        if (temp.length > 1) {
                            if ("xpath".equals(temp[0])) {
                                temp[1] = temp[1].replaceAll("^\"|\"$", "");
                                this.arg_map.put("xpath", temp[1]);
                                a_list.add("");
                            } else if ("selector".equals(temp[0]) && temp[1].startsWith("\"#")) {
                                temp[1] = temp[1].replaceAll("^\"#|\"$", "");
                                this.arg_map.put("id", temp[1]);
                                a_list.add("");
                            } else {
                                a_list.add(temp[1]);
                            }
                        }
                        res_lambda = String.valueOf(res_lambda) + temp[0];
                    }
                    ++i;
                }
                res_lambda = String.valueOf(res_lambda) + ")";
                t_script = String.valueOf(res_lambda) + "-> " + t_script;
                String t_an = (String)this.getAnnotationFromScript(target);
                if (t_an != null) {
                    this.arg_map.put("script", t_an.toString());
                } else {
                    this.arg_map.put("script", t_script);
                }
            } else {
                t_m = srcid_pat.matcher(target);
                if (t_m.find()) {
                    target = t_m.group();
                }
                this.arg_map.put("script", target);
            }
        }
        return super.getJsonElement(null, null);
    }

    private Object getAnnotationFromScript(Object src) {
        Matcher t_m = srcid_pat.matcher(src.toString());
        if (t_m.find()) {
            return t_m.group();
        }
        return null;
    }

    protected String getTemplateString(WebElementGetter wg) {
        ArrayList<JSONRecord> t_result = Tool._db().getJSONRecWhere("java.lang.String", "js_%", Tool.version);
        String t_json = null;
        String t_id = null;
        if (t_result.size() == 1) {
            t_json = t_result.get((int)0).content;
            t_id = t_result.get((int)0).name;
        } else if (t_result.size() > 1) {
            JSONChooser t_ch = new JSONChooser(wg, t_result);
            t_ch.setVisible(true);
            if (t_ch.is_ok) {
                t_json = t_ch.m_json;
                t_id = t_ch.m_name;
            }
        }
        if (t_json != null) {
            s_scripts.put(t_id, t_json);
            String t_jexe = (String)Tool.getObjectfromJSON(String.class, t_json);
            if (t_jexe != null) {
                return "@ScriptId(" + t_id + ")\n" + t_jexe;
            }
        }
        return null;
    }

    @Override
    protected JPopupMenu getPopup(WebElementGetter wg, String cur_str) {
        Object src;
        ArrayList<JSONRecord> t_result = Tool._db().getJSONRecWhere("java.lang.String", "js_%", Tool.version);
        JPopupMenu t_pop = new JPopupMenu();
        if (t_result != null && t_result.size() > 0) {
            t_pop.add(new JMenuItem(new JQAction(Messages.getString("JQExec.58"), wg, cur_str)));
        }
        if ((src = this.arg_map.get("script")) != null && src.toString().length() > 0) {
            t_pop.add(new JMenuItem(new JQAction(Messages.getString("JQExec.59"), wg, cur_str)));
        }
        JMenu t_menu = new JMenu(Messages.getString("JQExec.39"));
        if (cur_str.matches("^[\\s\\S]*\\(.*xpath=.*\\)\\s*\\->[\\s\\S]*$")) {
            String t_path = cur_str.replaceFirst("^\\(.*xpath=\"([^\"]+)\".*\\)\\s*\\->[\\s\\S]*$", "$1");
            if (t_path.contains("input")) {
                t_menu.add(new JMenuItem(new PageAction.InsertAction(Messages.getString("JQExec.44"), "EqualsText@", wg, cur_str)));
                t_menu.add(new JMenuItem(new PageAction.InsertAction(Messages.getString("JQExec.46"), "ContainsText@", wg, cur_str)));
            } else {
                t_menu.add(new JMenuItem(new PageAction.InsertAction(Messages.getString("JQExec.48"), "EqualsText", wg, cur_str)));
                t_menu.add(new JMenuItem(new PageAction.InsertAction(Messages.getString("JQExec.50"), "ContainsText", wg, cur_str)));
                t_menu.add(new JMenuItem(new PageAction.InsertAction(Messages.getString("JQExec.2"), "HasTag", wg, cur_str)));
            }
        }
        t_pop.add(t_menu);
        return t_pop;
    }

    class JQAction
    extends AbstractAction {
        String m_name;
        String m_src;
        WebElementGetter m_master;

        JQAction(String name, WebElementGetter master, String src) {
            this.putValue("Name", name);
            this.m_name = name;
            this.m_master = master;
            this.m_src = src;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.m_name.equals(Messages.getString("JQExec.0"))) {
                this.m_master.setTargetFromPopup(JQExec.this.getTemplateString(this.m_master));
            } else if (this.m_name.equals(Messages.getString("JQExec.1"))) {
                String t_str = JQExec.this.getJsonElement(this.m_src, "");
                t_str = t_str.replaceFirst("^[\\s\\S]*\"script\":\"([^\"]*)\"[\\s\\S]*$", "$1");
                t_str = Fson.restore(t_str);
                this.m_master.registerTargetFromPopup("java.lang.String", t_str);
            }
        }
    }
}

