package com.ftinc.si.assist.test.web;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map.Entry;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.ObjectRecord;
import com.ftinc.si.assist.test.Tool;

public class BrowserSetter extends JDialog {
	private ObjectRecord m_rec;

	private JComboBox<String> browserCombo;
	private JCheckBox chckbxGrid;
	private JComboBox<String> versionCombo;
	private JComboBox<String> platfCombo;
	private JTextField gridAdress;

	private HashMap<String, HashMap<String, String>> m_bmap = null;
	private HashMap<String, String> m_curVmap;
	private JTextField serverPort;
	private JTextField userText;
	private JTextField pwdText;

	public BrowserSetter(JDialog owner, ObjectRecord rec) {
		super(owner, true);
		setTitle(Messages.getString("BrowserSetter.this.title")); //$NON-NLS-1$
		setResizable(false);

		m_rec = rec;
		setBounds(owner.getX() + 50, owner.getY() + 50, 590, 300);
		getContentPane().setLayout(null);

		JLabel lblBrowser = new JLabel(Messages.getString("BrowserSetter.0")); //$NON-NLS-1$
		lblBrowser.setBounds(12, 10, 70, 13);
		getContentPane().add(lblBrowser);

		browserCombo = new JComboBox<String>();
		browserCombo.addItem("Firefox"); //$NON-NLS-1$
		browserCombo.addItem("IE"); //$NON-NLS-1$
		browserCombo.addItem("Chrome"); //$NON-NLS-1$
		browserCombo.addItem("Safari"); //$NON-NLS-1$

		browserCombo.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (browserCombo.getSelectedIndex() >= 0) {
					setVersion(browserCombo.getSelectedItem().toString());
				} else {
					setVersion(null);
				}
			}
		});
		browserCombo.setBounds(102, 7, 148, 19);
		getContentPane().add(browserCombo);

		chckbxGrid = new JCheckBox(Messages.getString("BrowserSetter.1")); //$NON-NLS-1$
		chckbxGrid.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (chckbxGrid.isSelected()) {
					versionCombo.setEnabled(true);
					platfCombo.setEnabled(true);
					gridAdress.setEnabled(true);
				} else {
					versionCombo.setEnabled(false);
					platfCombo.setEnabled(false);
					gridAdress.setEnabled(false);
				}
			}
		});
		chckbxGrid.setBounds(8, 45, 89, 21);
		getContentPane().add(chckbxGrid);

		versionCombo = new JComboBox<String>();
		versionCombo.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (versionCombo.getSelectedIndex() >= 0) {
					setPlatform(versionCombo.getSelectedItem().toString());
				} else {
					setPlatform(null);
				}
			}
		});
		versionCombo.setBounds(172, 84, 78, 19);
		getContentPane().add(versionCombo);

		JLabel lblPlatform = new JLabel(Messages.getString("BrowserSetter.2")); //$NON-NLS-1$
		lblPlatform.setBounds(274, 87, 78, 13);
		getContentPane().add(lblPlatform);

		JLabel lblVersion = new JLabel(Messages.getString("BrowserSetter.3")); //$NON-NLS-1$
		lblVersion.setBounds(102, 87, 58, 13);
		getContentPane().add(lblVersion);

		platfCombo = new JComboBox<String>();
		platfCombo.setBounds(358, 81, 214, 19);
		getContentPane().add(platfCombo);

		JButton btnOK = new JButton(Messages.getString("BrowserSetter.4")); //$NON-NLS-1$
		btnOK.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				setJson();
				setVisible(false);
			}
		});
		btnOK.setBounds(182, 240, 91, 21);
		getContentPane().add(btnOK);

		JButton btnCancel = new JButton(Messages.getString("BrowserSetter.5")); //$NON-NLS-1$
		btnCancel.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				setVisible(false);
			}
		});
		btnCancel.setBounds(297, 240, 91, 21);
		getContentPane().add(btnCancel);

		gridAdress = new JTextField();
		gridAdress.setBounds(102, 46, 470, 19);
		getContentPane().add(gridAdress);
		gridAdress.setColumns(10);

		versionCombo.setEnabled(false);
		platfCombo.setEnabled(false);
		gridAdress.setEnabled(false);

		JLabel lblProxy = new JLabel(Messages.getString("BrowserSetter.lblProxy.text")); //$NON-NLS-1$
		lblProxy.setBounds(12, 145, 50, 13);
		getContentPane().add(lblProxy);

		serverPort = new JTextField();
		serverPort.setToolTipText("server address : port");
		serverPort.setBounds(102, 142, 470, 19);
		getContentPane().add(serverPort);
		serverPort.setColumns(10);

		JLabel lblUser = new JLabel(Messages.getString("BrowserSetter.lblUser.text")); //$NON-NLS-1$
		lblUser.setBounds(102, 171, 50, 13);
		getContentPane().add(lblUser);

		userText = new JTextField();
		userText.setToolTipText("user_id for proxy server");
		userText.setBounds(172, 168, 180, 19);
		getContentPane().add(userText);
		userText.setColumns(10);

		JLabel lblPassword = new JLabel(Messages.getString("BrowserSetter.lblPassword.text")); //$NON-NLS-1$
		lblPassword.setBounds(102, 200, 70, 13);
		getContentPane().add(lblPassword);

		pwdText = new JTextField();
		pwdText.setToolTipText("password for proxy server");
		pwdText.setBounds(172, 197, 180, 19);
		getContentPane().add(pwdText);
		pwdText.setColumns(10);

		initBrowserMap();
	}

	//コマンドラインからの-properties:{browser_map:json}　でSystem.propertyにセットされた値を読み取る。
	@SuppressWarnings("unchecked")
	private void initBrowserMap() {
		if (System.getProperty("browser_map") != null) { //$NON-NLS-1$
			String t_mapstr = System.getProperty("browser_map"); //$NON-NLS-1$
			m_bmap = (HashMap<String, HashMap<String,String>>)Tool.getObjectfromJSON(HashMap.class, t_mapstr);
		}
	}

	private void setJson() {
		String t_json = "{"; //$NON-NLS-1$
		int n = browserCombo.getSelectedIndex();
		if (n >= 0) {
			t_json += "\"browser\":\"" + browserCombo.getItemAt(n).toString() + "\""; //$NON-NLS-1$ //$NON-NLS-2$

			if (chckbxGrid.isSelected()) {
				t_json += ",\"grid\":\"" + gridAdress.getText() + "\""; //$NON-NLS-1$ //$NON-NLS-2$

				n = versionCombo.getSelectedIndex();
				if (n >= 0) {
					t_json += ",\"version\":\"" + versionCombo.getItemAt(n).toString() + "\""; //$NON-NLS-1$ //$NON-NLS-2$
				}

				n = platfCombo.getSelectedIndex();
				if (n >= 0) {
					t_json += ",\"platform\":\"" + platfCombo.getItemAt(n).toString() + "\""; //$NON-NLS-1$ //$NON-NLS-2$
				}
			}

			if (serverPort.getText().length() > 0) {
				t_json += ",\"proxy\":\"" + serverPort.getText() + "\""; //$NON-NLS-1$ //$NON-NLS-2$
				if (userText.getText().length() > 0) {
					t_json += ",\"proxy.user_id\":\"" + userText.getText() + "\""; //$NON-NLS-1$ //$NON-NLS-2$
					if (pwdText.getText().length() > 0) {
						t_json += ",\"proxy.password\":\"" + pwdText.getText() + "\""; //$NON-NLS-1$ //$NON-NLS-2$
					}
				}
			}
		}
		t_json += "}"; //$NON-NLS-1$
		if (t_json.length() > 2) {
			//JSONはこのメソッドを通じるべし。
			m_rec.setJSON(t_json);
		}
	}

	//Browserの名前から可能な版数をセットする。
	private void setVersion(String browser) {
		versionCombo.removeAll();
		if (m_bmap != null && m_bmap.containsKey(browser)) {
			m_curVmap = m_bmap.get(browser);

			versionCombo.removeAll();
			for(Entry<String, String> e : m_curVmap.entrySet()) {
				versionCombo.addItem(e.getKey());
			}
			setPlatform(null);
		}
		setPlatform(null);
	}

	//Browserの版数を選んだ際に、動作環境（OS）の選択項目をセットする。
	private void setPlatform(String ver) {
		platfCombo.removeAll();
		if (m_bmap != null && m_curVmap != null && versionCombo.getSelectedIndex() >= 0) {
			String t_str = versionCombo.getSelectedItem().toString();
			String array_str = m_curVmap.get(t_str);

			String[] t_list = (String[])Tool.getObjectfromJSON(String[].class, array_str);
			if (t_list != null && t_list.length > 0) {
				for (int i = 0; i < t_list.length; i++) {
					platfCombo.addItem(t_list[i]);
				}
			}
		}
	}
}
