#!/usr/bin/env python
# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#
#   ftg.py : It is a tool that ,
#            you can capture and anlyze.
#

__version__ = "0.3"

import sys
import os
import re
from optparse import OptionParser, OptionGroup
from ftg.grapher import Grapher
from ftg.utils.common import CommonUtils
from ftg.formatter.graphviz_tb import GraphvizTBFormatter
from ftg.formatter.csv import CSVFormatter
from ftg.formatter.tsv import TSVFormatter


if __name__ == "__main__":
    # init program options
    p = OptionParser(version="ver: %s" % __version__)
    p.add_option(
        '-i', '--dump_file', dest='dump_file',
        help="specify Open vSwitch dump-flows FILE", metavar="FILE")
    p.add_option(
        '-f', '--formatter', dest='formatter',
        help="specify formatter (graphviz, csv, tsv)", default="graphviz")
    p.add_option(
        '-b', '--entries_per_block', dest='entries_per_block', type='int',
        help="specify number of entries in priority block", default=10)
    p.add_option(
        '-t', '--tables', dest='output_target_tables',
        help="specify the tables to be output.")
    p.add_option(
        '-v', '--verbose', dest='verbose', action="store_true", default=False,
        help="verbose output")
    p.add_option(
        '-d', '--debug', dest='debug', action="store_true", default=False,
        help="debug output")
    g1 = OptionGroup(p, "Output Flags")
    g1.add_option(
        '--enable_output_resubmit_loop', dest='output_resubmit_loop',
        action="store_true", default=True,
        help="enable the output of the 'resubmit to start' that re-evaluate at the same table")
    g1.add_option(
        '--disable_output_resubmit_loop', dest='output_resubmit_loop',
        action="store_false", default=True,
        help="disable the output of the 'resubmit to start' that re-evaluate at the same table")
    g1.add_option(
        '--enable_output_summary', dest='output_summary',
        action="store_true", default=True,
        help="enable the output of the summary informations")
    g1.add_option(
        '--disable_output_summary', dest='output_summary',
        action="store_false", default=True,
        help="disable the output of the output summary informations")
    p.add_option_group(g1)
    (opts, args) = p.parse_args()

    util = CommonUtils(opts)

    output_target_tables = []
    if  opts.output_target_tables is not None:
        output_target_tables = opts.output_target_tables.split(',')
        
    if  opts.formatter == "graphviz":
        formatter = GraphvizTBFormatter(util)
        formatter.set_output_target_tables(output_target_tables)
        formatter.set_entries_per_block(opts.entries_per_block)
        formatter.set_output_summary(opts.output_summary)
        formatter.set_output_resubmit_loop(opts.output_resubmit_loop)
    elif  opts.formatter == "csv":
        formatter = CSVFormatter(util)
    elif  opts.formatter == "tsv":
        formatter = TSVFormatter(util)
    else:
        util.error_out("specify valid formatter.")
        sys.exit(1)

    if opts.dump_file is not None and opts.dump_file != "":
        grapher = Grapher(util, opts.dump_file, formatter)
        grapher.run()
    else:
        util.error_out("specify Open vSwitch dump-flows file with -i option.")
        sys.exit(1)
        

     
