# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

from ftg.utils.common import CommonUtils
from ftg.parser.ovs_flow_dump import OVSFlowDumpParser


class Grapher():

    def __init__(self, util, dump_file, formatter):
        self.util = util
        self.dump_file = dump_file
        self.formatter = formatter

    def run(self):
        parser = OVSFlowDumpParser(self.util, self.dump_file)
        parser.parse()
        tables = parser.get_tables()
        self.formatter.set_tables(tables)
        for formatted_line in self.formatter.format():
            print formatted_line

#         for action in self.actions:
#             action_title = "ACTION: " + action
#             self.util.message_out("\n" + action_title)
#             self.util.message_out("-" * len(action_title))
#             action_type = str(self.scenario.get_item(action, "ACTION")).upper()
#             action_params = self.scenario.get_items_as_dict(action)
#             if action_type == "GENERATE":
#                 packet_def_name = str(
#                     self.scenario.get_item(action, "PACKET_DEF"))
#                 task_runner = PacketGenerator(self.util, self._get_packet_def(
#                     packet_def_name), action_params, self.reporter)
#             elif action_type == "CAPTURE":
#                 task_runner = PacketCapture(
#                     self.util, self.packet_templates, action_params, self.reporter)
#             elif action_type == "ANALYZE":
#                 task_runner = PacketAnalyzer(
#                     self.util, self.packet_templates, action_params, self.reporter)
#             else:
#                 packet_def_name = str(
#                     self.scenario.get_item(action, "PACKET_DEF"))
#                 task_runner = PacketGenerator(self.util, self._get_packet_def(
#                     packet_def_name), action_params, self.reporter)
#             task_runner.run()
