#!/usr/local/bin/python

# ftpy is ftp clone.

import ftplib,string,os
from ftpy_define import *

class ftpclient:
	#--------------------------------#
	#	Member Method                #
	#--------------------------------#
	def setHostname(self,hostname):
		self.hostname = hostname
	
	def getHostname(self):
		return self.hostname
	
	def setPortno(self,portno):
		self.portno = portno
		
	def getPortno(self):
		return self.portno
		
	def setUser(self,user):
		self.user = user
		
	def getUser(self):
		return self.user
		
	def setPassword(self,password):
		self.password = password
		
	def getPassword(self):
		return self.password
		
	def setLocal_dir(self,local_dir):
		self.local_dir = local_dir
		
	def getLocal_dir(self):
		return self.local_dir

	def getReturnMsg(self):
		return self.return_msg
		
	def getError_Obj(self):
		return self.error_obj
		
	def getMsg_Obj(self):
		return self.msg_obj
	
	def getRemoteDir_Obj(self):
		return self.remotedir_obj
	
	def getLocalDir_Obj(self):
		return self.localdir_obj
	
	#--------------------------------#
	#	Connection                   #
	#--------------------------------#
	#FTP Connection to FTP Server
	def connect(self):
		try:
			self.ftpcon = ftplib.FTP()
			self.return_msg = self.ftpcon.connect(self.hostname,self.portno)
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG
	
	#Loing to FTP Server
	def login(self):
		try:
			self.return_msg = self.ftpcon.login(self.user,self.password)
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG
	
	#Close Connection
	def close(self):
		try:
			self.return_msg = self.ftpcon.quit()
			return C_OK
		except Exception, e:
			try:
				self.return_msg = self.ftpcon.close()
				return C_OK
			except Exception, e:
				return C_NG
	
	#Abort
	def abort(self):
		try:
			self.return_msg = self.ftpcon.abort()
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG
	
	#Set pasv mode
	def setPasvmode(self,mode):
		try:
			if mode == C_ON:
				self.return_msg = self.ftpcon.set_pasv(True)
			else:
				self.ftpcon.set_pasv(False)
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Get welcome message
	def getWelcomeMsg(self):
		try:
			self.return_msg = self.ftpcon.getwelcome()
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Get Server System
	def getServerSystem(self):
		try:
			self.sendUserCmd("SYST")
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG
	
	#Get Server Status
	def getServerStatus(self):
		try:
			self.sendUserCmd("STAT")
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#--------------------------------#
	#	Send  Command                #
	#--------------------------------#
	#Send user command
	def sendUserCmd(self,cmd):
		try:
			self.return_msg = self.ftpcon.sendcmd(cmd)
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG
			
	#--------------------------------#
	#	Remote Directory             #
	#--------------------------------#
	#Get remote dir list
	def getRemoteDirData(self,pattarn=""):
		try:
			self.remotedir_obj = []
			if pattarn == "":
				send_command = "LIST -L"
			else:
				send_command = "LIST " + pattarn
			self.ftpcon.retrlines(send_command,self.remotedir_obj.append)
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Get current remote dir
	def getCurrentRemoteDir(self):
		try:
			self.msg_obj = []
			self.msg_obj.append(self.ftpcon.pwd())
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Change remote dir
	def changeRemoteDir(self,dirname,dummy=None):
		try:
			self.return_msg = self.ftpcon.cwd(dirname)
			self.getRemoteDirData()
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#--------------------------------#
	#	File Transfer                #
	#--------------------------------#
	#Get file(BINARY MODE)
	def getRemoteFile(self,remote_filename,local_filename):
		try:
			self.return_msg = self.ftpcon.retrbinary("RETR " + remote_filename,open(local_filename,"wb").write)
			self.getRemoteDirData()
			return C_OK
		except Exception, e:
			os.remove(local_filename)
			self.error_obj = e
			return C_NG
	
	#Put file(BINARY MODE)
	def putLocalFile(self,remote_filename,local_filename):
		try:
			localfile = open(local_filename,"rb")
			self.return_msg = self.ftpcon.storbinary("STOR " + remote_filename,localfile)
			localfile.close()
			self.getRemoteDirData()
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Get file(ASCII MODE)
	def getRemoteFileAscii(self,remote_filename,local_filename):
		try:
			self.return_msg = self.ftpcon.retrlines("RETR " + remote_filename,open(local_filename,"wb").write)
			self.getRemoteDirData()
			return C_OK
		except Exception, e:
			os.remove(local_filename)
			self.error_obj = e
			return C_NG
	
	#Put file(ASCII MODE)
	def putLocalFileAscii(self,remote_filename,local_filename):
		try:
			localfile = open(local_filename,"rb")
			self.return_msg = self.ftpcon.storlines("STOR " + remote_filename,localfile)
			localfile.close()
			self.getRemoteDirData()
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#--------------------------------#
	#	Remote File Control          #
	#--------------------------------#
	#Get file size
	def getRemoteFileSize(self,remote_filename):
		try:
			return self.ftpcon.size(remote_filename)
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Remove file
	def removeRemoteFile(self,remote_filename):
		try:
			self.return_msg = self.ftpcon.delete(remote_filename)
			self.getRemoteDirData()
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Chage mode to remote file
	def changeModeRemoteFile(self,remote_filename,file_mode):
		try:
			send_command = "SITE CHMOD %s %s" % (file_mode,remote_filename)
			self.return_msg = self.ftpcon.sendcmd(send_command)
			self.getRemoteDirData()
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#--------------------------------#
	#	Remote Directory Control     #
	#--------------------------------#
	#Create dir
	def createRemote_dir(self,dir_name):
		try:
			self.return_msg = self.ftpcon.mkd(dir_name)
			self.getRemoteDirData()
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Remove dir
	def removeRemote_dir(self,dir_name):
		try:
			self.return_msg = self.ftpcon.rmd(dir_name)
			self.getRemoteDirData()
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Get Directory
	def getRemoteDir(self,remote_dir,local_dir):
		try:
			res = self.changeRemoteDir(remote_dir)
			if res == C_NG:
				return C_NG
			if local_dir[-1:] == "/":
				mkdirpath = local_dir + remote_dir + "/"
			else:
				mkdirpath = local_dir + "/" + remote_dir + "/"
			res = self.createLocalDir(mkdirpath)
			if res == C_NG:
				res = self.changeRemoteDir("..")
				return C_NG
			dir_list = []
			self.return_msg = self.ftpcon.retrlines("LIST",dir_list.append)
			for line in dir_list:
				line_ent = []
				for ent in string.split(line," "):
					if ent <> "":
						line_ent.append(ent)
				if line[0] == "d":
					if line_ent[8] <> ".." and line_ent[8] <> ".":
						self.return_msg = self.getRemoteDir(line_ent[8],mkdirpath)
				elif line[0] == "-":
					localfilepath = mkdirpath + line_ent[8]
					self.return_msg = self.getRemoteFile(line_ent[8],localfilepath)
					if res == C_NG:
						return C_NG
			res = self.changeRemoteDir("..")
			if res == C_NG:
				return C_NG
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG


	#--------------------------------#
	#	Local Directory Control      #
	#--------------------------------#
	#Create local dir
	def createLocalDir(self,dir_name):
		try:
			os.mkdir(dir_name)
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Change local dir
	def changeLocalDir(self,dir_name):
		try:
			os.chdir(dir_name)
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Get local dir
	def getCurrentLocalDir(self):
		try:
			self.msg_obj = []
			self.msg_obj.append(os.getcwd())
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG
			
	#Get local dir data
	def getLocalDirData(self,dirname):
		try:
			self.localdir_obj = []
			for e in os.listdir(dirname):
				self.localdir_obj.append(e)
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG
	
	#Delete local directory
	def deleteLocalDirectory(self,dirname):
		try:
			os.rmdir(dirname)
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG
			
	#--------------------------------#
	#	Local File Control           #
	#--------------------------------#
	#Change local file name
	def renameLocalFile(self,fromname,toname):
		try:
			os.rename(fromname,toname)
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG
			
	#Delete local file
	def deleteLocalFile(self,filename):
		try:
			os.remove(filename)
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Rename file
	def renameRemoteFile(self,from_filename,to_filename):
		try:
			self.return_msg = self.ftpcon.rename(from_filename,to_filename)
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG


			
	
	#Class initial
	def __init__(self):
		self.hostname = ""
		self.portno = 21
		self.user = ""
		self.password = ""
		
