#pragma once

#include "FileInfo.hpp"
#include "FileInfoComparator.hpp"
#include "FileInfoCollection.hpp"
#include "NameMatcher.hpp"
#include "EnumDir.hpp"
#include "FindFile.hpp"

/**
 * t@C̃Xe[^XB
 */
typedef enum FILEINFO_TRACE_STATUS_ 
{
	/**
	 * ĂȂ
	 */
	FILEINFO_TRACE_STATUS_UNCHECK = 0,

	/**
	 * ȑȌԂύXĂȂ
	 */
	FILEINFO_TRACE_STATUS_NOT_MODIFIED = 1,

	/**
	 * ȑȌԂύXꂽ
	 */
	FILEINFO_TRACE_STATUS_MODIFIED = 2,

	/**
	 * 쐬ꂽBȑȌԂȂB
	 */
	FILEINFO_TRACE_STATUS_CREATED = 4,

	/**
	 * 폜ꂽBȑȌԂ͂邪VԂȂB
	 */
	FILEINFO_TRACE_STATUS_REMOVED = 8

} FILEINFO_TRACE_STATUS;

/**
 * t@CXe[^X
 */
class __declspec(novtable, uuid("8868AAF8-F248-4490-A500-C2B63AB970CF")) IFileInfoTraceStatus : public IUnknown
{
public:

	/**
	 * ێĂt@C擾܂B
	 * @param v_ppFileInfo t@Ci[|C^
	 * @return ܂͎s킷HRESULT
	 */
	virtual HRESULT __stdcall get_FileInfo(IFileInfo** v_ppFileInfo) throw() = 0;

	/**
	 * t@CZbg܂B
	 * @param v_pFileInfo t@C
	 * @return ܂͎s킷HRESULT
	 */
	virtual HRESULT __stdcall set_FileInfo(IFileInfo* v_pFileInfo) throw() = 0;

	/**
	 * Xe[^XXV擾܂B
	 * @param v_pFileTime XVi[|C^
	 * @return ܂͎s킷HRESULT
	 */
	virtual HRESULT __stdcall get_Timestamp(FILETIME* v_pFileTime) throw() = 0;

	/**
	 * Xe[^XXVZbg܂B
	 * @param v_pTimestamp Xe[^XXV
	 * @return ܂͎s\HRESULT
	 */
	virtual HRESULT __stdcall set_Timestamp(const FILETIME* v_pFileTime) throw() = 0;

	/**
	 * Xe[^X擾܂B
	 * @param v_pStatus Xe[^Xi[|C^
	 * @return ܂͎s\HRESULT
	 */
	virtual HRESULT __stdcall get_Status(FILEINFO_TRACE_STATUS* v_pStatus) throw() = 0;

	/**
	 * Xe[^Xݒ肵܂B
	 * @param v_status Xe[^X
	 * @return ܂͎s\HRESULT
	 */
	virtual HRESULT __stdcall set_Status(const FILEINFO_TRACE_STATUS v_status) throw() = 0;
};

/**
 * t@CXe[^XIuWFNg\z܂B
 * @param v_pFileInfo t@C
 * @param v_status Xe[^X
 * @param v_pTimestamp Xe[^XXV
 * @return ܂͎s\HRESULT
 */
extern "C" HRESULT __stdcall CreateFileInfoTraceStatusObject(IFileInfo* v_pFileInfo,
	FILEINFO_TRACE_STATUS v_status, const FILETIME* v_pTimestamp,
	IFileInfoTraceStatus** v_ppFileInfoStatus) throw();

/**
 * t@CXe[^X̏sC^[tFCX
 */
class __declspec(novtable, uuid("D5EBC71B-5E80-47f4-8D9A-39D6AB6AF8C1")) IFileInfoTraceCondition : public IUnknown
{
public:

	/**
	 * w肳ꂽt@CXe[^XɃ}b`邩肵܂B
	 * }b`S_OKA}b`ȂS_FALSEԂ܂B
	 * @param v_pName pX
	 * @param v_pFileInfoStatus Xe[^X
	 * @return S_OKȂ΃}b`AS_FALSEȂ}b`AG[Ȃ΃G[R[h
	 */
	virtual HRESULT __stdcall IsAccept(LPCWSTR v_pName,
		IFileInfoTraceStatus* v_pFileInfoStatus) throw() = 0;
};

/**
 * Xe[^XɃ}b`RfBV쐬܂B
 * v_pTimestampNULLłȂꍇAXe[^XA̍XVȑOł݂̂̂ΏۂƂ܂B
 * @param v_status Xe[^X
 * @param v_pTimestamp XVȑÔ̂ΏۂƂ܂BXV𔻒肵ȂꍇNULLwł܂B
 * @param v_ppCondition RfBVi[|C^w肵܂B
 * @return S_OKȂ΃}b`AS_FALSEȂ}b`AG[Ȃ΃G[R[h
 */
extern "C" HRESULT __stdcall CreateFileInfoTraceConditionObject(FILEINFO_TRACE_STATUS v_status,
	const FILETIME* v_pTimestamp, IFileInfoTraceCondition** v_ppCondition) throw();


class __declspec(novtable, uuid("DA8CF54C-6B2F-4382-AB8A-1AAC90DD791F")) IFileInfoTraceCollecionView : public IUnknown
{
public:

	/**
	 * ̃r[ɂAACě擾܂B
	 * @return ܂͎s\HRESULT
	 */
	virtual HRESULT __stdcall get_Length(ULONG* v_pLength) throw() = 0;

	/**
	 * ̃r[ɂAׂẴACe܂B
	 * @return ܂͎s\HRESULT
	 */
	virtual HRESULT __stdcall Clear() throw() = 0;

	/**
	 * ̃r[́AׂẴACe̖Oi[SAFEARRAYԂ܂B
	 * SAFEARRAYɂBSTRi[Ă܂B
	 * @param v_ppNamesArray SAFEARRAYi[|C^
	 * @return ܂͎s\HRESULT
	 */
	virtual HRESULT __stdcall get_ItemNames(SAFEARRAY** v_ppNamesArray) throw() = 0;

	/**
	 * ̃r[ɁAw肵Õt@C񂪑݂邩肵܂B
	 * ݂S_OKA݂ȂS_FALSEԂ܂B
	 * @param v_pName pX
	 * @return ݂S_OKA݂ȂS_FALSEAG[Ȃ΃G[R[h
	 */
	virtual HRESULT __stdcall IsExists(LPCWSTR v_pName) throw() = 0;

	/**
	 * ̃r[́Aw肵Õt@CXe[^X擾܂B
	 * ݂ȂꍇE_FAILԂ܂B
	 * @param v_pName pX
	 * @param v_ppStatus Xe[^Xi[|C^
	 * @return ܂͎s\HRESULT
	 */
	virtual HRESULT __stdcall get_Item(LPCWSTR v_pName,
		IFileInfoTraceStatus** v_ppStatus) throw() = 0;

	/**
	 * ̃r[́AׂẴACẽXe[^XύX܂B
	 * v_pTimestampNULLłȂꍇ́AŏIXVύX܂B
	 * v_statusMaskŎw肳ꂽrbĝ݂e󂯂܂B
	 * @param v_status Xe[^X
	 * @param v_statusMask OXe[^X̃rbg}XNA0Ȃ΂ׂāB
	 * @param v_pTimestamp ŏIXVAύXȂꍇNULL
	 * @return ܂͎s킷HRESULT
	 */
	virtual HRESULT __stdcall SetStatusAllItems(FILEINFO_TRACE_STATUS v_status,
		FILEINFO_TRACE_STATUS v_statusMask, const FILETIME* v_pTimestamp) throw() = 0;
};

class __declspec(novtable, uuid("B08454BF-1B43-4c97-BBBD-76B851C883D9")) IFileInfoTraceCollection : public IUnknown
{
public:

	/**
	 * Xe[gXVݒ肵܂B
	 * @param v_pTimestamp XV
	 * @return ܂͎s\HRESULT
	 */
	virtual HRESULT __stdcall set_Timestamp(const FILETIME* v_pTimestamp) throw() = 0;

	/**
	 * Xe[gXV擾܂B
	 * @param v_pTimestamp XVi[|C^
	 * @return ܂͎s\HRESULT
	 */
	virtual HRESULT __stdcall get_Timestamp(FILETIME* v_pTimestamp) throw() = 0;

	/**
	 * t@C̏ԂXV܂B
	 * Ԃ́A̂悤ɑJڂ܂B
	 *
	 *          [VKo] [ύXo] [ύXȂ] [폜o()] [폜o(폜ς)]
	 * VK         1        -         -           -                 -
	 * ύXȂ     0         0         1           0                 1
	 * ύXς     1         1         -           1                 -
	 * 폜ς     0         0         -           1                 -
	 * XV     x         x         -           x                 -
	 */
	virtual HRESULT __stdcall update(IFileInfoCollection* v_pCollection) throw() = 0;

	/**
	 * Ƀ}b`r[\z܂B
	 * v_pConditionNULL̏ꍇ́AׂĂɃ}b`r[Ԃ܂B
	 * @param v_pCondition ANULL̏ꍇׂ͂ă}b`܂B
	 * @param v_ppView r[i[|C^
	 * @return ܂͎s\HRESULT
	 */
	virtual HRESULT __stdcall CreateView(IFileInfoTraceCondition* v_pCondition, 
		IFileInfoTraceCollecionView** v_ppView) throw() = 0;

};

/**
 * IFileInfoTraceCollectioñIuWFNg\z܂B
 * @param v_pComparator IFileInfoComparator t@C̓𔻒肷Rp[^
 * @param v_ppCollection IFileInfoTraceCollectioni[|C^
 * @return ܂͎s킷HRESULT
 */
extern "C" HRESULT __stdcall CreateFileInfoTraceCollectionObject(
	IFileInfoComparator* v_pComparator,
	IFileInfoTraceCollection** v_ppCollection) throw();
